/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.orm.database.lambda.stream.build;

import java.lang.reflect.ParameterizedType;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.wu.framework.core.exception.AssertFactory;
import org.wu.framework.core.utils.ObjectUtils;
import org.wu.framework.lazy.orm.core.factory.LazyTableStructureConverterFactory;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyTableEndpoint;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyTableFieldEndpoint;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyTableStructure;
import org.wu.framework.lazy.orm.core.persistence.util.LazyFieldStrategyUtil;
import org.wu.framework.lazy.orm.core.source.SqlSourceClass;
import org.wu.framework.lazy.orm.core.source.adapter.SourceFactory;
import org.wu.framework.lazy.orm.core.stereotype.LazyFieldStrategy;
import org.wu.framework.lazy.orm.database.lambda.domain.Persistence;
import org.wu.framework.lazy.orm.database.lambda.domain.PersistenceRepository;
import org.wu.framework.lazy.orm.database.lambda.domain.PersistenceRepositoryFactory;
import org.wu.framework.lazy.orm.database.lambda.stream.LambdaTableType;
import org.wu.framework.lazy.orm.database.lambda.stream.build.AbstractSimpleSelectBuild;
import org.wu.framework.lazy.orm.database.lambda.stream.build.Build;
import org.wu.framework.lazy.orm.database.lambda.stream.build.delete.SimpleDeleteBuild;
import org.wu.framework.lazy.orm.database.lambda.stream.build.insert.SimpleInsertBuild;
import org.wu.framework.lazy.orm.database.lambda.stream.build.select.SimpleSelectBuild;
import org.wu.framework.lazy.orm.database.lambda.stream.build.update.SimpleUpdateBuild;
import org.wu.framework.lazy.orm.database.lambda.stream.condition.BasicComparison;
import org.wu.framework.lazy.orm.database.lambda.stream.condition.ParadigmTClassCondition;
import org.wu.framework.lazy.orm.database.lambda.stream.condition.part.SqlPart;
import org.wu.framework.lazy.orm.database.lambda.stream.condition.update.SetValueBasicComparison;
import org.wu.framework.lazy.orm.database.lambda.stream.execute.Execute;
import org.wu.framework.lazy.orm.database.lambda.stream.execute.LambdaExecute;
import org.wu.framework.lazy.orm.database.lambda.stream.function.Snippet;

public abstract class AbstractBuild<T>
extends AbstractSimpleSelectBuild<T>
implements Build<T>,
SimpleInsertBuild<T>,
SimpleSelectBuild<T>,
SimpleUpdateBuild<T>,
SimpleDeleteBuild<T> {
    protected final String SELECT_ALL = "select %s.* from %s";
    protected final String DELETE_FROM = "delete from ";

    protected abstract Execute<T> createExecute(PersistenceRepository var1);

    protected abstract LambdaExecute<T> createExecute();

    @Override
    public void insertSet(SetValueBasicComparison<T, ?, ?, ?> lazySetValue) {
        SqlPart sqlPart = new SqlPart();
        AssertFactory.notNull(lazySetValue, (String)"\u63d2\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        ConcurrentHashMap<String, Object> insertSet = lazySetValue.setValue();
        Class<T> classT = this.getClassT(lazySetValue);
        LazyTableEndpoint lazyTableEndpoint = SourceFactory.defaultAnalyzeLazyTableFromClass(classT);
        sqlPart.setInsertSet(insertSet);
        sqlPart.setExecutionEnum(Persistence.ExecutionEnum.INSERT_WITH_SET);
        sqlPart.setPrimaryClass(classT);
        sqlPart.setPrimaryTable(lazyTableEndpoint.getTableName());
        PersistenceRepository persistenceRepository = sqlPart.persistenceRepository();
        persistenceRepository.setExecutionType(LambdaTableType.INSERT);
        persistenceRepository.setSqlPart(sqlPart);
        LambdaExecute<T> execute = this.createExecute();
        execute.setPersistenceRepository(persistenceRepository);
        execute.collectOne(Integer.class);
    }

    @Override
    public void upsertSet(SetValueBasicComparison<T, ?, ?, ?> lazySetValue) {
        SqlPart sqlPart = new SqlPart();
        AssertFactory.notNull(lazySetValue, (String)"\u63d2\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        ConcurrentHashMap<String, Object> insertSet = lazySetValue.setValue();
        Class<T> classT = this.getClassT(lazySetValue);
        LazyTableEndpoint lazyTableEndpoint = SourceFactory.defaultAnalyzeLazyTableFromClass(classT);
        sqlPart.setInsertSet(insertSet);
        sqlPart.setExecutionEnum(Persistence.ExecutionEnum.UPSERT);
        sqlPart.setPrimaryClass(classT);
        sqlPart.setPrimaryTable(lazyTableEndpoint.getTableName());
        PersistenceRepository persistenceRepository = sqlPart.persistenceRepository();
        persistenceRepository.setExecutionType(LambdaTableType.UPSERT);
        persistenceRepository.setSqlPart(sqlPart);
        LambdaExecute<T> execute = this.createExecute();
        execute.setPersistenceRepository(persistenceRepository);
        execute.collectOne(Integer.class);
    }

    @Override
    @Deprecated
    public Execute<T> select(BasicComparison comparison, Snippet<T, ?> ... snippets) {
        SqlPart sqlPart;
        Class<T> classT = this.getClassT(comparison);
        if (ObjectUtils.isEmpty(classT)) {
            AssertFactory.notNull((Object)comparison, (String)"\u5f53\u524d\u672a\u6307\u5b9a\u4e3b\u8868,\u8bf7\u4f7f\u7528LazyLambdaStream.of(Class clazz) or make comparison not null");
            classT = comparison.getClassT();
        }
        LazyTableEndpoint lazyTableEndpoint = SourceFactory.defaultAnalyzeLazyTableFromClass(classT);
        String tableName = lazyTableEndpoint.getTableName();
        if (null == comparison) {
            sqlPart = new SqlPart();
            sqlPart.setPrimaryClass(classT);
        } else {
            sqlPart = comparison.getSqlPart();
        }
        sqlPart.setExecutionEnum(Persistence.ExecutionEnum.SELECT);
        sqlPart.setPrimaryClass(classT);
        sqlPart.setPrimaryTable(tableName);
        PersistenceRepository persistenceRepository = sqlPart.persistenceRepository();
        persistenceRepository.setExecutionType(LambdaTableType.SELECT);
        return this.createExecute(persistenceRepository);
    }

    @Override
    public Execute<T> select(BasicComparison<T, ?, ?, ?> comparison) {
        SqlPart sqlPart;
        Class<T> classT = this.getClassT(comparison);
        if (ObjectUtils.isEmpty(classT)) {
            AssertFactory.notNull(comparison, (String)"\u5f53\u524d\u672a\u6307\u5b9a\u4e3b\u8868,\u8bf7\u4f7f\u7528LazyLambdaStream.of(Class clazz) or make comparison not null");
            classT = comparison.getClassT();
        }
        LazyTableEndpoint lazyTableEndpoint = SourceFactory.defaultAnalyzeLazyTableFromClass(classT);
        String tableName = lazyTableEndpoint.getTableName();
        if (null == comparison) {
            sqlPart = new SqlPart();
            sqlPart.setPrimaryClass(classT);
        } else {
            sqlPart = comparison.getSqlPart();
        }
        sqlPart.setExecutionEnum(Persistence.ExecutionEnum.SELECT);
        sqlPart.setPrimaryClass(classT);
        sqlPart.setPrimaryTable(tableName);
        PersistenceRepository persistenceRepository = sqlPart.persistenceRepository();
        persistenceRepository.setExecutionType(LambdaTableType.SELECT);
        return this.createExecute(persistenceRepository);
    }

    @Override
    public Execute<T> select(String sql, Class<T> returnType) {
        PersistenceRepository persistenceRepository = PersistenceRepositoryFactory.create();
        persistenceRepository.setExecutionType(LambdaTableType.SELECT);
        persistenceRepository.setQueryString(sql);
        persistenceRepository.setResultClass(returnType);
        return this.createExecute(persistenceRepository);
    }

    protected <R> Execute<R> createExecute(Collection<?> rResult) {
        return null;
    }

    @Override
    public Integer delete(BasicComparison<T, ?, ?, ?> comparison) {
        SqlPart sqlPart;
        Class<T> classT = this.getClassT(comparison);
        LazyTableEndpoint lazyTableEndpoint = SourceFactory.defaultAnalyzeLazyTableFromClass(classT);
        if (null == comparison) {
            sqlPart = new SqlPart();
            sqlPart.setPrimaryClass(classT);
        } else {
            sqlPart = comparison.getSqlPart();
        }
        sqlPart.setExecutionEnum(Persistence.ExecutionEnum.DELETE);
        sqlPart.setPrimaryClass(classT);
        sqlPart.setPrimaryTable(lazyTableEndpoint.getTableName());
        PersistenceRepository persistenceRepository = sqlPart.persistenceRepository();
        persistenceRepository.setExecutionType(LambdaTableType.DELETE);
        LambdaExecute<T> execute = this.createExecute();
        execute.setPersistenceRepository(persistenceRepository);
        return execute.collectOne(Integer.class);
    }

    @Override
    public Integer update(T t, BasicComparison<T, ?, ?, ?> whereComparison) {
        SqlPart sqlPart = whereComparison.getSqlPart();
        AssertFactory.notNull(t, (String)"\u66f4\u65b0\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        LazyTableStructure lazyTableStructure = LazyTableStructureConverterFactory.dataStructure(t);
        List payload = lazyTableStructure.payload();
        HashMap<String, Object> updateSet = new HashMap<String, Object>();
        payload.forEach(lazyTableFieldEndpoints -> {
            for (LazyTableFieldEndpoint lazyTableFieldEndpoint : lazyTableFieldEndpoints) {
                if (!LazyFieldStrategyUtil.testUpdate((Object)lazyTableFieldEndpoint.getFieldValue(), (LazyFieldStrategy)lazyTableFieldEndpoint.getUpdateStrategy()).booleanValue()) continue;
                updateSet.put(lazyTableFieldEndpoint.getColumnName(), lazyTableFieldEndpoint.getFieldValue());
            }
        });
        sqlPart.setUpdateSet(updateSet);
        sqlPart.setExecutionEnum(Persistence.ExecutionEnum.UPDATE);
        sqlPart.setPrimaryClass(lazyTableStructure.schema().getClazz());
        sqlPart.setPrimaryTable(lazyTableStructure.schema().getTableName());
        PersistenceRepository persistenceRepository = sqlPart.persistenceRepository();
        persistenceRepository.setExecutionType(LambdaTableType.UPDATE);
        LambdaExecute<T> execute = this.createExecute();
        execute.setPersistenceRepository(persistenceRepository);
        return execute.collectOne(Integer.class);
    }

    @Override
    public Integer update(SetValueBasicComparison<T, ?, ?, ?> lambdaSetValueBasicComparison, BasicComparison<T, ?, ?, ?> whereComparison) {
        SqlPart sqlPart = whereComparison.getSqlPart();
        AssertFactory.notNull(lambdaSetValueBasicComparison, (String)"\u66f4\u65b0\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        ConcurrentHashMap<String, Object> updateSet = lambdaSetValueBasicComparison.setValue();
        Class<T> classT = this.getClassT(lambdaSetValueBasicComparison);
        LazyTableEndpoint lazyTableEndpoint = SourceFactory.defaultAnalyzeLazyTableFromClass(classT);
        sqlPart.setUpdateSet(updateSet);
        sqlPart.setExecutionEnum(Persistence.ExecutionEnum.UPDATE);
        sqlPart.setPrimaryClass(classT);
        sqlPart.setPrimaryTable(lazyTableEndpoint.getTableName());
        PersistenceRepository persistenceRepository = sqlPart.persistenceRepository();
        persistenceRepository.setExecutionType(LambdaTableType.UPDATE);
        LambdaExecute<T> execute = this.createExecute();
        execute.setPersistenceRepository(persistenceRepository);
        return execute.collectOne(Integer.class);
    }

    @Override
    public boolean exists(BasicComparison<T, ?, ?, ?> comparison) {
        PersistenceRepository persistenceRepository;
        Class<T> classT = this.getClassT(comparison);
        if (ObjectUtils.isEmpty(classT)) {
            AssertFactory.notNull(comparison, (String)"\u5f53\u524d\u672a\u6307\u5b9a\u4e3b\u8868,\u8bf7\u4f7f\u7528LazyLambdaStream.of(Class clazz) or make comparison not null");
            classT = comparison.getClassT();
        }
        LazyTableEndpoint lazyTableEndpoint = SourceFactory.defaultAnalyzeLazyTableFromClass(classT);
        String tableName = lazyTableEndpoint.getFullTableName();
        String prefix = "select count(1) from " + tableName;
        if (null == comparison) {
            persistenceRepository = PersistenceRepositoryFactory.create();
            persistenceRepository.setQueryString(prefix);
        } else {
            SqlPart sqlPart = comparison.getSqlPart();
            sqlPart.setPrefix(prefix);
            persistenceRepository = sqlPart.persistenceRepository();
        }
        persistenceRepository.setExecutionType(LambdaTableType.SELECT);
        Execute<T> execute = this.createExecute(persistenceRepository);
        Long aLong = execute.collectOne(Long.class);
        return aLong != null && aLong != 0L;
    }

    @Override
    public Long count(BasicComparison<T, ?, ?, ?> comparison) {
        PersistenceRepository persistenceRepository;
        Class<T> classT = this.getClassT(comparison);
        if (ObjectUtils.isEmpty(classT)) {
            AssertFactory.notNull(comparison, (String)"\u5f53\u524d\u672a\u6307\u5b9a\u4e3b\u8868,\u8bf7\u4f7f\u7528LazyLambdaStream.of(Class clazz) or make comparison not null");
            classT = comparison.getClassT();
        }
        SqlSourceClass sqlSourceClass = SqlSourceClass.getInstance(classT);
        LazyTableEndpoint lazyTableEndpoint = sqlSourceClass.getLazyTableEndpoint();
        String tableName = lazyTableEndpoint.getFullTableName();
        String prefix = "select count(1) from " + tableName;
        if (null == comparison) {
            persistenceRepository = PersistenceRepositoryFactory.create();
            persistenceRepository.setQueryString(prefix);
        } else {
            SqlPart sqlPart = comparison.getSqlPart();
            sqlPart.setPrefix(prefix);
            persistenceRepository = sqlPart.persistenceRepository();
        }
        persistenceRepository.setExecutionType(LambdaTableType.SELECT);
        Execute<T> execute = this.createExecute(persistenceRepository);
        return execute.collectOne(Long.class);
    }

    protected Class<T> getClassT() {
        ParameterizedType superClass = (ParameterizedType)this.getClass().getGenericSuperclass();
        return (Class)superClass.getActualTypeArguments()[0];
    }

    protected abstract Class<T> getClassT(ParadigmTClassCondition<T> var1);
}

