/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.orm.database.lambda.dynamic.toolkit;

import java.util.ArrayDeque;
import java.util.Deque;
import org.wu.framework.lazy.orm.core.persistence.conf.ClassLazyDynamicEndpoint;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyDynamicEndpoint;

public final class DynamicLazyDSContextHolder {
    private static final ThreadLocal<Deque<LazyDynamicEndpoint>> LOOKUP_KEY_HOLDER = ThreadLocal.withInitial(ArrayDeque::new);

    private DynamicLazyDSContextHolder() {
    }

    public static LazyDynamicEndpoint peek() {
        return LOOKUP_KEY_HOLDER.get().peek();
    }

    public static void push(LazyDynamicEndpoint ds) {
        LOOKUP_KEY_HOLDER.get().push(ds);
    }

    public static void switchDatasource(String dataSourceName) {
        ClassLazyDynamicEndpoint lazyDynamicEndpoint = new ClassLazyDynamicEndpoint();
        lazyDynamicEndpoint.setName(dataSourceName);
        DynamicLazyDSContextHolder.push((LazyDynamicEndpoint)lazyDynamicEndpoint);
    }

    public static void switchDatasourceAndSchema(String dataSourceName, String schema) {
        ClassLazyDynamicEndpoint lazyDynamicEndpoint = new ClassLazyDynamicEndpoint();
        lazyDynamicEndpoint.setName(dataSourceName);
        lazyDynamicEndpoint.setSchema(schema);
        DynamicLazyDSContextHolder.push((LazyDynamicEndpoint)lazyDynamicEndpoint);
    }

    public static void switchSchema(String schema) {
        ClassLazyDynamicEndpoint lazyDynamicEndpoint = new ClassLazyDynamicEndpoint();
        lazyDynamicEndpoint.setSchema(schema);
        DynamicLazyDSContextHolder.push((LazyDynamicEndpoint)lazyDynamicEndpoint);
    }

    public static void poll() {
        Deque<LazyDynamicEndpoint> deque = LOOKUP_KEY_HOLDER.get();
        deque.poll();
        if (deque.isEmpty()) {
            LOOKUP_KEY_HOLDER.remove();
        }
    }

    public static void clear() {
        LOOKUP_KEY_HOLDER.remove();
    }
}

