/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.orm.database.lambda.dynamic.function;

import org.wu.framework.lazy.orm.core.config.enums.LazyDataSourceType;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyDynamicEndpoint;
import org.wu.framework.lazy.orm.core.toolkit.DynamicLazyDataSourceTypeHolder;
import org.wu.framework.lazy.orm.database.lambda.dynamic.function.DynamicDatasourceConsumer;
import org.wu.framework.lazy.orm.database.lambda.dynamic.function.DynamicDatasourceConsumerQuery;
import org.wu.framework.lazy.orm.database.lambda.dynamic.toolkit.DynamicLazyDSContextHolder;

public final class DynamicDatasourceSupport {
    public static <T> T doSameSilently(String name, String schema, DynamicDatasourceConsumerQuery<T> datasourceConsumer) {
        LazyDynamicEndpoint dynamicEndpoint = DynamicLazyDSContextHolder.peek();
        LazyDataSourceType lazyDataSourceType = DynamicLazyDataSourceTypeHolder.peek();
        try {
            DynamicLazyDSContextHolder.switchDatasourceAndSchema(name, schema);
            T t = datasourceConsumer.accept();
            return t;
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
        finally {
            DynamicLazyDSContextHolder.clear();
            if (dynamicEndpoint != null) {
                DynamicLazyDSContextHolder.push(dynamicEndpoint);
            }
            if (lazyDataSourceType != null) {
                DynamicLazyDataSourceTypeHolder.push((LazyDataSourceType)lazyDataSourceType);
            }
        }
    }

    public static void doSameSilently(String name, String schema, DynamicDatasourceConsumer datasourceConsumer) {
        LazyDynamicEndpoint dynamicEndpoint = DynamicLazyDSContextHolder.peek();
        LazyDataSourceType lazyDataSourceType = DynamicLazyDataSourceTypeHolder.peek();
        try {
            DynamicLazyDSContextHolder.switchDatasourceAndSchema(name, schema);
            datasourceConsumer.accept();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
        finally {
            DynamicLazyDSContextHolder.clear();
            if (dynamicEndpoint != null) {
                DynamicLazyDSContextHolder.push(dynamicEndpoint);
            }
            if (lazyDataSourceType != null) {
                DynamicLazyDataSourceTypeHolder.push((LazyDataSourceType)lazyDataSourceType);
            }
        }
    }

    public static <T> T doOtherSilently(LazyDataSourceType dataSourceType, String name, String schema, DynamicDatasourceConsumerQuery<T> datasourceConsumer) {
        LazyDynamicEndpoint dynamicEndpoint = DynamicLazyDSContextHolder.peek();
        LazyDataSourceType lazyDataSourceType = DynamicLazyDataSourceTypeHolder.peek();
        try {
            DynamicLazyDSContextHolder.switchDatasourceAndSchema(name, schema);
            DynamicLazyDataSourceTypeHolder.push((LazyDataSourceType)dataSourceType);
            T t = datasourceConsumer.accept();
            return t;
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
        finally {
            DynamicLazyDSContextHolder.clear();
            DynamicLazyDataSourceTypeHolder.clear();
            if (dynamicEndpoint != null) {
                DynamicLazyDSContextHolder.push(dynamicEndpoint);
            }
            if (lazyDataSourceType != null) {
                DynamicLazyDataSourceTypeHolder.push((LazyDataSourceType)lazyDataSourceType);
            }
        }
    }

    public static void doOtherSilently(LazyDataSourceType dataSourceType, String name, String schema, DynamicDatasourceConsumer datasourceConsumer) {
        LazyDynamicEndpoint dynamicEndpoint = DynamicLazyDSContextHolder.peek();
        LazyDataSourceType lazyDataSourceType = DynamicLazyDataSourceTypeHolder.peek();
        try {
            DynamicLazyDSContextHolder.switchDatasourceAndSchema(name, schema);
            DynamicLazyDataSourceTypeHolder.push((LazyDataSourceType)dataSourceType);
            datasourceConsumer.accept();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
        finally {
            DynamicLazyDSContextHolder.clear();
            DynamicLazyDataSourceTypeHolder.clear();
            if (dynamicEndpoint != null) {
                DynamicLazyDSContextHolder.push(dynamicEndpoint);
            }
            if (lazyDataSourceType != null) {
                DynamicLazyDataSourceTypeHolder.push((LazyDataSourceType)lazyDataSourceType);
            }
        }
    }
}

