/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.orm.database.lambda.dynamic;

import java.sql.SQLException;
import java.util.Map;
import javax.sql.DataSource;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wu.framework.core.utils.ObjectUtils;
import org.wu.framework.lazy.database.datasource.proxy.LazyProxyDataSource;
import org.wu.framework.lazy.database.datasource.proxy.connection.LazyProxyConnection;
import org.wu.framework.lazy.database.datasource.proxy.handler.JdbcHandlerAdapter;
import org.wu.framework.lazy.database.datasource.proxy.util.LazyDataSourceProxyUtils;
import org.wu.framework.lazy.orm.core.config.prop.LazyDataSourceAttribute;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyDynamicEndpoint;
import org.wu.framework.lazy.orm.database.lambda.dynamic.AbstractDynamicDatasourceAdapter;
import org.wu.framework.lazy.orm.database.lambda.dynamic.toolkit.DynamicLazyDSContextHolder;

public class LazyDynamicDatasourceAdapter
extends AbstractDynamicDatasourceAdapter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LazyDynamicDatasourceAdapter.class);
    private final JdbcHandlerAdapter jdbcHandlerAdapter;

    public LazyDynamicDatasourceAdapter(Map<String, LazyProxyDataSource> dataSourceMap, JdbcHandlerAdapter jdbcHandlerAdapter) {
        super(dataSourceMap, jdbcHandlerAdapter);
        this.jdbcHandlerAdapter = jdbcHandlerAdapter;
    }

    @Override
    public LazyProxyDataSource determineDataSource() {
        String primary = this.getPrimary();
        Map<String, LazyProxyDataSource> dataSourceMap = this.getDataSourceMap();
        LazyDynamicEndpoint ds = DynamicLazyDSContextHolder.peek();
        if (ObjectUtils.isEmpty((Object)ds)) {
            if (dataSourceMap.keySet().size() > 1) {
                log.debug("\u5f53\u524d\u65b9\u6cd5\u6ca1\u6709\u8bbe\u7f6e\u9ed8\u8ba4\u503c,\u5c06\u4f7f\u7528\u9ed8\u8ba4\u6570\u636e\u6e90master:{} ", (Object)primary);
            }
        } else {
            if (!ObjectUtils.isEmpty((Object)ds.getName()) && dataSourceMap.containsKey(ds.getName())) {
                return dataSourceMap.get(ds.getName());
            }
            log.debug("\u65e0\u6cd5\u4f7f\u7528\u6570\u636e\u6e90{} \u5c06\u4f7f\u7528\u9ed8\u8ba4\u6570\u636e\u6e90master:{} ", (Object)ds, (Object)primary);
        }
        return dataSourceMap.get(primary);
    }

    @Override
    public LazyProxyConnection determineConnection() throws SQLException {
        LazyProxyDataSource dataSource = this.determineDataSource();
        return dataSource.getLazyConnection();
    }

    @Override
    public void loading(LazyDataSourceAttribute sourceProperties) {
        DataSource build = sourceProperties.getDatasource();
        this.getDataSourceMap().put(sourceProperties.getAlias(), LazyDataSourceProxyUtils.proxy((DataSource)build, (JdbcHandlerAdapter)this.jdbcHandlerAdapter));
    }
}

