/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.orm.database.lambda.dynamic;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wu.framework.core.ReflexUtils;
import org.wu.framework.core.utils.ObjectUtils;
import org.wu.framework.lazy.database.datasource.proxy.LazyProxyDataSource;
import org.wu.framework.lazy.database.datasource.proxy.handler.JdbcHandlerAdapter;
import org.wu.framework.lazy.database.datasource.proxy.util.LazyDataSourceProxyUtils;
import org.wu.framework.lazy.orm.database.lambda.dynamic.DynamicDatasourceAdapter;

public abstract class AbstractDynamicDatasourceAdapter
implements DynamicDatasourceAdapter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractDynamicDatasourceAdapter.class);
    private Map<String, LazyProxyDataSource> dataSourceMap;
    private final JdbcHandlerAdapter jdbcHandlerAdapter;
    private String primary = "master";

    protected AbstractDynamicDatasourceAdapter(Map<String, LazyProxyDataSource> dataSourceMap, JdbcHandlerAdapter jdbcHandlerAdapter) {
        this.dataSourceMap = dataSourceMap;
        this.jdbcHandlerAdapter = jdbcHandlerAdapter;
    }

    public void afterPropertiesSet() {
        this.primary = this.dataSourceMap.keySet().iterator().next();
        this.dataSourceMap.forEach((alias, dataSource) -> {
            try {
                this.mybatisDataSource((String)alias, (DataSource)dataSource);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            log.info("\u521d\u59cb\u5316\u6570\u636e\u6e90:\u3010{}\u3011", alias);
        });
    }

    public void mybatisDataSource(String key, DataSource dataSource) throws Exception {
        if ("com.baomidou.dynamic.datasource.DynamicRoutingDataSource".equals(dataSource.getClass().getName())) {
            Field primaryDeclaredField = dataSource.getClass().getDeclaredField("primary");
            primaryDeclaredField.setAccessible(true);
            this.primary = (String)primaryDeclaredField.get(dataSource);
            Field dataSourceMapDeclaredField = dataSource.getClass().getDeclaredField("dataSourceMap");
            dataSourceMapDeclaredField.setAccessible(true);
            Map mybatisDataSourceMap = (Map)dataSourceMapDeclaredField.get(dataSource);
            mybatisDataSourceMap.forEach((mybatisKey, mybatisDataSource) -> this.dataSourceMap.put((String)mybatisKey, LazyDataSourceProxyUtils.proxy((DataSource)mybatisDataSource, (JdbcHandlerAdapter)this.jdbcHandlerAdapter)));
        } else {
            this.dataSourceMap.put(key, LazyDataSourceProxyUtils.proxy((DataSource)dataSource, (JdbcHandlerAdapter)this.jdbcHandlerAdapter));
        }
    }

    public Map<String, LazyProxyDataSource> getDataSourceMap() {
        if (ObjectUtils.isEmpty(this.dataSourceMap)) {
            this.dataSourceMap = new HashMap<String, LazyProxyDataSource>();
        }
        return this.dataSourceMap;
    }

    public void closeDataSource(String alias) {
        if (this.dataSourceMap.containsKey(alias)) {
            LazyProxyDataSource lazyProxyDataSource = this.dataSourceMap.get(alias);
            if (ReflexUtils.existsDeclaredMethod(lazyProxyDataSource.getClass(), (String)"connectionClose", (Class[])new Class[0]).booleanValue()) {
                Method declaredMethod = ReflexUtils.findDeclaredMethod(lazyProxyDataSource.getClass(), (String)"connectionClose", (Class[])new Class[0]);
                ReflexUtils.invokeDeclaredMethod((Object)lazyProxyDataSource, (Method)declaredMethod, (Object[])new Object[0]);
            }
        } else {
            throw new RuntimeException("\u65e0\u6cd5\u901a\u8fc7\u6570\u636e\u6e90ID\uff1a\u3010" + alias + "\u3011\u83b7\u53d6\u6570\u636e\u6e90\uff0c\u5173\u95ed\u6570\u636e\u6e90\u5931\u8d25");
        }
    }

    public String getPrimary() {
        return this.primary;
    }

    public void setPrimary(String primary) {
        this.primary = primary;
    }
}

