/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.orm.database.lambda.stream.script;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import javax.script.ScriptException;
import org.wu.framework.core.exception.AssertFactory;
import org.wu.framework.core.io.ScriptResource;
import org.wu.framework.lazy.orm.database.lambda.stream.script.DatabasePopulator;
import org.wu.framework.lazy.orm.database.lambda.stream.script.ScriptUtils;

public class ScriptResourceDatabasePopulator
implements DatabasePopulator {
    List<ScriptResource> scriptResources = new ArrayList<ScriptResource>();
    private String sqlScriptEncoding;
    private String separator = ";";
    private String[] commentPrefixes = new String[]{"--"};
    private String blockCommentStartDelimiter = "/*";
    private String blockCommentEndDelimiter = "*/";
    private boolean continueOnError = false;
    private boolean ignoreFailedDrops = false;

    public void setSqlScriptEncoding(String sqlScriptEncoding) {
        this.sqlScriptEncoding = sqlScriptEncoding;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public void setCommentPrefixes(String[] commentPrefixes) {
        this.commentPrefixes = commentPrefixes;
    }

    public void setBlockCommentStartDelimiter(String blockCommentStartDelimiter) {
        this.blockCommentStartDelimiter = blockCommentStartDelimiter;
    }

    public void setBlockCommentEndDelimiter(String blockCommentEndDelimiter) {
        this.blockCommentEndDelimiter = blockCommentEndDelimiter;
    }

    public void setContinueOnError(boolean continueOnError) {
        this.continueOnError = continueOnError;
    }

    public void setIgnoreFailedDrops(boolean ignoreFailedDrops) {
        this.ignoreFailedDrops = ignoreFailedDrops;
    }

    public void addScripts(ScriptResource resource) {
        this.scriptResources.add(resource);
    }

    @Override
    public void populate(Connection connection) throws ScriptException {
        AssertFactory.notNull((Object)connection, (String)"'connection' must not be null");
        for (ScriptResource script : this.scriptResources) {
            ScriptUtils.executeSqlScript(connection, script, this.ignoreFailedDrops, this.commentPrefixes, this.separator, this.blockCommentStartDelimiter, this.blockCommentEndDelimiter);
        }
    }
}

