/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.orm.database.lambda.stream.condition.update;

import java.lang.reflect.Field;
import java.util.concurrent.ConcurrentHashMap;
import org.wu.framework.core.CamelAndUnderLineConverter;
import org.wu.framework.core.ReflexUtils;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyTableEndpoint;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyTableFieldEndpoint;
import org.wu.framework.lazy.orm.core.source.adapter.SourceFactory;
import org.wu.framework.lazy.orm.database.lambda.stream.condition.update.LambdaSetValueBasicComparison;
import org.wu.framework.lazy.orm.database.lambda.stream.function.Snippet;
import org.wu.framework.lazy.orm.database.lambda.stream.function.SnippetUtil;
import org.wu.framework.lazy.orm.database.lambda.stream.support.LambdaMeta;

public class LambdaSetBeanBasicComparison<T>
extends LambdaSetValueBasicComparison<T> {
    private final T bean;
    protected Class<T> classT;

    public LambdaSetBeanBasicComparison(T bean) {
        this.bean = bean;
    }

    @Override
    public Class<T> getClassT() {
        return this.bean.getClass();
    }

    @Override
    public ConcurrentHashMap<String, Object> setValue() {
        ConcurrentHashMap<String, Object> concurrentHashMap = super.setValue();
        LazyTableEndpoint lazyTableEndpoint = SourceFactory.defaultAnalyzeLazyTableFromClass(this.bean.getClass());
        for (LazyTableFieldEndpoint lazyTableFieldEndpoint : lazyTableEndpoint.getLazyTableFieldEndpointList()) {
            String columnName = lazyTableFieldEndpoint.getColumnName();
            Object declaredFieldBean = ReflexUtils.findDeclaredFieldBean(this.bean, (Field)lazyTableFieldEndpoint.getField());
            concurrentHashMap.put(columnName, declaredFieldBean);
        }
        return concurrentHashMap;
    }

    @Override
    protected String columnToString(Snippet<T, ?> row) {
        LambdaMeta lambdaMeta = SnippetUtil.extract(row);
        assert (lambdaMeta != null);
        Class<?> tClass = lambdaMeta.instantiatedClass();
        if (null == this.classT) {
            this.classT = tClass;
        }
        String methodName = lambdaMeta.methodName();
        String fieldName = CamelAndUnderLineConverter.methodToField((String)methodName);
        return CamelAndUnderLineConverter.humpToLine2((String)fieldName);
    }
}

