/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.orm.database.lambda.stream.condition.part;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.wu.framework.core.exception.AssertFactory;
import org.wu.framework.core.utils.ObjectUtils;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyTableEndpoint;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyTableFieldEndpoint;
import org.wu.framework.lazy.orm.core.persistence.util.LazySQLUtil;
import org.wu.framework.lazy.orm.core.source.SqlSourceClass;
import org.wu.framework.lazy.orm.core.source.adapter.SourceFactory;
import org.wu.framework.lazy.orm.database.lambda.domain.Persistence;
import org.wu.framework.lazy.orm.database.lambda.stream.condition.part.SqlPart;
import org.wu.framework.lazy.orm.database.lambda.stream.condition.part.SqlPartExecutedAdapter;
import org.wu.framework.lazy.orm.database.lambda.stream.condition.part.SqlPartStringBuilder;

public abstract class SqlPartAbstract
implements SqlPartExecutedAdapter {
    abstract Persistence.ExecutionEnum getExecutionEnum();

    abstract Map<String, String> getColumnAsMap();

    abstract String getPrimaryTable();

    abstract Class getPrimaryClass();

    abstract List<SqlPart> getJoinConditions();

    abstract List<SqlPart> getOrSqlPart();

    abstract List<HashMap<String, Object>> getInsert();

    abstract Map<String, Object> getInsertDuplicateKey();

    abstract Map<String, Object> getInsertSet();

    abstract Map<String, Object> getUpdateSet();

    abstract List<String> getIgnoreColumnList();

    abstract Boolean getOnlyUseAs();

    @Override
    public SqlPartStringBuilder select() {
        AssertFactory.isFalse((boolean)Persistence.ExecutionEnum.SELECT.equals((Object)this.getExecutionEnum()), (String)("\u6267\u884c\u65b9\u6cd5\u9519\u8bef\uff1a{" + (Object)((Object)this.getExecutionEnum()) + "}"));
        SqlPartStringBuilder sqlPartStringBuilder = new SqlPartStringBuilder();
        sqlPartStringBuilder.append(Persistence.ExecutionEnum.SELECT.getExecution());
        SqlSourceClass sqlSourceClass = SqlSourceClass.getInstance((Class)this.getPrimaryClass());
        LazyTableEndpoint lazyTableEndpoint = sqlSourceClass.getLazyTableEndpoint();
        Map<Object, Object> columnAsMap = new HashMap();
        if (!this.getOnlyUseAs().booleanValue()) {
            String primaryTable = this.getPrimaryTable();
            Map<String, String> masterTablesColumnsAsMap = lazyTableEndpoint.getLazyTableFieldEndpointList().stream().collect(Collectors.toMap(fieldLazyTableFieldEndpoint -> primaryTable + "." + fieldLazyTableFieldEndpoint.getColumnName(), LazyTableFieldEndpoint::getAlias));
            columnAsMap.putAll(masterTablesColumnsAsMap);
            if (!ObjectUtils.isEmpty(this.getJoinConditions())) {
                Map<String, String> joinTablesColumnsAsMap = this.getJoinConditions().stream().map(conditions -> {
                    Class<?> entityClass = conditions.getPrimaryClass();
                    SqlSourceClass joinSqlSourceClass = SqlSourceClass.getInstance(entityClass);
                    LazyTableEndpoint joinClassLazyTableEndpoint = joinSqlSourceClass.getLazyTableEndpoint();
                    List fieldEndpoints = joinClassLazyTableEndpoint.getLazyTableFieldEndpointList();
                    String fullTableName = joinClassLazyTableEndpoint.getFullTableName();
                    return fieldEndpoints.stream().collect(Collectors.toMap(fieldLazyTableFieldEndpoint -> fullTableName + "." + fieldLazyTableFieldEndpoint.getColumnName(), LazyTableFieldEndpoint::getAlias));
                }).filter(joinTableColumnSql -> !ObjectUtils.isEmpty((Object)joinTableColumnSql)).flatMap(m -> m.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (A, B) -> B));
                columnAsMap.putAll(joinTablesColumnsAsMap);
            }
            columnAsMap.putAll(this.getColumnAsMap());
        } else {
            columnAsMap = this.getColumnAsMap();
        }
        columnAsMap = columnAsMap.entrySet().stream().filter(stringStringEntry -> !this.getIgnoreColumnList().contains(stringStringEntry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (A, B) -> B)).entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey, (A, B) -> {
            if (this.getColumnAsMap().containsKey(A)) {
                return A;
            }
            if (this.getColumnAsMap().containsKey(B)) {
                return B;
            }
            return B;
        })).entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey, (A, B) -> B));
        if (!ObjectUtils.isEmpty(columnAsMap)) {
            String as = columnAsMap.entrySet().stream().map(stringStringEntry -> " " + (String)stringStringEntry.getKey() + " " + "as" + " " + (String)stringStringEntry.getValue() + " ").collect(Collectors.joining(","));
            sqlPartStringBuilder.append(as);
        } else {
            sqlPartStringBuilder.append("*");
        }
        String primaryFullTableName = lazyTableEndpoint.getFullTableName();
        sqlPartStringBuilder.append("from").append(primaryFullTableName);
        return sqlPartStringBuilder;
    }

    @Override
    public SqlPartStringBuilder update() {
        AssertFactory.isFalse((boolean)Persistence.ExecutionEnum.UPDATE.equals((Object)this.getExecutionEnum()), (String)("\u6267\u884c\u65b9\u6cd5\u9519\u8bef\uff1a{" + (Object)((Object)this.getExecutionEnum()) + "}"));
        SqlPartStringBuilder sqlPartStringBuilder = new SqlPartStringBuilder();
        sqlPartStringBuilder.append(Persistence.ExecutionEnum.UPDATE.getExecution()).append(this.getPrimaryTable()).append("SET");
        if (!ObjectUtils.isEmpty(this.getUpdateSet())) {
            String setSql = this.getUpdateSet().entrySet().stream().map(stringStringEntry -> {
                String columnName = (String)stringStringEntry.getKey();
                Object fieldValue = stringStringEntry.getValue();
                return columnName + "=" + LazySQLUtil.valueToSqlValue(fieldValue);
            }).collect(Collectors.joining(","));
            sqlPartStringBuilder.append(setSql);
        }
        return sqlPartStringBuilder;
    }

    @Override
    public SqlPartStringBuilder insert() {
        AssertFactory.isFalse((boolean)Persistence.ExecutionEnum.INSERT.equals((Object)this.getExecutionEnum()), (String)("\u6267\u884c\u65b9\u6cd5\u9519\u8bef\uff1a{" + (Object)((Object)this.getExecutionEnum()) + "}"));
        SqlPartStringBuilder sqlPartStringBuilder = new SqlPartStringBuilder();
        sqlPartStringBuilder.append(Persistence.ExecutionEnum.INSERT.getExecution()).append(this.getPrimaryTable()).append("(");
        String columns = String.join((CharSequence)",", this.getInsert().get(0).keySet());
        sqlPartStringBuilder.append(columns);
        sqlPartStringBuilder.append(")");
        sqlPartStringBuilder.append("VALUES");
        String rowsValue = this.getInsert().stream().map(stringObjectHashMap -> "(" + stringObjectHashMap.values().stream().map(o -> {
            if (ObjectUtils.isEmpty((Object)o)) {
                return null;
            }
            return o.toString();
        }).collect(Collectors.joining(",")) + ")").collect(Collectors.joining(","));
        sqlPartStringBuilder.append(rowsValue);
        return sqlPartStringBuilder;
    }

    @Override
    public SqlPartStringBuilder upsert() {
        AssertFactory.isFalse((boolean)Persistence.ExecutionEnum.UPSERT.equals((Object)this.getExecutionEnum()), (String)("\u6267\u884c\u65b9\u6cd5\u9519\u8bef\uff1a{" + (Object)((Object)this.getExecutionEnum()) + "}"));
        SqlPartStringBuilder sqlPartStringBuilder = new SqlPartStringBuilder();
        sqlPartStringBuilder.append(Persistence.ExecutionEnum.UPSERT.getExecution()).append(this.getPrimaryTable()).append("(");
        String columns = String.join((CharSequence)",", this.getInsert().get(0).keySet());
        sqlPartStringBuilder.append(columns);
        sqlPartStringBuilder.append(")");
        sqlPartStringBuilder.append("VALUES");
        String rowsValue = this.getInsert().stream().map(stringObjectHashMap -> "(" + stringObjectHashMap.values().stream().map(o -> {
            if (ObjectUtils.isEmpty((Object)o)) {
                return null;
            }
            return o.toString();
        }).collect(Collectors.joining(",")) + ")").collect(Collectors.joining(","));
        sqlPartStringBuilder.append(rowsValue);
        sqlPartStringBuilder.append(" ");
        sqlPartStringBuilder.append("ON DUPLICATE KEY UPDATE");
        Map<String, Object> insertDuplicateKey = this.getInsertDuplicateKey();
        if (ObjectUtils.isEmpty(insertDuplicateKey)) {
            String duplicateKey = this.getInsert().get(0).keySet().stream().map(key -> " " + key + " " + "=" + " " + "VALUES" + "(" + key + ")").collect(Collectors.joining(","));
            sqlPartStringBuilder.append(duplicateKey);
        } else {
            String duplicateKey = insertDuplicateKey.entrySet().stream().map(stringObjectEntry -> " " + (String)stringObjectEntry.getKey() + " " + "=" + stringObjectEntry.getValue()).collect(Collectors.joining(","));
            sqlPartStringBuilder.append(duplicateKey);
        }
        return sqlPartStringBuilder;
    }

    @Override
    public SqlPartStringBuilder insertWithSet() {
        AssertFactory.isFalse((boolean)Persistence.ExecutionEnum.INSERT_WITH_SET.equals((Object)this.getExecutionEnum()), (String)("\u6267\u884c\u65b9\u6cd5\u9519\u8bef\uff1a{" + (Object)((Object)this.getExecutionEnum()) + "}"));
        SqlPartStringBuilder sqlPartStringBuilder = new SqlPartStringBuilder();
        sqlPartStringBuilder.append(Persistence.ExecutionEnum.INSERT_WITH_SET.getExecution()).append(this.getPrimaryTable()).append("SET");
        if (!ObjectUtils.isEmpty(this.getInsertSet())) {
            String setSql = this.getInsertSet().entrySet().stream().map(stringStringEntry -> {
                String columnName = (String)stringStringEntry.getKey();
                Object fieldValue = stringStringEntry.getValue();
                return SourceFactory.cleanSpecialColumn((String)columnName) + "=" + LazySQLUtil.valueToSqlValue(fieldValue);
            }).collect(Collectors.joining(","));
            sqlPartStringBuilder.append(setSql);
        }
        return sqlPartStringBuilder;
    }

    @Override
    public SqlPartStringBuilder upsertWithSet() {
        AssertFactory.isFalse((boolean)Persistence.ExecutionEnum.UPSERT_WITH_SET.equals((Object)this.getExecutionEnum()), (String)("\u6267\u884c\u65b9\u6cd5\u9519\u8bef\uff1a{" + (Object)((Object)this.getExecutionEnum()) + "}"));
        SqlPartStringBuilder sqlPartStringBuilder = new SqlPartStringBuilder();
        sqlPartStringBuilder.append(Persistence.ExecutionEnum.UPSERT_WITH_SET.getExecution()).append(this.getPrimaryTable());
        sqlPartStringBuilder.append(" ");
        if (!ObjectUtils.isEmpty(this.getInsertSet())) {
            sqlPartStringBuilder.append("(");
            String setColumnSql = this.getInsertSet().keySet().stream().map(SourceFactory::cleanSpecialColumn).collect(Collectors.joining(","));
            sqlPartStringBuilder.append(setColumnSql);
            sqlPartStringBuilder.append(")");
            sqlPartStringBuilder.append(" ");
            sqlPartStringBuilder.append("VALUES");
            sqlPartStringBuilder.append(" ");
            sqlPartStringBuilder.append("(");
            String setColumnValueSql = this.getInsertSet().values().stream().map(fieldValue -> Objects.requireNonNull(LazySQLUtil.valueToSqlValue((Object)fieldValue)).toString()).collect(Collectors.joining(","));
            sqlPartStringBuilder.append(setColumnValueSql);
            sqlPartStringBuilder.append(")");
            sqlPartStringBuilder.append(" ");
            sqlPartStringBuilder.append("ON DUPLICATE KEY UPDATE");
            String updateColumns = this.getInsertSet().keySet().stream().map(column -> column + "=" + "VALUES" + " " + "(" + column + ")").collect(Collectors.joining(","));
            sqlPartStringBuilder.append(updateColumns);
            sqlPartStringBuilder.append(" ");
        }
        return sqlPartStringBuilder;
    }

    @Override
    public SqlPartStringBuilder delete() {
        AssertFactory.isFalse((boolean)Persistence.ExecutionEnum.DELETE.equals((Object)this.getExecutionEnum()), (String)("\u6267\u884c\u65b9\u6cd5\u9519\u8bef\uff1a{" + (Object)((Object)this.getExecutionEnum()) + "}"));
        SqlPartStringBuilder sqlPartStringBuilder = new SqlPartStringBuilder();
        sqlPartStringBuilder.append(Persistence.ExecutionEnum.DELETE.getExecution()).append("from").append(this.getPrimaryTable());
        return sqlPartStringBuilder;
    }
}

