/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.orm.database.lambda.stream.condition.part;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.wu.framework.core.utils.ObjectUtils;
import org.wu.framework.lazy.orm.core.config.enums.RowValueType;
import org.wu.framework.lazy.orm.core.persistence.util.LazySQLUtil;
import org.wu.framework.lazy.orm.database.lambda.domain.Persistence;
import org.wu.framework.lazy.orm.database.lambda.domain.PersistenceRepository;
import org.wu.framework.lazy.orm.database.lambda.domain.PersistenceRepositoryFactory;
import org.wu.framework.lazy.orm.database.lambda.stream.condition.part.Condition;
import org.wu.framework.lazy.orm.database.lambda.stream.condition.part.SqlPartAbstract;

public class SqlPart
extends SqlPartAbstract {
    private Persistence.ExecutionEnum executionEnum;
    private Map<String, String> columnAsMap = new HashMap<String, String>();
    private List<String> ignoreColumnList = new ArrayList<String>();
    private Boolean onlyUseAs = false;
    private String prefix;
    private String primaryTable;
    private Class<?> primaryClass;
    private List<HashMap<String, Object>> insert;
    private Map<String, Object> insertDuplicateKey;
    private Map<String, Object> insertSet;
    private Map<String, Object> updateSet;
    private String conditionType;
    private List<Condition> conditionList = new ArrayList<Condition>();
    private List<SqlPart> orSqlPart = new ArrayList<SqlPart>();
    private List<SqlPart> joinConditions = new ArrayList<SqlPart>();
    private List<Condition> groupByConditions = new ArrayList<Condition>();
    private List<SqlPart> havingConditions = new ArrayList<SqlPart>();
    private List<Condition> orderConditions = new ArrayList<Condition>();
    private String limitSql;
    private String lastSql;
    private PersistenceRepository persistenceRepository = null;

    public SqlPart() {
    }

    public SqlPart(String conditionType) {
        this.conditionType = conditionType;
    }

    private void addAnd(Condition condition) {
        this.conditionList.add(condition);
    }

    public void put(Condition.AndOr andOr, Object rowName, String type, Object rowValue) {
        this.addAnd(new Condition().setAndOr(andOr).setRowName(rowName).setType(type).setRowValue(rowValue));
    }

    public void put(Object rowName, String type, Object rowValue) {
        this.addAnd(new Condition().setRowName(rowName).setType(type).setRowValue(rowValue));
    }

    public void put(Condition.AndOr andOr, Object rowName, String type, RowValueType rowValueType, Object rowValue) {
        this.addAnd(new Condition().setAndOr(andOr).setRowName(rowName).setType(type).setRowValueType(rowValueType).setRowValue(rowValue));
    }

    public void put(Object rowName, String type, RowValueType rowValueType, Object rowValue) {
        this.addAnd(new Condition().setRowName(rowName).setType(type).setRowValueType(rowValueType).setRowValue(rowValue));
    }

    public void put(Condition.AndOr andOr, String fieldName, Object rowName, String type, RowValueType rowValueType, String fieldValueName, Object rowValue) {
        this.addAnd(new Condition().setAndOr(andOr).setFieldName(fieldName).setRowName(rowName).setType(type).setRowValueType(rowValueType).setFieldValueName(fieldValueName).setRowValue(rowValue));
    }

    public void put(String fieldName, Object rowName, String type, RowValueType rowValueType, String fieldValueName, Object rowValue) {
        this.addAnd(new Condition().setFieldName(fieldName).setRowName(rowName).setType(type).setRowValueType(rowValueType).setFieldValueName(fieldValueName).setRowValue(rowValue));
    }

    public void columnAs(String columnName, String asName) {
        this.columnAsMap.put(columnName, asName);
    }

    public void ignoreColumnAs(String columnName) {
        this.ignoreColumnList.add(columnName);
    }

    public void setOnlyUseAs(boolean onlyUseAs) {
        this.onlyUseAs = onlyUseAs;
    }

    public void join(SqlPart sqlPart) {
        this.joinConditions.add(sqlPart);
    }

    public void or(SqlPart sqlPart) {
        this.orSqlPart.add(sqlPart);
    }

    public void groupBy(Condition condition) {
        this.groupByConditions.add(condition);
    }

    public void having(SqlPart condition) {
        this.havingConditions.add(condition);
    }

    public void orderBy(Condition condition) {
        this.orderConditions.add(condition);
    }

    public StringBuilder splice(String prefix) {
        StringBuilder builder = new StringBuilder(prefix);
        String join = this.joinConditions.stream().map(conditionList -> " " + conditionList.getPrefix() + " " + conditionList.getPrimaryTable() + " " + conditionList.getConditionType() + conditionList.conditionList.stream().map(condition -> {
            if (RowValueType.STRING.equals((Object)condition.getRowValueType())) {
                return " " + condition.getRowName() + " " + " " + condition.getType() + " " + LazySQLUtil.sqlValue((Object)condition.getRowValue(), (!"in".equals(condition.getType()) ? 1 : 0) != 0) + " ";
            }
            return " " + condition.getRowName() + " " + " " + condition.getType() + " " + LazySQLUtil.sqlValue((Object)condition.getRowValue(), (boolean)false) + " ";
        }).collect(Collectors.joining("and")) + " ").collect(Collectors.joining());
        builder.append(join);
        String splice = this.conditionList.stream().map(condition -> {
            if (RowValueType.STRING.equals((Object)condition.getRowValueType())) {
                return " " + condition.getRowName() + " " + " " + condition.getType() + " " + LazySQLUtil.valueToSqlValue((Object)condition.getRowValue(), (RowValueType)RowValueType.STRING) + " ";
            }
            return " " + condition.getRowName() + " " + " " + condition.getType() + " " + LazySQLUtil.valueToSqlValue((Object)condition.getRowValue(), (RowValueType)RowValueType.EXPRESSION) + " ";
        }).collect(Collectors.joining(" and "));
        String orSplice = this.orSqlPart.stream().map(sqlPart -> "(" + sqlPart.getConditionList().stream().map(condition -> {
            if (RowValueType.STRING.equals((Object)condition.getRowValueType())) {
                return " " + condition.getRowName() + " " + " " + condition.getType() + " " + LazySQLUtil.valueToSqlValue((Object)condition.getRowValue(), (RowValueType)RowValueType.STRING) + " ";
            }
            return " " + condition.getRowName() + " " + " " + condition.getType() + " " + LazySQLUtil.valueToSqlValue((Object)condition.getRowValue(), (RowValueType)RowValueType.EXPRESSION) + " ";
        }).collect(Collectors.joining(" and ")) + ")").collect(Collectors.joining(" or "));
        if (ObjectUtils.isEmpty((Object)splice)) {
            splice = orSplice;
        } else if (!ObjectUtils.isEmpty((Object)orSplice)) {
            splice = splice + "or" + " " + orSplice;
        }
        if (ObjectUtils.isEmpty((Object)splice)) {
            this.appendGroupAndOrder(builder);
            return builder;
        }
        builder.append(this.conditionType);
        builder.append(splice);
        this.appendGroupAndOrder(builder);
        this.appendLimitAndLast(builder);
        return builder;
    }

    public StringBuilder appendGroupAndOrder(StringBuilder builder) {
        if (!ObjectUtils.isEmpty(this.groupByConditions)) {
            String groupBy = this.groupByConditions.stream().map(condition -> condition.getRowName().toString()).collect(Collectors.joining(","));
            builder.append(" group by ");
            builder.append(groupBy);
        }
        if (!ObjectUtils.isEmpty(this.orderConditions)) {
            String orderBy = this.orderConditions.stream().map(condition -> condition.getRowName().toString()).collect(Collectors.joining(","));
            builder.append(" order by ");
            builder.append(orderBy);
            Optional<String> first = this.orderConditions.stream().map(Condition::getType).findFirst();
            first.ifPresent(s -> builder.append(" ").append((String)s));
        }
        return builder;
    }

    public StringBuilder appendLimitAndLast(StringBuilder builder) {
        if (!ObjectUtils.isEmpty((Object)this.limitSql)) {
            builder.append(this.limitSql);
        }
        if (!ObjectUtils.isEmpty((Object)this.lastSql)) {
            builder.append(this.lastSql);
        }
        return builder;
    }

    public PersistenceRepository persistenceRepository() {
        if (this.persistenceRepository == null) {
            this.persistenceRepository = PersistenceRepositoryFactory.create();
        }
        String sql = this.sql();
        this.persistenceRepository.setSqlPart(this);
        this.persistenceRepository.setQueryString(sql);
        return this.persistenceRepository;
    }

    public String sql() {
        String prefixSql = this.prefix;
        if (ObjectUtils.isEmpty((Object)prefixSql)) {
            if (Persistence.ExecutionEnum.SELECT.equals((Object)this.getExecutionEnum())) {
                prefixSql = this.select().toString();
            } else if (Persistence.ExecutionEnum.DELETE.equals((Object)this.getExecutionEnum())) {
                prefixSql = this.delete().toString();
            } else if (Persistence.ExecutionEnum.UPDATE.equals((Object)this.getExecutionEnum())) {
                prefixSql = this.update().toString();
            } else if (Persistence.ExecutionEnum.INSERT.equals((Object)this.getExecutionEnum())) {
                prefixSql = this.insert().toString();
            } else if (Persistence.ExecutionEnum.UPSERT.equals((Object)this.getExecutionEnum())) {
                prefixSql = this.upsert().toString();
            } else if (Persistence.ExecutionEnum.INSERT_WITH_SET.equals((Object)this.getExecutionEnum())) {
                prefixSql = this.insertWithSet().toString();
            } else if (Persistence.ExecutionEnum.UPSERT_WITH_SET.equals((Object)this.getExecutionEnum())) {
                prefixSql = this.upsertWithSet().toString();
            }
        }
        return this.splice(prefixSql).toString();
    }

    public Condition createCondition() {
        return new Condition();
    }

    public SqlPart copy() {
        SqlPart conditions = new SqlPart();
        for (Condition condition : this.conditionList) {
            conditions.addAnd(condition.copy());
        }
        conditions.setExecutionEnum(this.getExecutionEnum());
        conditions.setPrefix(this.getPrefix());
        conditions.setPrimaryTable(this.getPrimaryTable());
        conditions.setPrimaryClass(this.getPrimaryClass());
        conditions.setConditionType(this.getConditionType());
        conditions.setConditionList(this.getConditionList());
        conditions.setJoinConditions(this.getJoinConditions());
        conditions.setOrSqlPart(this.getOrSqlPart());
        conditions.setGroupByConditions(this.getGroupByConditions());
        conditions.setOrderConditions(this.getOrderConditions());
        conditions.setLimitSql(this.getLimitSql());
        conditions.setLastSql(this.getLastSql());
        conditions.setColumnAsMap(this.getColumnAsMap());
        conditions.setIgnoreColumnList(this.getIgnoreColumnList());
        conditions.setInsertSet(this.getInsertSet());
        conditions.setInsert(this.getInsert());
        conditions.setInsertDuplicateKey(this.getInsertDuplicateKey());
        conditions.setUpdateSet(this.getUpdateSet());
        conditions.setHavingConditions(this.getHavingConditions());
        conditions.setOnlyUseAs(this.getOnlyUseAs());
        return conditions;
    }

    public String toString() {
        return "SqlPart{executionEnum=" + (Object)((Object)this.executionEnum) + ", columnAsMap=" + this.columnAsMap + ", ignoreColumnList=" + this.ignoreColumnList + ", onlyUseAs=" + this.onlyUseAs + ", prefix='" + this.prefix + '\'' + ", primaryTable='" + this.primaryTable + '\'' + ", primaryClass=" + this.primaryClass + ", insertWithSet=" + this.insert + ", insertDuplicateKey=" + this.insertDuplicateKey + ", insertSet=" + this.insertSet + ", updateSet=" + this.updateSet + ", conditionType='" + this.conditionType + '\'' + ", conditionList=" + this.conditionList + ", orSqlPart=" + this.orSqlPart + ", joinConditions=" + this.joinConditions + ", groupByConditions=" + this.groupByConditions + ", havingConditions=" + this.havingConditions + ", orderConditions=" + this.orderConditions + ", limitSql='" + this.limitSql + '\'' + ", lastSql='" + this.lastSql + '\'' + '}';
    }

    @Override
    @Generated
    public Persistence.ExecutionEnum getExecutionEnum() {
        return this.executionEnum;
    }

    @Override
    @Generated
    public Map<String, String> getColumnAsMap() {
        return this.columnAsMap;
    }

    @Override
    @Generated
    public List<String> getIgnoreColumnList() {
        return this.ignoreColumnList;
    }

    @Override
    @Generated
    public Boolean getOnlyUseAs() {
        return this.onlyUseAs;
    }

    @Generated
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    @Generated
    public String getPrimaryTable() {
        return this.primaryTable;
    }

    @Override
    @Generated
    public Class<?> getPrimaryClass() {
        return this.primaryClass;
    }

    @Override
    @Generated
    public List<HashMap<String, Object>> getInsert() {
        return this.insert;
    }

    @Override
    @Generated
    public Map<String, Object> getInsertDuplicateKey() {
        return this.insertDuplicateKey;
    }

    @Override
    @Generated
    public Map<String, Object> getInsertSet() {
        return this.insertSet;
    }

    @Override
    @Generated
    public Map<String, Object> getUpdateSet() {
        return this.updateSet;
    }

    @Generated
    public String getConditionType() {
        return this.conditionType;
    }

    @Generated
    public List<Condition> getConditionList() {
        return this.conditionList;
    }

    @Override
    @Generated
    public List<SqlPart> getOrSqlPart() {
        return this.orSqlPart;
    }

    @Override
    @Generated
    public List<SqlPart> getJoinConditions() {
        return this.joinConditions;
    }

    @Generated
    public List<Condition> getGroupByConditions() {
        return this.groupByConditions;
    }

    @Generated
    public List<SqlPart> getHavingConditions() {
        return this.havingConditions;
    }

    @Generated
    public List<Condition> getOrderConditions() {
        return this.orderConditions;
    }

    @Generated
    public String getLimitSql() {
        return this.limitSql;
    }

    @Generated
    public String getLastSql() {
        return this.lastSql;
    }

    @Generated
    public PersistenceRepository getPersistenceRepository() {
        return this.persistenceRepository;
    }

    @Generated
    public SqlPart setExecutionEnum(Persistence.ExecutionEnum executionEnum) {
        this.executionEnum = executionEnum;
        return this;
    }

    @Generated
    public SqlPart setColumnAsMap(Map<String, String> columnAsMap) {
        this.columnAsMap = columnAsMap;
        return this;
    }

    @Generated
    public SqlPart setIgnoreColumnList(List<String> ignoreColumnList) {
        this.ignoreColumnList = ignoreColumnList;
        return this;
    }

    @Generated
    public SqlPart setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @Generated
    public SqlPart setPrimaryTable(String primaryTable) {
        this.primaryTable = primaryTable;
        return this;
    }

    @Generated
    public SqlPart setPrimaryClass(Class<?> primaryClass) {
        this.primaryClass = primaryClass;
        return this;
    }

    @Generated
    public SqlPart setInsert(List<HashMap<String, Object>> insert) {
        this.insert = insert;
        return this;
    }

    @Generated
    public SqlPart setInsertDuplicateKey(Map<String, Object> insertDuplicateKey) {
        this.insertDuplicateKey = insertDuplicateKey;
        return this;
    }

    @Generated
    public SqlPart setInsertSet(Map<String, Object> insertSet) {
        this.insertSet = insertSet;
        return this;
    }

    @Generated
    public SqlPart setUpdateSet(Map<String, Object> updateSet) {
        this.updateSet = updateSet;
        return this;
    }

    @Generated
    public SqlPart setConditionType(String conditionType) {
        this.conditionType = conditionType;
        return this;
    }

    @Generated
    public SqlPart setConditionList(List<Condition> conditionList) {
        this.conditionList = conditionList;
        return this;
    }

    @Generated
    public SqlPart setOrSqlPart(List<SqlPart> orSqlPart) {
        this.orSqlPart = orSqlPart;
        return this;
    }

    @Generated
    public SqlPart setJoinConditions(List<SqlPart> joinConditions) {
        this.joinConditions = joinConditions;
        return this;
    }

    @Generated
    public SqlPart setGroupByConditions(List<Condition> groupByConditions) {
        this.groupByConditions = groupByConditions;
        return this;
    }

    @Generated
    public SqlPart setHavingConditions(List<SqlPart> havingConditions) {
        this.havingConditions = havingConditions;
        return this;
    }

    @Generated
    public SqlPart setOrderConditions(List<Condition> orderConditions) {
        this.orderConditions = orderConditions;
        return this;
    }

    @Generated
    public SqlPart setLimitSql(String limitSql) {
        this.limitSql = limitSql;
        return this;
    }

    @Generated
    public SqlPart setLastSql(String lastSql) {
        this.lastSql = lastSql;
        return this;
    }

    @Generated
    public SqlPart setPersistenceRepository(PersistenceRepository persistenceRepository) {
        this.persistenceRepository = persistenceRepository;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SqlPart)) {
            return false;
        }
        SqlPart other = (SqlPart)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$onlyUseAs = this.getOnlyUseAs();
        Boolean other$onlyUseAs = other.getOnlyUseAs();
        if (this$onlyUseAs == null ? other$onlyUseAs != null : !((Object)this$onlyUseAs).equals(other$onlyUseAs)) {
            return false;
        }
        Persistence.ExecutionEnum this$executionEnum = this.getExecutionEnum();
        Persistence.ExecutionEnum other$executionEnum = other.getExecutionEnum();
        if (this$executionEnum == null ? other$executionEnum != null : !((Object)((Object)this$executionEnum)).equals((Object)other$executionEnum)) {
            return false;
        }
        Map<String, String> this$columnAsMap = this.getColumnAsMap();
        Map<String, String> other$columnAsMap = other.getColumnAsMap();
        if (this$columnAsMap == null ? other$columnAsMap != null : !((Object)this$columnAsMap).equals(other$columnAsMap)) {
            return false;
        }
        List<String> this$ignoreColumnList = this.getIgnoreColumnList();
        List<String> other$ignoreColumnList = other.getIgnoreColumnList();
        if (this$ignoreColumnList == null ? other$ignoreColumnList != null : !((Object)this$ignoreColumnList).equals(other$ignoreColumnList)) {
            return false;
        }
        String this$prefix = this.getPrefix();
        String other$prefix = other.getPrefix();
        if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
            return false;
        }
        String this$primaryTable = this.getPrimaryTable();
        String other$primaryTable = other.getPrimaryTable();
        if (this$primaryTable == null ? other$primaryTable != null : !this$primaryTable.equals(other$primaryTable)) {
            return false;
        }
        Class<?> this$primaryClass = this.getPrimaryClass();
        Class<?> other$primaryClass = other.getPrimaryClass();
        if (this$primaryClass == null ? other$primaryClass != null : !this$primaryClass.equals(other$primaryClass)) {
            return false;
        }
        List<HashMap<String, Object>> this$insert = this.getInsert();
        List<HashMap<String, Object>> other$insert = other.getInsert();
        if (this$insert == null ? other$insert != null : !((Object)this$insert).equals(other$insert)) {
            return false;
        }
        Map<String, Object> this$insertDuplicateKey = this.getInsertDuplicateKey();
        Map<String, Object> other$insertDuplicateKey = other.getInsertDuplicateKey();
        if (this$insertDuplicateKey == null ? other$insertDuplicateKey != null : !((Object)this$insertDuplicateKey).equals(other$insertDuplicateKey)) {
            return false;
        }
        Map<String, Object> this$insertSet = this.getInsertSet();
        Map<String, Object> other$insertSet = other.getInsertSet();
        if (this$insertSet == null ? other$insertSet != null : !((Object)this$insertSet).equals(other$insertSet)) {
            return false;
        }
        Map<String, Object> this$updateSet = this.getUpdateSet();
        Map<String, Object> other$updateSet = other.getUpdateSet();
        if (this$updateSet == null ? other$updateSet != null : !((Object)this$updateSet).equals(other$updateSet)) {
            return false;
        }
        String this$conditionType = this.getConditionType();
        String other$conditionType = other.getConditionType();
        if (this$conditionType == null ? other$conditionType != null : !this$conditionType.equals(other$conditionType)) {
            return false;
        }
        List<Condition> this$conditionList = this.getConditionList();
        List<Condition> other$conditionList = other.getConditionList();
        if (this$conditionList == null ? other$conditionList != null : !((Object)this$conditionList).equals(other$conditionList)) {
            return false;
        }
        List<SqlPart> this$orSqlPart = this.getOrSqlPart();
        List<SqlPart> other$orSqlPart = other.getOrSqlPart();
        if (this$orSqlPart == null ? other$orSqlPart != null : !((Object)this$orSqlPart).equals(other$orSqlPart)) {
            return false;
        }
        List<SqlPart> this$joinConditions = this.getJoinConditions();
        List<SqlPart> other$joinConditions = other.getJoinConditions();
        if (this$joinConditions == null ? other$joinConditions != null : !((Object)this$joinConditions).equals(other$joinConditions)) {
            return false;
        }
        List<Condition> this$groupByConditions = this.getGroupByConditions();
        List<Condition> other$groupByConditions = other.getGroupByConditions();
        if (this$groupByConditions == null ? other$groupByConditions != null : !((Object)this$groupByConditions).equals(other$groupByConditions)) {
            return false;
        }
        List<SqlPart> this$havingConditions = this.getHavingConditions();
        List<SqlPart> other$havingConditions = other.getHavingConditions();
        if (this$havingConditions == null ? other$havingConditions != null : !((Object)this$havingConditions).equals(other$havingConditions)) {
            return false;
        }
        List<Condition> this$orderConditions = this.getOrderConditions();
        List<Condition> other$orderConditions = other.getOrderConditions();
        if (this$orderConditions == null ? other$orderConditions != null : !((Object)this$orderConditions).equals(other$orderConditions)) {
            return false;
        }
        String this$limitSql = this.getLimitSql();
        String other$limitSql = other.getLimitSql();
        if (this$limitSql == null ? other$limitSql != null : !this$limitSql.equals(other$limitSql)) {
            return false;
        }
        String this$lastSql = this.getLastSql();
        String other$lastSql = other.getLastSql();
        if (this$lastSql == null ? other$lastSql != null : !this$lastSql.equals(other$lastSql)) {
            return false;
        }
        PersistenceRepository this$persistenceRepository = this.getPersistenceRepository();
        PersistenceRepository other$persistenceRepository = other.getPersistenceRepository();
        return !(this$persistenceRepository == null ? other$persistenceRepository != null : !((Object)this$persistenceRepository).equals(other$persistenceRepository));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SqlPart;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $onlyUseAs = this.getOnlyUseAs();
        result = result * 59 + ($onlyUseAs == null ? 43 : ((Object)$onlyUseAs).hashCode());
        Persistence.ExecutionEnum $executionEnum = this.getExecutionEnum();
        result = result * 59 + ($executionEnum == null ? 43 : ((Object)((Object)$executionEnum)).hashCode());
        Map<String, String> $columnAsMap = this.getColumnAsMap();
        result = result * 59 + ($columnAsMap == null ? 43 : ((Object)$columnAsMap).hashCode());
        List<String> $ignoreColumnList = this.getIgnoreColumnList();
        result = result * 59 + ($ignoreColumnList == null ? 43 : ((Object)$ignoreColumnList).hashCode());
        String $prefix = this.getPrefix();
        result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
        String $primaryTable = this.getPrimaryTable();
        result = result * 59 + ($primaryTable == null ? 43 : $primaryTable.hashCode());
        Class<?> $primaryClass = this.getPrimaryClass();
        result = result * 59 + ($primaryClass == null ? 43 : $primaryClass.hashCode());
        List<HashMap<String, Object>> $insert = this.getInsert();
        result = result * 59 + ($insert == null ? 43 : ((Object)$insert).hashCode());
        Map<String, Object> $insertDuplicateKey = this.getInsertDuplicateKey();
        result = result * 59 + ($insertDuplicateKey == null ? 43 : ((Object)$insertDuplicateKey).hashCode());
        Map<String, Object> $insertSet = this.getInsertSet();
        result = result * 59 + ($insertSet == null ? 43 : ((Object)$insertSet).hashCode());
        Map<String, Object> $updateSet = this.getUpdateSet();
        result = result * 59 + ($updateSet == null ? 43 : ((Object)$updateSet).hashCode());
        String $conditionType = this.getConditionType();
        result = result * 59 + ($conditionType == null ? 43 : $conditionType.hashCode());
        List<Condition> $conditionList = this.getConditionList();
        result = result * 59 + ($conditionList == null ? 43 : ((Object)$conditionList).hashCode());
        List<SqlPart> $orSqlPart = this.getOrSqlPart();
        result = result * 59 + ($orSqlPart == null ? 43 : ((Object)$orSqlPart).hashCode());
        List<SqlPart> $joinConditions = this.getJoinConditions();
        result = result * 59 + ($joinConditions == null ? 43 : ((Object)$joinConditions).hashCode());
        List<Condition> $groupByConditions = this.getGroupByConditions();
        result = result * 59 + ($groupByConditions == null ? 43 : ((Object)$groupByConditions).hashCode());
        List<SqlPart> $havingConditions = this.getHavingConditions();
        result = result * 59 + ($havingConditions == null ? 43 : ((Object)$havingConditions).hashCode());
        List<Condition> $orderConditions = this.getOrderConditions();
        result = result * 59 + ($orderConditions == null ? 43 : ((Object)$orderConditions).hashCode());
        String $limitSql = this.getLimitSql();
        result = result * 59 + ($limitSql == null ? 43 : $limitSql.hashCode());
        String $lastSql = this.getLastSql();
        result = result * 59 + ($lastSql == null ? 43 : $lastSql.hashCode());
        PersistenceRepository $persistenceRepository = this.getPersistenceRepository();
        result = result * 59 + ($persistenceRepository == null ? 43 : ((Object)$persistenceRepository).hashCode());
        return result;
    }
}

