/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.orm.database.lambda.stream.condition.as;

import org.wu.framework.core.CamelAndUnderLineConverter;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyTableEndpoint;
import org.wu.framework.lazy.orm.core.persistence.util.SqlMessageFormatUtil;
import org.wu.framework.lazy.orm.core.source.SqlSourceClass;
import org.wu.framework.lazy.orm.core.source.adapter.SourceFactory;
import org.wu.framework.lazy.orm.database.lambda.domain.Persistence;
import org.wu.framework.lazy.orm.database.lambda.domain.PersistenceRepository;
import org.wu.framework.lazy.orm.database.lambda.stream.condition.BasicComparison;
import org.wu.framework.lazy.orm.database.lambda.stream.condition.as.FunctionAsComparison;
import org.wu.framework.lazy.orm.database.lambda.stream.condition.part.SqlPart;
import org.wu.framework.lazy.orm.database.lambda.stream.function.Snippet;
import org.wu.framework.lazy.orm.database.lambda.stream.function.SnippetUtil;
import org.wu.framework.lazy.orm.database.lambda.stream.support.LambdaMeta;

public class LambdaFunctionAsComparison<T>
implements FunctionAsComparison<T, LambdaFunctionAsComparison<T>> {
    private String functionFragment;

    protected <T1> String snippetToTableColumnString(Snippet<T1, ?> row) {
        LambdaMeta meta = SnippetUtil.extract(row);
        assert (meta != null);
        Class<?> tClass = meta.instantiatedClass();
        String methodName = meta.methodName();
        if ("toString".equals(methodName)) {
            return methodName;
        }
        String field = CamelAndUnderLineConverter.methodToField((String)methodName);
        String fieldRowName = CamelAndUnderLineConverter.humpToLine2((String)field);
        SqlSourceClass sqlSourceClass = SqlSourceClass.getInstance(tClass);
        String tableName = sqlSourceClass.getLazyTableEndpoint().getTableName();
        return tableName + "." + fieldRowName;
    }

    protected <T1> String snippetToColumnString(Snippet<T1, ?> row) {
        LambdaMeta meta = SnippetUtil.extract(row);
        assert (meta != null);
        String methodName = meta.methodName();
        if ("toString".equals(methodName)) {
            return methodName;
        }
        String field = CamelAndUnderLineConverter.methodToField((String)methodName);
        String fieldRowName = CamelAndUnderLineConverter.humpToLine2((String)field);
        return fieldRowName;
    }

    @Override
    public <T1> LambdaFunctionAsComparison<T> select(Snippet<T1, ?> row, BasicComparison<T1, ?, ?, ?> comparison) {
        String tableColumn = this.snippetToTableColumnString(row);
        String column = this.snippetToColumnString(row);
        SqlPart sqlPart = comparison.getSqlPart();
        sqlPart.setOnlyUseAs(true);
        sqlPart.columnAs(tableColumn, column);
        Class classT = comparison.getClassT();
        LazyTableEndpoint lazyTableEndpoint = SourceFactory.defaultAnalyzeLazyTableFromClass(classT);
        String tableName = lazyTableEndpoint.getTableName();
        sqlPart.setExecutionEnum(Persistence.ExecutionEnum.SELECT);
        sqlPart.setPrimaryClass(classT);
        sqlPart.setPrimaryTable(tableName);
        PersistenceRepository persistenceRepository = sqlPart.persistenceRepository();
        this.functionFragment = String.format("(%s)", persistenceRepository.getQueryString());
        return this;
    }

    @Override
    public <T1> LambdaFunctionAsComparison<T> sqlFunction(String sql) {
        this.functionFragment = sql;
        return this;
    }

    @Override
    public <T1> LambdaFunctionAsComparison<T> count(Snippet<T1, ?> snippet) {
        this.functionFragment = SqlMessageFormatUtil.format((String)" count({0}) ", (Object[])new Object[]{this.snippetToTableColumnString(snippet)});
        return this;
    }

    @Override
    public <T1> LambdaFunctionAsComparison<T> sum(Snippet<T1, ?> snippet) {
        this.functionFragment = SqlMessageFormatUtil.format((String)" sum({0}) ", (Object[])new Object[]{this.snippetToTableColumnString(snippet)});
        return this;
    }

    @Override
    public <T1> LambdaFunctionAsComparison<T> max(Snippet<T1, ?> snippet) {
        this.functionFragment = SqlMessageFormatUtil.format((String)" max({0}) ", (Object[])new Object[]{this.snippetToTableColumnString(snippet)});
        return this;
    }

    @Override
    public <T1> LambdaFunctionAsComparison<T> min(Snippet<T1, ?> snippet) {
        this.functionFragment = SqlMessageFormatUtil.format((String)" min({0}) ", (Object[])new Object[]{this.snippetToTableColumnString(snippet)});
        return this;
    }

    @Override
    public String getFunctionFragment() {
        return this.functionFragment;
    }
}

