/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.orm.database.lambda.stream.condition;

import java.util.Collection;
import java.util.stream.Collectors;
import org.wu.framework.core.utils.ObjectUtils;
import org.wu.framework.lazy.orm.core.config.enums.RowValueType;
import org.wu.framework.lazy.orm.core.persistence.util.LazySQLUtil;
import org.wu.framework.lazy.orm.database.lambda.stream.condition.BasicComparison;
import org.wu.framework.lazy.orm.database.lambda.stream.condition.part.Condition;
import org.wu.framework.lazy.orm.database.lambda.stream.condition.part.SqlPart;

public abstract class AbstractJoinBasicComparison<T1, T2, R1, R2>
implements BasicComparison<T1, R1, R2, AbstractJoinBasicComparison<T1, T2, R1, R2>> {
    protected SqlPart sqlPart = new SqlPart(" on ");

    @Override
    public AbstractJoinBasicComparison<T1, T2, R1, R2> apply(boolean condition, String applySql, Object ... values) {
        if (condition) {
            if (ObjectUtils.isEmpty((Object)applySql)) {
                return this;
            }
            this.sqlPart.put(String.format(applySql, values), " ", RowValueType.EXPRESSION, (Object)" ");
        }
        return this;
    }

    @Override
    public AbstractJoinBasicComparison<T1, T2, R1, R2> groupBy(R1 ... rows) {
        for (R1 row : rows) {
            String rowName = this.column1ToString(row);
            Condition condition = new Condition();
            condition.setRowName(rowName);
            this.sqlPart.groupBy(condition);
        }
        return this;
    }

    @Override
    public AbstractJoinBasicComparison<T1, T2, R1, R2> orderBy(String order, R1 ... rows) {
        for (R1 row : rows) {
            String rowName = this.column1ToString(row);
            Condition condition = new Condition();
            condition.setRowName(rowName);
            condition.setType(order);
            this.sqlPart.orderBy(condition);
        }
        return this;
    }

    @Override
    public AbstractJoinBasicComparison<T1, T2, R1, R2> eq(boolean condition, R1 row, R2 var) {
        if (condition) {
            this.sqlPart.put(this.column1ToString(row), "=", RowValueType.EXPRESSION, (Object)this.column2ToString(var));
            this.sqlPart.setPrimaryClass(this.getClassT2());
        }
        return this;
    }

    @Override
    public AbstractJoinBasicComparison<T1, T2, R1, R2> or(boolean condition, R1 row, R2 var) {
        if (condition) {
            this.sqlPart.put(Condition.AndOr.OR, this.column1ToString(row), "=", RowValueType.EXPRESSION, this.column2ToString(var));
            this.sqlPart.setPrimaryClass(this.getClassT2());
        }
        return this;
    }

    @Override
    public AbstractJoinBasicComparison<T1, T2, R1, R2> eqo(boolean condition, R1 row, Object var) {
        if (condition) {
            this.sqlPart.put(this.column1ToString(row), "=", var);
            this.sqlPart.setPrimaryClass(this.getClassT1());
        }
        return this;
    }

    public AbstractJoinBasicComparison<T1, T2, R1, R2> eqRighto(R2 row, Object var) {
        return this.eqRighto(true, row, var);
    }

    public AbstractJoinBasicComparison<T1, T2, R1, R2> eqRightIgnoreEmptyO(R2 row, Object var) {
        if (ObjectUtils.isNotEmpty((Object)var)) {
            return this.eqRighto(row, var);
        }
        return this;
    }

    public AbstractJoinBasicComparison<T1, T2, R1, R2> eqRighto(boolean condition, R2 row, Object var) {
        if (condition) {
            this.sqlPart.put(this.column2ToString(row), "=", var);
            this.sqlPart.setPrimaryClass(this.getClassT2());
        }
        return this;
    }

    @Override
    public AbstractJoinBasicComparison<T1, T2, R1, R2> ne(boolean condition, R1 row, R2 var) {
        this.sqlPart.put(this.column1ToString(row), "!=", RowValueType.EXPRESSION, (Object)this.column2ToString(var));
        this.sqlPart.setPrimaryClass(this.getClassT2());
        return this;
    }

    @Override
    public AbstractJoinBasicComparison<T1, T2, R1, R2> neo(boolean condition, R1 row, Object var) {
        if (condition) {
            this.sqlPart.put(this.column1ToString(row), "!=", RowValueType.EXPRESSION, var);
            this.sqlPart.setPrimaryClass(this.getClassT2());
        }
        return this;
    }

    public AbstractJoinBasicComparison<T1, T2, R1, R2> neRighto(R2 row, Object var) {
        return this.neRighto(true, row, var);
    }

    public AbstractJoinBasicComparison<T1, T2, R1, R2> neRightIgnoreEmptyO(R2 row, Object var) {
        if (ObjectUtils.isNotEmpty((Object)var)) {
            return this.neRighto(true, row, var);
        }
        return this;
    }

    public AbstractJoinBasicComparison<T1, T2, R1, R2> neRighto(boolean condition, R2 row, Object var) {
        if (condition) {
            this.sqlPart.put(this.column2ToString(row), "!=", var);
            this.sqlPart.setPrimaryClass(this.getClassT2());
        }
        return this;
    }

    @Override
    public AbstractJoinBasicComparison<T1, T2, R1, R2> notNull(R1 row) {
        this.sqlPart.put(this.column1ToString(row), "IS not ", null);
        return this;
    }

    @Override
    public AbstractJoinBasicComparison<T1, T2, R1, R2> isNull(R1 row) {
        this.sqlPart.put(this.column1ToString(row), "IS ", null);
        return this;
    }

    public AbstractJoinBasicComparison<T1, T2, R1, R2> isNullRight(R2 row) {
        this.sqlPart.put(this.column2ToString(row), "IS ", null);
        return this;
    }

    public AbstractJoinBasicComparison<T1, T2, R1, R2> notNullRight(R2 row) {
        this.sqlPart.put(this.column2ToString(row), "IS not ", null);
        return this;
    }

    @Override
    public AbstractJoinBasicComparison<T1, T2, R1, R2> gt(boolean condition, R1 row, R2 var) {
        if (condition) {
            this.sqlPart.put(this.column1ToString(row), ">", RowValueType.EXPRESSION, (Object)this.column2ToString(var));
            this.sqlPart.setPrimaryClass(this.getClassT2());
        }
        return this;
    }

    @Override
    public AbstractJoinBasicComparison<T1, T2, R1, R2> gto(boolean condition, R1 row, Object var) {
        if (condition) {
            this.sqlPart.put(this.column1ToString(row), ">", RowValueType.EXPRESSION, var);
            this.sqlPart.setPrimaryClass(this.getClassT2());
        }
        return this;
    }

    public AbstractJoinBasicComparison<T1, T2, R1, R2> gtRighto(boolean condition, R2 row, Object var) {
        if (condition) {
            this.sqlPart.put(this.column2ToString(row), ">", RowValueType.EXPRESSION, var);
            this.sqlPart.setPrimaryClass(this.getClassT2());
        }
        return this;
    }

    public AbstractJoinBasicComparison<T1, T2, R1, R2> gtRighto(R2 row, Object var) {
        return this.gtRighto(true, row, var);
    }

    @Override
    public AbstractJoinBasicComparison<T1, T2, R1, R2> lt(boolean condition, R1 row, R2 var) {
        if (condition) {
            this.sqlPart.put(this.column1ToString(row), "<", RowValueType.EXPRESSION, (Object)this.column2ToString(var));
            this.sqlPart.setPrimaryClass(this.getClassT2());
        }
        return this;
    }

    @Override
    public AbstractJoinBasicComparison<T1, T2, R1, R2> lto(boolean condition, R1 row, Object var) {
        if (condition) {
            this.sqlPart.put(this.column1ToString(row), "<", RowValueType.EXPRESSION, var);
            this.sqlPart.setPrimaryClass(this.getClassT2());
        }
        return this;
    }

    public AbstractJoinBasicComparison<T1, T2, R1, R2> ltRighto(boolean condition, R2 row, Object var) {
        if (condition) {
            this.sqlPart.put(this.column2ToString(row), "<", RowValueType.EXPRESSION, var);
            this.sqlPart.setPrimaryClass(this.getClassT2());
        }
        return this;
    }

    public AbstractJoinBasicComparison<T1, T2, R1, R2> ltRighto(R2 row, Object var) {
        return this.ltRighto(true, row, var);
    }

    @Override
    public AbstractJoinBasicComparison<T1, T2, R1, R2> like(boolean condition, R1 row, R2 var) {
        if (condition) {
            this.sqlPart.put(this.column1ToString(row), "like", RowValueType.EXPRESSION, (Object)this.column2ToString(var));
            this.sqlPart.setPrimaryClass(this.getClassT2());
        }
        return this;
    }

    @Override
    public AbstractJoinBasicComparison<T1, T2, R1, R2> gLike(boolean condition, R1 row, R2 var) {
        if (condition) {
            this.sqlPart.put(this.column1ToString(row), "like", RowValueType.EXPRESSION, (Object)this.column2ToString(var));
            this.sqlPart.setPrimaryClass(this.getClassT2());
        }
        return this;
    }

    @Override
    public AbstractJoinBasicComparison<T1, T2, R1, R2> lLike(boolean condition, R1 row, R2 var) {
        if (condition) {
            this.sqlPart.put(this.column1ToString(row), "like", RowValueType.EXPRESSION, (Object)this.column2ToString(var));
            this.sqlPart.setPrimaryClass(this.getClassT2());
        }
        return this;
    }

    @Override
    public AbstractJoinBasicComparison<T1, T2, R1, R2> likeO(boolean condition, R1 row, Object var) {
        if (condition) {
            this.sqlPart.put(this.column1ToString(row), "like", RowValueType.EXPRESSION, var);
            this.sqlPart.setPrimaryClass(this.getClassT2());
        }
        return this;
    }

    public AbstractJoinBasicComparison<T1, T2, R1, R2> likeRightO(boolean condition, R2 row, Object var) {
        if (condition) {
            this.sqlPart.put(this.column2ToString(row), "like", RowValueType.EXPRESSION, var);
            this.sqlPart.setPrimaryClass(this.getClassT2());
        }
        return this;
    }

    public AbstractJoinBasicComparison<T1, T2, R1, R2> likeRightO(R2 row, Object var) {
        return this.likeRightO(true, row, var);
    }

    @Override
    public AbstractJoinBasicComparison<T1, T2, R1, R2> notLike(boolean condition, R1 row, R2 var) {
        if (condition) {
            this.sqlPart.put(this.column1ToString(row), "notlike", RowValueType.EXPRESSION, (Object)this.column2ToString(var));
            this.sqlPart.setPrimaryClass(this.getClassT2());
        }
        return this;
    }

    @Override
    public AbstractJoinBasicComparison<T1, T2, R1, R2> notLikeO(boolean condition, R1 row, Object var) {
        if (condition) {
            this.sqlPart.put(this.column1ToString(row), "notlike", RowValueType.EXPRESSION, var);
            this.sqlPart.setPrimaryClass(this.getClassT2());
        }
        return this;
    }

    public AbstractJoinBasicComparison<T1, T2, R1, R2> notLikeRightO(boolean condition, R2 row, Object var) {
        if (condition) {
            this.sqlPart.put(this.column2ToString(row), "notlike", RowValueType.EXPRESSION, var);
            this.sqlPart.setPrimaryClass(this.getClassT2());
        }
        return this;
    }

    public AbstractJoinBasicComparison<T1, T2, R1, R2> notLikeRightO(R2 row, Object var) {
        return this.notLikeRightO(true, row, var);
    }

    @Override
    public AbstractJoinBasicComparison<T1, T2, R1, R2> in(boolean condition, R1 row, R2 var) {
        return this;
    }

    public AbstractJoinBasicComparison<T1, T2, R1, R2> inRighto(boolean condition, R2 row, Object var) {
        if (condition) {
            if (Collection.class.isAssignableFrom(var.getClass())) {
                String in = ((Collection)var).stream().map(va -> LazySQLUtil.sqlValue((Object)va).toString()).collect(Collectors.joining(","));
                this.sqlPart.put(this.column2ToString(row), "in", RowValueType.EXPRESSION, (Object)("(" + LazySQLUtil.sqlValue((Object)in, (boolean)false) + ")"));
            } else {
                this.sqlPart.put(this.column2ToString(row), "in", RowValueType.EXPRESSION, (Object)("(" + LazySQLUtil.sqlValue((Object)var, (boolean)false) + ")"));
            }
        }
        return this;
    }

    public AbstractJoinBasicComparison<T1, T2, R1, R2> inRightIgnoreEmptyO(R2 row, Object var) {
        return this.inRighto(true, row, var);
    }

    @Override
    public AbstractJoinBasicComparison<T1, T2, R1, R2> inOr(boolean condition, R1 row, R2 var) {
        return this;
    }

    @Override
    public AbstractJoinBasicComparison<T1, T2, R1, R2> ino(boolean condition, R1 row, Object var) {
        return this;
    }

    @Override
    public AbstractJoinBasicComparison<T1, T2, R1, R2> notIn(boolean condition, R1 row, R2 var) {
        return this;
    }

    @Override
    public AbstractJoinBasicComparison<T1, T2, R1, R2> notIno(boolean condition, R1 row, Object var) {
        return this;
    }

    @Override
    public AbstractJoinBasicComparison<T1, T2, R1, R2> between(boolean condition, R1 row, Object leftVar, Object rightVar) {
        return this;
    }

    @Override
    public AbstractJoinBasicComparison<T1, T2, R1, R2> betweenO(boolean condition, R1 row, Object leftVar, Object rightVar) {
        return this;
    }

    @Override
    public AbstractJoinBasicComparison<T1, T2, R1, R2> limit(long limit) {
        this.sqlPart.setLimitSql(" limit " + limit + " ");
        return this;
    }

    @Override
    public AbstractJoinBasicComparison<T1, T2, R1, R2> limit(long skipped, long limit) {
        this.sqlPart.setLimitSql(" limit " + skipped + "," + limit + " ");
        return this;
    }

    @Override
    public AbstractJoinBasicComparison<T1, T2, R1, R2> lastSql(String lastSql) {
        this.sqlPart.setLastSql(lastSql);
        return this;
    }

    @Override
    public SqlPart getSqlPart() {
        return this.sqlPart;
    }

    protected abstract Class<T1> getClassT1();

    protected abstract Class<T2> getClassT2();

    protected abstract String column1ToString(R1 var1);

    protected abstract String column2ToString(R2 var1);
}

