/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.orm.database.lambda.dynamic.toolkit;

import java.util.ArrayDeque;
import java.util.Deque;
import javax.sql.DataSource;

public final class DynamicLazyDataSourceContextHolder {
    private static final ThreadLocal<Deque<DataSource>> LOOKUP_KEY_HOLDER = ThreadLocal.withInitial(ArrayDeque::new);

    private DynamicLazyDataSourceContextHolder() {
    }

    public static DataSource peek() {
        return LOOKUP_KEY_HOLDER.get().peek();
    }

    public static void push(DataSource ds) {
        LOOKUP_KEY_HOLDER.get().push(ds);
    }

    public static void poll() {
        Deque<DataSource> deque = LOOKUP_KEY_HOLDER.get();
        deque.poll();
        if (deque.isEmpty()) {
            LOOKUP_KEY_HOLDER.remove();
        }
    }

    public static void clear() {
        LOOKUP_KEY_HOLDER.remove();
    }
}

