/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.orm.database.lambda.domain;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;

public class LazyPage<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long total;
    private int size = 10;
    private long pages;
    private int current = 1;
    private boolean searchCount = true;
    private boolean openSort = true;
    private boolean optimizeCountSql = true;
    private List<String> ascs;
    private List<String> descs;
    private boolean isAsc = true;
    private String orderByField;
    private Collection<T> records;
    private Object ext;

    public LazyPage() {
    }

    public LazyPage(int current, int size) {
        this(current, size, true);
    }

    public LazyPage(int current, int size, boolean searchCount) {
        this(current, size, searchCount, true);
    }

    public LazyPage(int current, int size, boolean searchCount, boolean openSort) {
        if (current > 1) {
            this.current = current;
        }
        this.size = size;
        this.searchCount = searchCount;
        this.openSort = openSort;
    }

    public LazyPage(int current, int size, Collection<T> records) {
        if (current > 1) {
            this.current = current;
        }
        this.size = size;
        this.records = records;
    }

    public static <T> LazyPage<T> of(int current, int size) {
        return new LazyPage<T>(current, size);
    }

    public static <T> LazyPage<T> of(int current, int size, Collection<T> record) {
        return new LazyPage<T>(current, size, record);
    }

    public <R> LazyPage<R> convert(Function<? super T, ? extends R> mapper) {
        LazyPage<T> lazyPage = new LazyPage<T>(this.current, this.size);
        lazyPage.setTotal(this.total);
        Collection collect = this.getRecords().stream().map(mapper).collect(Collectors.toList());
        lazyPage.setRecords(collect);
        return lazyPage;
    }

    @Generated
    public long getTotal() {
        return this.total;
    }

    @Generated
    public int getSize() {
        return this.size;
    }

    @Generated
    public long getPages() {
        return this.pages;
    }

    @Generated
    public int getCurrent() {
        return this.current;
    }

    @Generated
    public boolean isSearchCount() {
        return this.searchCount;
    }

    @Generated
    public boolean isOpenSort() {
        return this.openSort;
    }

    @Generated
    public boolean isOptimizeCountSql() {
        return this.optimizeCountSql;
    }

    @Generated
    public List<String> getAscs() {
        return this.ascs;
    }

    @Generated
    public List<String> getDescs() {
        return this.descs;
    }

    @Generated
    public boolean isAsc() {
        return this.isAsc;
    }

    @Generated
    public String getOrderByField() {
        return this.orderByField;
    }

    @Generated
    public Collection<T> getRecords() {
        return this.records;
    }

    @Generated
    public Object getExt() {
        return this.ext;
    }

    @Generated
    public void setTotal(long total) {
        this.total = total;
    }

    @Generated
    public void setSize(int size) {
        this.size = size;
    }

    @Generated
    public void setPages(long pages) {
        this.pages = pages;
    }

    @Generated
    public void setCurrent(int current) {
        this.current = current;
    }

    @Generated
    public void setSearchCount(boolean searchCount) {
        this.searchCount = searchCount;
    }

    @Generated
    public void setOpenSort(boolean openSort) {
        this.openSort = openSort;
    }

    @Generated
    public void setOptimizeCountSql(boolean optimizeCountSql) {
        this.optimizeCountSql = optimizeCountSql;
    }

    @Generated
    public void setAscs(List<String> ascs) {
        this.ascs = ascs;
    }

    @Generated
    public void setDescs(List<String> descs) {
        this.descs = descs;
    }

    @Generated
    public void setAsc(boolean isAsc) {
        this.isAsc = isAsc;
    }

    @Generated
    public void setOrderByField(String orderByField) {
        this.orderByField = orderByField;
    }

    @Generated
    public void setRecords(Collection<T> records) {
        this.records = records;
    }

    @Generated
    public void setExt(Object ext) {
        this.ext = ext;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LazyPage)) {
            return false;
        }
        LazyPage other = (LazyPage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTotal() != other.getTotal()) {
            return false;
        }
        if (this.getSize() != other.getSize()) {
            return false;
        }
        if (this.getPages() != other.getPages()) {
            return false;
        }
        if (this.getCurrent() != other.getCurrent()) {
            return false;
        }
        if (this.isSearchCount() != other.isSearchCount()) {
            return false;
        }
        if (this.isOpenSort() != other.isOpenSort()) {
            return false;
        }
        if (this.isOptimizeCountSql() != other.isOptimizeCountSql()) {
            return false;
        }
        if (this.isAsc() != other.isAsc()) {
            return false;
        }
        List<String> this$ascs = this.getAscs();
        List<String> other$ascs = other.getAscs();
        if (this$ascs == null ? other$ascs != null : !((Object)this$ascs).equals(other$ascs)) {
            return false;
        }
        List<String> this$descs = this.getDescs();
        List<String> other$descs = other.getDescs();
        if (this$descs == null ? other$descs != null : !((Object)this$descs).equals(other$descs)) {
            return false;
        }
        String this$orderByField = this.getOrderByField();
        String other$orderByField = other.getOrderByField();
        if (this$orderByField == null ? other$orderByField != null : !this$orderByField.equals(other$orderByField)) {
            return false;
        }
        Collection<T> this$records = this.getRecords();
        Collection<T> other$records = other.getRecords();
        if (this$records == null ? other$records != null : !((Object)this$records).equals(other$records)) {
            return false;
        }
        Object this$ext = this.getExt();
        Object other$ext = other.getExt();
        return !(this$ext == null ? other$ext != null : !this$ext.equals(other$ext));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LazyPage;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $total = this.getTotal();
        result = result * 59 + (int)($total >>> 32 ^ $total);
        result = result * 59 + this.getSize();
        long $pages = this.getPages();
        result = result * 59 + (int)($pages >>> 32 ^ $pages);
        result = result * 59 + this.getCurrent();
        result = result * 59 + (this.isSearchCount() ? 79 : 97);
        result = result * 59 + (this.isOpenSort() ? 79 : 97);
        result = result * 59 + (this.isOptimizeCountSql() ? 79 : 97);
        result = result * 59 + (this.isAsc() ? 79 : 97);
        List<String> $ascs = this.getAscs();
        result = result * 59 + ($ascs == null ? 43 : ((Object)$ascs).hashCode());
        List<String> $descs = this.getDescs();
        result = result * 59 + ($descs == null ? 43 : ((Object)$descs).hashCode());
        String $orderByField = this.getOrderByField();
        result = result * 59 + ($orderByField == null ? 43 : $orderByField.hashCode());
        Collection<T> $records = this.getRecords();
        result = result * 59 + ($records == null ? 43 : ((Object)$records).hashCode());
        Object $ext = this.getExt();
        result = result * 59 + ($ext == null ? 43 : $ext.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "LazyPage(total=" + this.getTotal() + ", size=" + this.getSize() + ", pages=" + this.getPages() + ", current=" + this.getCurrent() + ", searchCount=" + this.isSearchCount() + ", openSort=" + this.isOpenSort() + ", optimizeCountSql=" + this.isOptimizeCountSql() + ", ascs=" + this.getAscs() + ", descs=" + this.getDescs() + ", isAsc=" + this.isAsc() + ", orderByField=" + this.getOrderByField() + ", records=" + this.getRecords() + ", ext=" + this.getExt() + ")";
    }
}

