/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.orm.database.jpa.repository.support.method;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.wu.framework.core.CamelAndUnderLineConverter;
import org.wu.framework.core.utils.ObjectUtils;
import org.wu.framework.lazy.orm.database.jpa.repository.enums.MethodName2SQLType;
import org.wu.framework.lazy.orm.database.jpa.repository.support.method.AbstractLazyDynamicMethodSimpleQuerySupport;

public class LazySelectMethodSupport
extends AbstractLazyDynamicMethodSimpleQuerySupport {
    @Override
    protected List<MethodName2SQLType> supportMethodName2SQLTypeList() {
        return Arrays.asList(MethodName2SQLType.LIST, MethodName2SQLType.QUERY, MethodName2SQLType.SELECT, MethodName2SQLType.PAGE, MethodName2SQLType.FIND, MethodName2SQLType.GET);
    }

    @Override
    public String methodName2SQL(Method method) {
        String mainTableName = this.getMainTableName(method);
        String methodName = method.getName();
        MethodName2SQLType methodName2SQLType = this.getMethodName2SQLType(methodName);
        String methodNameToLine = CamelAndUnderLineConverter.humpToLine2((String)methodName);
        String[] byString = (methodNameToLine = methodNameToLine.replaceAll(methodName2SQLType.getStartMethodNamePrefix(), "")).split("_by_");
        if (byString.length > 0) {
            String condition;
            String selectSQL = String.format("select * from %s", mainTableName);
            if (byString.length > 1 && !ObjectUtils.isEmpty((Object)byString[0])) {
                String queryColumn = byString[0].replaceFirst("_", "");
                String queryColumnSQL = Arrays.stream(queryColumn.split("_and_")).filter(selectColumn -> !ObjectUtils.isEmpty((Object)selectColumn)).collect(Collectors.joining(","));
                selectSQL = "select " + queryColumnSQL + " from " + mainTableName;
            }
            if (!ObjectUtils.isEmpty((Object)(condition = byString[1]))) {
                selectSQL = selectSQL + " WHERE ";
                String[] columnList = condition.split("_and_");
                String andList = Arrays.stream(columnList).filter(whereColumn -> !ObjectUtils.isEmpty((Object)whereColumn)).map(whereColumn -> whereColumn + " " + (whereColumn.endsWith("_in") ? "in" : "=") + " " + " " + "{" + whereColumn + "}").collect(Collectors.joining(" and "));
                return selectSQL + andList;
            }
            return selectSQL;
        }
        String format = "select * from %s";
        return String.format(format, mainTableName);
    }
}

