/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.orm.database.jpa.repository.support.method;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import org.wu.framework.lazy.orm.database.jpa.repository.enums.MethodName2SQLType;
import org.wu.framework.lazy.orm.database.jpa.repository.enums.QueryType;
import org.wu.framework.lazy.orm.database.jpa.repository.support.method.LazyDeleteMethodSupport;
import org.wu.framework.lazy.orm.database.jpa.repository.support.method.LazyDynamicMethodSimpleQuerySupport;
import org.wu.framework.lazy.orm.database.jpa.repository.support.method.LazyInsertMethodSupport;
import org.wu.framework.lazy.orm.database.jpa.repository.support.method.LazySelectMethodSupport;
import org.wu.framework.lazy.orm.database.jpa.repository.support.method.LazyUpdateMethodSupport;

public class JpaDynamicMethodSupportFactory {
    protected static final ConcurrentHashMap<QueryType, LazyDynamicMethodSimpleQuerySupport> cache = new ConcurrentHashMap(){
        {
            this.put(QueryType.INSERT, new LazyInsertMethodSupport());
            this.put(QueryType.DELETE, new LazyDeleteMethodSupport());
            this.put(QueryType.UPDATE, new LazyUpdateMethodSupport());
            this.put(QueryType.SELECT, new LazySelectMethodSupport());
        }
    };

    public static String createSqlByMethod(Method method) {
        String methodName = method.getName();
        MethodName2SQLType name2SQLType = Arrays.stream(MethodName2SQLType.values()).filter(methodName2SQLType -> methodName.startsWith(methodName2SQLType.getStartMethodNamePrefix())).findFirst().get();
        QueryType queryType = name2SQLType.getQueryType();
        return cache.get((Object)queryType).methodName2SQL(method);
    }
}

