/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.orm.database.jpa.repository.support;

import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.wu.framework.core.exception.AssertFactory;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyTableEndpoint;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyTableFieldEndpoint;
import org.wu.framework.lazy.orm.core.source.adapter.SourceFactory;
import org.wu.framework.lazy.orm.database.jpa.repository.LazyJpaRepository;
import org.wu.framework.lazy.orm.database.lambda.stream.condition.BasicComparison;
import org.wu.framework.lazy.orm.database.lambda.stream.condition.StringBasicComparison;
import org.wu.framework.lazy.orm.database.lambda.stream.lambda.LazyLambdaStream;
import org.wu.framework.lazy.orm.database.lambda.stream.wrapper.LazyWrappers;

public class SimpleLazyJpaRepository<T, ID>
implements LazyJpaRepository<T, ID> {
    private final LazyLambdaStream lazyLambdaStream;
    private final Class<T> domainClass;

    public SimpleLazyJpaRepository(LazyLambdaStream lazyLambdaStream, Class<T> domainClass) {
        this.lazyLambdaStream = lazyLambdaStream;
        this.domainClass = domainClass;
    }

    @Override
    public <S extends T> Iterable<S> saveAll(Iterable<S> entities) {
        AssertFactory.notNull(entities, (String)"entities must not be null");
        this.lazyLambdaStream.insertMultiple(StreamSupport.stream(entities.spliterator(), false).collect(Collectors.toList()));
        return entities;
    }

    @Override
    public Iterable<T> findAll() {
        return this.lazyLambdaStream.of(this.domainClass).selectList((BasicComparison)LazyWrappers.lambdaWrapper(), this.domainClass);
    }

    @Override
    public Iterable<T> findAllByIds(Iterable<ID> ids) {
        AssertFactory.notNull(ids, (String)"ids must not be null");
        StringBasicComparison in = LazyWrappers.wrapper().in(this.getPrimaryKeyColumnName(), ids);
        return this.lazyLambdaStream.of(this.domainClass).selectList((BasicComparison)in, this.domainClass);
    }

    @Override
    public void deleteAllByIds(Iterable<? extends ID> ids) {
        AssertFactory.notNull(ids, (String)"ids must not be null");
        StringBasicComparison in = LazyWrappers.wrapper().in(this.getPrimaryKeyColumnName(), ids);
        this.lazyLambdaStream.of(this.domainClass).delete((BasicComparison)in);
    }

    @Override
    public void deleteAll(Iterable<? extends T> entities) {
        AssertFactory.notNull(entities, (String)"entities must not be null");
        entities.forEach(t -> this.lazyLambdaStream.delete((BasicComparison)LazyWrappers.lambdaWrapperBean((Object)t)));
    }

    @Override
    public void deleteAll() {
        this.lazyLambdaStream.of(this.domainClass).delete((BasicComparison)LazyWrappers.lambdaWrapper());
    }

    @Override
    public <S extends T> S save(S entity) {
        AssertFactory.notNull(entity, (String)"entity must not be null");
        this.lazyLambdaStream.insert(entity);
        return entity;
    }

    @Override
    public Optional<T> findById(ID id) {
        AssertFactory.notNull(id, (String)"id must not be null");
        Object t = this.lazyLambdaStream.of(this.domainClass).selectOne((BasicComparison)LazyWrappers.wrapper().eq(this.getPrimaryKeyColumnName(), id));
        return Optional.of(t);
    }

    @Override
    public boolean existsById(ID id) {
        AssertFactory.notNull(id, (String)"id must not be null");
        return this.lazyLambdaStream.of(this.domainClass).exists((BasicComparison)LazyWrappers.wrapper().eq(this.getPrimaryKeyColumnName(), id));
    }

    @Override
    public long count() {
        return this.lazyLambdaStream.of(this.domainClass).count((BasicComparison)LazyWrappers.wrapper());
    }

    @Override
    public void deleteById(ID id) {
        AssertFactory.notNull(id, (String)"id must not be null");
        this.lazyLambdaStream.of(this.domainClass).delete((BasicComparison)LazyWrappers.wrapper().eq(this.getPrimaryKeyColumnName(), id));
    }

    @Override
    public void delete(T entity) {
        AssertFactory.notNull(entity, (String)"entity must not be null");
        this.lazyLambdaStream.of(this.domainClass).delete((BasicComparison)LazyWrappers.lambdaWrapperBean(entity));
    }

    protected String getPrimaryKeyColumnName() {
        LazyTableEndpoint lazyTableEndpoint = SourceFactory.defaultAnalyzeLazyTableFromClass(this.domainClass);
        LazyTableFieldEndpoint tableId = lazyTableEndpoint.findTableId();
        return tableId.getColumnName();
    }
}

