/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.orm.database.jpa.repository.support;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.concurrent.ConcurrentHashMap;
import org.wu.framework.core.exception.RuntimeExceptionFactory;
import org.wu.framework.lazy.orm.database.jpa.repository.LazyJpaRepository;
import org.wu.framework.lazy.orm.database.jpa.repository.LazyRepository;
import org.wu.framework.lazy.orm.database.jpa.repository.core.DefaultLazyJapRepositoryMetadata;
import org.wu.framework.lazy.orm.database.jpa.repository.core.DefaultLazyJpaEntityMetadata;
import org.wu.framework.lazy.orm.database.jpa.repository.core.LazyJpaEntityMetadata;
import org.wu.framework.lazy.orm.database.jpa.repository.proxy.LazyJpaRepositoryProxy;
import org.wu.framework.lazy.orm.database.jpa.repository.support.SimpleLazyJpaRepository;
import org.wu.framework.lazy.orm.database.lambda.stream.lambda.LazyLambdaStream;

public final class LazyRepositoryFactorySupport {
    private static final ConcurrentHashMap<Class<?>, LazyJpaEntityMetadata<?, ?, ?>> cacheLazyJpaMetadata = new ConcurrentHashMap();

    public static <R extends LazyJpaRepository<?, ?>> R createLazyJpaRepository(LazyLambdaStream lazyLambdaStream, Class<?> lazyJpaRepositoryClass) {
        LazyJpaEntityMetadata lazyJpaEntityMetadata = LazyRepositoryFactorySupport.getJpaMetadata(lazyJpaRepositoryClass);
        Class entityClass = lazyJpaEntityMetadata.getEntityClass();
        Class idClass = lazyJpaEntityMetadata.getIdClass();
        SimpleLazyJpaRepository simpleLazyJpaRepository = new SimpleLazyJpaRepository(lazyLambdaStream, entityClass);
        DefaultLazyJapRepositoryMetadata defaultLazyJapRepositoryMetadata = new DefaultLazyJapRepositoryMetadata(lazyJpaEntityMetadata, simpleLazyJpaRepository, lazyLambdaStream);
        LazyJpaRepositoryProxy lazyJpaRepositoryProxy = new LazyJpaRepositoryProxy(defaultLazyJapRepositoryMetadata);
        return (R)((LazyJpaRepository)Proxy.newProxyInstance(lazyJpaRepositoryClass.getClassLoader(), new Class[]{lazyJpaRepositoryClass}, (InvocationHandler)((Object)lazyJpaRepositoryProxy)));
    }

    public static <T, ID, R extends LazyJpaRepository<T, ID>> LazyJpaEntityMetadata getJpaMetadata(Class<?> lazyJpaRepositoryClass) {
        if (cacheLazyJpaMetadata.containsKey(lazyJpaRepositoryClass)) {
            return cacheLazyJpaMetadata.get(lazyJpaRepositoryClass);
        }
        Type[] genericInterfaces = lazyJpaRepositoryClass.getGenericInterfaces();
        DefaultLazyJpaEntityMetadata defaultLazyJpaEntityMetadata = null;
        for (Type genericInterface : genericInterfaces) {
            ParameterizedType parameterizedType;
            Type rawType;
            if (!(genericInterface instanceof ParameterizedType) || !LazyRepository.class.isAssignableFrom((Class)(rawType = (parameterizedType = (ParameterizedType)genericInterface).getRawType()))) continue;
            Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            Class entityClass = (Class)actualTypeArguments[0];
            Class idClass = (Class)actualTypeArguments[1];
            defaultLazyJpaEntityMetadata = new DefaultLazyJpaEntityMetadata(entityClass, idClass, lazyJpaRepositoryClass);
            cacheLazyJpaMetadata.put(lazyJpaRepositoryClass, defaultLazyJpaEntityMetadata);
            break;
        }
        if (defaultLazyJpaEntityMetadata == null) {
            RuntimeExceptionFactory.of((String)("\u65e0\u6cd5\u83b7\u53d6:" + lazyJpaRepositoryClass.getName() + "\u4e2d\u7684\u8303\u578b"));
        }
        return cacheLazyJpaMetadata.get(lazyJpaRepositoryClass);
    }
}

