/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.orm.database.jpa.repository.support;

import java.lang.reflect.Method;
import org.wu.framework.lazy.orm.core.persistence.util.LazySQLUtil;
import org.wu.framework.lazy.orm.database.jpa.repository.query.LazyParameter;
import org.wu.framework.lazy.orm.database.jpa.repository.query.LazyQueryMetadata;
import org.wu.framework.lazy.orm.database.jpa.repository.support.LazySimpleQuerySupport;
import org.wu.framework.lazy.orm.database.lambda.domain.PersistenceRepository;
import org.wu.framework.lazy.orm.database.lambda.domain.PersistenceRepositoryFactory;

public abstract class AbstractLazySimpleQuerySupport
implements LazySimpleQuerySupport {
    private final LazyQueryMetadata lazyQueryMetadata;

    protected AbstractLazySimpleQuerySupport(LazyQueryMetadata lazyQueryMetadata) {
        this.lazyQueryMetadata = lazyQueryMetadata;
    }

    @Override
    public <T> T query() {
        return this.doQuery();
    }

    protected abstract <T> T doQuery();

    protected PersistenceRepository lazyQueryMetadata2PersistenceRepository(LazyQueryMetadata lazyQueryMetadata) {
        String querySql = lazyQueryMetadata.getQuerySql();
        for (LazyParameter parameter : lazyQueryMetadata.getParameters()) {
            querySql = querySql.replace("{" + parameter.getName() + "}", LazySQLUtil.valueToSqlValue((Object)parameter.getValue()).toString());
        }
        Method queryMethod = lazyQueryMetadata.getQueryMethod();
        Class<?> returnType = queryMethod.getReturnType();
        PersistenceRepository persistenceRepository = PersistenceRepositoryFactory.create();
        persistenceRepository.setQueryString(querySql);
        persistenceRepository.setResultClass(returnType);
        persistenceRepository.setExecutionType(lazyQueryMetadata.getQueryType().getLambdaTableType());
        return persistenceRepository;
    }
}

