/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.orm.database.jpa.repository.query;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import org.wu.framework.core.CamelAndUnderLineConverter;
import org.wu.framework.core.annotation.AnnotatedElementUtils;
import org.wu.framework.core.exception.RuntimeExceptionFactory;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyTableEndpoint;
import org.wu.framework.lazy.orm.core.source.SqlSourceClass;
import org.wu.framework.lazy.orm.database.jpa.repository.annotation.LazyParam;
import org.wu.framework.lazy.orm.database.jpa.repository.annotation.LazyQuery;
import org.wu.framework.lazy.orm.database.jpa.repository.enums.MethodName2SQLType;
import org.wu.framework.lazy.orm.database.jpa.repository.enums.QueryType;
import org.wu.framework.lazy.orm.database.jpa.repository.query.DefaultLazyParameters;
import org.wu.framework.lazy.orm.database.jpa.repository.query.DefaultLazyQueryMetadata;
import org.wu.framework.lazy.orm.database.jpa.repository.query.LazyQueryMetadata;
import org.wu.framework.lazy.orm.database.jpa.repository.support.method.JpaDynamicMethodSupportFactory;
import org.wu.framework.lazy.orm.database.lambda.stream.lambda.LazyLambdaStream;

public class LazyQueryMetadataFactory {
    public static LazyQueryMetadata createLazyQueryMetadata(Method method, Object[] arguments, LazyLambdaStream lazyLambdaStream) {
        if (AnnotatedElementUtils.hasAnnotation((AnnotatedElement)method, LazyQuery.class)) {
            LazyQuery lazyQuery = (LazyQuery)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, LazyQuery.class);
            assert (lazyQuery != null);
            QueryType queryType = lazyQuery.queryType();
            String querySql = lazyQuery.value();
            Parameter[] methodParameters = method.getParameters();
            DefaultLazyParameters defaultLazyParameters = new DefaultLazyParameters();
            for (int i = 0; i < methodParameters.length; ++i) {
                Parameter methodParameter = methodParameters[i];
                LazyParam annotation = methodParameter.getAnnotation(LazyParam.class);
                Object argument = arguments[i];
                if (annotation != null) {
                    defaultLazyParameters.addParameter(annotation.value(), argument);
                    continue;
                }
                defaultLazyParameters.addParameter(CamelAndUnderLineConverter.humpToLine2((String)methodParameter.getName()), argument);
            }
            return new DefaultLazyQueryMetadata(querySql, queryType, method, defaultLazyParameters, lazyLambdaStream);
        }
        RuntimeExceptionFactory.of((String)("\u65e0\u6cd5\u89e3\u6790\u65b9\u6cd5\uff0c\u8bf7\u786e\u5b9a\u65b9\u6cd5" + method + "\u662f\u5426\u5305\u542b\u6307\u5b9a\u6ce8\u89e3@LazyQuery"));
        return null;
    }

    public static LazyQueryMetadata createLazyQueryMetadataByMethodName(Method method, Object[] arguments, LazyLambdaStream lazyLambdaStream) {
        if (!LazyQueryMetadataFactory.support(method).booleanValue()) {
            Class<?> declaringClass = method.getDeclaringClass();
            LazyTableEndpoint lazyTableEndpoint = SqlSourceClass.getInstance(declaringClass).getLazyTableEndpoint();
            String tableName = lazyTableEndpoint.getTableName();
            String methodName = method.getName();
            MethodName2SQLType name2SQLType = Arrays.stream(MethodName2SQLType.values()).filter(methodName2SQLType -> methodName.startsWith(methodName2SQLType.getStartMethodNamePrefix())).findFirst().get();
            QueryType queryType = name2SQLType.getQueryType();
            String querySql = JpaDynamicMethodSupportFactory.createSqlByMethod(method);
            Parameter[] methodParameters = method.getParameters();
            DefaultLazyParameters defaultLazyParameters = new DefaultLazyParameters();
            for (int i = 0; i < methodParameters.length; ++i) {
                Parameter methodParameter = methodParameters[i];
                LazyParam annotation = methodParameter.getAnnotation(LazyParam.class);
                Object argument = arguments[i];
                if (annotation != null) {
                    defaultLazyParameters.addParameter(annotation.value(), argument);
                    continue;
                }
                defaultLazyParameters.addParameter(methodParameter.getName(), argument);
            }
            return new DefaultLazyQueryMetadata(querySql, queryType, method, defaultLazyParameters, lazyLambdaStream);
        }
        RuntimeExceptionFactory.of((String)"\u89e3\u6790\u81ea\u5b9a\u4e49\u65b9\u6cd5\u540d\u9519\u8bef\uff0c\u5f53\u524d\u65b9\u6cd5\u542b\u6709\u6ce8\u89e3@LazyQuery\u6216\u8005\u5176\u5b50\u6ce8\u89e3");
        return null;
    }

    public static Boolean support(Method method) {
        return AnnotatedElementUtils.hasAnnotation((AnnotatedElement)method, LazyQuery.class);
    }

    public static Boolean hasXml(Method method) {
        return false;
    }

    public static Boolean supportMethodName2SQL(Method method) {
        String methodName = method.getName();
        return Arrays.stream(MethodName2SQLType.values()).anyMatch(methodName2SQLType -> methodName.startsWith(methodName2SQLType.getStartMethodNamePrefix()));
    }
}

