/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.orm.core.toolkit;

import java.util.ArrayDeque;
import java.util.Deque;
import org.wu.framework.lazy.orm.core.config.enums.LazyDataSourceType;

public final class DynamicLazyDataSourceTypeHolder {
    private static final ThreadLocal<Deque<LazyDataSourceType>> LOOKUP_KEY_HOLDER = ThreadLocal.withInitial(ArrayDeque::new);

    private DynamicLazyDataSourceTypeHolder() {
    }

    public static LazyDataSourceType peek() {
        return LOOKUP_KEY_HOLDER.get().peek();
    }

    public static void push(LazyDataSourceType ds) {
        LOOKUP_KEY_HOLDER.get().push(ds);
    }

    public static void poll() {
        Deque<LazyDataSourceType> deque = LOOKUP_KEY_HOLDER.get();
        deque.poll();
        if (deque.isEmpty()) {
            LOOKUP_KEY_HOLDER.remove();
        }
    }

    public static void clear() {
        LOOKUP_KEY_HOLDER.remove();
    }
}

