/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.orm.core.stereotype;

import java.io.File;
import java.io.InputStream;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.wu.framework.core.annotation.AliasFor;
import org.wu.framework.core.stereotype.LayerField;
import org.wu.framework.lazy.orm.core.stereotype.LazyFieldStrategy;
import org.wu.framework.lazy.orm.core.stereotype.LazyTableIndex;
import org.wu.framework.translation.data.DefaultIEnum;
import org.wu.framework.translation.data.IEnum;

@Target(value={ElementType.FIELD, ElementType.ANNOTATION_TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
@Documented
@LayerField
@Inherited
public @interface LazyTableField {
    @AliasFor(attribute="name", annotation=LayerField.class)
    public String value() default "";

    @AliasFor(attribute="value", annotation=LayerField.class)
    public String name() default "";

    public String columnType() default "";

    public String comment() default "";

    public boolean notNull() default false;

    public String defaultValue() default "";

    public boolean key() default false;

    public String extra() default "";

    public Privilege[] privileges() default {Privilege.select, Privilege.insert, Privilege.update, Privilege.references};

    public boolean exist() default true;

    public LazyFieldStrategy upsertStrategy() default LazyFieldStrategy.NO_VERIFY;

    public LazyFieldStrategy updateStrategy() default LazyFieldStrategy.IGNORED_NULL;

    public int version() default 1;

    public long scale() default 0L;

    public int serialNumber() default 0;

    public String parameters() default "";

    public boolean optional() default true;

    @Deprecated
    public String fieldDefaultValue() default "";

    public Class<? extends IEnum> iEnum() default DefaultIEnum.class;

    public String dataType() default "";

    public String convert() default "";

    public LazyTableIndex[] lazyTableIndexs() default {@LazyTableIndex};

    public static enum Privilege {
        select,
        insert,
        update,
        references;


        @Generated
        private Privilege() {
        }
    }

    public static enum FieldType {
        STRING(Collections.singletonList(String.class), " varchar(255) ", " String ", " varchar(255) ", " varchar(255) ", " varchar(255) ", " varchar(255) "),
        BYTE(Arrays.asList(Byte.class, Byte.TYPE), " varbinary(1024) ", " String ", " BINARY ", " bytea ", " varbinary(1024) ", " varbinary(1024) "),
        BYTE_ARRAYS(Arrays.asList(Byte[].class, byte[].class), " varbinary(1024) ", " String ", " BINARY ", " bytea ", " varbinary(1024) ", " varbinary(1024) "),
        INTEGER(Arrays.asList(Integer.class, Integer.TYPE), " int(11) ", " UInt8 ", " INTEGER ", " integer ", " int(11) ", " int(11) "),
        LONG(Arrays.asList(Long.class, Long.TYPE), " bigint ", " UInt32 ", " BIGINT ", " bigint ", " bigint ", " bigint "),
        BOOLEAN(Arrays.asList(Boolean.class, Boolean.TYPE), " tinyint(1) ", " String ", " BOOLEAN ", " boolean ", " tinyint(1) ", " tinyint(1) "),
        LOCAL_DATE_TIME(Arrays.asList(LocalDateTime.class, Timestamp.class), " datetime ", " String ", " TIMESTAMP ", " date ", " datetime ", " datetime "),
        TIME(Arrays.asList(LocalTime.class), " time ", " String ", " TIME ", " timestamp(n) without time zone ", " time ", " time "),
        LOCAL_DATE(Arrays.asList(LocalDate.class, Date.class, java.util.Date.class), " date ", " String ", " DATE ", " time(n) without time zone ", " date ", " date "),
        DOUBLE(Arrays.asList(Double.class, Double.TYPE, BigDecimal.class), " double ", " Float64 ", " DOUBLE ", " double precision ", " double ", " double "),
        FLOAT(Arrays.asList(Float.class, Float.TYPE), " float ", " Float32 ", " REAL ", " real ", " float ", " float "),
        BINARY(Arrays.asList(File.class, InputStream.class), " Blob ", " String ", " BLOB ", " bytea ", " Blob ", " Blob "),
        JSON(Arrays.asList(List.class, Arrays.class, Collection.class, Object.class), " json ", " String ", " varchar(255) ", " json ", " json ", " json ");

        private static final Map<Class<?>, String> TYPE_MAP;
        private final List<Class<?>> clazz;
        private final String mysqlType;
        private final String clickHouseType;
        private final String h2Type;
        private final String postgresType;
        private final String sqliteType;
        private final String questdbType;

        public static String getMysqlTypeByClass(Class<?> clazz) {
            for (FieldType fieldType : FieldType.values()) {
                if (!fieldType.clazz.contains(clazz)) continue;
                return fieldType.mysqlType;
            }
            return FieldType.STRING.mysqlType;
        }

        public static String getClickHouseTypeByClass(Class<?> clazz) {
            for (FieldType fieldType : FieldType.values()) {
                if (!fieldType.clazz.contains(clazz)) continue;
                return fieldType.clickHouseType;
            }
            return FieldType.STRING.clickHouseType;
        }

        public static String getH2TypeByClass(Class<?> clazz) {
            for (FieldType fieldType : FieldType.values()) {
                if (!fieldType.clazz.contains(clazz)) continue;
                return fieldType.h2Type;
            }
            return FieldType.STRING.h2Type;
        }

        public static String getSqliteTypeByClass(Class<?> clazz) {
            for (FieldType fieldType : FieldType.values()) {
                if (!fieldType.clazz.contains(clazz)) continue;
                return fieldType.mysqlType;
            }
            return FieldType.STRING.mysqlType;
        }

        public static String getPostgresTypeByClass(Class<?> clazz) {
            for (FieldType fieldType : FieldType.values()) {
                if (!fieldType.clazz.contains(clazz)) continue;
                return fieldType.h2Type;
            }
            return FieldType.STRING.h2Type;
        }

        public static String getQuestDBTypeByClass(Class<?> clazz) {
            for (FieldType fieldType : FieldType.values()) {
                if (!fieldType.clazz.contains(clazz)) continue;
                return fieldType.h2Type;
            }
            return FieldType.STRING.h2Type;
        }

        @Generated
        public List<Class<?>> getClazz() {
            return this.clazz;
        }

        @Generated
        public String getMysqlType() {
            return this.mysqlType;
        }

        @Generated
        public String getClickHouseType() {
            return this.clickHouseType;
        }

        @Generated
        public String getH2Type() {
            return this.h2Type;
        }

        @Generated
        public String getPostgresType() {
            return this.postgresType;
        }

        @Generated
        public String getSqliteType() {
            return this.sqliteType;
        }

        @Generated
        public String getQuestdbType() {
            return this.questdbType;
        }

        @Generated
        private FieldType(List<Class<?>> clazz, String mysqlType, String clickHouseType, String h2Type, String postgresType, String sqliteType, String questdbType) {
            this.clazz = clazz;
            this.mysqlType = mysqlType;
            this.clickHouseType = clickHouseType;
            this.h2Type = h2Type;
            this.postgresType = postgresType;
            this.sqliteType = sqliteType;
            this.questdbType = questdbType;
        }

        static {
            TYPE_MAP = new HashMap();
            for (FieldType fieldType : FieldType.values()) {
                Map classStringMap = fieldType.clazz.stream().collect(Collectors.toMap(Function.identity(), c -> fieldType.mysqlType));
                TYPE_MAP.putAll(classStringMap);
            }
        }
    }
}

