/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.orm.core.source.sqlite;

import java.text.Collator;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wu.framework.core.stereotype.LayerField;
import org.wu.framework.core.utils.ObjectUtils;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyDatabaseJsonMessage;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyTableFieldEndpoint;
import org.wu.framework.lazy.orm.core.persistence.conf.clazz.AbstractLazyTableEndpoint;
import org.wu.framework.lazy.orm.core.source.sqlite.SqliteColumnEndpoint;

public class SqliteTableLazyTableEndpoint
extends AbstractLazyTableEndpoint<SqliteColumnEndpoint> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SqliteTableLazyTableEndpoint.class);
    private List<SqliteColumnEndpoint> lazyTableFieldEndpointList;

    @Override
    public String creatTableSQL() {
        Map<String, List<LazyTableFieldEndpoint>> spatialIndexMap;
        StringBuilder createTableSQLBuffer = new StringBuilder(String.format("-- \u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\n-- create table %s  %s  \n-- add by  %s  %s  \n-- \u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\n", this.getFullTableName(), this.getComment(), "wujiawei", LocalDate.now()));
        if (!ObjectUtils.isEmpty((Object)this.getSchema())) {
            createTableSQLBuffer.append(String.format(" CREATE DATABASE IF NOT EXISTS %s; \n use %s ; \n ", this.getSchema(), this.getSchema()));
        }
        createTableSQLBuffer.append("CREATE TABLE IF NOT EXISTS \"").append(this.getTableName()).append("\" ( \n");
        List<SqliteColumnEndpoint> fieldEndpoints = this.getLazyTableFieldEndpointList();
        List<SqliteColumnEndpoint> fieldLazyTableFieldEndpointList = new ArrayList<SqliteColumnEndpoint>(fieldEndpoints);
        fieldLazyTableFieldEndpointList.addAll(this.toThisFieldEndpointList(LazyDatabaseJsonMessage.extraFields));
        fieldLazyTableFieldEndpointList = fieldLazyTableFieldEndpointList.stream().sorted((firstLazyTableFieldEndpoint, secondLazyFieldLazyTableFieldEndpoint) -> Collator.getInstance(Locale.CHINA).compare(firstLazyTableFieldEndpoint.getColumnName(), secondLazyFieldLazyTableFieldEndpoint.getColumnName())).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<SqliteColumnEndpoint>(Comparator.comparing(LazyTableFieldEndpoint::getColumnName))), ArrayList::new));
        List uniqueList = fieldLazyTableFieldEndpointList.stream().filter(LazyTableFieldEndpoint::isExist).filter(field -> Arrays.stream(field.getLazyTableIndexEndpoints()).anyMatch(index -> LayerField.LayerFieldType.UNIQUE.equals((Object)index.getFieldIndexType()))).map(LazyTableFieldEndpoint::getColumnName).collect(Collectors.toList());
        Map<LayerField.LayerFieldType, Map<String, List<LazyTableFieldEndpoint>>> layerFieldTypeMap = this.getLayerFieldTypeMap(fieldLazyTableFieldEndpointList);
        ArrayList columnList = new ArrayList();
        fieldLazyTableFieldEndpointList.stream().filter(LazyTableFieldEndpoint::isExist).forEach(field -> columnList.add(field.columnSQL() + "\n"));
        createTableSQLBuffer.append(String.join((CharSequence)",", columnList));
        createTableSQLBuffer.append(")");
        createTableSQLBuffer.append(";\n");
        if (!ObjectUtils.isEmpty(layerFieldTypeMap)) {
            Map<String, List<LazyTableFieldEndpoint>> fulltextIndexMap;
            Map<String, List<LazyTableFieldEndpoint>> normalIndexMap;
            Map<String, List<LazyTableFieldEndpoint>> uniqueIndexMap = layerFieldTypeMap.get(LayerField.LayerFieldType.UNIQUE);
            if (!ObjectUtils.isEmpty(uniqueIndexMap)) {
                uniqueIndexMap.forEach((uniqueIndexName, lazyTableFieldEndpoints) -> {
                    String uniqueIndexSql = "CREATE UNIQUE INDEX IF NOT EXISTS " + uniqueIndexName + " " + "on" + " " + this.getTableName() + " (" + lazyTableFieldEndpoints.stream().map(LazyTableFieldEndpoint::getColumnName).collect(Collectors.joining(",")) + ");" + "\n";
                    createTableSQLBuffer.append(uniqueIndexSql);
                });
            }
            if (!ObjectUtils.isEmpty(normalIndexMap = layerFieldTypeMap.get(LayerField.LayerFieldType.NORMAL))) {
                normalIndexMap.forEach((normalIndexName, lazyTableFieldEndpoints) -> {
                    String normalIndexSql = " CREATE INDEX " + normalIndexName + " " + "on" + " " + this.getTableName() + " (" + lazyTableFieldEndpoints.stream().map(LazyTableFieldEndpoint::getColumnName).collect(Collectors.joining(",")) + ");" + "\n";
                    createTableSQLBuffer.append(normalIndexSql);
                });
            }
            if (!ObjectUtils.isEmpty(fulltextIndexMap = layerFieldTypeMap.get(LayerField.LayerFieldType.FULLTEXT))) {
                fulltextIndexMap.forEach((fulltextIndexName, lazyTableFieldEndpoints) -> {
                    String fulltextIndexSql = " CREATE INDEX " + fulltextIndexName + " " + "on" + " " + this.getTableName() + " (" + lazyTableFieldEndpoints.stream().map(LazyTableFieldEndpoint::getColumnName).collect(Collectors.joining(",")) + ");" + "\n";
                    createTableSQLBuffer.append(fulltextIndexSql);
                });
            }
        }
        if (!ObjectUtils.isEmpty(spatialIndexMap = layerFieldTypeMap.get(LayerField.LayerFieldType.SPATIAL))) {
            spatialIndexMap.forEach((spatialIndexName, lazyTableFieldEndpoints) -> {
                String spatialIndexSql = " CREATE INDEX " + spatialIndexName + " " + "on" + " " + this.getTableName() + " (" + lazyTableFieldEndpoints.stream().map(LazyTableFieldEndpoint::getColumnName).collect(Collectors.joining(",")) + ");" + "\n";
                createTableSQLBuffer.append(spatialIndexSql);
            });
        }
        createTableSQLBuffer.append("-- ------end \n-- \u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\n");
        System.out.println(createTableSQLBuffer);
        return createTableSQLBuffer.toString();
    }

    @Override
    public String alterTableSQL(List<SqliteColumnEndpoint> currentColumnNameList, boolean dropColumn) {
        List<String> alterTableColumnSQLPartList = this.alterTableColumnSQLPartList(currentColumnNameList = currentColumnNameList.stream().sorted((fieldLazyTableFieldEndpoint1, fieldLazyTableFieldEndpoint2) -> Collator.getInstance(Locale.CHINA).compare(fieldLazyTableFieldEndpoint1.getColumnName(), fieldLazyTableFieldEndpoint2.getColumnName())).collect(Collectors.toList()), dropColumn);
        if (ObjectUtils.isEmpty(alterTableColumnSQLPartList)) {
            return null;
        }
        String alterSQL = alterTableColumnSQLPartList.stream().filter(alertSql -> !ObjectUtils.isEmpty((Object)alertSql)).collect(Collectors.joining(";\n"));
        log.debug("\u66f4\u65b0\u8868\u7ed3\u6784\u8bed\u53e5:{}", (Object)alterSQL);
        return alterSQL;
    }

    @Override
    protected List<String> alterTableColumnSQLPartList(List<SqliteColumnEndpoint> currentColumnNameList, boolean dropColumn) {
        String javaColumnPkIndex;
        String currentColumnPkIndex;
        currentColumnNameList = currentColumnNameList.stream().sorted((fieldLazyTableFieldEndpoint1, fieldLazyTableFieldEndpoint2) -> Collator.getInstance(Locale.CHINA).compare(fieldLazyTableFieldEndpoint1.getColumnName(), fieldLazyTableFieldEndpoint2.getColumnName())).collect(Collectors.toList());
        String alertTablePre = "ALTER TABLE " + this.getFullTableName() + " ";
        String ADD_FIELD = " ADD %s %s comment '%s' ";
        List javaFieldLazyTableFieldEndpointList = this.getLazyTableFieldEndpointList().stream().sorted((fieldLazyTableFieldEndpoint1, fieldLazyTableFieldEndpoint2) -> Collator.getInstance(Locale.CHINA).compare(fieldLazyTableFieldEndpoint1.getColumnName(), fieldLazyTableFieldEndpoint2.getColumnName())).collect(Collectors.toList());
        javaFieldLazyTableFieldEndpointList.addAll(this.toThisFieldEndpointList(LazyDatabaseJsonMessage.extraFields));
        javaFieldLazyTableFieldEndpointList = javaFieldLazyTableFieldEndpointList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<SqliteColumnEndpoint>(Comparator.comparing(LazyTableFieldEndpoint::getColumnName))), ArrayList::new));
        Map<String, LazyTableFieldEndpoint> currentColumnNameMap = currentColumnNameList.stream().collect(Collectors.toMap(lazyTableFieldEndpoint -> lazyTableFieldEndpoint.getColumnName().toLowerCase(Locale.ROOT), convertedField -> convertedField, (A, B) -> A));
        List ADD_SQL_LIST = javaFieldLazyTableFieldEndpointList.stream().filter(field -> !currentColumnNameMap.containsKey(field.getColumnName().toLowerCase(Locale.ROOT))).map(convertedField -> String.format(ADD_FIELD, convertedField.getColumnName(), convertedField.getColumnType(), convertedField.getComment())).collect(Collectors.toList());
        ArrayList<String> modifySqlList = new ArrayList<String>();
        for (LazyTableFieldEndpoint fieldEndpoint : javaFieldLazyTableFieldEndpointList) {
            String currentColumnName = fieldEndpoint.getColumnName().replaceAll("`", "");
            if (!currentColumnNameMap.containsKey(currentColumnName)) continue;
            LazyTableFieldEndpoint mysqlFieldEndpoint = currentColumnNameMap.get(currentColumnName);
            String comment = fieldEndpoint.getComment();
            if (mysqlFieldEndpoint.isNotNull() == fieldEndpoint.isNotNull() && Objects.equals(mysqlFieldEndpoint.getDefaultValue(), fieldEndpoint.getDefaultValue()) && Objects.equals(mysqlFieldEndpoint.getComment(), comment) && fieldEndpoint.isKey() == mysqlFieldEndpoint.isKey() && Objects.equals(fieldEndpoint.getExtra(), mysqlFieldEndpoint.getExtra()) && Objects.equals(fieldEndpoint.getColumnType().replaceAll(" ", ""), mysqlFieldEndpoint.getColumnType().replaceAll(" ", ""))) continue;
            modifySqlList.add(alertTablePre + fieldEndpoint.modifyColumnSQL());
        }
        if (dropColumn) {
            List finalJavaFieldLazyTableFieldEndpointList = javaFieldLazyTableFieldEndpointList;
            currentColumnNameList.stream().filter(lazyTableFieldEndpoint -> !finalJavaFieldLazyTableFieldEndpointList.stream().map(LazyTableFieldEndpoint::getColumnName).collect(Collectors.toList()).contains(lazyTableFieldEndpoint.getColumnName())).forEach(lazyTableFieldEndpoint -> modifySqlList.add(alertTablePre + lazyTableFieldEndpoint.dropColumnSQL()));
        }
        if (!Objects.equals(currentColumnPkIndex = currentColumnNameList.stream().filter(LazyTableFieldEndpoint::isKey).map(LazyTableFieldEndpoint::getColumnName).collect(Collectors.joining("_")), javaColumnPkIndex = javaFieldLazyTableFieldEndpointList.stream().filter(LazyTableFieldEndpoint::isKey).map(LazyTableFieldEndpoint::getColumnName).collect(Collectors.joining("_")))) {
            if (currentColumnNameList.stream().anyMatch(LazyTableFieldEndpoint::isKey)) {
                modifySqlList.add("DROP PRIMARY KEY ON " + this.getFullTableName());
            }
            if (!ObjectUtils.isEmpty((Object)javaColumnPkIndex)) {
                String pk = javaFieldLazyTableFieldEndpointList.stream().filter(LazyTableFieldEndpoint::isKey).map(LazyTableFieldEndpoint::getColumnName).collect(Collectors.joining(","));
                modifySqlList.add(alertTablePre + String.format("ADD PRIMARY KEY (%s) ", pk));
            }
        }
        Map<LayerField.LayerFieldType, Map<String, List<LazyTableFieldEndpoint>>> currentLayerFieldTypeMap = this.getLayerFieldTypeMap(currentColumnNameList);
        Map<LayerField.LayerFieldType, Map<String, List<LazyTableFieldEndpoint>>> javaLayerFieldTypeMap = this.getLayerFieldTypeMap(javaFieldLazyTableFieldEndpointList);
        Map<String, List<LazyTableFieldEndpoint>> currentColumnUniqueIndex = currentLayerFieldTypeMap.get(LayerField.LayerFieldType.UNIQUE);
        Map<String, List<LazyTableFieldEndpoint>> javaColumnUniqueIndex = javaLayerFieldTypeMap.get(LayerField.LayerFieldType.UNIQUE);
        if (!ObjectUtils.isEmpty(javaColumnUniqueIndex)) {
            javaColumnUniqueIndex.forEach((indexName, lazyTableFieldEndpoints) -> {
                String string = indexName = ObjectUtils.isEmpty((Object)indexName) ? lazyTableFieldEndpoints.stream().map(lazyTableFieldEndpoint -> lazyTableFieldEndpoint.getColumnName().replaceAll("`", "").substring(0, 1)).collect(Collectors.joining("_")) : indexName;
                if (!ObjectUtils.isEmpty((Object)currentColumnUniqueIndex) && currentColumnUniqueIndex.containsKey(indexName)) {
                    List indexLazyTableFieldEndpoints = (List)currentColumnUniqueIndex.get(indexName);
                    ArrayList duplicateList = new ArrayList(lazyTableFieldEndpoints);
                    duplicateList.addAll(indexLazyTableFieldEndpoints);
                    ArrayList tableFieldEndpointArrayList = duplicateList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<LazyTableFieldEndpoint>(Comparator.comparing(LazyTableFieldEndpoint::getColumnName))), ArrayList::new));
                    if (!ObjectUtils.isEmpty((Object)tableFieldEndpointArrayList)) {
                        String indexColumns = lazyTableFieldEndpoints.stream().map(LazyTableFieldEndpoint::getColumnName).collect(Collectors.joining(","));
                        modifySqlList.add(String.format("DROP INDEX IF EXISTS \"%s\" ON %s", indexName, this.getFullTableName()));
                        modifySqlList.add(String.format("CREATE UNIQUE INDEX IF NOT EXISTS \"%s\" ON %s(%s)", indexName, this.getFullTableName(), indexColumns));
                    }
                } else {
                    String indexColumns = lazyTableFieldEndpoints.stream().map(LazyTableFieldEndpoint::getColumnName).collect(Collectors.joining(","));
                    modifySqlList.add(String.format("CREATE UNIQUE INDEX IF NOT EXISTS \"%s\" ON %s(%s)", indexName, this.getFullTableName(), indexColumns));
                }
            });
        }
        Map<String, List<LazyTableFieldEndpoint>> currentColumnNormalIndex = currentLayerFieldTypeMap.get(LayerField.LayerFieldType.NORMAL);
        Map<String, List<LazyTableFieldEndpoint>> javaColumnNormalIndex = javaLayerFieldTypeMap.get(LayerField.LayerFieldType.NORMAL);
        if (!ObjectUtils.isEmpty(javaColumnNormalIndex)) {
            javaColumnNormalIndex.forEach((indexName, lazyTableFieldEndpoints) -> {
                String string = indexName = ObjectUtils.isEmpty((Object)indexName) ? lazyTableFieldEndpoints.stream().sorted(Comparator.comparing(LazyTableFieldEndpoint::getColumnName)).map(lazyTableFieldEndpoint -> lazyTableFieldEndpoint.getColumnName().replaceAll("`", "").substring(0, 1)).collect(Collectors.joining("_")) : indexName;
                if (!ObjectUtils.isEmpty((Object)currentColumnNormalIndex) && currentColumnNormalIndex.containsKey(indexName)) {
                    List indexLazyTableFieldEndpoints = (List)currentColumnNormalIndex.get(indexName);
                    ArrayList duplicateList = new ArrayList(lazyTableFieldEndpoints);
                    duplicateList.addAll(indexLazyTableFieldEndpoints);
                    ArrayList tableFieldEndpointArrayList = duplicateList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<LazyTableFieldEndpoint>(Comparator.comparing(LazyTableFieldEndpoint::getColumnName))), ArrayList::new));
                    if (!ObjectUtils.isEmpty((Object)tableFieldEndpointArrayList)) {
                        String indexColumns = lazyTableFieldEndpoints.stream().map(lazyTableFieldEndpoint -> "`" + lazyTableFieldEndpoint.getColumnName() + "`").collect(Collectors.joining(","));
                        modifySqlList.add(String.format("DROP INDEX \"%s\" ON %s ", indexName, this.getFullTableName()));
                        modifySqlList.add(String.format("CREATE  INDEX IF NOT EXISTS \"%s\"  ON %s(%s)", indexName, this.getFullTableName(), indexColumns));
                    }
                } else {
                    String indexColumns = lazyTableFieldEndpoints.stream().map(LazyTableFieldEndpoint::getColumnName).collect(Collectors.joining(","));
                    modifySqlList.add(String.format("CREATE  INDEX IF NOT EXISTS \"%s\" ON %s(%s)", indexName, this.getFullTableName(), indexColumns));
                }
            });
        }
        if (ObjectUtils.isEmpty(ADD_SQL_LIST) && ObjectUtils.isEmpty(modifySqlList)) {
            return modifySqlList;
        }
        modifySqlList.addAll(ADD_SQL_LIST);
        return modifySqlList;
    }

    @Override
    public List<String> alterTableColumnSQL(List<SqliteColumnEndpoint> currentColumnNameList, boolean dropColumn) {
        List<String> sql = this.alterTableColumnSQLPartList(currentColumnNameList, dropColumn);
        return sql.stream().filter(columnSql -> !ObjectUtils.isEmpty((Object)columnSql)).collect(Collectors.toList());
    }

    @Override
    public List<SqliteColumnEndpoint> specifiedFieldAnnotation(LayerField.LayerFieldType layerFieldType) {
        List<SqliteColumnEndpoint> lazyTableFieldEndpoints = new ArrayList<SqliteColumnEndpoint>();
        List<SqliteColumnEndpoint> fieldEndpoints = this.getLazyTableFieldEndpointList();
        if (ObjectUtils.isEmpty(fieldEndpoints)) {
            return lazyTableFieldEndpoints;
        }
        lazyTableFieldEndpoints = fieldEndpoints.stream().filter(lazyTableFieldEndpoint -> Arrays.stream(lazyTableFieldEndpoint.getLazyTableIndexEndpoints()).anyMatch(lazyTableIndexEndpoint -> lazyTableIndexEndpoint.getFieldIndexType().equals((Object)layerFieldType))).collect(Collectors.toList());
        return lazyTableFieldEndpoints;
    }

    @Override
    public SqliteColumnEndpoint createLazyTableFieldEndpointInstance() {
        return new SqliteColumnEndpoint();
    }

    @Override
    @Generated
    public void setLazyTableFieldEndpointList(List<SqliteColumnEndpoint> lazyTableFieldEndpointList) {
        this.lazyTableFieldEndpointList = lazyTableFieldEndpointList;
    }

    @Override
    @Generated
    public List<SqliteColumnEndpoint> getLazyTableFieldEndpointList() {
        return this.lazyTableFieldEndpointList;
    }
}

