/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.orm.core.source.sqlite;

import org.wu.framework.core.exception.AssertFactory;
import org.wu.framework.core.utils.ObjectUtils;
import org.wu.framework.lazy.orm.core.config.enums.LazyDataSourceType;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyColumn;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyColumnIndex;
import org.wu.framework.lazy.orm.core.persistence.conf.LazySchemata;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyTableInfo;
import org.wu.framework.lazy.orm.core.source.sqlite.SqliteLazyColumn;
import org.wu.framework.lazy.orm.core.source.sqlite.SqliteLazyColumnIndex;
import org.wu.framework.lazy.orm.core.source.sqlite.SqliteLazySchemata;
import org.wu.framework.lazy.orm.core.source.sqlite.SqliteLazyTable;
import org.wu.framework.lazy.orm.core.source.sqlite.SqliteSourceAdvancedTargetAbstract;

public class SqliteSourceAdvancedTarget
extends SqliteSourceAdvancedTargetAbstract {
    @Override
    public boolean support(LazyDataSourceType lazyDataSourceType) {
        return LazyDataSourceType.SQLITE.equals((Object)lazyDataSourceType);
    }

    @Override
    public String getUrl(String host, int port, String schema) {
        if (ObjectUtils.isEmpty((Object)schema)) {
            schema = "sqlite";
        }
        String urlFormat = "jdbc:sqlite::resource:dbs/%s.db";
        return String.format(urlFormat, host, port, schema);
    }

    @Override
    public String formatUrl(String url) {
        return url;
    }

    @Override
    public String getUrlSchema(String url) {
        AssertFactory.notNull((Object)url, (String)"\u6570\u636e\u5e93\u8fde\u63a5\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        return null;
    }

    @Override
    public String getDefaultInformationSchemaUrl(String url) {
        return null;
    }

    @Override
    public LazyDataSourceType getLazyDataSourceType(String url) {
        if (ObjectUtils.isEmpty((Object)url)) {
            return null;
        }
        if (url.startsWith("jdbc:sqlite")) {
            return LazyDataSourceType.SQLITE;
        }
        return null;
    }

    @Override
    public Class<? extends LazyTableInfo> findTableInfoClass() {
        return SqliteLazyTable.class;
    }

    @Override
    public Class<? extends LazySchemata> findSchemaInfoClass() {
        return SqliteLazySchemata.class;
    }

    @Override
    public Class<? extends LazyColumn> findColumnInfoClass() {
        return SqliteLazyColumn.class;
    }

    @Override
    public Class<? extends LazyColumnIndex> findColumnIndexInfoClass() {
        return SqliteLazyColumnIndex.class;
    }
}

