/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.orm.core.source.questdb;

import org.wu.framework.core.exception.AssertFactory;
import org.wu.framework.core.utils.ObjectUtils;
import org.wu.framework.lazy.orm.core.config.enums.LazyDataSourceType;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyColumn;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyColumnIndex;
import org.wu.framework.lazy.orm.core.persistence.conf.LazySchemata;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyTableInfo;
import org.wu.framework.lazy.orm.core.source.questdb.QuestDBLazyColumn;
import org.wu.framework.lazy.orm.core.source.questdb.QuestDBLazyColumnIndex;
import org.wu.framework.lazy.orm.core.source.questdb.QuestDBLazySchemata;
import org.wu.framework.lazy.orm.core.source.questdb.QuestDBLazyTable;
import org.wu.framework.lazy.orm.core.source.questdb.QuestDBSourceAdvancedTargetAbstract;

public class QuestDBSourceAdvancedTarget
extends QuestDBSourceAdvancedTargetAbstract {
    @Override
    public boolean support(LazyDataSourceType lazyDataSourceType) {
        return LazyDataSourceType.QUEST_DB.equals((Object)lazyDataSourceType);
    }

    @Override
    public String getHost(String url) {
        return null;
    }

    @Override
    public int getPort(String url) {
        return -1;
    }

    @Override
    public String getUrl(String host, int port, String schema) {
        if (ObjectUtils.isEmpty((Object)schema)) {
            schema = "information_schema";
        }
        String urlFormat = "jdbc:questdb:tcp://%s:%s/information_schema";
        return String.format(urlFormat, host, port, schema);
    }

    @Override
    public String formatUrl(String url) {
        return url.replaceFirst(":questdb", ":postgresql");
    }

    @Override
    public String getUrlSchema(String url) {
        AssertFactory.notNull((Object)url, (String)"\u6570\u636e\u5e93\u8fde\u63a5\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        if (url.startsWith("jdbc:questdb:tcp:")) {
            return url.substring(url.lastIndexOf("/") + 1, !url.contains(";") ? url.length() : url.indexOf(";"));
        }
        return url.substring(url.lastIndexOf(":") + 1, !url.contains(";") ? url.length() : url.indexOf(";"));
    }

    @Override
    public String getDefaultInformationSchemaUrl(String url) {
        return null;
    }

    @Override
    public LazyDataSourceType getLazyDataSourceType(String url) {
        if (ObjectUtils.isEmpty((Object)url)) {
            return null;
        }
        if (url.startsWith("jdbc:questdb:")) {
            return LazyDataSourceType.QUEST_DB;
        }
        return null;
    }

    @Override
    public Class<? extends LazyTableInfo> findTableInfoClass() {
        return QuestDBLazyTable.class;
    }

    @Override
    public Class<? extends LazySchemata> findSchemaInfoClass() {
        return QuestDBLazySchemata.class;
    }

    @Override
    public Class<? extends LazyColumn> findColumnInfoClass() {
        return QuestDBLazyColumn.class;
    }

    @Override
    public Class<? extends LazyColumnIndex> findColumnIndexInfoClass() {
        return QuestDBLazyColumnIndex.class;
    }
}

