/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.orm.core.source.postgresql;

import java.text.Collator;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wu.framework.core.stereotype.LayerField;
import org.wu.framework.core.utils.ObjectUtils;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyDatabaseJsonMessage;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyTableFieldEndpoint;
import org.wu.framework.lazy.orm.core.persistence.conf.clazz.AbstractLazyTableEndpoint;
import org.wu.framework.lazy.orm.core.source.postgresql.PostgresqlColumnEndpoint;

public class PostgresqlTableLazyTableEndpoint
extends AbstractLazyTableEndpoint<PostgresqlColumnEndpoint> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PostgresqlTableLazyTableEndpoint.class);
    private List<PostgresqlColumnEndpoint> lazyTableFieldEndpointList;

    @Override
    public String creatTableSQL() {
        Map<String, List<LazyTableFieldEndpoint>> spatialIndexMap;
        StringBuilder createTableSQLBuffer = new StringBuilder(String.format("-- \u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\n-- create table %s  %s  \n-- add by  %s  %s  \n-- \u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\n", this.getFullTableName(), this.getComment(), "wujiawei", LocalDate.now()));
        if (!ObjectUtils.isEmpty((Object)this.getSchema())) {
            createTableSQLBuffer.append(String.format(" CREATE DATABASE IF NOT EXISTS %s; \n use %s ; \n ", this.getSchema(), this.getSchema()));
        }
        String tableName = this.getTableName();
        createTableSQLBuffer.append("CREATE TABLE IF NOT EXISTS \"").append(tableName).append("\" ( \n");
        List<PostgresqlColumnEndpoint> fieldEndpoints = this.getLazyTableFieldEndpointList();
        List<PostgresqlColumnEndpoint> fieldLazyTableFieldEndpointList = new ArrayList<PostgresqlColumnEndpoint>(fieldEndpoints);
        fieldLazyTableFieldEndpointList.addAll(this.toThisFieldEndpointList(LazyDatabaseJsonMessage.extraFields));
        fieldLazyTableFieldEndpointList = fieldLazyTableFieldEndpointList.stream().sorted((firstLazyTableFieldEndpoint, secondLazyFieldLazyTableFieldEndpoint) -> Collator.getInstance(Locale.CHINA).compare(firstLazyTableFieldEndpoint.getColumnName(), secondLazyFieldLazyTableFieldEndpoint.getColumnName())).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<PostgresqlColumnEndpoint>(Comparator.comparing(LazyTableFieldEndpoint::getColumnName))), ArrayList::new));
        List uniqueList = fieldLazyTableFieldEndpointList.stream().filter(LazyTableFieldEndpoint::isExist).filter(field -> Arrays.stream(field.getLazyTableIndexEndpoints()).anyMatch(index -> LayerField.LayerFieldType.UNIQUE.equals((Object)index.getFieldIndexType()))).map(LazyTableFieldEndpoint::getColumnName).collect(Collectors.toList());
        Map<LayerField.LayerFieldType, Map<String, List<LazyTableFieldEndpoint>>> layerFieldTypeMap = this.getLayerFieldTypeMap(fieldLazyTableFieldEndpointList);
        ArrayList<String> columnList = new ArrayList<String>();
        fieldLazyTableFieldEndpointList.stream().filter(LazyTableFieldEndpoint::isExist).forEach(field -> columnList.add(field.columnSQL() + "\n"));
        List idList = fieldLazyTableFieldEndpointList.stream().filter(LazyTableFieldEndpoint::isExist).filter(LazyTableFieldEndpoint::isKey).map(LazyTableFieldEndpoint::getColumnName).collect(Collectors.toList());
        if (!ObjectUtils.isEmpty(idList)) {
            for (Object indexColumnName : idList) {
                columnList.add(String.format("CONSTRAINT \"%s\" PRIMARY KEY (%s) ", indexColumnName, indexColumnName) + "\n");
            }
        }
        if (!ObjectUtils.isEmpty(spatialIndexMap = layerFieldTypeMap.get(LayerField.LayerFieldType.SPATIAL))) {
            spatialIndexMap.forEach((spatialIndexName, lazyTableFieldEndpoints) -> {
                String spatialIndexSql = " SPATIAL KEY `" + spatialIndexName + "` (" + lazyTableFieldEndpoints.stream().map(LazyTableFieldEndpoint::getColumnName).collect(Collectors.joining(",")) + ")";
                columnList.add(spatialIndexSql);
            });
        }
        createTableSQLBuffer.append(String.join((CharSequence)",", columnList));
        createTableSQLBuffer.append(") ");
        createTableSQLBuffer.append(";\n");
        createTableSQLBuffer.append(String.format(" COMMENT ON TABLE \"public\".\"%s\" IS '%s';", tableName, this.getComment()));
        createTableSQLBuffer.append("\n");
        for (LazyTableFieldEndpoint lazyTableFieldEndpoint : fieldLazyTableFieldEndpointList) {
            createTableSQLBuffer.append(String.format(" COMMENT ON COLUMN \"public\".\"%s\".\"%s\" IS '';", tableName, lazyTableFieldEndpoint.getColumnName(), lazyTableFieldEndpoint.getComment()));
            createTableSQLBuffer.append("\n");
        }
        if (!ObjectUtils.isEmpty(layerFieldTypeMap)) {
            Map<String, List<LazyTableFieldEndpoint>> fulltextIndexMap;
            Map<String, List<LazyTableFieldEndpoint>> map;
            Map<String, List<LazyTableFieldEndpoint>> uniqueIndexMap = layerFieldTypeMap.get(LayerField.LayerFieldType.UNIQUE);
            if (!ObjectUtils.isEmpty(uniqueIndexMap)) {
                uniqueIndexMap.forEach((uniqueIndexName, lazyTableFieldEndpoints) -> {
                    String uniqueIndexSql = "CREATE UNIQUE INDEX IF NOT EXISTS \"" + uniqueIndexName + "\" ON \"public\".\"" + tableName + "\" USING btree (" + lazyTableFieldEndpoints.stream().map(LazyTableFieldEndpoint::getColumnName).collect(Collectors.joining(",")) + ");";
                    createTableSQLBuffer.append(uniqueIndexSql);
                    createTableSQLBuffer.append("\n");
                });
            }
            if (!ObjectUtils.isEmpty(map = layerFieldTypeMap.get(LayerField.LayerFieldType.NORMAL))) {
                map.forEach((normalIndexName, lazyTableFieldEndpoints) -> {
                    String normalIndexSql = " KEY `" + normalIndexName + "` (" + lazyTableFieldEndpoints.stream().map(LazyTableFieldEndpoint::getColumnName).collect(Collectors.joining(",")) + ")";
                    columnList.add(normalIndexSql);
                });
            }
            if (!ObjectUtils.isEmpty(fulltextIndexMap = layerFieldTypeMap.get(LayerField.LayerFieldType.FULLTEXT))) {
                fulltextIndexMap.forEach((fulltextIndexName, lazyTableFieldEndpoints) -> {
                    String fulltextIndexSql = " FULLTEXT KEY `" + fulltextIndexName + "` (" + lazyTableFieldEndpoints.stream().map(LazyTableFieldEndpoint::getColumnName).collect(Collectors.joining(",")) + ")";
                    columnList.add(fulltextIndexSql);
                });
            }
        }
        createTableSQLBuffer.append("-- ------end \n-- \u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\n");
        System.out.println(createTableSQLBuffer);
        return createTableSQLBuffer.toString();
    }

    @Override
    public String alterTableSQL(List<PostgresqlColumnEndpoint> currentColumnNameList, boolean dropColumn) {
        currentColumnNameList = currentColumnNameList.stream().sorted((fieldLazyTableFieldEndpoint1, fieldLazyTableFieldEndpoint2) -> Collator.getInstance(Locale.CHINA).compare(fieldLazyTableFieldEndpoint1.getColumnName(), fieldLazyTableFieldEndpoint2.getColumnName())).collect(Collectors.toList());
        String ALTER_TABLE = "ALTER TABLE %s ";
        List<String> sql = this.alterTableColumnSQLPartList(currentColumnNameList, dropColumn);
        if (ObjectUtils.isEmpty(sql)) {
            return null;
        }
        String alterSQL = String.format(ALTER_TABLE, this.getFullTableName()) + sql.stream().filter(s -> !ObjectUtils.isEmpty((Object)s)).collect(Collectors.joining(","));
        log.debug("\u66f4\u65b0\u8868\u7ed3\u6784\u8bed\u53e5:{}", (Object)alterSQL);
        return alterSQL;
    }

    @Override
    public List<String> alterTableColumnSQL(List<PostgresqlColumnEndpoint> currentColumnNameList, boolean dropColumn) {
        String ALTER_TABLE = "ALTER TABLE %s ";
        List<String> sql = this.alterTableColumnSQLPartList(currentColumnNameList, dropColumn);
        List<String> alterSQLList = sql.stream().filter(columnSql -> !ObjectUtils.isEmpty((Object)columnSql)).map(columnSql -> String.format(ALTER_TABLE, this.getFullTableName()) + columnSql).collect(Collectors.toList());
        return alterSQLList;
    }

    @Override
    public List<PostgresqlColumnEndpoint> specifiedFieldAnnotation(LayerField.LayerFieldType layerFieldType) {
        List<PostgresqlColumnEndpoint> lazyTableFieldEndpoints = new ArrayList<PostgresqlColumnEndpoint>();
        List<PostgresqlColumnEndpoint> fieldEndpoints = this.getLazyTableFieldEndpointList();
        if (ObjectUtils.isEmpty(fieldEndpoints)) {
            return lazyTableFieldEndpoints;
        }
        lazyTableFieldEndpoints = fieldEndpoints.stream().filter(lazyTableFieldEndpoint -> Arrays.stream(lazyTableFieldEndpoint.getLazyTableIndexEndpoints()).anyMatch(lazyTableIndexEndpoint -> lazyTableIndexEndpoint.getFieldIndexType().equals((Object)layerFieldType))).collect(Collectors.toList());
        return lazyTableFieldEndpoints;
    }

    @Override
    public PostgresqlColumnEndpoint createLazyTableFieldEndpointInstance() {
        return new PostgresqlColumnEndpoint();
    }

    @Generated
    public PostgresqlTableLazyTableEndpoint() {
    }

    @Override
    @Generated
    public List<PostgresqlColumnEndpoint> getLazyTableFieldEndpointList() {
        return this.lazyTableFieldEndpointList;
    }

    @Override
    @Generated
    public void setLazyTableFieldEndpointList(List<PostgresqlColumnEndpoint> lazyTableFieldEndpointList) {
        this.lazyTableFieldEndpointList = lazyTableFieldEndpointList;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PostgresqlTableLazyTableEndpoint)) {
            return false;
        }
        PostgresqlTableLazyTableEndpoint other = (PostgresqlTableLazyTableEndpoint)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<PostgresqlColumnEndpoint> this$lazyTableFieldEndpointList = this.getLazyTableFieldEndpointList();
        List<PostgresqlColumnEndpoint> other$lazyTableFieldEndpointList = other.getLazyTableFieldEndpointList();
        return !(this$lazyTableFieldEndpointList == null ? other$lazyTableFieldEndpointList != null : !((Object)this$lazyTableFieldEndpointList).equals(other$lazyTableFieldEndpointList));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PostgresqlTableLazyTableEndpoint;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<PostgresqlColumnEndpoint> $lazyTableFieldEndpointList = this.getLazyTableFieldEndpointList();
        result = result * 59 + ($lazyTableFieldEndpointList == null ? 43 : ((Object)$lazyTableFieldEndpointList).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "PostgresqlTableLazyTableEndpoint(lazyTableFieldEndpointList=" + this.getLazyTableFieldEndpointList() + ")";
    }
}

