/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.orm.core.source.postgresql;

import org.wu.framework.core.exception.AssertFactory;
import org.wu.framework.core.utils.ObjectUtils;
import org.wu.framework.lazy.orm.core.config.enums.LazyDataSourceType;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyColumn;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyColumnIndex;
import org.wu.framework.lazy.orm.core.persistence.conf.LazySchemata;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyTableInfo;
import org.wu.framework.lazy.orm.core.source.postgresql.PostgresSQLLazyColumn;
import org.wu.framework.lazy.orm.core.source.postgresql.PostgresSQLLazyColumnIndex;
import org.wu.framework.lazy.orm.core.source.postgresql.PostgresSQLLazySchemata;
import org.wu.framework.lazy.orm.core.source.postgresql.PostgresSQLLazyTable;
import org.wu.framework.lazy.orm.core.source.postgresql.PostgresSQLSourceAdvancedTargetAbstract;

public class PostgresSQLSourceAdvancedTarget
extends PostgresSQLSourceAdvancedTargetAbstract {
    @Override
    public boolean support(LazyDataSourceType lazyDataSourceType) {
        return LazyDataSourceType.POSTGRESQL.equals((Object)lazyDataSourceType);
    }

    @Override
    public String getHost(String url) {
        AssertFactory.notNull((Object)url, (String)"\u6570\u636e\u5e93\u8fde\u63a5\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        int firstIndex = url.indexOf("//");
        int lastIndex = url.lastIndexOf("/");
        if (firstIndex == -1 || lastIndex == -1) {
            return null;
        }
        String substring = url.substring(firstIndex, lastIndex);
        substring = substring.replace("//", "");
        String[] split = substring.split(":");
        return split[0];
    }

    @Override
    public int getPort(String url) {
        AssertFactory.notNull((Object)url, (String)"\u6570\u636e\u5e93\u8fde\u63a5\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        String substring = url.substring(url.indexOf("//") + 2, url.lastIndexOf("/"));
        String split = substring.substring(substring.indexOf(":") + 1, substring.indexOf("/") == -1 ? substring.length() : substring.indexOf("/"));
        return Integer.parseInt(split);
    }

    @Override
    public String getUrl(String host, int port, String schema) {
        if (ObjectUtils.isEmpty((Object)schema)) {
            schema = "postgres";
        }
        String urlFormat = "jdbc:postgresql://%s:%s/%s";
        return String.format(urlFormat, host, port, schema);
    }

    @Override
    public String formatUrl(String url) {
        return url;
    }

    @Override
    public String getUrlSchema(String url) {
        AssertFactory.notNull((Object)url, (String)"\u6570\u636e\u5e93\u8fde\u63a5\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        String substring = url.substring(url.indexOf("//") + 2, url.lastIndexOf("?") == -1 ? url.length() : url.lastIndexOf("?"));
        String[] split = substring.split("/");
        return split[1];
    }

    @Override
    public String getDefaultInformationSchemaUrl(String url) {
        return null;
    }

    @Override
    public LazyDataSourceType getLazyDataSourceType(String url) {
        if (ObjectUtils.isEmpty((Object)url)) {
            return null;
        }
        if (url.startsWith("jdbc:postgresql:")) {
            return LazyDataSourceType.POSTGRESQL;
        }
        return null;
    }

    @Override
    public Class<? extends LazyTableInfo> findTableInfoClass() {
        return PostgresSQLLazyTable.class;
    }

    @Override
    public Class<? extends LazySchemata> findSchemaInfoClass() {
        return PostgresSQLLazySchemata.class;
    }

    @Override
    public Class<? extends LazyColumn> findColumnInfoClass() {
        return PostgresSQLLazyColumn.class;
    }

    @Override
    public Class<? extends LazyColumnIndex> findColumnIndexInfoClass() {
        return PostgresSQLLazyColumnIndex.class;
    }
}

