/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.orm.core.source.mysql;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wu.framework.core.CamelAndUnderLineConverter;
import org.wu.framework.core.annotation.AnnotatedElementUtils;
import org.wu.framework.core.exception.AssertFactory;
import org.wu.framework.core.exception.RuntimeExceptionFactory;
import org.wu.framework.core.stereotype.LayerField;
import org.wu.framework.core.utils.ObjectUtils;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyColumn;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyColumnIndex;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyDatabaseJsonMessage;
import org.wu.framework.lazy.orm.core.persistence.conf.LazySchemata;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyTableEndpoint;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyTableFieldEndpoint;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyTableIndexEndpoint;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyTableInfo;
import org.wu.framework.lazy.orm.core.persistence.util.LazyTableIndexUtil;
import org.wu.framework.lazy.orm.core.persistence.util.SqlMessageFormatUtil;
import org.wu.framework.lazy.orm.core.source.advanced.SourceAdvanced;
import org.wu.framework.lazy.orm.core.source.advanced.SourceAdvancedAbstract;
import org.wu.framework.lazy.orm.core.source.mysql.MySQLColumnEndpoint;
import org.wu.framework.lazy.orm.core.source.mysql.MySQLLazyColumn;
import org.wu.framework.lazy.orm.core.source.mysql.MySQLLazyColumnIndex;
import org.wu.framework.lazy.orm.core.source.mysql.MySQLLazySchemata;
import org.wu.framework.lazy.orm.core.source.mysql.MySQLLazyTableInfo;
import org.wu.framework.lazy.orm.core.source.mysql.MySQLTableLazyTableEndpoint;
import org.wu.framework.lazy.orm.core.stereotype.LazyFieldStrategy;
import org.wu.framework.lazy.orm.core.stereotype.LazyTable;
import org.wu.framework.lazy.orm.core.stereotype.LazyTableField;
import org.wu.framework.lazy.orm.core.stereotype.LazyTableFieldId;

public abstract class MySQLSourceAdvancedTargetAbstract
extends SourceAdvancedAbstract
implements SourceAdvanced {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MySQLSourceAdvancedTargetAbstract.class);
    private static final ConcurrentMap<Class<?>, LazyTableEndpoint<?>> MYSQL_TABLE_CLASS_ATTR_MAP = new ConcurrentHashMap();
    private static final ConcurrentMap<String, LazyTableEndpoint<?>> MYSQL_TABLE_STR_ATTR_MAP = new ConcurrentHashMap();
    private static final ConcurrentMap<String, LazyTableEndpoint<?>> MYSQL_MAP_TABLE_STR_ATTR_MAP = new ConcurrentHashMap();
    public static List<String> specialFields = new ArrayList<String>(){
        {
            this.add("DESCRIBE");
            this.add("SCHEMA");
            this.add("SELECT");
            this.add("INSERT");
            this.add("UPDATE");
            this.add("DELETE");
            this.add("WHERE");
            this.add("ALTER");
            this.add("DESC");
            this.add("CURRENT_TIME");
            this.add("RANGE");
            this.add("CONTENT");
            this.add("SCHEMA");
            this.add("DESCRIBE");
            this.add("CURRENT_TIMESTAMP");
            this.add("CONDITION");
            this.add("SHOW");
            this.add("SYSTEM");
            this.add("FROM");
            this.add("TO");
            this.add("TIME");
            this.add("PROCEDURE");
            this.add("HANDLER");
            this.add("LIMIT");
            this.add("GROUP");
            this.add("KEY");
            this.add("INDEX");
            this.add("NAME");
            this.add("METHOD");
        }
    };
    public static List<String> specialFunction = new ArrayList<String>(){
        {
            this.add("CURRENT_TIMESTAMP");
            this.add("CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP");
            this.add("SCHEMA");
        }
    };

    @Override
    public String analyzeLazyTableName(Class<?> clazz) {
        AssertFactory.notNull(clazz, (String)"\u8868\u5bf9\u5e94\u7684class \u4e0d\u80fd\u662f\u7a7a");
        LazyTable lazyTable = (LazyTable)AnnotatedElementUtils.findMergedAnnotation(clazz, LazyTable.class);
        if (null == lazyTable || ObjectUtils.isEmpty((Object)lazyTable.tableName())) {
            String simpleName = clazz.getSimpleName();
            for (String ddlIgnoredTableSuffix : LazyDatabaseJsonMessage.ddlIgnoredTablePrefix) {
                if (!simpleName.startsWith(ddlIgnoredTableSuffix)) continue;
                simpleName = simpleName.substring(ddlIgnoredTableSuffix.length());
                break;
            }
            for (String ddlIgnoredTableSuffix : LazyDatabaseJsonMessage.ddlIgnoredTableSuffix) {
                if (!simpleName.endsWith(ddlIgnoredTableSuffix)) continue;
                simpleName = simpleName.substring(0, simpleName.length() - ddlIgnoredTableSuffix.length());
                break;
            }
            return CamelAndUnderLineConverter.humpToLine2((String)simpleName);
        }
        return lazyTable.tableName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LazyTableEndpoint<?> analyzeLazyTableFromLazyColumns(LazyTableInfo lazyTableInfo, List<? extends LazyColumn> lazyColumnList) {
        if (ObjectUtils.isEmpty(lazyColumnList)) {
            RuntimeExceptionFactory.of((String)"\u8868\u7ed3\u6784\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String tableName = lazyTableInfo.getTableName();
        String schemaName = lazyTableInfo.getTableSchema();
        String tableComment = lazyTableInfo.getTableComment();
        if (!MYSQL_TABLE_STR_ATTR_MAP.containsKey(tableName)) {
            ConcurrentMap<String, LazyTableEndpoint<?>> concurrentMap = MYSQL_TABLE_STR_ATTR_MAP;
            synchronized (concurrentMap) {
                List<MySQLColumnEndpoint> analyzeFieldOnAnnotation = lazyColumnList.stream().map(lazyColumn -> {
                    String columnComment = lazyColumn.getColumnComment();
                    String columnType = lazyColumn.getColumnType();
                    String columnName = lazyColumn.getColumnName();
                    String columnKey = lazyColumn.getColumnKey();
                    String extra = lazyColumn.getExtra();
                    String isNullable = lazyColumn.getIsNullable();
                    MySQLColumnEndpoint lazyTableFieldEndpoint = new MySQLColumnEndpoint();
                    lazyTableFieldEndpoint.setName(CamelAndUnderLineConverter.lineToHumpField((String)columnName));
                    lazyTableFieldEndpoint.setColumnType(columnType);
                    lazyTableFieldEndpoint.setComment(columnComment);
                    lazyTableFieldEndpoint.setExist(true);
                    lazyTableFieldEndpoint.setColumnName(columnName);
                    lazyTableFieldEndpoint.setExtra(extra);
                    lazyTableFieldEndpoint.setNotNull(!"yes".equalsIgnoreCase(lazyColumn.getIsNullable()));
                    lazyTableFieldEndpoint.setKey("PRI".equalsIgnoreCase(columnKey));
                    lazyTableFieldEndpoint.setDataType(lazyColumn.getDataType());
                    lazyTableFieldEndpoint.setDefaultValue(lazyColumn.getColumnDefault());
                    lazyTableFieldEndpoint.setScale(lazyColumn.getNumericScale());
                    lazyTableFieldEndpoint.setAlias(columnName);
                    return lazyTableFieldEndpoint;
                }).collect(Collectors.toList());
                boolean smartFillField = false;
                MySQLTableLazyTableEndpoint lazyTableEndpoint = new MySQLTableLazyTableEndpoint();
                if (ObjectUtils.isNotEmpty((Object)schemaName)) {
                    lazyTableEndpoint.setSchema(schemaName);
                }
                lazyTableEndpoint.setComment(tableComment);
                lazyTableEndpoint.setTableName(tableName);
                lazyTableEndpoint.setLazyTableFieldEndpointList(analyzeFieldOnAnnotation);
                lazyTableEndpoint.setSmartFillField(smartFillField);
                lazyTableEndpoint.setExist(true);
                log.info("Initialize column list date ,tableName:[{}],comment:[{}]", (Object)tableName, (Object)tableComment);
                MYSQL_TABLE_STR_ATTR_MAP.put(tableName, lazyTableEndpoint);
            }
        }
        return (LazyTableEndpoint)MYSQL_TABLE_STR_ATTR_MAP.get(tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LazyTableEndpoint<?> analyzeLazyTableFromClass(Class<?> clazz) {
        if (!MYSQL_TABLE_CLASS_ATTR_MAP.containsKey(clazz)) {
            ConcurrentMap<Class<?>, LazyTableEndpoint<?>> concurrentMap = MYSQL_TABLE_CLASS_ATTR_MAP;
            synchronized (concurrentMap) {
                LazyTable lazyTable = (LazyTable)AnnotatedElementUtils.findMergedAnnotation(clazz, LazyTable.class);
                String className = clazz.getName();
                String tableName = this.analyzeLazyTableName(clazz);
                Package clazzPackage = clazz.getPackage();
                if (null == clazzPackage) {
                    log.error("error find class package {}", (Object)className);
                }
                assert (clazzPackage != null);
                String packageName = clazzPackage.getName();
                String comment = "";
                boolean smartFillField = false;
                boolean exist = true;
                MySQLTableLazyTableEndpoint lazyTableEndpoint = new MySQLTableLazyTableEndpoint();
                if (null != lazyTable) {
                    lazyTableEndpoint.setSchema(lazyTable.schema());
                    smartFillField = lazyTable.smartFillField();
                    comment = lazyTable.comment();
                    if (AnnotatedElementUtils.hasAnnotation(clazz, Deprecated.class)) {
                        comment = comment + "\uff08\u5373\u5c06\u5f03\u7528\uff09";
                    }
                    LazyTable.Engine engine = lazyTable.engine();
                    lazyTableEndpoint.setEngine(engine);
                    exist = lazyTable.exist();
                }
                List<MySQLColumnEndpoint> analyzeFieldOnAnnotation = this.analyzeFieldOnAnnotation(clazz, null);
                lazyTableEndpoint.setPackageName(packageName);
                lazyTableEndpoint.setComment(comment);
                lazyTableEndpoint.setClassName(className);
                lazyTableEndpoint.setClazz(clazz);
                lazyTableEndpoint.setTableName(tableName);
                lazyTableEndpoint.setLazyTableFieldEndpointList(analyzeFieldOnAnnotation);
                lazyTableEndpoint.setSmartFillField(smartFillField);
                lazyTableEndpoint.setExist(exist);
                log.info("Initialize {} annotation parameters  className:[{}],tableName:[{}],comment:[{}]", new Object[]{clazz, className, tableName, comment});
                MYSQL_TABLE_CLASS_ATTR_MAP.put(clazz, lazyTableEndpoint);
            }
        }
        return (LazyTableEndpoint)MYSQL_TABLE_CLASS_ATTR_MAP.get(clazz);
    }

    @Override
    public LazyTableEndpoint<?> analyzeLazyTableFromMap(String schemaName, String tableName, Map<String, Object> beanData) {
        String fullTableName = ObjectUtils.isEmpty((Object)schemaName) ? tableName : schemaName + "." + tableName;
        List<MySQLColumnEndpoint> analyzeFieldOnAnnotation = beanData.entrySet().stream().filter(entry -> !ObjectUtils.isEmpty(entry.getValue())).map(entry -> {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            String fieldName = key;
            MySQLColumnEndpoint lazyTableFieldEndpoint = new MySQLColumnEndpoint();
            lazyTableFieldEndpoint.setName(fieldName);
            String tempFieldName = fieldName;
            if (specialFields.contains(tempFieldName.toUpperCase())) {
                fieldName = "`" + fieldName + "`";
            }
            Class fieldClazz = null == value ? String.class : value.getClass();
            lazyTableFieldEndpoint.setColumnType(LazyTableField.FieldType.getMysqlTypeByClass(fieldClazz));
            lazyTableFieldEndpoint.setComment(String.format("\u6570\u636e\u683c\u5f0f\u5982:%s", value));
            lazyTableFieldEndpoint.setClazz(fieldClazz);
            lazyTableFieldEndpoint.setExist(true);
            lazyTableFieldEndpoint.setColumnName(fieldName);
            lazyTableFieldEndpoint.setFieldValue(value);
            return lazyTableFieldEndpoint;
        }).collect(Collectors.toList());
        String comment = "\u901a\u8fc7Map\u6570\u636e\u521b\u5efa\u7684\u8868";
        boolean smartFillField = false;
        MySQLTableLazyTableEndpoint lazyTableEndpoint = new MySQLTableLazyTableEndpoint();
        if (ObjectUtils.isNotEmpty((Object)schemaName)) {
            lazyTableEndpoint.setSchema(schemaName);
        }
        lazyTableEndpoint.setComment(comment);
        lazyTableEndpoint.setTableName(tableName);
        lazyTableEndpoint.setLazyTableFieldEndpointList(analyzeFieldOnAnnotation);
        lazyTableEndpoint.setSmartFillField(smartFillField);
        lazyTableEndpoint.setExist(true);
        log.info("Initialize map date ,tableName:[{}],comment:[{}]", (Object)fullTableName, (Object)comment);
        MYSQL_MAP_TABLE_STR_ATTR_MAP.put(fullTableName, lazyTableEndpoint);
        return (LazyTableEndpoint)MYSQL_MAP_TABLE_STR_ATTR_MAP.get(fullTableName);
    }

    @Override
    public LazyTableFieldEndpoint getLazyTableFieldEndpointInstance() {
        return new MySQLColumnEndpoint();
    }

    @Override
    public LazyTableEndpoint<?> getLazyTableEndpointInstance() {
        return new MySQLTableLazyTableEndpoint();
    }

    @Override
    public ConcurrentMap<Class<?>, LazyTableEndpoint<?>> getClassTableCache() {
        return MYSQL_TABLE_CLASS_ATTR_MAP;
    }

    @Override
    public ConcurrentMap<String, LazyTableEndpoint<?>> getMapTableCache() {
        return MYSQL_MAP_TABLE_STR_ATTR_MAP;
    }

    public <T> List<MySQLColumnEndpoint> analyzeFieldOnAnnotation(Class<T> clazz, LayerField.LayerFieldType tableFileIndexType) {
        boolean haveId = false;
        ArrayList<MySQLColumnEndpoint> convertedFieldList = new ArrayList();
        for (Field declaredField : clazz.getDeclaredFields()) {
            LazyTableFieldId lazyTableFieldId;
            declaredField.setAccessible(true);
            String columnName = CamelAndUnderLineConverter.humpToLine2((String)declaredField.getName());
            MySQLColumnEndpoint lazyTableFieldEndpoint = new MySQLColumnEndpoint();
            String alias = columnName;
            boolean notNull = false;
            boolean key = false;
            boolean exist = true;
            String comment = "";
            String columnType = LazyTableField.FieldType.getMysqlTypeByClass(declaredField.getType());
            LazyTableIndexEndpoint[] lazyTableIndexEndpoints = new LazyTableIndexEndpoint[]{};
            LazyTableField lazyTableField = (LazyTableField)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)declaredField, LazyTableField.class);
            String defaultValue = null;
            LazyFieldStrategy lazyFieldStrategy = LazyFieldStrategy.NO_VERIFY;
            LazyFieldStrategy updateStrategy = LazyFieldStrategy.IGNORED_NULL;
            String extra = "";
            int serialNumber = 0;
            if (!ObjectUtils.isEmpty((Object)lazyTableField)) {
                exist = lazyTableField.exist();
                if (!exist) continue;
                comment = lazyTableField.comment();
                lazyTableIndexEndpoints = LazyTableIndexUtil.analyzeFieldIndex(lazyTableField);
                if (!ObjectUtils.isEmpty((Object)tableFileIndexType) && !ObjectUtils.isEmpty((Object)lazyTableIndexEndpoints) && Arrays.stream(lazyTableIndexEndpoints).noneMatch(lazyTableIndexEndpoint -> tableFileIndexType.equals((Object)lazyTableIndexEndpoint.getFieldIndexType()))) continue;
                if (!ObjectUtils.isEmpty((Object)lazyTableField.value())) {
                    columnName = lazyTableField.value();
                }
                notNull = lazyTableField.notNull();
                key = lazyTableField.key();
                defaultValue = ObjectUtils.isEmpty((Object)lazyTableField.defaultValue()) ? null : lazyTableField.defaultValue();
                columnType = lazyTableField.columnType();
                lazyFieldStrategy = lazyTableField.upsertStrategy();
                updateStrategy = lazyTableField.updateStrategy();
                extra = lazyTableField.extra();
                serialNumber = lazyTableField.serialNumber();
            }
            if (AnnotatedElementUtils.hasAnnotation((AnnotatedElement)declaredField, Deprecated.class)) {
                comment = comment + "\uff08\u5373\u5c06\u5f03\u7528\uff09";
            }
            lazyTableFieldEndpoint.setExist(exist);
            lazyTableFieldEndpoint.setComment(comment);
            lazyTableFieldEndpoint.setColumnType(columnType);
            lazyTableFieldEndpoint.setUpsertStrategy(lazyFieldStrategy);
            lazyTableFieldEndpoint.setUpdateStrategy(updateStrategy);
            lazyTableFieldEndpoint.setExtra(extra);
            lazyTableFieldEndpoint.setLazyTableIndexEndpoints(lazyTableIndexEndpoints);
            lazyTableFieldEndpoint.setSerialNumber(serialNumber);
            if (!haveId && !ObjectUtils.isEmpty((Object)(lazyTableFieldId = (LazyTableFieldId)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)declaredField, LazyTableFieldId.class)))) {
                haveId = true;
                LazyTableFieldId.IdType idType = lazyTableFieldId.idType();
                lazyTableFieldEndpoint.setIdType(idType);
                if (LazyTableFieldId.IdType.INPUT_ID.equals((Object)idType)) {
                    lazyTableFieldEndpoint.setExtra("");
                }
            }
            lazyTableFieldEndpoint.setField(declaredField);
            lazyTableFieldEndpoint.setColumnName(columnName);
            lazyTableFieldEndpoint.setName(declaredField.getName());
            lazyTableFieldEndpoint.setClazz(declaredField.getType());
            lazyTableFieldEndpoint.setAlias(alias);
            lazyTableFieldEndpoint.setNotNull(notNull);
            lazyTableFieldEndpoint.setKey(key);
            lazyTableFieldEndpoint.setDefaultValue(defaultValue);
            convertedFieldList.add(lazyTableFieldEndpoint);
        }
        convertedFieldList = convertedFieldList.stream().sorted(Comparator.comparing(LazyTableFieldEndpoint::getSerialNumber)).collect(Collectors.toList());
        return convertedFieldList;
    }

    @Override
    public String cleanSpecialColumn(String column) {
        AssertFactory.notNull((Object)column, (String)"\u5217\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
        if (specialFields.contains(column.toUpperCase(Locale.ROOT))) {
            return "`" + column + "`";
        }
        return column;
    }

    @Override
    public String findSchemaListSql() {
        return "show databases;";
    }

    @Override
    public String findTableColumnListSql(String schema, String table) {
        String sqlFormat = "select * from information_schema.COLUMNS where table_schema='{0}' and table_name='{1}' ";
        return SqlMessageFormatUtil.format(sqlFormat, schema, table);
    }

    @Override
    public String findTableColumnIndexListSql(String schema, String table) {
        String sqlFormat = "SELECT * FROM INFORMATION_SCHEMA.STATISTICS WHERE table_schema =  '{0}' AND table_name = '{1}'";
        return SqlMessageFormatUtil.format(sqlFormat, schema, table);
    }

    @Override
    public String findTableInfoSql(String schema, String table) {
        String sqlFormat = "select * from information_schema.tables where table_schema='{0}' and table_name='{1}'";
        return SqlMessageFormatUtil.format(sqlFormat, schema, table);
    }

    @Override
    public String createSchemaSql(String schemaName) {
        String sqlFormat = "CREATE DATABASE IF NOT EXISTS `{0}`";
        return SqlMessageFormatUtil.format(sqlFormat, schemaName);
    }

    @Override
    public Class<? extends LazyTableInfo> findTableInfoClass() {
        return MySQLLazyTableInfo.class;
    }

    @Override
    public Class<? extends LazySchemata> findSchemaInfoClass() {
        return MySQLLazySchemata.class;
    }

    @Override
    public Class<? extends LazyColumn> findColumnInfoClass() {
        return MySQLLazyColumn.class;
    }

    @Override
    public Class<? extends LazyColumnIndex> findColumnIndexInfoClass() {
        return MySQLLazyColumnIndex.class;
    }
}

