/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.orm.core.source.h2;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wu.framework.core.CamelAndUnderLineConverter;
import org.wu.framework.core.annotation.AnnotatedElementUtils;
import org.wu.framework.core.exception.AssertFactory;
import org.wu.framework.core.exception.RuntimeExceptionFactory;
import org.wu.framework.core.stereotype.LayerField;
import org.wu.framework.core.utils.ObjectUtils;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyColumn;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyDatabaseJsonMessage;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyTableEndpoint;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyTableFieldEndpoint;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyTableIndexEndpoint;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyTableInfo;
import org.wu.framework.lazy.orm.core.persistence.util.LazyTableIndexUtil;
import org.wu.framework.lazy.orm.core.persistence.util.SqlMessageFormatUtil;
import org.wu.framework.lazy.orm.core.source.advanced.SourceAdvanced;
import org.wu.framework.lazy.orm.core.source.advanced.SourceAdvancedAbstract;
import org.wu.framework.lazy.orm.core.source.clickhouse.ClickHouseColumnEndpoint;
import org.wu.framework.lazy.orm.core.source.clickhouse.ClickHouseTableLazyTableEndpoint;
import org.wu.framework.lazy.orm.core.source.h2.H2ColumnEndpoint;
import org.wu.framework.lazy.orm.core.source.h2.H2TableLazyTableEndpoint;
import org.wu.framework.lazy.orm.core.stereotype.LazyTable;
import org.wu.framework.lazy.orm.core.stereotype.LazyTableField;
import org.wu.framework.lazy.orm.core.stereotype.LazyTableFieldId;

public abstract class H2SourceAdvancedTargetAbstract
extends SourceAdvancedAbstract
implements SourceAdvanced {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(H2SourceAdvancedTargetAbstract.class);
    private static final ConcurrentMap<Class<?>, LazyTableEndpoint<?>> H2_TABLE_CLASS_ATTR_MAP = new ConcurrentHashMap();
    private static final ConcurrentMap<String, LazyTableEndpoint<?>> H2_TABLE_STR_ATTR_MAP = new ConcurrentHashMap();
    private static final ConcurrentMap<String, LazyTableEndpoint<?>> H2_MAP_TABLE_STR_ATTR_MAP = new ConcurrentHashMap();
    public static List<String> specialFields = new ArrayList<String>(){
        {
            this.add("ALL");
            this.add("AND");
            this.add("ANY");
            this.add("ARRAY");
            this.add("AS");
            this.add("ASYMMETRICNR");
            this.add("AUTHORIZATION");
            this.add("BETWEENNR");
            this.add("BOTH");
            this.add("CASE");
            this.add("CAST");
            this.add("CHECK");
            this.add("CONSTRAINT");
            this.add("CROSS");
            this.add("CURRENT_CATALOG");
            this.add("CURRENT_DATE");
            this.add("CURRENT_PATH");
            this.add("CURRENT_ROLE");
            this.add("CURRENT_SCHEMA");
            this.add("CURRENT_TIME");
            this.add("CURRENT_TIMESTAMP");
            this.add("CURRENT_USER");
            this.add("DAY");
            this.add("DEFAULT");
            this.add("DISTINCT");
            this.add("ELSE");
            this.add("END");
            this.add("EXCEPT");
            this.add("EXISTSNR");
            this.add("FALSE");
            this.add("FETCH");
            this.add("FOR");
            this.add("FOREIGN");
            this.add("FROM");
            this.add("FULL");
            this.add("GROUP");
            this.add("GROUPS");
            this.add("HAVING");
            this.add("HOUR");
            this.add("IF");
            this.add("ILIKE");
            this.add("IN");
            this.add("INNER");
            this.add("INTERSECT");
            this.add("INTERVAL");
            this.add("IS");
            this.add("JOIN");
            this.add("KEYNRNRNRNR");
            this.add("LEADING");
            this.add("LEFT");
            this.add("LIKE");
            this.add("LIMITMS");
            this.add("LOCALTIME");
            this.add("LOCALTIMESTAMP");
            this.add("MINUSMS");
            this.add("MINUTE");
            this.add("MONTH");
            this.add("NATURAL");
            this.add("NOT");
            this.add("NULL");
            this.add("OFFSET");
            this.add("ON");
            this.add("OR");
            this.add("ORDER");
            this.add("OVER");
            this.add("PARTITION");
            this.add("PRIMARY");
            this.add("QUALIFY");
            this.add("RANGE");
            this.add("REGEXP");
            this.add("RIGHT");
            this.add("ROW");
            this.add("ROWNUM");
            this.add("ROWS");
            this.add("SECOND");
            this.add("SELECT");
            this.add("SESSION_USER");
            this.add("SET");
            this.add("SOME");
            this.add("SYMMETRICNR");
            this.add("SYSTEM_USER");
            this.add("TABLE");
            this.add("TO");
            this.add("TOPMS");
            this.add("CS");
            this.add("TRAILING");
            this.add("TRUE");
            this.add("UESCAPE");
            this.add("UNION");
            this.add("UNIQUE");
            this.add("UNKNOWN");
            this.add("USER");
            this.add("USING");
            this.add("VALUE");
            this.add("VALUES");
            this.add("WHEN");
            this.add("WHERE");
            this.add("WINDOW");
            this.add("WITH");
            this.add("YEAR");
            this.add("_ROWID_");
        }
    };

    @Override
    public String analyzeLazyTableName(Class<?> clazz) {
        AssertFactory.notNull(clazz, (String)"\u8868\u5bf9\u5e94\u7684 class \u4e0d\u80fd\u662f\u7a7a");
        LazyTable lazyTable = (LazyTable)AnnotatedElementUtils.findMergedAnnotation(clazz, LazyTable.class);
        if (null == lazyTable || ObjectUtils.isEmpty((Object)lazyTable.tableName())) {
            String simpleName = clazz.getSimpleName();
            for (String ddlIgnoredTableSuffix : LazyDatabaseJsonMessage.ddlIgnoredTablePrefix) {
                if (!simpleName.startsWith(ddlIgnoredTableSuffix)) continue;
                simpleName = simpleName.substring(ddlIgnoredTableSuffix.length());
                break;
            }
            for (String ddlIgnoredTableSuffix : LazyDatabaseJsonMessage.ddlIgnoredTableSuffix) {
                if (!simpleName.endsWith(ddlIgnoredTableSuffix)) continue;
                simpleName = simpleName.substring(0, simpleName.length() - ddlIgnoredTableSuffix.length());
                break;
            }
            return CamelAndUnderLineConverter.humpToLine2((String)simpleName);
        }
        return lazyTable.tableName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LazyTableEndpoint<?> analyzeLazyTableFromLazyColumns(LazyTableInfo lazyTableInfo, List<? extends LazyColumn> lazyColumnList) {
        if (ObjectUtils.isEmpty(lazyColumnList)) {
            RuntimeExceptionFactory.of((String)"\u8868\u7ed3\u6784\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String tableName = lazyTableInfo.getTableName();
        String schemaName = lazyTableInfo.getTableSchema();
        String tableComment = lazyTableInfo.getTableComment();
        if (!H2_TABLE_STR_ATTR_MAP.containsKey(tableName)) {
            ConcurrentMap<String, LazyTableEndpoint<?>> concurrentMap = H2_TABLE_STR_ATTR_MAP;
            synchronized (concurrentMap) {
                List<ClickHouseColumnEndpoint> analyzeFieldOnAnnotation = lazyColumnList.stream().map(lazyColumn -> {
                    String columnComment = lazyColumn.getColumnComment();
                    String columnType = lazyColumn.getColumnType();
                    String columnName = lazyColumn.getColumnName();
                    String columnKey = lazyColumn.getColumnKey();
                    String extra = lazyColumn.getExtra();
                    String isNullable = lazyColumn.getIsNullable();
                    ClickHouseColumnEndpoint lazyTableFieldEndpoint = new ClickHouseColumnEndpoint();
                    lazyTableFieldEndpoint.setName(CamelAndUnderLineConverter.lineToHumpField((String)columnName));
                    lazyTableFieldEndpoint.setColumnType(columnType);
                    lazyTableFieldEndpoint.setComment(columnComment);
                    lazyTableFieldEndpoint.setExist(true);
                    lazyTableFieldEndpoint.setColumnName(columnName);
                    lazyTableFieldEndpoint.setExtra(extra);
                    lazyTableFieldEndpoint.setNotNull(!"yes".equalsIgnoreCase(lazyColumn.getIsNullable()));
                    lazyTableFieldEndpoint.setKey("PRI".equalsIgnoreCase(columnKey));
                    lazyTableFieldEndpoint.setDataType(lazyColumn.getDataType());
                    lazyTableFieldEndpoint.setDefaultValue(lazyColumn.getColumnDefault());
                    lazyTableFieldEndpoint.setScale(lazyColumn.getNumericScale());
                    lazyTableFieldEndpoint.setAlias(columnName);
                    return lazyTableFieldEndpoint;
                }).collect(Collectors.toList());
                boolean smartFillField = false;
                ClickHouseTableLazyTableEndpoint lazyTableEndpoint = new ClickHouseTableLazyTableEndpoint();
                if (ObjectUtils.isNotEmpty((Object)schemaName)) {
                    lazyTableEndpoint.setSchema(schemaName);
                }
                lazyTableEndpoint.setComment(tableComment);
                lazyTableEndpoint.setTableName(tableName);
                lazyTableEndpoint.setLazyTableFieldEndpointList(analyzeFieldOnAnnotation);
                lazyTableEndpoint.setSmartFillField(smartFillField);
                lazyTableEndpoint.setExist(true);
                log.info("Initialize column list date ,tableName:[{}],comment:[{}]", (Object)tableName, (Object)tableComment);
                H2_TABLE_STR_ATTR_MAP.put(tableName, lazyTableEndpoint);
            }
        }
        return (LazyTableEndpoint)H2_TABLE_STR_ATTR_MAP.get(tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LazyTableEndpoint<?> analyzeLazyTableFromClass(Class<?> clazz) {
        if (!H2_TABLE_CLASS_ATTR_MAP.containsKey(clazz)) {
            ConcurrentMap<Class<?>, LazyTableEndpoint<?>> concurrentMap = H2_TABLE_CLASS_ATTR_MAP;
            synchronized (concurrentMap) {
                LazyTable lazyTable = (LazyTable)AnnotatedElementUtils.findMergedAnnotation(clazz, LazyTable.class);
                String className = clazz.getName();
                String tableName = this.analyzeLazyTableName(clazz);
                Package clazzPackage = clazz.getPackage();
                if (null == clazzPackage) {
                    System.out.println(className);
                }
                String packageName = clazzPackage.getName();
                String comment = "";
                boolean smartFillField = false;
                boolean exist = true;
                H2TableLazyTableEndpoint lazyTableEndpoint = new H2TableLazyTableEndpoint();
                if (null != lazyTable) {
                    lazyTableEndpoint.setSchema(lazyTable.schema());
                    smartFillField = lazyTable.smartFillField();
                    comment = lazyTable.comment();
                    if (AnnotatedElementUtils.hasAnnotation(clazz, Deprecated.class)) {
                        comment = comment + "\uff08\u5373\u5c06\u5f03\u7528\uff09";
                    }
                    LazyTable.Engine engine = lazyTable.engine();
                    lazyTableEndpoint.setEngine(engine);
                    exist = lazyTable.exist();
                }
                List<H2ColumnEndpoint> analyzeFieldOnAnnotation = this.analyzeFieldOnAnnotation(clazz, null);
                lazyTableEndpoint.setPackageName(packageName);
                lazyTableEndpoint.setComment(comment);
                lazyTableEndpoint.setClassName(className);
                lazyTableEndpoint.setClazz(clazz);
                lazyTableEndpoint.setTableName(tableName);
                lazyTableEndpoint.setLazyTableFieldEndpointList(analyzeFieldOnAnnotation);
                lazyTableEndpoint.setSmartFillField(smartFillField);
                lazyTableEndpoint.setExist(exist);
                log.info("Initialize {} annotation parameters  className:[{}],tableName:[{}],comment:[{}]", new Object[]{clazz, className, tableName, comment});
                H2_TABLE_CLASS_ATTR_MAP.put(clazz, lazyTableEndpoint);
            }
        }
        return (LazyTableEndpoint)H2_TABLE_CLASS_ATTR_MAP.get(clazz);
    }

    @Override
    public LazyTableEndpoint<?> analyzeLazyTableFromMap(String schemaName, String tableName, Map<String, Object> beanData) {
        String fullTableName = ObjectUtils.isEmpty((Object)schemaName) ? tableName : schemaName + "." + tableName;
        List<H2ColumnEndpoint> analyzeFieldOnAnnotation = beanData.entrySet().stream().filter(entry -> !ObjectUtils.isEmpty(entry.getValue())).map(entry -> {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            String fieldName = key;
            H2ColumnEndpoint lazyTableFieldEndpoint = new H2ColumnEndpoint();
            lazyTableFieldEndpoint.setName(fieldName);
            String tempFieldName = fieldName;
            if (specialFields.contains(tempFieldName.toUpperCase())) {
                fieldName = "`" + fieldName + "`";
            }
            Class fieldClazz = null == value ? String.class : value.getClass();
            lazyTableFieldEndpoint.setColumnType(LazyTableField.FieldType.getH2TypeByClass(fieldClazz));
            lazyTableFieldEndpoint.setComment(String.format("\u6570\u636e\u683c\u5f0f\u5982:%s", value));
            lazyTableFieldEndpoint.setClazz(fieldClazz);
            lazyTableFieldEndpoint.setExist(true);
            lazyTableFieldEndpoint.setColumnName(fieldName);
            lazyTableFieldEndpoint.setFieldValue(value);
            return lazyTableFieldEndpoint;
        }).collect(Collectors.toList());
        String comment = "\u901a\u8fc7Map\u6570\u636e\u521b\u5efa\u7684\u8868";
        boolean smartFillField = false;
        H2TableLazyTableEndpoint lazyTableEndpoint = new H2TableLazyTableEndpoint();
        if (ObjectUtils.isNotEmpty((Object)schemaName)) {
            lazyTableEndpoint.setSchema(schemaName);
        }
        lazyTableEndpoint.setComment(comment);
        lazyTableEndpoint.setTableName(tableName);
        lazyTableEndpoint.setLazyTableFieldEndpointList(analyzeFieldOnAnnotation);
        lazyTableEndpoint.setSmartFillField(smartFillField);
        lazyTableEndpoint.setExist(true);
        log.info("Initialize map date ,tableName:[{}],comment:[{}]", (Object)fullTableName, (Object)comment);
        H2_MAP_TABLE_STR_ATTR_MAP.put(fullTableName, lazyTableEndpoint);
        return (LazyTableEndpoint)H2_MAP_TABLE_STR_ATTR_MAP.get(fullTableName);
    }

    @Override
    public LazyTableFieldEndpoint getLazyTableFieldEndpointInstance() {
        return new H2ColumnEndpoint();
    }

    @Override
    public LazyTableEndpoint<?> getLazyTableEndpointInstance() {
        return new H2TableLazyTableEndpoint();
    }

    @Override
    public ConcurrentMap<Class<?>, LazyTableEndpoint<?>> getClassTableCache() {
        return H2_TABLE_CLASS_ATTR_MAP;
    }

    @Override
    public ConcurrentMap<String, LazyTableEndpoint<?>> getMapTableCache() {
        return H2_MAP_TABLE_STR_ATTR_MAP;
    }

    public <T> List<H2ColumnEndpoint> analyzeFieldOnAnnotation(Class<T> clazz, LayerField.LayerFieldType tableFileIndexType) {
        boolean haveId = false;
        ArrayList<H2ColumnEndpoint> convertedFieldList = new ArrayList();
        for (Field declaredField : clazz.getDeclaredFields()) {
            LazyTableFieldId lazyTableFieldId;
            declaredField.setAccessible(true);
            LazyTableField lazyTableField = (LazyTableField)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)declaredField, LazyTableField.class);
            String columnName = CamelAndUnderLineConverter.humpToLine2((String)declaredField.getName());
            H2ColumnEndpoint lazyTableFieldEndpoint = new H2ColumnEndpoint();
            String alias = columnName;
            boolean notNull = false;
            boolean key = false;
            String defaultValue = null;
            if (!ObjectUtils.isEmpty((Object)lazyTableField)) {
                lazyTableFieldEndpoint.setExist(lazyTableField.exist());
                if (!lazyTableField.exist()) continue;
                String comment = lazyTableField.comment();
                if (AnnotatedElementUtils.hasAnnotation((AnnotatedElement)declaredField, Deprecated.class)) {
                    comment = comment + "\uff08\u5373\u5c06\u5f03\u7528\uff09";
                }
                LazyTableIndexEndpoint[] lazyTableIndexEndpoints = LazyTableIndexUtil.analyzeFieldIndex(lazyTableField);
                if (!ObjectUtils.isEmpty((Object)tableFileIndexType) && !ObjectUtils.isEmpty((Object)lazyTableIndexEndpoints) && Arrays.stream(lazyTableIndexEndpoints).noneMatch(lazyTableIndexEndpoint -> tableFileIndexType.equals((Object)lazyTableIndexEndpoint.getFieldIndexType()))) continue;
                if (!ObjectUtils.isEmpty((Object)lazyTableField.value())) {
                    columnName = lazyTableField.value();
                }
                notNull = lazyTableField.notNull();
                key = lazyTableField.key();
                defaultValue = ObjectUtils.isEmpty((Object)lazyTableField.defaultValue()) ? null : lazyTableField.defaultValue();
                lazyTableFieldEndpoint.setComment(comment);
                lazyTableFieldEndpoint.setColumnType(lazyTableField.columnType());
                lazyTableFieldEndpoint.setUpsertStrategy(lazyTableField.upsertStrategy());
                lazyTableFieldEndpoint.setUpdateStrategy(lazyTableField.updateStrategy());
                lazyTableFieldEndpoint.setExtra(lazyTableField.extra());
                lazyTableFieldEndpoint.setLazyTableIndexEndpoints(lazyTableIndexEndpoints);
                lazyTableFieldEndpoint.setSerialNumber(lazyTableField.serialNumber());
            } else {
                lazyTableFieldEndpoint.setExist(true);
            }
            if (!haveId && !ObjectUtils.isEmpty((Object)(lazyTableFieldId = (LazyTableFieldId)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)declaredField, LazyTableFieldId.class)))) {
                haveId = true;
                LazyTableFieldId.IdType idType = lazyTableFieldId.idType();
                lazyTableFieldEndpoint.setIdType(idType);
                if (LazyTableFieldId.IdType.INPUT_ID.equals((Object)idType)) {
                    lazyTableFieldEndpoint.setExtra("");
                }
            }
            lazyTableFieldEndpoint.setField(declaredField);
            lazyTableFieldEndpoint.setColumnName(columnName);
            lazyTableFieldEndpoint.setName(declaredField.getName());
            lazyTableFieldEndpoint.setClazz(declaredField.getType());
            lazyTableFieldEndpoint.setAlias(alias);
            lazyTableFieldEndpoint.setNotNull(notNull);
            lazyTableFieldEndpoint.setKey(key);
            lazyTableFieldEndpoint.setDefaultValue(defaultValue);
            convertedFieldList.add(lazyTableFieldEndpoint);
        }
        convertedFieldList = convertedFieldList.stream().sorted(Comparator.comparing(LazyTableFieldEndpoint::getSerialNumber)).collect(Collectors.toList());
        return convertedFieldList;
    }

    @Override
    public String cleanSpecialColumn(String column) {
        AssertFactory.notNull((Object)column, (String)"\u5217\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
        if (specialFields.contains(column.toUpperCase(Locale.ROOT))) {
            return "`" + column + "`";
        }
        return column;
    }

    @Override
    public String findSchemaListSql() {
        return "show databases;";
    }

    @Override
    public String findTableColumnListSql(String schema, String table) {
        String sqlFormat = "select * from information_schema.COLUMNS where (table_catalog =  '{0}' or table_catalog =  '{1}') and ( table_name='{2}' or  table_name='{3}' ) ";
        return SqlMessageFormatUtil.format(sqlFormat, schema.toLowerCase(), schema.toUpperCase(), table.toLowerCase(), table.toUpperCase());
    }

    @Override
    public String findTableColumnIndexListSql(String schema, String table) {
        String sqlFormat = "SELECT * FROM INFORMATION_SCHEMA.INDEX_COLUMNS WHERE (table_catalog =  '{0}' or table_catalog =  '{1}') and ( table_name='{2}' or  table_name='{3}' )";
        return SqlMessageFormatUtil.format(sqlFormat, schema.toLowerCase(), schema.toUpperCase(), table.toLowerCase(), table.toUpperCase());
    }

    @Override
    public String findTableInfoSql(String schema, String table) {
        String sqlFormat = "select * from information_schema.tables where (table_catalog =  '{0}' or table_catalog =  '{1}') and ( table_name='{2}' or  table_name='{3}' )";
        return SqlMessageFormatUtil.format(sqlFormat, schema.toLowerCase(), schema.toUpperCase(), table.toLowerCase(), table.toUpperCase());
    }

    @Override
    public String createSchemaSql(String schemaName) {
        String sqlFormat = "CREATE DATABASE IF NOT EXISTS `{0}`";
        return SqlMessageFormatUtil.format(sqlFormat, schemaName);
    }
}

