/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.orm.core.source.h2;

import org.wu.framework.core.exception.AssertFactory;
import org.wu.framework.core.utils.ObjectUtils;
import org.wu.framework.lazy.orm.core.config.enums.LazyDataSourceType;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyColumn;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyColumnIndex;
import org.wu.framework.lazy.orm.core.persistence.conf.LazySchemata;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyTableInfo;
import org.wu.framework.lazy.orm.core.source.h2.H2LazyColumn;
import org.wu.framework.lazy.orm.core.source.h2.H2LazyColumnIndex;
import org.wu.framework.lazy.orm.core.source.h2.H2LazySchemata;
import org.wu.framework.lazy.orm.core.source.h2.H2LazyTable;
import org.wu.framework.lazy.orm.core.source.h2.H2SourceAdvancedTargetAbstract;

public class H2SourceAdvancedTarget
extends H2SourceAdvancedTargetAbstract {
    @Override
    public boolean support(LazyDataSourceType lazyDataSourceType) {
        return LazyDataSourceType.H2.equals((Object)lazyDataSourceType);
    }

    @Override
    public String getHost(String url) {
        return null;
    }

    @Override
    public int getPort(String url) {
        return -1;
    }

    @Override
    public String getUrl(String host, int port, String schema) {
        String urlFormat = "jdbc:h2:tcp://%s:%s/information_schema";
        return String.format(urlFormat, host, port);
    }

    @Override
    public String formatUrl(String url) {
        return url;
    }

    @Override
    public String getUrlSchema(String url) {
        AssertFactory.notNull((Object)url, (String)"\u6570\u636e\u5e93\u8fde\u63a5\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        if (url.startsWith("jdbc:h2:tcp:")) {
            return url.substring(url.lastIndexOf("/") + 1, !url.contains(";") ? url.length() : url.indexOf(";"));
        }
        return url.substring(url.lastIndexOf(":") + 1, !url.contains(";") ? url.length() : url.indexOf(";"));
    }

    @Override
    public String getDefaultInformationSchemaUrl(String url) {
        return null;
    }

    @Override
    public LazyDataSourceType getLazyDataSourceType(String url) {
        if (ObjectUtils.isEmpty((Object)url)) {
            return null;
        }
        if (url.startsWith("jdbc:h2:")) {
            return LazyDataSourceType.H2;
        }
        return null;
    }

    @Override
    public Class<? extends LazyTableInfo> findTableInfoClass() {
        return H2LazyTable.class;
    }

    @Override
    public Class<? extends LazySchemata> findSchemaInfoClass() {
        return H2LazySchemata.class;
    }

    @Override
    public Class<? extends LazyColumn> findColumnInfoClass() {
        return H2LazyColumn.class;
    }

    @Override
    public Class<? extends LazyColumnIndex> findColumnIndexInfoClass() {
        return H2LazyColumnIndex.class;
    }
}

