/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.orm.core.source.clickhouse;

import java.text.Collator;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wu.framework.core.stereotype.LayerField;
import org.wu.framework.core.utils.ObjectUtils;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyDatabaseJsonMessage;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyTableFieldEndpoint;
import org.wu.framework.lazy.orm.core.persistence.conf.clazz.AbstractLazyTableEndpoint;
import org.wu.framework.lazy.orm.core.source.clickhouse.ClickHouseColumnEndpoint;

public class ClickHouseTableLazyTableEndpoint
extends AbstractLazyTableEndpoint<ClickHouseColumnEndpoint> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClickHouseTableLazyTableEndpoint.class);
    private List<ClickHouseColumnEndpoint> lazyTableFieldEndpointList;

    @Override
    public String creatTableSQL() {
        Map<String, List<LazyTableFieldEndpoint>> spatialIndexMap;
        StringBuilder createTableSQLBuffer = new StringBuilder(String.format("-- \u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\n-- create table %s  %s  \n-- add by  %s  %s  \n-- \u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\n", this.getFullTableName(), this.getComment(), "wujiawei", LocalDate.now()));
        if (!ObjectUtils.isEmpty((Object)this.getSchema())) {
            createTableSQLBuffer.append(String.format(" CREATE DATABASE IF NOT EXISTS %s; \n use %s ; \n ", this.getSchema(), this.getSchema()));
        }
        createTableSQLBuffer.append("CREATE TABLE IF NOT EXISTS `").append(this.getTableName()).append("` ( \n");
        List<ClickHouseColumnEndpoint> fieldEndpoints = this.getLazyTableFieldEndpointList();
        List<ClickHouseColumnEndpoint> fieldLazyTableFieldEndpointList = new ArrayList<ClickHouseColumnEndpoint>(fieldEndpoints);
        fieldLazyTableFieldEndpointList.addAll(this.toThisFieldEndpointList(LazyDatabaseJsonMessage.extraFields));
        fieldLazyTableFieldEndpointList = fieldLazyTableFieldEndpointList.stream().sorted((firstLazyTableFieldEndpoint, secondLazyFieldLazyTableFieldEndpoint) -> Collator.getInstance(Locale.CHINA).compare(firstLazyTableFieldEndpoint.getColumnName(), secondLazyFieldLazyTableFieldEndpoint.getColumnName())).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<ClickHouseColumnEndpoint>(Comparator.comparing(LazyTableFieldEndpoint::getColumnName))), ArrayList::new));
        Map<LayerField.LayerFieldType, Map<String, List<LazyTableFieldEndpoint>>> layerFieldTypeMap = this.getLayerFieldTypeMap(fieldLazyTableFieldEndpointList);
        ArrayList<String> columnList = new ArrayList<String>();
        fieldLazyTableFieldEndpointList.stream().filter(LazyTableFieldEndpoint::isExist).forEach(field -> columnList.add(field.columnSQL() + "\n"));
        List idList = fieldLazyTableFieldEndpointList.stream().filter(LazyTableFieldEndpoint::isExist).filter(LazyTableFieldEndpoint::isKey).map(LazyTableFieldEndpoint::getColumnName).collect(Collectors.toList());
        if (!ObjectUtils.isEmpty(idList)) {
            columnList.add(String.format("PRIMARY KEY (%s) ", String.join((CharSequence)",", idList)) + "\n");
        }
        if (!ObjectUtils.isEmpty(layerFieldTypeMap)) {
            Map<String, List<LazyTableFieldEndpoint>> fulltextIndexMap;
            Map<String, List<LazyTableFieldEndpoint>> normalIndexMap;
            Map<String, List<LazyTableFieldEndpoint>> uniqueIndexMap = layerFieldTypeMap.get(LayerField.LayerFieldType.UNIQUE);
            if (!ObjectUtils.isEmpty(uniqueIndexMap)) {
                uniqueIndexMap.forEach((uniqueIndexName, lazyTableFieldEndpoints) -> {
                    String uniqueIndexSql = "UNIQUE KEY `" + uniqueIndexName + "` (" + lazyTableFieldEndpoints.stream().map(LazyTableFieldEndpoint::getColumnName).collect(Collectors.joining(",")) + ")";
                    columnList.add(uniqueIndexSql);
                });
            }
            if (!ObjectUtils.isEmpty(normalIndexMap = layerFieldTypeMap.get(LayerField.LayerFieldType.NORMAL))) {
                normalIndexMap.forEach((normalIndexName, lazyTableFieldEndpoints) -> {
                    String normalIndexSql = " KEY `" + normalIndexName + "` (" + lazyTableFieldEndpoints.stream().map(LazyTableFieldEndpoint::getColumnName).collect(Collectors.joining(",")) + ")";
                    columnList.add(normalIndexSql);
                });
            }
            if (!ObjectUtils.isEmpty(fulltextIndexMap = layerFieldTypeMap.get(LayerField.LayerFieldType.FULLTEXT))) {
                fulltextIndexMap.forEach((fulltextIndexName, lazyTableFieldEndpoints) -> {
                    String fulltextIndexSql = " FULLTEXT KEY `" + fulltextIndexName + "` (" + lazyTableFieldEndpoints.stream().map(LazyTableFieldEndpoint::getColumnName).collect(Collectors.joining(",")) + ")";
                    columnList.add(fulltextIndexSql);
                });
            }
        }
        if (!ObjectUtils.isEmpty(spatialIndexMap = layerFieldTypeMap.get(LayerField.LayerFieldType.SPATIAL))) {
            spatialIndexMap.forEach((spatialIndexName, lazyTableFieldEndpoints) -> {
                String spatialIndexSql = " SPATIAL KEY `" + spatialIndexName + "` (" + lazyTableFieldEndpoints.stream().map(LazyTableFieldEndpoint::getColumnName).collect(Collectors.joining(",")) + ")";
                columnList.add(spatialIndexSql);
            });
        }
        createTableSQLBuffer.append(String.join((CharSequence)",", columnList));
        createTableSQLBuffer.append(") ENGINE= MergeTree() ");
        createTableSQLBuffer.append("COMMENT");
        createTableSQLBuffer.append(" ");
        createTableSQLBuffer.append("'");
        createTableSQLBuffer.append(this.getComment());
        createTableSQLBuffer.append("'");
        createTableSQLBuffer.append(";");
        createTableSQLBuffer.append("\n");
        createTableSQLBuffer.append("-- ------end \n-- \u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\n");
        System.out.println(createTableSQLBuffer);
        return createTableSQLBuffer.toString();
    }

    @Override
    public String alterTableSQL(List<ClickHouseColumnEndpoint> currentColumnNameList, boolean dropColumn) {
        currentColumnNameList = currentColumnNameList.stream().sorted((fieldLazyTableFieldEndpoint1, fieldLazyTableFieldEndpoint2) -> Collator.getInstance(Locale.CHINA).compare(fieldLazyTableFieldEndpoint1.getColumnName(), fieldLazyTableFieldEndpoint2.getColumnName())).collect(Collectors.toList());
        String ALTER_TABLE = "ALTER TABLE %s ";
        List<String> sql = this.alterTableColumnSQLPartList(currentColumnNameList, dropColumn);
        if (ObjectUtils.isEmpty(sql)) {
            return null;
        }
        String alterSQL = String.format(ALTER_TABLE, this.getFullTableName()) + sql.stream().filter(s -> !ObjectUtils.isEmpty((Object)s)).collect(Collectors.joining(","));
        log.debug("\u66f4\u65b0\u8868\u7ed3\u6784\u8bed\u53e5:{}", (Object)alterSQL);
        return alterSQL;
    }

    @Override
    protected List<String> alterTableColumnSQLPartList(List<ClickHouseColumnEndpoint> currentColumnNameList, boolean dropColumn) {
        String javaColumnPkIndex;
        String currentColumnPkIndex;
        currentColumnNameList = currentColumnNameList.stream().sorted((fieldLazyTableFieldEndpoint1, fieldLazyTableFieldEndpoint2) -> Collator.getInstance(Locale.CHINA).compare(fieldLazyTableFieldEndpoint1.getColumnName(), fieldLazyTableFieldEndpoint2.getColumnName())).collect(Collectors.toList());
        String ALTER_TABLE = "ALTER TABLE %s ";
        String ADD_FIELD = " ADD COLUMN `%s` %s comment '%s' ";
        List javaFieldLazyTableFieldEndpointList = this.getLazyTableFieldEndpointList().stream().sorted((first, second) -> Collator.getInstance(Locale.CHINA).compare(first.getColumnName(), second.getColumnName())).collect(Collectors.toList());
        javaFieldLazyTableFieldEndpointList.addAll(this.toThisFieldEndpointList(LazyDatabaseJsonMessage.extraFields));
        javaFieldLazyTableFieldEndpointList = javaFieldLazyTableFieldEndpointList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<ClickHouseColumnEndpoint>(Comparator.comparing(LazyTableFieldEndpoint::getColumnName))), ArrayList::new));
        Map<String, LazyTableFieldEndpoint> currentColumnNameMap = currentColumnNameList.stream().collect(Collectors.toMap(lazyTableFieldEndpoint -> lazyTableFieldEndpoint.getColumnName().toLowerCase(Locale.ROOT), convertedField -> convertedField, (A, B) -> A));
        List ADD_SQL_LIST = javaFieldLazyTableFieldEndpointList.stream().filter(field -> !currentColumnNameMap.containsKey(field.getColumnName().toLowerCase(Locale.ROOT))).map(convertedField -> String.format(ADD_FIELD, convertedField.getColumnName(), convertedField.getColumnType(), convertedField.getComment())).collect(Collectors.toList());
        ArrayList<String> modifySqlList = new ArrayList<String>();
        for (LazyTableFieldEndpoint fieldEndpoint : javaFieldLazyTableFieldEndpointList) {
            String currentColumnName = fieldEndpoint.getColumnName().replaceAll("`", "");
            if (!currentColumnNameMap.containsKey(currentColumnName)) continue;
            LazyTableFieldEndpoint mysqlFieldEndpoint = currentColumnNameMap.get(currentColumnName);
            String comment = fieldEndpoint.getComment();
            if (mysqlFieldEndpoint.isNotNull() == fieldEndpoint.isNotNull() && Objects.equals(mysqlFieldEndpoint.getDefaultValue(), fieldEndpoint.getDefaultValue()) && Objects.equals(mysqlFieldEndpoint.getComment(), comment) && fieldEndpoint.isKey() == mysqlFieldEndpoint.isKey() && Objects.equals(fieldEndpoint.getExtra(), mysqlFieldEndpoint.getExtra()) && Objects.equals(fieldEndpoint.getColumnType().replaceAll(" ", ""), mysqlFieldEndpoint.getColumnType().replaceAll(" ", ""))) continue;
            modifySqlList.add(fieldEndpoint.modifyColumnSQL());
        }
        if (dropColumn) {
            List finalJavaFieldLazyTableFieldEndpointList = javaFieldLazyTableFieldEndpointList;
            currentColumnNameList.stream().filter(lazyTableFieldEndpoint -> !finalJavaFieldLazyTableFieldEndpointList.stream().map(LazyTableFieldEndpoint::getColumnName).collect(Collectors.toList()).contains(lazyTableFieldEndpoint.getColumnName())).forEach(lazyTableFieldEndpoint -> modifySqlList.add(lazyTableFieldEndpoint.dropColumnSQL()));
        }
        if (!Objects.equals(currentColumnPkIndex = currentColumnNameList.stream().filter(LazyTableFieldEndpoint::isKey).map(LazyTableFieldEndpoint::getColumnName).collect(Collectors.joining("_")), javaColumnPkIndex = javaFieldLazyTableFieldEndpointList.stream().filter(LazyTableFieldEndpoint::isKey).map(LazyTableFieldEndpoint::getColumnName).collect(Collectors.joining("_")))) {
            if (currentColumnNameList.stream().anyMatch(LazyTableFieldEndpoint::isKey)) {
                modifySqlList.add("DROP PRIMARY KEY");
            }
            if (!ObjectUtils.isEmpty((Object)javaColumnPkIndex)) {
                String pk = javaFieldLazyTableFieldEndpointList.stream().filter(LazyTableFieldEndpoint::isKey).map(LazyTableFieldEndpoint::getColumnName).collect(Collectors.joining(","));
                modifySqlList.add(String.format("ADD PRIMARY KEY (%s) USING BTREE", pk));
            }
        }
        Map<LayerField.LayerFieldType, Map<String, List<LazyTableFieldEndpoint>>> currentLayerFieldTypeMap = this.getLayerFieldTypeMap(currentColumnNameList);
        Map<LayerField.LayerFieldType, Map<String, List<LazyTableFieldEndpoint>>> javaLayerFieldTypeMap = this.getLayerFieldTypeMap(javaFieldLazyTableFieldEndpointList);
        Map<String, List<LazyTableFieldEndpoint>> currentColumnUniqueIndex = currentLayerFieldTypeMap.get(LayerField.LayerFieldType.UNIQUE);
        Map<String, List<LazyTableFieldEndpoint>> javaColumnUniqueIndex = javaLayerFieldTypeMap.get(LayerField.LayerFieldType.UNIQUE);
        if (!ObjectUtils.isEmpty(javaColumnUniqueIndex)) {
            javaColumnUniqueIndex.forEach((indexName, lazyTableFieldEndpoints) -> {
                String string = indexName = ObjectUtils.isEmpty((Object)indexName) ? lazyTableFieldEndpoints.stream().map(lazyTableFieldEndpoint -> lazyTableFieldEndpoint.getColumnName().replaceAll("`", "").substring(0, 1)).collect(Collectors.joining("_")) : indexName;
                if (!ObjectUtils.isEmpty((Object)currentColumnUniqueIndex) && currentColumnUniqueIndex.containsKey(indexName)) {
                    List indexLazyTableFieldEndpoints = (List)currentColumnUniqueIndex.get(indexName);
                    ArrayList duplicateList = new ArrayList(lazyTableFieldEndpoints);
                    duplicateList.addAll(indexLazyTableFieldEndpoints);
                    ArrayList tableFieldEndpointArrayList = duplicateList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<LazyTableFieldEndpoint>(Comparator.comparing(LazyTableFieldEndpoint::getColumnName))), ArrayList::new));
                    if (!ObjectUtils.isEmpty((Object)tableFieldEndpointArrayList)) {
                        String indexColumns = lazyTableFieldEndpoints.stream().map(LazyTableFieldEndpoint::getColumnName).collect(Collectors.joining(","));
                        modifySqlList.add(String.format("DROP INDEX `%s`", indexName));
                        modifySqlList.add(String.format("ADD UNIQUE INDEX `%s` (%s)", indexName, indexColumns));
                    }
                } else {
                    String indexColumns = lazyTableFieldEndpoints.stream().map(LazyTableFieldEndpoint::getColumnName).collect(Collectors.joining(","));
                    modifySqlList.add(String.format("ADD UNIQUE INDEX `%s` (%s)", indexName, indexColumns));
                }
            });
        }
        Map<String, List<LazyTableFieldEndpoint>> currentColumnNormalIndex = currentLayerFieldTypeMap.get(LayerField.LayerFieldType.NORMAL);
        Map<String, List<LazyTableFieldEndpoint>> javaColumnNormalIndex = javaLayerFieldTypeMap.get(LayerField.LayerFieldType.NORMAL);
        if (!ObjectUtils.isEmpty(javaColumnNormalIndex)) {
            javaColumnNormalIndex.forEach((indexName, lazyTableFieldEndpoints) -> {
                String string = indexName = ObjectUtils.isEmpty((Object)indexName) ? lazyTableFieldEndpoints.stream().sorted(Comparator.comparing(LazyTableFieldEndpoint::getColumnName)).map(lazyTableFieldEndpoint -> lazyTableFieldEndpoint.getColumnName().replaceAll("`", "").substring(0, 1)).collect(Collectors.joining("_")) : indexName;
                if (!ObjectUtils.isEmpty((Object)currentColumnNormalIndex) && currentColumnNormalIndex.containsKey(indexName)) {
                    List indexLazyTableFieldEndpoints = (List)currentColumnNormalIndex.get(indexName);
                    ArrayList duplicateList = new ArrayList(lazyTableFieldEndpoints);
                    duplicateList.addAll(indexLazyTableFieldEndpoints);
                    ArrayList tableFieldEndpointArrayList = duplicateList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<LazyTableFieldEndpoint>(Comparator.comparing(LazyTableFieldEndpoint::getColumnName))), ArrayList::new));
                    if (!ObjectUtils.isEmpty((Object)tableFieldEndpointArrayList)) {
                        String indexColumns = lazyTableFieldEndpoints.stream().map(lazyTableFieldEndpoint -> "`" + lazyTableFieldEndpoint.getColumnName() + "`").collect(Collectors.joining(","));
                        modifySqlList.add(String.format("DROP INDEX `%s`", indexName));
                        modifySqlList.add(String.format("ADD  INDEX `%s` (%s)", indexName, indexColumns));
                    }
                } else {
                    String indexColumns = lazyTableFieldEndpoints.stream().map(LazyTableFieldEndpoint::getColumnName).collect(Collectors.joining(","));
                    modifySqlList.add(String.format("ADD  INDEX `%s` (%s)", indexName, indexColumns));
                }
            });
        }
        if (ObjectUtils.isEmpty(ADD_SQL_LIST) && ObjectUtils.isEmpty(modifySqlList)) {
            return modifySqlList;
        }
        modifySqlList.addAll(ADD_SQL_LIST);
        return modifySqlList;
    }

    @Override
    public List<String> alterTableColumnSQL(List<ClickHouseColumnEndpoint> currentColumnNameList, boolean dropColumn) {
        String ALTER_TABLE = "ALTER TABLE %s ";
        List<String> sql = this.alterTableColumnSQLPartList(currentColumnNameList, dropColumn);
        List<String> alterSQLList = sql.stream().filter(columnSql -> !ObjectUtils.isEmpty((Object)columnSql)).map(columnSql -> String.format(ALTER_TABLE, this.getFullTableName()) + columnSql).collect(Collectors.toList());
        return alterSQLList;
    }

    @Override
    public List<ClickHouseColumnEndpoint> specifiedFieldAnnotation(LayerField.LayerFieldType layerFieldType) {
        List<ClickHouseColumnEndpoint> lazyTableFieldEndpoints = new ArrayList<ClickHouseColumnEndpoint>();
        List<ClickHouseColumnEndpoint> fieldEndpoints = this.getLazyTableFieldEndpointList();
        if (ObjectUtils.isEmpty(fieldEndpoints)) {
            return lazyTableFieldEndpoints;
        }
        lazyTableFieldEndpoints = fieldEndpoints.stream().filter(lazyTableFieldEndpoint -> Arrays.stream(lazyTableFieldEndpoint.getLazyTableIndexEndpoints()).anyMatch(lazyTableIndexEndpoint -> lazyTableIndexEndpoint.getFieldIndexType().equals((Object)layerFieldType))).collect(Collectors.toList());
        return lazyTableFieldEndpoints;
    }

    @Override
    public ClickHouseColumnEndpoint createLazyTableFieldEndpointInstance() {
        return new ClickHouseColumnEndpoint();
    }

    @Generated
    public ClickHouseTableLazyTableEndpoint() {
    }

    @Override
    @Generated
    public List<ClickHouseColumnEndpoint> getLazyTableFieldEndpointList() {
        return this.lazyTableFieldEndpointList;
    }

    @Override
    @Generated
    public void setLazyTableFieldEndpointList(List<ClickHouseColumnEndpoint> lazyTableFieldEndpointList) {
        this.lazyTableFieldEndpointList = lazyTableFieldEndpointList;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClickHouseTableLazyTableEndpoint)) {
            return false;
        }
        ClickHouseTableLazyTableEndpoint other = (ClickHouseTableLazyTableEndpoint)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<ClickHouseColumnEndpoint> this$lazyTableFieldEndpointList = this.getLazyTableFieldEndpointList();
        List<ClickHouseColumnEndpoint> other$lazyTableFieldEndpointList = other.getLazyTableFieldEndpointList();
        return !(this$lazyTableFieldEndpointList == null ? other$lazyTableFieldEndpointList != null : !((Object)this$lazyTableFieldEndpointList).equals(other$lazyTableFieldEndpointList));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ClickHouseTableLazyTableEndpoint;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<ClickHouseColumnEndpoint> $lazyTableFieldEndpointList = this.getLazyTableFieldEndpointList();
        result = result * 59 + ($lazyTableFieldEndpointList == null ? 43 : ((Object)$lazyTableFieldEndpointList).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "ClickHouseTableLazyTableEndpoint(lazyTableFieldEndpointList=" + this.getLazyTableFieldEndpointList() + ")";
    }
}

