/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.orm.core.source.clickhouse;

import org.wu.framework.core.exception.AssertFactory;
import org.wu.framework.core.utils.ObjectUtils;
import org.wu.framework.lazy.orm.core.config.enums.LazyDataSourceType;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyColumn;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyColumnIndex;
import org.wu.framework.lazy.orm.core.persistence.conf.LazySchemata;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyTableInfo;
import org.wu.framework.lazy.orm.core.source.clickhouse.ClickHouseLazyColumn;
import org.wu.framework.lazy.orm.core.source.clickhouse.ClickHouseLazyColumnIndex;
import org.wu.framework.lazy.orm.core.source.clickhouse.ClickHouseLazySchemata;
import org.wu.framework.lazy.orm.core.source.clickhouse.ClickHouseLazyTableInfo;
import org.wu.framework.lazy.orm.core.source.clickhouse.ClickHouseSourceAdvancedTargetAbstract;

public class ClickHouseSourceAdvancedTarget
extends ClickHouseSourceAdvancedTargetAbstract {
    @Override
    public boolean support(LazyDataSourceType lazyDataSourceType) {
        return LazyDataSourceType.CLICK_HOUSE.equals((Object)lazyDataSourceType);
    }

    @Override
    public String getHost(String url) {
        AssertFactory.notNull((Object)url, (String)"\u6570\u636e\u5e93\u8fde\u63a5\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        int firstIndex = url.indexOf("//");
        int lastIndex = url.lastIndexOf("/");
        if (firstIndex == -1 || lastIndex == -1) {
            return null;
        }
        String substring = url.substring(firstIndex, lastIndex);
        substring = substring.replace("//", "");
        String[] split = substring.split(":");
        return split[0];
    }

    @Override
    public int getPort(String url) {
        AssertFactory.notNull((Object)url, (String)"\u6570\u636e\u5e93\u8fde\u63a5\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        String substring = url.substring(url.indexOf("//") + 2, url.lastIndexOf("/"));
        String split = substring.substring(substring.indexOf(":") + 1, !substring.contains("/") ? substring.length() : substring.indexOf("/"));
        return Integer.parseInt(split);
    }

    @Override
    public String getUrl(String host, int port, String schema) {
        if (ObjectUtils.isEmpty((Object)schema)) {
            schema = "system";
        }
        String urlFormat = "jdbc:clickhouse://%s:%s/%s?allowMultiQueries=true&useUnicode=true&autoReconnect=true&useAffectedRows=true&useSSL=false&serverTimezone=Asia/Shanghai&allowPublicKeyRetrieval=true&databaseTerm=SCHEMA";
        return String.format(urlFormat, host, port, schema);
    }

    @Override
    public String formatUrl(String url) {
        return url;
    }

    @Override
    public String getUrlSchema(String url) {
        AssertFactory.notNull((Object)url, (String)"\u6570\u636e\u5e93\u8fde\u63a5\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        String substring = url.substring(url.indexOf("//") + 2, url.lastIndexOf("?") == -1 ? url.length() : url.lastIndexOf("?"));
        String[] split = substring.split("/");
        return split[1];
    }

    @Override
    public String getDefaultInformationSchemaUrl(String url) {
        String host = this.getHost(url);
        int port = this.getPort(url);
        String urlFormat = "jdbc:clickhouse://%s:%s/%s";
        return String.format(urlFormat, host, port, "system");
    }

    @Override
    public LazyDataSourceType getLazyDataSourceType(String url) {
        if (ObjectUtils.isEmpty((Object)url)) {
            return null;
        }
        if (url.startsWith("jdbc:clickhouse:")) {
            return LazyDataSourceType.CLICK_HOUSE;
        }
        return null;
    }

    @Override
    public Class<? extends LazyTableInfo> findTableInfoClass() {
        return ClickHouseLazyTableInfo.class;
    }

    @Override
    public Class<? extends LazySchemata> findSchemaInfoClass() {
        return ClickHouseLazySchemata.class;
    }

    @Override
    public Class<? extends LazyColumn> findColumnInfoClass() {
        return ClickHouseLazyColumn.class;
    }

    @Override
    public Class<? extends LazyColumnIndex> findColumnIndexInfoClass() {
        return ClickHouseLazyColumnIndex.class;
    }
}

