/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.orm.core.source.adapter;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.wu.framework.lazy.orm.core.config.enums.LazyDataSourceType;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyColumn;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyColumnIndex;
import org.wu.framework.lazy.orm.core.persistence.conf.LazySchemata;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyTableEndpoint;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyTableFieldEndpoint;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyTableInfo;
import org.wu.framework.lazy.orm.core.source.advanced.SourceAdvanced;
import org.wu.framework.lazy.orm.core.source.clickhouse.ClickHouseSourceAdvancedTarget;
import org.wu.framework.lazy.orm.core.source.h2.H2SourceAdvancedTarget;
import org.wu.framework.lazy.orm.core.source.mysql.MySQLSourceAdvancedTarget;
import org.wu.framework.lazy.orm.core.source.postgresql.PostgresSQLSourceAdvancedTarget;
import org.wu.framework.lazy.orm.core.source.questdb.QuestDBSourceAdvancedTarget;
import org.wu.framework.lazy.orm.core.source.sqlite.SqliteSourceAdvancedTarget;
import org.wu.framework.lazy.orm.core.toolkit.DynamicLazyDataSourceTypeHolder;

public class SourceFactory {
    public static LazyDataSourceType defaultLazyDataSourceType = null;
    private static final List<SourceAdvanced> sourceAdvancedList = Arrays.asList(new MySQLSourceAdvancedTarget(), new ClickHouseSourceAdvancedTarget(), new PostgresSQLSourceAdvancedTarget(), new H2SourceAdvancedTarget(), new SqliteSourceAdvancedTarget(), new QuestDBSourceAdvancedTarget());

    public static String getUrl(LazyDataSourceType lazyDataSourceType, String host, int port) {
        return SourceFactory.getUrl(lazyDataSourceType, host, port, null);
    }

    public static String getUrl(LazyDataSourceType lazyDataSourceType, String host, int port, String schema) {
        for (SourceAdvanced sourceAdvanced : sourceAdvancedList) {
            if (!sourceAdvanced.support(lazyDataSourceType)) continue;
            return sourceAdvanced.getUrl(host, port, schema);
        }
        return null;
    }

    public static String formatUrl(String url) {
        LazyDataSourceType lazyDataSourceType = SourceFactory.getLazyDataSourceType(url);
        for (SourceAdvanced sourceAdvanced : sourceAdvancedList) {
            if (!sourceAdvanced.support(lazyDataSourceType)) continue;
            return sourceAdvanced.formatUrl(url);
        }
        return null;
    }

    public static String getHost(String url) {
        LazyDataSourceType lazyDataSourceType = SourceFactory.getLazyDataSourceType(url);
        for (SourceAdvanced sourceAdvanced : sourceAdvancedList) {
            if (!sourceAdvanced.support(lazyDataSourceType)) continue;
            return sourceAdvanced.getHost(url);
        }
        return null;
    }

    public static int getPort(String url) {
        LazyDataSourceType lazyDataSourceType = SourceFactory.getLazyDataSourceType(url);
        for (SourceAdvanced sourceAdvanced : sourceAdvancedList) {
            if (!sourceAdvanced.support(lazyDataSourceType)) continue;
            return sourceAdvanced.getPort(url);
        }
        return 0;
    }

    public static String getUrlSchema(String url) {
        LazyDataSourceType dataSourceType = SourceFactory.getLazyDataSourceType(url);
        for (SourceAdvanced sourceAdvanced : sourceAdvancedList) {
            if (!sourceAdvanced.support(dataSourceType)) continue;
            return sourceAdvanced.getUrlSchema(url);
        }
        throw new IllegalArgumentException("\u65e0\u6cd5\u89e3\u6790url\u4e2d\u7684schema:[" + url + "]");
    }

    public static LazyDataSourceType getLazyDataSourceType(String url) {
        for (SourceAdvanced sourceAdvanced : sourceAdvancedList) {
            LazyDataSourceType dataSourceType = sourceAdvanced.getLazyDataSourceType(url);
            if (null == dataSourceType) continue;
            return dataSourceType;
        }
        throw new IllegalArgumentException("\u65e0\u6cd5\u89e3\u6790url\u4e3a\u6307\u5b9a\u7c7b\u578b\u7684\u6570\u636e\u6e90\u7c7b\u578b:[" + url + "]");
    }

    public static String getDefaultInformationSchemaUrl(String url) {
        LazyDataSourceType lazyDataSourceType = SourceFactory.getLazyDataSourceType(url);
        for (SourceAdvanced sourceAdvanced : sourceAdvancedList) {
            if (!sourceAdvanced.support(lazyDataSourceType)) continue;
            return sourceAdvanced.getDefaultInformationSchemaUrl(url);
        }
        throw new IllegalArgumentException("\u65e0\u6cd5\u4eceurl\u4e2d\u89e3\u6790\u51fainformation_schema:[" + url + "]");
    }

    public static LazyTableEndpoint<?> analyzeLazyTableFromLazyColumns(LazyDataSourceType lazyDataSourceType, LazyTableInfo lazyTableInfo, List<? extends LazyColumn> lazyColumnList) {
        for (SourceAdvanced sourceAdvanced : sourceAdvancedList) {
            if (!sourceAdvanced.support(lazyDataSourceType)) continue;
            return sourceAdvanced.analyzeLazyTableFromLazyColumns(lazyTableInfo, lazyColumnList);
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u6570\u636e\u6e90\u7c7b\u578b:" + (Object)((Object)lazyDataSourceType));
    }

    public static LazyTableEndpoint<?> defaultAnalyzeLazyTableFromLazyColumns(LazyTableInfo lazyTableInfo, List<? extends LazyColumn> lazyColumnList) {
        LazyDataSourceType currentLazyDataSourceType;
        LazyDataSourceType lazyDataSourceType = currentLazyDataSourceType = DynamicLazyDataSourceTypeHolder.peek() == null ? defaultLazyDataSourceType : DynamicLazyDataSourceTypeHolder.peek();
        if (currentLazyDataSourceType == null) {
            throw new IllegalArgumentException("\u65e0\u6cd5\u89e3\u6790\u5f53\u524d\u6570\u636e\u6e90\u7c7b\u578b");
        }
        return SourceFactory.analyzeLazyTableFromLazyColumns(currentLazyDataSourceType, lazyTableInfo, lazyColumnList);
    }

    public static LazyTableEndpoint<?> analyzeLazyTableFromClass(LazyDataSourceType lazyDataSourceType, Class<?> clazz) {
        for (SourceAdvanced sourceAdvanced : sourceAdvancedList) {
            if (!sourceAdvanced.support(lazyDataSourceType)) continue;
            return sourceAdvanced.analyzeLazyTableFromClass(clazz);
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u6570\u636e\u6e90\u7c7b\u578b:" + (Object)((Object)lazyDataSourceType));
    }

    public static LazyTableEndpoint<?> defaultAnalyzeLazyTableFromClass(Class<?> clazz) {
        LazyDataSourceType currentLazyDataSourceType;
        LazyDataSourceType lazyDataSourceType = currentLazyDataSourceType = DynamicLazyDataSourceTypeHolder.peek() == null ? defaultLazyDataSourceType : DynamicLazyDataSourceTypeHolder.peek();
        if (currentLazyDataSourceType == null) {
            throw new IllegalArgumentException("\u65e0\u6cd5\u89e3\u6790\u5f53\u524d\u6570\u636e\u6e90\u7c7b\u578b");
        }
        return SourceFactory.analyzeLazyTableFromClass(currentLazyDataSourceType, clazz);
    }

    public static LazyTableEndpoint<?> analyzeLazyTableFromMap(LazyDataSourceType lazyDataSourceType, String schemaName, String tableName, Map<String, Object> beanData) {
        for (SourceAdvanced sourceAdvanced : sourceAdvancedList) {
            if (!sourceAdvanced.support(lazyDataSourceType)) continue;
            return sourceAdvanced.analyzeLazyTableFromMap(schemaName, tableName, beanData);
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u6570\u636e\u6e90\u7c7b\u578b:" + (Object)((Object)lazyDataSourceType));
    }

    public static LazyTableEndpoint defaultAnalyzeLazyTableFromMap(String schemaName, String tableName, Map<String, Object> beanData) {
        LazyDataSourceType currentLazyDataSourceType;
        LazyDataSourceType lazyDataSourceType = currentLazyDataSourceType = DynamicLazyDataSourceTypeHolder.peek() == null ? defaultLazyDataSourceType : DynamicLazyDataSourceTypeHolder.peek();
        if (currentLazyDataSourceType == null) {
            throw new IllegalArgumentException("\u65e0\u6cd5\u89e3\u6790\u5f53\u524d\u6570\u636e\u6e90\u7c7b\u578b");
        }
        return SourceFactory.analyzeLazyTableFromMap(currentLazyDataSourceType, schemaName, tableName, beanData);
    }

    public static LazyTableEndpoint defaultAnalyzeLazyTableFromMap(String tableName, Map<String, Object> beanData) {
        LazyDataSourceType currentLazyDataSourceType;
        LazyDataSourceType lazyDataSourceType = currentLazyDataSourceType = DynamicLazyDataSourceTypeHolder.peek() == null ? defaultLazyDataSourceType : DynamicLazyDataSourceTypeHolder.peek();
        if (currentLazyDataSourceType == null) {
            throw new IllegalArgumentException("\u65e0\u6cd5\u89e3\u6790\u5f53\u524d\u6570\u636e\u6e90\u7c7b\u578b");
        }
        return SourceFactory.analyzeLazyTableFromMap(currentLazyDataSourceType, null, tableName, beanData);
    }

    public static LazyTableFieldEndpoint getLazyTableFieldEndpointInstance(LazyDataSourceType lazyDataSourceType) {
        for (SourceAdvanced sourceAdvanced : sourceAdvancedList) {
            if (!sourceAdvanced.support(lazyDataSourceType)) continue;
            return sourceAdvanced.getLazyTableFieldEndpointInstance();
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u6570\u636e\u6e90\u7c7b\u578b:" + (Object)((Object)lazyDataSourceType));
    }

    public static LazyTableFieldEndpoint getDefaultLazyTableFieldEndpointInstance() {
        LazyDataSourceType currentLazyDataSourceType;
        LazyDataSourceType lazyDataSourceType = currentLazyDataSourceType = DynamicLazyDataSourceTypeHolder.peek() == null ? defaultLazyDataSourceType : DynamicLazyDataSourceTypeHolder.peek();
        if (currentLazyDataSourceType == null) {
            throw new IllegalArgumentException("\u65e0\u6cd5\u89e3\u6790\u5f53\u524d\u6570\u636e\u6e90\u7c7b\u578b");
        }
        return SourceFactory.getLazyTableFieldEndpointInstance(currentLazyDataSourceType);
    }

    public static LazyTableEndpoint<?> getLazyLazyTableEndpointInstance(LazyDataSourceType lazyDataSourceType) {
        for (SourceAdvanced sourceAdvanced : sourceAdvancedList) {
            if (!sourceAdvanced.support(lazyDataSourceType)) continue;
            return sourceAdvanced.getLazyTableEndpointInstance();
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u6570\u636e\u6e90\u7c7b\u578b:" + (Object)((Object)lazyDataSourceType));
    }

    public static LazyTableEndpoint<?> getDefaultLazyTableEndpointInstance() {
        LazyDataSourceType currentLazyDataSourceType;
        LazyDataSourceType lazyDataSourceType = currentLazyDataSourceType = DynamicLazyDataSourceTypeHolder.peek() == null ? defaultLazyDataSourceType : DynamicLazyDataSourceTypeHolder.peek();
        if (currentLazyDataSourceType == null) {
            throw new IllegalArgumentException("\u65e0\u6cd5\u89e3\u6790\u5f53\u524d\u6570\u636e\u6e90\u7c7b\u578b");
        }
        return SourceFactory.getLazyLazyTableEndpointInstance(currentLazyDataSourceType);
    }

    public static ConcurrentMap<Class<?>, LazyTableEndpoint<?>> getClassTableCache(LazyDataSourceType lazyDataSourceType) {
        for (SourceAdvanced sourceAdvanced : sourceAdvancedList) {
            if (!sourceAdvanced.support(lazyDataSourceType)) continue;
            return sourceAdvanced.getClassTableCache();
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u6570\u636e\u6e90\u7c7b\u578b:" + (Object)((Object)lazyDataSourceType));
    }

    public static ConcurrentMap<Class<?>, LazyTableEndpoint<?>> getClassTableCache() {
        LazyDataSourceType currentLazyDataSourceType;
        LazyDataSourceType lazyDataSourceType = currentLazyDataSourceType = DynamicLazyDataSourceTypeHolder.peek() == null ? defaultLazyDataSourceType : DynamicLazyDataSourceTypeHolder.peek();
        if (currentLazyDataSourceType == null) {
            throw new IllegalArgumentException("\u65e0\u6cd5\u89e3\u6790\u5f53\u524d\u6570\u636e\u6e90\u7c7b\u578b");
        }
        return SourceFactory.getClassTableCache(currentLazyDataSourceType);
    }

    public static ConcurrentMap<String, LazyTableEndpoint<?>> getMapTableCache(LazyDataSourceType lazyDataSourceType) {
        for (SourceAdvanced sourceAdvanced : sourceAdvancedList) {
            if (!sourceAdvanced.support(lazyDataSourceType)) continue;
            return sourceAdvanced.getMapTableCache();
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u6570\u636e\u6e90\u7c7b\u578b:" + (Object)((Object)lazyDataSourceType));
    }

    public static ConcurrentMap<String, LazyTableEndpoint<?>> getMapTableCache() {
        LazyDataSourceType currentLazyDataSourceType;
        LazyDataSourceType lazyDataSourceType = currentLazyDataSourceType = DynamicLazyDataSourceTypeHolder.peek() == null ? defaultLazyDataSourceType : DynamicLazyDataSourceTypeHolder.peek();
        if (currentLazyDataSourceType == null) {
            throw new IllegalArgumentException("\u65e0\u6cd5\u89e3\u6790\u5f53\u524d\u6570\u636e\u6e90\u7c7b\u578b");
        }
        return SourceFactory.getMapTableCache(currentLazyDataSourceType);
    }

    public static String cleanSpecialColumn(String column) {
        LazyDataSourceType currentLazyDataSourceType;
        LazyDataSourceType lazyDataSourceType = currentLazyDataSourceType = DynamicLazyDataSourceTypeHolder.peek() == null ? defaultLazyDataSourceType : DynamicLazyDataSourceTypeHolder.peek();
        if (currentLazyDataSourceType == null) {
            throw new IllegalArgumentException("\u65e0\u6cd5\u89e3\u6790\u5f53\u524d\u6570\u636e\u6e90\u7c7b\u578b");
        }
        return SourceFactory.cleanSpecialColumn(currentLazyDataSourceType, column);
    }

    public static String cleanSpecialColumn(LazyDataSourceType lazyDataSourceType, String column) {
        for (SourceAdvanced sourceAdvanced : sourceAdvancedList) {
            if (!sourceAdvanced.support(lazyDataSourceType)) continue;
            return sourceAdvanced.cleanSpecialColumn(column);
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u6570\u636e\u6e90\u7c7b\u578b:" + (Object)((Object)lazyDataSourceType));
    }

    public static String createSchemaSql(String schemaName) {
        LazyDataSourceType currentLazyDataSourceType;
        LazyDataSourceType lazyDataSourceType = currentLazyDataSourceType = DynamicLazyDataSourceTypeHolder.peek() == null ? defaultLazyDataSourceType : DynamicLazyDataSourceTypeHolder.peek();
        if (currentLazyDataSourceType == null) {
            throw new IllegalArgumentException("\u65e0\u6cd5\u89e3\u6790\u5f53\u524d\u6570\u636e\u6e90\u7c7b\u578b");
        }
        return SourceFactory.createSchemaSql(currentLazyDataSourceType, schemaName);
    }

    public static String createSchemaSql(LazyDataSourceType lazyDataSourceType, String schemaName) {
        for (SourceAdvanced sourceAdvanced : sourceAdvancedList) {
            if (!sourceAdvanced.support(lazyDataSourceType)) continue;
            return sourceAdvanced.createSchemaSql(schemaName);
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u6570\u636e\u6e90\u7c7b\u578b:" + (Object)((Object)lazyDataSourceType));
    }

    public static String findSchemaListSql() {
        LazyDataSourceType currentLazyDataSourceType;
        LazyDataSourceType lazyDataSourceType = currentLazyDataSourceType = DynamicLazyDataSourceTypeHolder.peek() == null ? defaultLazyDataSourceType : DynamicLazyDataSourceTypeHolder.peek();
        if (currentLazyDataSourceType == null) {
            throw new IllegalArgumentException("\u65e0\u6cd5\u89e3\u6790\u5f53\u524d\u6570\u636e\u6e90\u7c7b\u578b");
        }
        return SourceFactory.findSchemaListSql(currentLazyDataSourceType);
    }

    public static String findSchemaListSql(LazyDataSourceType lazyDataSourceType) {
        for (SourceAdvanced sourceAdvanced : sourceAdvancedList) {
            if (!sourceAdvanced.support(lazyDataSourceType)) continue;
            return sourceAdvanced.findSchemaListSql();
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u6570\u636e\u6e90\u7c7b\u578b:" + (Object)((Object)lazyDataSourceType));
    }

    public static String findTableColumnListSql(String schema, String table) {
        LazyDataSourceType currentLazyDataSourceType;
        LazyDataSourceType lazyDataSourceType = currentLazyDataSourceType = DynamicLazyDataSourceTypeHolder.peek() == null ? defaultLazyDataSourceType : DynamicLazyDataSourceTypeHolder.peek();
        if (currentLazyDataSourceType == null) {
            throw new IllegalArgumentException("\u65e0\u6cd5\u89e3\u6790\u5f53\u524d\u6570\u636e\u6e90\u7c7b\u578b");
        }
        return SourceFactory.findTableColumnListSql(currentLazyDataSourceType, schema, table);
    }

    public static String findTableColumnListSql(LazyDataSourceType lazyDataSourceType, String schema, String table) {
        for (SourceAdvanced sourceAdvanced : sourceAdvancedList) {
            if (!sourceAdvanced.support(lazyDataSourceType)) continue;
            return sourceAdvanced.findTableColumnListSql(schema, table);
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u6570\u636e\u6e90\u7c7b\u578b:" + (Object)((Object)lazyDataSourceType));
    }

    public static String findTableColumnIndexListSql(String schema, String table) {
        LazyDataSourceType currentLazyDataSourceType;
        LazyDataSourceType lazyDataSourceType = currentLazyDataSourceType = DynamicLazyDataSourceTypeHolder.peek() == null ? defaultLazyDataSourceType : DynamicLazyDataSourceTypeHolder.peek();
        if (currentLazyDataSourceType == null) {
            throw new IllegalArgumentException("\u65e0\u6cd5\u89e3\u6790\u5f53\u524d\u6570\u636e\u6e90\u7c7b\u578b");
        }
        return SourceFactory.findTableColumnIndexListSql(currentLazyDataSourceType, schema, table);
    }

    public static String findTableColumnIndexListSql(LazyDataSourceType lazyDataSourceType, String schema, String table) {
        for (SourceAdvanced sourceAdvanced : sourceAdvancedList) {
            if (!sourceAdvanced.support(lazyDataSourceType)) continue;
            return sourceAdvanced.findTableColumnIndexListSql(schema, table);
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u6570\u636e\u6e90\u7c7b\u578b:" + (Object)((Object)lazyDataSourceType));
    }

    public static String findTableInfoSql(String schema, String table) {
        LazyDataSourceType currentLazyDataSourceType;
        LazyDataSourceType lazyDataSourceType = currentLazyDataSourceType = DynamicLazyDataSourceTypeHolder.peek() == null ? defaultLazyDataSourceType : DynamicLazyDataSourceTypeHolder.peek();
        if (currentLazyDataSourceType == null) {
            throw new IllegalArgumentException("\u65e0\u6cd5\u89e3\u6790\u5f53\u524d\u6570\u636e\u6e90\u7c7b\u578b");
        }
        return SourceFactory.findTableInfoSql(currentLazyDataSourceType, schema, table);
    }

    public static String findTableInfoSql(LazyDataSourceType lazyDataSourceType, String schema, String table) {
        for (SourceAdvanced sourceAdvanced : sourceAdvancedList) {
            if (!sourceAdvanced.support(lazyDataSourceType)) continue;
            return sourceAdvanced.findTableInfoSql(schema, table);
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u6570\u636e\u6e90\u7c7b\u578b:" + (Object)((Object)lazyDataSourceType));
    }

    public static Class<? extends LazyTableInfo> findTableInfoClass() {
        LazyDataSourceType currentLazyDataSourceType;
        LazyDataSourceType lazyDataSourceType = currentLazyDataSourceType = DynamicLazyDataSourceTypeHolder.peek() == null ? defaultLazyDataSourceType : DynamicLazyDataSourceTypeHolder.peek();
        if (currentLazyDataSourceType == null) {
            throw new IllegalArgumentException("\u65e0\u6cd5\u89e3\u6790\u5f53\u524d\u6570\u636e\u6e90\u7c7b\u578b");
        }
        return SourceFactory.findTableInfoClass(currentLazyDataSourceType);
    }

    public static Class<? extends LazyTableInfo> findTableInfoClass(LazyDataSourceType lazyDataSourceType) {
        for (SourceAdvanced sourceAdvanced : sourceAdvancedList) {
            if (!sourceAdvanced.support(lazyDataSourceType)) continue;
            return sourceAdvanced.findTableInfoClass();
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u6570\u636e\u6e90\u7c7b\u578b:" + (Object)((Object)lazyDataSourceType));
    }

    public static Class<? extends LazySchemata> findSchemaInfoClass() {
        LazyDataSourceType currentLazyDataSourceType;
        LazyDataSourceType lazyDataSourceType = currentLazyDataSourceType = DynamicLazyDataSourceTypeHolder.peek() == null ? defaultLazyDataSourceType : DynamicLazyDataSourceTypeHolder.peek();
        if (currentLazyDataSourceType == null) {
            throw new IllegalArgumentException("\u65e0\u6cd5\u89e3\u6790\u5f53\u524d\u6570\u636e\u6e90\u7c7b\u578b");
        }
        return SourceFactory.findSchemaInfoClass(currentLazyDataSourceType);
    }

    public static Class<? extends LazySchemata> findSchemaInfoClass(LazyDataSourceType lazyDataSourceType) {
        for (SourceAdvanced sourceAdvanced : sourceAdvancedList) {
            if (!sourceAdvanced.support(lazyDataSourceType)) continue;
            return sourceAdvanced.findSchemaInfoClass();
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u6570\u636e\u6e90\u7c7b\u578b:" + (Object)((Object)lazyDataSourceType));
    }

    public static Class<? extends LazyColumn> findColumnInfoClass() {
        LazyDataSourceType currentLazyDataSourceType;
        LazyDataSourceType lazyDataSourceType = currentLazyDataSourceType = DynamicLazyDataSourceTypeHolder.peek() == null ? defaultLazyDataSourceType : DynamicLazyDataSourceTypeHolder.peek();
        if (currentLazyDataSourceType == null) {
            throw new IllegalArgumentException("\u65e0\u6cd5\u89e3\u6790\u5f53\u524d\u6570\u636e\u6e90\u7c7b\u578b");
        }
        return SourceFactory.findColumnInfoClass(currentLazyDataSourceType);
    }

    public static Class<? extends LazyColumn> findColumnInfoClass(LazyDataSourceType lazyDataSourceType) {
        for (SourceAdvanced sourceAdvanced : sourceAdvancedList) {
            if (!sourceAdvanced.support(lazyDataSourceType)) continue;
            return sourceAdvanced.findColumnInfoClass();
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u6570\u636e\u6e90\u7c7b\u578b:" + (Object)((Object)lazyDataSourceType));
    }

    public static Class<? extends LazyColumnIndex> findColumnIndexInfoClass() {
        LazyDataSourceType currentLazyDataSourceType;
        LazyDataSourceType lazyDataSourceType = currentLazyDataSourceType = DynamicLazyDataSourceTypeHolder.peek() == null ? defaultLazyDataSourceType : DynamicLazyDataSourceTypeHolder.peek();
        if (currentLazyDataSourceType == null) {
            throw new IllegalArgumentException("\u65e0\u6cd5\u89e3\u6790\u5f53\u524d\u6570\u636e\u6e90\u7c7b\u578b");
        }
        return SourceFactory.findColumnIndexInfoClass(currentLazyDataSourceType);
    }

    public static Class<? extends LazyColumnIndex> findColumnIndexInfoClass(LazyDataSourceType lazyDataSourceType) {
        for (SourceAdvanced sourceAdvanced : sourceAdvancedList) {
            if (!sourceAdvanced.support(lazyDataSourceType)) continue;
            return sourceAdvanced.findColumnIndexInfoClass();
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u6570\u636e\u6e90\u7c7b\u578b:" + (Object)((Object)lazyDataSourceType));
    }
}

