/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.orm.core.persistence.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import org.wu.framework.core.utils.BinHexSwitchUtil;
import org.wu.framework.core.utils.JsonUtils;
import org.wu.framework.core.utils.ObjectUtils;
import org.wu.framework.lazy.orm.core.config.enums.RowValueType;

public final class LazySQLUtil {
    public static Object valueToSqlValue(Object fieldValue, RowValueType rowValueType) {
        if (RowValueType.STRING.equals((Object)rowValueType)) {
            return LazySQLUtil.valueToSqlValue(fieldValue, "'%s'");
        }
        return LazySQLUtil.valueToSqlValue(fieldValue, "%s");
    }

    public static Object valueToSqlValue(Object fieldValue) {
        if (ObjectUtils.isNotEmpty((Object)fieldValue)) {
            if (fieldValue.toString().startsWith("'")) {
                return fieldValue;
            }
            return LazySQLUtil.valueToSqlValue(fieldValue, "'%s'");
        }
        return null;
    }

    public static Object valueToSqlValue(Object fieldValue, String placeholder) {
        if (ObjectUtils.isEmpty((Object)fieldValue)) {
            return null;
        }
        Class<Object> fieldValueClass = fieldValue.getClass();
        byte[] binary = LazySQLUtil.isBinary(fieldValue);
        if (!ObjectUtils.isEmpty((Object)binary)) {
            return BinHexSwitchUtil.bytesToHexSql((byte[])binary);
        }
        if (fieldValueClass.isAssignableFrom(Boolean.class)) {
            return fieldValue;
        }
        if (fieldValueClass.isAssignableFrom(Boolean.TYPE)) {
            return fieldValue;
        }
        if (fieldValueClass.isAssignableFrom(Long.class)) {
            return fieldValue;
        }
        if (fieldValueClass.isAssignableFrom(Long.TYPE)) {
            return fieldValue;
        }
        if (fieldValueClass.isAssignableFrom(Integer.class)) {
            return fieldValue;
        }
        if (fieldValueClass.isAssignableFrom(Integer.TYPE)) {
            return fieldValue;
        }
        if (fieldValueClass.isEnum()) {
            return String.format(placeholder, ((Enum)fieldValue).name());
        }
        if (fieldValueClass.isAssignableFrom(String.class) || fieldValueClass.isAssignableFrom(Double.class) || fieldValueClass.isAssignableFrom(Double.TYPE) || fieldValueClass.isAssignableFrom(Short.TYPE) || fieldValueClass.isAssignableFrom(Short.class) || fieldValueClass.isAssignableFrom(Float.class) || fieldValueClass.isAssignableFrom(Float.TYPE) || fieldValueClass.isAssignableFrom(BigDecimal.class) || fieldValueClass.isEnum()) {
            return String.format(placeholder, fieldValue.toString().replaceAll("'", "\"").replaceAll("\\\\", "\\\\\\\\"));
        }
        if (java.util.Date.class.isAssignableFrom(fieldValueClass)) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return String.format(placeholder, simpleDateFormat.format(fieldValue));
        }
        if (Date.class.isAssignableFrom(fieldValueClass)) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return String.format(placeholder, simpleDateFormat.format(fieldValue));
        }
        if (LocalDateTime.class.isAssignableFrom(fieldValueClass)) {
            return String.format(placeholder, ((LocalDateTime)fieldValue).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        }
        if (LocalDate.class.isAssignableFrom(fieldValueClass)) {
            return String.format(placeholder, ((LocalDate)fieldValue).format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        }
        if (LocalTime.class.isAssignableFrom(fieldValueClass)) {
            return String.format(placeholder, ((LocalTime)fieldValue).format(DateTimeFormatter.ofPattern("HH:mm:ss")));
        }
        if (Collection.class.isAssignableFrom(fieldValueClass)) {
            return LazySQLUtil.sqlValue(JsonUtils.toJsonString((Object)fieldValue), true);
        }
        return LazySQLUtil.sqlValue(JsonUtils.toJsonString((Object)fieldValue), true);
    }

    public static byte[] isBinary(Object fieldValue) {
        try {
            if (fieldValue == null) {
                return null;
            }
            if (File.class.equals(fieldValue.getClass())) {
                FileInputStream fileInputStream = new FileInputStream((File)fieldValue);
                return BinHexSwitchUtil.readBytes((InputStream)fileInputStream);
            }
            if (InputStream.class.isAssignableFrom(fieldValue.getClass())) {
                return BinHexSwitchUtil.readBytes((InputStream)((InputStream)fieldValue));
            }
            if (Byte[].class.isAssignableFrom(fieldValue.getClass())) {
                return (byte[])fieldValue;
            }
            if (byte[].class.isAssignableFrom(fieldValue.getClass())) {
                return (byte[])fieldValue;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Deprecated
    public static Object sqlValue(Object rowValue) {
        return LazySQLUtil.sqlValue(rowValue, true);
    }

    @Deprecated
    public static Object sqlValue(Object rowValue, boolean hasComma) {
        if (null == rowValue) {
            return " " + rowValue;
        }
        Class<?> rowValueClass = rowValue.getClass();
        if (String.class.isAssignableFrom(rowValueClass) || Enum.class.isAssignableFrom(rowValueClass)) {
            return " " + (hasComma ? "'" + rowValue + "'" : rowValue) + " ";
        }
        if (Boolean.class.isAssignableFrom(rowValueClass) || Boolean.TYPE.isAssignableFrom(rowValueClass)) {
            return " " + rowValue;
        }
        if (java.util.Date.class.isAssignableFrom(rowValueClass) || Date.class.isAssignableFrom(rowValueClass)) {
            return " " + (hasComma ? "'" + rowValue + "'" : rowValue) + " ";
        }
        if (Integer.TYPE.isAssignableFrom(rowValueClass) || Integer.class.isAssignableFrom(rowValueClass) || Long.class.isAssignableFrom(rowValueClass) || Long.class.isAssignableFrom(rowValueClass) || Double.class.isAssignableFrom(rowValueClass) || Double.TYPE.isAssignableFrom(rowValueClass) || Float.class.isAssignableFrom(rowValueClass) || Float.TYPE.isAssignableFrom(rowValueClass)) {
            return " " + rowValue;
        }
        return " " + rowValue;
    }
}

