/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.orm.core.persistence.reverse.lazy.mvc;

import java.util.List;
import lombok.Data;
import org.wu.framework.core.stereotype.LayerField;
import org.wu.framework.core.utils.ObjectUtils;
import org.wu.framework.lazy.orm.core.config.ReverseEngineering;
import org.wu.framework.lazy.orm.core.config.enums.OrmArchitecture;
import org.wu.framework.lazy.orm.core.persistence.reverse.ReverseClassLazyTableEndpoint;
import org.wu.framework.lazy.orm.core.persistence.reverse.lazy.DefaultAbstractJavaReverseEngineeringMethod;
import org.wu.framework.lazy.orm.core.stereotype.LazyTable;
import org.wu.framework.lazy.orm.core.stereotype.LazyTableField;
import org.wu.framework.lazy.orm.core.stereotype.LazyTableIndex;

public class DefaultMVCLazyEntity
extends DefaultAbstractJavaReverseEngineeringMethod {
    public DefaultMVCLazyEntity(ReverseClassLazyTableEndpoint reverseClassLazyTableEndpoint, ReverseEngineering reverseEngineering) {
        super(reverseClassLazyTableEndpoint, reverseEngineering);
    }

    @Override
    public void initImportClassName() {
        ReverseEngineering reverseEngineering = this.getReverseEngineering();
        ReverseClassLazyTableEndpoint tableEndpoint = this.getReverseClassLazyTableEndpoint();
        List<String> importClass = this.getImportClassNames();
        List<String> classAnnotation = this.getClassAnnotationParts();
        if (reverseEngineering.isEnableLombokData()) {
            classAnnotation.add("@Data");
            importClass.add(Data.class.getName());
        }
        if (reverseEngineering.isEnableLombokAccessors()) {
            classAnnotation.add("@Accessors(chain = true)");
            importClass.add("lombok.experimental.Accessors");
        }
        if (OrmArchitecture.MYBATIS.equals((Object)reverseEngineering.getOrmArchitecture())) {
            if (reverseEngineering.isEnableSchema()) {
                classAnnotation.add(String.format("@TableName(value = \"%s\",schema = \"%s\")", tableEndpoint.getTableName(), tableEndpoint.getSchema()));
            } else {
                classAnnotation.add(String.format("@TableName(value = \"%s\")", tableEndpoint.getTableName()));
            }
            importClass.add("com.baomidou.mybatisplus.annotation.TableName");
        }
        if (OrmArchitecture.LAZY.equals((Object)reverseEngineering.getOrmArchitecture())) {
            if (reverseEngineering.isEnableSchema()) {
                classAnnotation.add(String.format("@LazyTable(tableName = \"%s\",schema = \"%s\",comment = \"%s\")", tableEndpoint.getTableName(), tableEndpoint.getSchema(), tableEndpoint.getComment()));
            } else {
                classAnnotation.add(String.format("@LazyTable(tableName = \"%s\",comment = \"%s\")", tableEndpoint.getTableName(), tableEndpoint.getComment()));
            }
            if (tableEndpoint.getOutLazyTableFieldEndpoints().stream().anyMatch(lazyTableFieldEndpoint -> ObjectUtils.isEmpty((Object)lazyTableFieldEndpoint.getLazyTableIndexEndpoints()))) {
                importClass.add(LazyTableIndex.class.getName());
                importClass.add(LayerField.LayerFieldType.class.getName().replace("$", "."));
            }
            importClass.add(LazyTable.class.getName());
            importClass.add(LayerField.class.getName());
            importClass.add(LazyTableField.class.getName());
        }
        if (OrmArchitecture.JPA.equals((Object)reverseEngineering.getOrmArchitecture())) {
            if (reverseEngineering.isEnableSchema()) {
                classAnnotation.add(String.format("@Table(name = \"%s\",schema = \"%s\")", tableEndpoint.getTableName(), tableEndpoint.getSchema()));
            } else {
                classAnnotation.add(String.format("@Table(name = \"%s\")", tableEndpoint.getTableName()));
            }
            classAnnotation.add("@Entity");
            importClass.add("jakarta.persistence.Entity");
            importClass.add("jakarta.persistence.Table");
        }
        if (reverseEngineering.isEnableSwagger()) {
            classAnnotation.add(String.format("@Schema(title = \"%s\",description = \"%s\")", tableEndpoint.getTableName(), tableEndpoint.getComment()));
            importClass.add("io.swagger.v3.oas.annotations.media.Schema");
            importClass.add("io.swagger.v3.oas.annotations.media.Schema");
        }
    }

    @Override
    public void initClassAnnotationPart() {
        super.initClassAnnotationPart();
    }

    @Override
    public void initClassNamePart() {
        ReverseClassLazyTableEndpoint tableEndpoint = this.getReverseClassLazyTableEndpoint();
        String className = tableEndpoint.getClassName();
        this.setFileName(className);
        String classnamePart = String.format("public class %s {", className) + "\n";
        this.addClassNamePart(classnamePart);
        super.initClassNamePart();
    }

    @Override
    protected String getModuleType() {
        return "entity";
    }
}

