/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.orm.core.persistence.reverse.lazy.feign;

import java.util.Arrays;
import org.wu.framework.core.CamelAndUnderLineConverter;
import org.wu.framework.lazy.orm.core.config.ReverseEngineering;
import org.wu.framework.lazy.orm.core.persistence.reverse.ParamDescribeList;
import org.wu.framework.lazy.orm.core.persistence.reverse.ReverseClassLazyTableEndpoint;
import org.wu.framework.lazy.orm.core.persistence.reverse.lazy.DefaultAbstractJavaReverseEngineeringMethod;
import org.wu.framework.translation.data.JavaKeyword;

public class DefaultFeignLazyApi
extends DefaultAbstractJavaReverseEngineeringMethod {
    public DefaultFeignLazyApi(ReverseClassLazyTableEndpoint reverseClassLazyTableEndpoint, ReverseEngineering reverseEngineering) {
        super(reverseClassLazyTableEndpoint, reverseEngineering);
    }

    @Override
    public void initImportClassName() {
        this.addImportClassName("org.springframework.cloud.openfeign.FeignClient");
        this.addImportClassName("org.springframework.web.bind.annotation.GetMapping");
        this.addImportClassName("org.springframework.web.bind.annotation.PostMapping");
        this.addImportClassName("org.springframework.web.bind.annotation.RequestBody");
        this.addImportClassName("org.springframework.web.bind.annotation.RequestParam");
        if (this.getReverseEngineering().isEnableSwagger()) {
            this.addImportClassName("io.swagger.v3.oas.annotations.tags.Tag");
            this.addImportClassName("io.swagger.v3.oas.annotations.Operation");
            this.addImportClassName("io.swagger.v3.oas.annotations.Parameter");
        }
        if (this.getReverseEngineering().isEnableNormalCrud()) {
            this.addImportClassName("org.springframework.web.bind.annotation.*");
            this.addImportClassName("org.wu.framework.web.response.Result");
            this.addImportClassName("org.wu.framework.web.response.ResultFactory");
            this.addImportClassName(this.getReverseClassLazyTableEndpoint().getPackageName() + "." + "command" + "." + this.humpToDOT() + "." + this.getReverseClassLazyTableEndpoint().getClassName() + "APICommand");
            this.addImportClassName(this.getReverseClassLazyTableEndpoint().getPackageName() + "." + "dto" + "." + this.humpToDOT() + "." + this.getReverseClassLazyTableEndpoint().getClassName() + "APIDTO");
            this.addImportClassName("java.util.List");
        }
    }

    @Override
    public void initClassAnnotationPart() {
        String serverName = "default-feign-server-provider";
        String className = this.getReverseClassLazyTableEndpoint().getClassName();
        this.addClassAnnotationPart(String.format("@FeignClient(contextId = \"%sApi\", name = \"%s\", url = \"${feign.url.%s: }\")", className, serverName, serverName));
        if (this.getReverseEngineering().isEnableSwagger()) {
            this.addClassAnnotationPart(String.format("@Tag(name = \"%sFeign\u63d0\u4f9b\u8005\")", this.getReverseClassLazyTableEndpoint().getComment() != null ? this.getReverseClassLazyTableEndpoint().getComment() : this.getReverseClassLazyTableEndpoint().getClassName()));
        }
        super.initClassAnnotationPart();
    }

    @Override
    public void initClassNamePart() {
        String apiName = this.getReverseClassLazyTableEndpoint().getClassName() + "Api";
        this.setFileName(apiName);
        this.addClassNamePart(String.format("public interface %s  {\n", apiName) + "\n");
        super.initClassNamePart();
    }

    @Override
    public void initClassMethodPart() {
        if (this.getReverseEngineering().isEnableNormalCrud()) {
            String lowercaseFirstLetter;
            String comment = this.getReverseClassLazyTableEndpoint().getComment();
            String className = this.getReverseClassLazyTableEndpoint().getClassName();
            String methodParamName = lowercaseFirstLetter = CamelAndUnderLineConverter.lowercaseFirstLetter((String)className);
            if (Arrays.stream(JavaKeyword.values()).anyMatch(javaKeyword -> javaKeyword.name().toLowerCase().equals(lowercaseFirstLetter))) {
                methodParamName = methodParamName + "_";
            }
            String saveMethodDescribe = this.generateMethodDescribe("\u65b0\u589e" + comment, ParamDescribeList.of().param(String.format("%sAPICommand", methodParamName), "\u65b0\u589e" + comment + "\u53c2\u6570").returnParam(String.format("Result<%sAPICommand>", className), "\u8fd4\u56de\u7ed3\u679c"));
            this.addClassMethodPart(saveMethodDescribe);
            if (this.getReverseEngineering().isEnableSwagger()) {
                this.addClassMethodPart(String.format("    @Operation(summary = \"\u65b0\u589e%s\")", comment));
            }
            this.addClassMethodPart("    @PostMapping(\"/story\")");
            this.addClassMethodPart(String.format("     Result<%sAPICommand> story(@RequestBody %sAPICommand %sAPICommand);", className, className, methodParamName));
            this.addClassMethodPart(this.generateMethodDescribe("\u6279\u91cf\u65b0\u589e" + comment, ParamDescribeList.of().param(String.format("%sAPICommandList", methodParamName), "\u6279\u91cf\u65b0\u589e" + comment + "\u53c2\u6570").returnParam(String.format("Result<List<%sAPICommand>>", className), "\u8fd4\u56de\u7ed3\u679c")));
            if (this.getReverseEngineering().isEnableSwagger()) {
                this.addClassMethodPart(String.format("    @Operation(summary = \"\u6279\u91cf\u65b0\u589e%s\")", comment));
            }
            this.addClassMethodPart("    @PostMapping(\"/batchStory\")");
            this.addClassMethodPart(String.format("     Result<List<%sAPICommand>> batchStory(@RequestBody List<%sAPICommand> %sAPICommandList);", className, className, methodParamName));
            String updateMethodDescribe = this.generateMethodDescribe("\u66f4\u65b0" + comment, ParamDescribeList.of().param(String.format("%sAPICommand", methodParamName), "\u66f4\u65b0" + comment + "\u53c2\u6570").returnParam(String.format("Result<%sAPICommand>", className), "\u8fd4\u56de\u7ed3\u679c"));
            this.addClassMethodPart(updateMethodDescribe);
            if (this.getReverseEngineering().isEnableSwagger()) {
                this.addClassMethodPart(String.format("    @Operation(summary = \"\u66f4\u65b0%s\")", comment));
            }
            this.addClassMethodPart("    @PutMapping(\"/updateOne\")");
            this.addClassMethodPart(String.format("     Result<%sAPICommand> updateOne(@RequestBody %sAPICommand %sAPICommand);", className, className, methodParamName));
            String findOneMethodDescribe = this.generateMethodDescribe("\u67e5\u8be2\u5355\u4e2a" + comment, ParamDescribeList.of().param(String.format("%sAPICommand", methodParamName), "\u67e5\u8be2\u5355\u4e2a" + comment + "\u53c2\u6570").returnParam(String.format("Result<%sAPIDTO>", className), "\u8fd4\u56de\u7ed3\u679c"));
            this.addClassMethodPart(findOneMethodDescribe);
            if (this.getReverseEngineering().isEnableSwagger()) {
                this.addClassMethodPart(String.format("    @Operation(summary = \"\u67e5\u8be2\u5355\u4e2a%s\")", comment));
            }
            this.addClassMethodPart("    @GetMapping(\"/findOne\")");
            this.addClassMethodPart(String.format("     Result<%sAPIDTO> findOne(@ModelAttribute %sAPICommand %sAPICommand);", className, className, methodParamName));
            String findListMethodDescribe = this.generateMethodDescribe("\u67e5\u8be2\u591a\u4e2a" + comment, ParamDescribeList.of().param(String.format("%sAPICommand", methodParamName), "\u67e5\u8be2\u591a\u4e2a" + comment + "\u53c2\u6570").returnParam(String.format("Result<List<%sAPIDTO>>", className), "\u8fd4\u56de\u7ed3\u679c"));
            this.addClassMethodPart(findListMethodDescribe);
            if (this.getReverseEngineering().isEnableSwagger()) {
                this.addClassMethodPart(String.format("    @Operation(summary = \"\u67e5\u8be2\u591a\u4e2a%s\")", comment));
            }
            this.addClassMethodPart("    @GetMapping(\"/findList\")");
            this.addClassMethodPart(String.format("     Result<List<%sAPIDTO>> findList(@ModelAttribute %sAPICommand %sAPICommand);", className, className, methodParamName));
            String deleteMethodDescribe = this.generateMethodDescribe("\u5220\u9664" + comment, ParamDescribeList.of().param(String.format("%sAPICommand", methodParamName), "\u5220\u9664" + comment + "\u53c2\u6570").returnParam(String.format("Result<%sAPICommand>", className), "\u8fd4\u56de\u7ed3\u679c"));
            this.addClassMethodPart(deleteMethodDescribe);
            this.addClassMethodPart(String.format("    @Operation(summary = \"\u5220\u9664%s\")", comment));
            this.addClassMethodPart("    @DeleteMapping(\"/remove\")");
            this.addClassMethodPart(String.format("     Result<%sAPICommand> remove(@ModelAttribute %sAPICommand %sAPICommand);", className, className, methodParamName));
        }
    }

    @Override
    public void initClassFieldPart() {
    }

    @Override
    protected String getModuleType() {
        return "api";
    }
}

