/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.orm.core.persistence.reverse.lazy.feign;

import java.io.File;
import java.util.List;
import lombok.Data;
import org.wu.framework.lazy.orm.core.config.ReverseEngineering;
import org.wu.framework.lazy.orm.core.config.enums.MysqlColumnTypeEnum;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyTableFieldEndpoint;
import org.wu.framework.lazy.orm.core.persistence.reverse.ReverseClassLazyTableEndpoint;
import org.wu.framework.lazy.orm.core.persistence.reverse.lazy.DefaultAbstractJavaReverseEngineeringMethod;

public class DefaultFeignLazyAPICommand
extends DefaultAbstractJavaReverseEngineeringMethod {
    public DefaultFeignLazyAPICommand(ReverseClassLazyTableEndpoint reverseClassLazyTableEndpoint, ReverseEngineering reverseEngineering) {
        super(reverseClassLazyTableEndpoint, reverseEngineering);
    }

    @Override
    public void initImportClassName() {
        ReverseEngineering reverseEngineering = this.getReverseEngineering();
        ReverseClassLazyTableEndpoint tableEndpoint = this.getReverseClassLazyTableEndpoint();
        List<String> importClass = this.getImportClassNames();
        List<String> classAnnotation = this.getClassAnnotationParts();
        if (reverseEngineering.isEnableLombokData()) {
            classAnnotation.add("@Data");
            importClass.add(Data.class.getName());
        }
        if (reverseEngineering.isEnableLombokAccessors()) {
            classAnnotation.add("@Accessors(chain = true)");
            importClass.add("lombok.experimental.Accessors");
        }
        if (reverseEngineering.isEnableSwagger()) {
            classAnnotation.add(String.format("@Schema(title = \"%s\",description = \"%s\")", tableEndpoint.getTableName(), tableEndpoint.getComment()));
            importClass.add("io.swagger.v3.oas.annotations.media.Schema");
            importClass.add("io.swagger.v3.oas.annotations.media.Schema");
        }
    }

    @Override
    public void initClassAnnotationPart() {
    }

    @Override
    public void initClassNamePart() {
        ReverseClassLazyTableEndpoint tableEndpoint = this.getReverseClassLazyTableEndpoint();
        String className = tableEndpoint.getClassName();
        className = className + "APICommand";
        this.setFileName(className);
        String classnamePart = String.format("public class %s {", className) + "\n";
        this.addClassNamePart(classnamePart);
        super.initClassNamePart();
    }

    @Override
    public void initClassFieldPart() {
        ReverseEngineering reverseEngineering = this.getReverseEngineering();
        ReverseClassLazyTableEndpoint tableEndpoint = this.getReverseClassLazyTableEndpoint();
        List<LazyTableFieldEndpoint> fieldEndpoints = tableEndpoint.getOutLazyTableFieldEndpoints();
        fieldEndpoints.forEach(fieldLazyTableFieldEndpoint -> {
            String comment = fieldLazyTableFieldEndpoint.getComment();
            String commentFormat = "\n" + String.format("    /**\n     * \n     * %s\n     */\n", comment);
            MysqlColumnTypeEnum mysqlColumnTypeEnum = MysqlColumnTypeEnum.MYSQL_COLUMN_TYPE_ENUM_MAP.getOrDefault(fieldLazyTableFieldEndpoint.getDataType(), MysqlColumnTypeEnum.VARCHAR);
            String format = String.format("    private %s %s;", mysqlColumnTypeEnum.getJavaType().getSimpleName(), fieldLazyTableFieldEndpoint.getName());
            String apiModelPropertyAnnotation = "";
            if (reverseEngineering.isEnableSwagger()) {
                apiModelPropertyAnnotation = String.format("    @Schema(description =\"%s\",name =\"%s\",example = \"%s\")", fieldLazyTableFieldEndpoint.getComment(), fieldLazyTableFieldEndpoint.getName(), "") + "\n";
            }
            String lazyTableFieldAnnotation = "";
            this.addImportClassName(mysqlColumnTypeEnum.getJavaType().getName());
            this.addClassFieldPart(commentFormat + apiModelPropertyAnnotation + lazyTableFieldAnnotation + format);
        });
    }

    @Override
    protected String getPackage() {
        return String.format("package %s;", this.getReverseClassLazyTableEndpoint().getPackageName() + "." + "api.command") + "\n" + "\n";
    }

    @Override
    protected String getModuleType() {
        return "api" + File.separator + "command";
    }
}

