/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.orm.core.persistence.reverse.lazy.ddd;

import com.fasterxml.jackson.annotation.JsonFormat;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import lombok.Data;
import org.wu.framework.lazy.orm.core.config.ReverseEngineering;
import org.wu.framework.lazy.orm.core.config.enums.MysqlColumnTypeEnum;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyTableFieldEndpoint;
import org.wu.framework.lazy.orm.core.persistence.reverse.ReverseClassLazyTableEndpoint;
import org.wu.framework.lazy.orm.core.persistence.reverse.lazy.DefaultAbstractJavaReverseEngineeringMethod;

public class DefaultDDDLazyQueryOneCommand
extends DefaultAbstractJavaReverseEngineeringMethod {
    public DefaultDDDLazyQueryOneCommand(ReverseClassLazyTableEndpoint reverseClassLazyTableEndpoint, ReverseEngineering reverseEngineering) {
        super(reverseClassLazyTableEndpoint, reverseEngineering);
    }

    @Override
    public void initImportClassName() {
        ReverseEngineering reverseEngineering = this.getReverseEngineering();
        List<String> importClass = this.getImportClassNames();
        List<String> classAnnotation = this.getClassAnnotationParts();
        if (reverseEngineering.isEnableLombokData()) {
            classAnnotation.add("@Data");
            importClass.add(Data.class.getName());
        }
        if (reverseEngineering.isEnableLombokAccessors()) {
            importClass.add("lombok.experimental.Accessors");
        }
        if (reverseEngineering.isEnableSwagger()) {
            this.addImportClassName("io.swagger.v3.oas.annotations.media.Schema");
        }
        importClass.add(JsonFormat.class.getName());
    }

    @Override
    public void initClassAnnotationPart() {
        ReverseEngineering reverseEngineering = this.getReverseEngineering();
        ReverseClassLazyTableEndpoint tableEndpoint = this.getReverseClassLazyTableEndpoint();
        if (reverseEngineering.isEnableLombokAccessors()) {
            this.addClassAnnotationPart("@Accessors(chain = true)");
        }
        if (reverseEngineering.isEnableSwagger()) {
            this.addClassAnnotationPart(String.format("@Schema(title = \"%s\",description = \"%s\")", tableEndpoint.getTableName() + "_query_one_command", tableEndpoint.getComment()));
        }
    }

    @Override
    public void initClassNamePart() {
        ReverseClassLazyTableEndpoint tableEndpoint = this.getReverseClassLazyTableEndpoint();
        String commandName = String.format("%sQueryOneCommand", tableEndpoint.getClassName());
        this.setFileName(commandName);
        this.addClassNamePart(String.format("public class %s {\n", commandName) + "\n");
    }

    @Override
    protected String getPackage() {
        ReverseClassLazyTableEndpoint tableEndpoint = this.getReverseClassLazyTableEndpoint();
        return String.format("package %s;", tableEndpoint.getPackageName() + "." + "application" + "." + "command" + "." + this.humpToDOT()) + "\n" + "\n";
    }

    @Override
    public void initClassFieldPart() {
        ReverseEngineering reverseEngineering = this.getReverseEngineering();
        ReverseClassLazyTableEndpoint tableEndpoint = this.getReverseClassLazyTableEndpoint();
        List<LazyTableFieldEndpoint> fieldEndpoints = tableEndpoint.getInLazyTableFieldEndpoints();
        fieldEndpoints.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<LazyTableFieldEndpoint>(Comparator.comparing(LazyTableFieldEndpoint::getName))), ArrayList::new)).forEach(fieldLazyTableFieldEndpoint -> {
            String comment = fieldLazyTableFieldEndpoint.getComment();
            String commentFormat = "\n" + String.format("    /**\n     * \n     * %s\n     */\n", comment);
            MysqlColumnTypeEnum mysqlColumnTypeEnum = MysqlColumnTypeEnum.MYSQL_COLUMN_TYPE_ENUM_MAP.getOrDefault(fieldLazyTableFieldEndpoint.getDataType(), MysqlColumnTypeEnum.VARCHAR);
            String format = String.format("    private %s %s;", mysqlColumnTypeEnum.getJavaType().getSimpleName(), fieldLazyTableFieldEndpoint.getName());
            String apiModelPropertyAnnotation = "";
            if (reverseEngineering.isEnableSwagger()) {
                apiModelPropertyAnnotation = String.format("    @Schema(description =\"%s\",name =\"%s\",example = \"%s\")", fieldLazyTableFieldEndpoint.getComment(), fieldLazyTableFieldEndpoint.getName(), "") + "\n";
            }
            String lazyTableFieldAnnotation = "";
            this.addImportClassName(mysqlColumnTypeEnum.getJavaType().getName());
            this.addClassFieldPart(commentFormat + apiModelPropertyAnnotation + lazyTableFieldAnnotation + format);
        });
    }

    @Override
    protected String getModuleType() {
        return "application" + File.separator + "command" + File.separator + this.humpToSeparator();
    }
}

