/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.orm.core.persistence.reverse.lazy.ddd;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.wu.framework.core.CamelAndUnderLineConverter;
import org.wu.framework.lazy.orm.core.config.ReverseEngineering;
import org.wu.framework.lazy.orm.core.config.enums.OrmArchitecture;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyTableFieldEndpoint;
import org.wu.framework.lazy.orm.core.persistence.reverse.ParamDescribeList;
import org.wu.framework.lazy.orm.core.persistence.reverse.ReverseClassLazyTableEndpoint;
import org.wu.framework.lazy.orm.core.persistence.reverse.lazy.DefaultAbstractJavaReverseEngineeringMethod;
import org.wu.framework.translation.data.JavaKeyword;

public class DefaultDDDLazyInfrastructurePersistence
extends DefaultAbstractJavaReverseEngineeringMethod {
    public DefaultDDDLazyInfrastructurePersistence(ReverseClassLazyTableEndpoint reverseClassLazyTableEndpoint, ReverseEngineering reverseEngineering) {
        super(reverseClassLazyTableEndpoint, reverseEngineering);
    }

    @Override
    public void initImportClassName() {
        ReverseClassLazyTableEndpoint tableEndpoint = this.getReverseClassLazyTableEndpoint();
        String className = tableEndpoint.getClassName();
        List domainNames = CamelAndUnderLineConverter.humpToArray((String)className);
        this.addImportClassName(tableEndpoint.getPackageName() + "." + "infrastructure.entity" + "." + className + "DO");
        this.addImportClassName(tableEndpoint.getPackageName() + "." + "infrastructure.converter" + "." + className + "Converter");
        this.addImportClassName(tableEndpoint.getPackageName() + "." + "infrastructure.mapper" + "." + className + "Mapper");
        this.addImportClassName(tableEndpoint.getPackageName() + "." + "domain.model." + domainNames.stream().map(domainName -> {
            if (Arrays.stream(JavaKeyword.values()).anyMatch(javaKeyword -> javaKeyword.name().toLowerCase().equals(domainName))) {
                return domainName + "_";
            }
            return domainName;
        }).collect(Collectors.joining(".")) + "." + className + "Repository");
        this.addImportClassName("org.springframework.stereotype.Repository");
        this.addImportClassName("java.util.stream.Collectors");
        this.addImportClassName("org.wu.framework.lazy.orm.database.lambda.stream.wrapper.LazyWrappers");
        ReverseEngineering reverseEngineering = this.getReverseEngineering();
        if (this.getReverseEngineering().isEnableNormalCrud()) {
            this.addImportClassName("org.wu.framework.web.response.Result");
            this.addImportClassName("org.wu.framework.web.response.ResultFactory");
            this.addImportClassName("jakarta.annotation.Resource");
            String domainClass = tableEndpoint.getPackageName() + "." + "domain.model." + domainNames.stream().map(domainName -> {
                if (Arrays.stream(JavaKeyword.values()).anyMatch(javaKeyword -> javaKeyword.name().toLowerCase().equals(domainName))) {
                    return domainName + "_";
                }
                return domainName;
            }).collect(Collectors.joining(".")) + "." + className;
            this.addImportClassName(domainClass);
        }
        this.addImportClassName("org.wu.framework.lazy.orm.database.lambda.stream.lambda.LazyLambdaStream");
        this.addImportClassName("java.util.List");
        this.addImportClassName("org.wu.framework.lazy.orm.database.lambda.domain.LazyPage");
    }

    @Override
    public void initClassAnnotationPart() {
        this.addClassAnnotationPart("@Repository");
    }

    @Override
    public void initClassNamePart() {
        ReverseClassLazyTableEndpoint tableEndpoint = this.getReverseClassLazyTableEndpoint();
        String className = tableEndpoint.getClassName();
        String repositoryImplName = String.format("%sRepositoryImpl", className);
        this.setFileName(repositoryImplName);
        this.addClassNamePart(String.format("public class %s  implements  %sRepository {\n", repositoryImplName, className) + "\n");
    }

    @Override
    public void initClassMethodPart() {
        if (this.getReverseEngineering().isEnableNormalCrud()) {
            String lowercaseFirstLetter;
            String comment = this.getReverseClassLazyTableEndpoint().getComment();
            String className = this.getReverseClassLazyTableEndpoint().getClassName();
            String methodParamName = lowercaseFirstLetter = CamelAndUnderLineConverter.lowercaseFirstLetter((String)className);
            if (Arrays.stream(JavaKeyword.values()).anyMatch(javaKeyword -> javaKeyword.name().toLowerCase().equals(lowercaseFirstLetter))) {
                methodParamName = methodParamName + "_";
            }
            String lowerFirstClassName = methodParamName;
            String saveMethodDescribe = this.generateMethodDescribe("\u65b0\u589e" + comment, ParamDescribeList.of().param(String.format("%s", methodParamName), "\u65b0\u589e" + comment).returnParam(String.format("Result<%s>", className), comment + "\u65b0\u589e\u540e\u9886\u57df\u5bf9\u8c61"));
            this.addClassMethodPart(saveMethodDescribe);
            this.addClassMethodPart("    @Override");
            this.addClassMethodPart(String.format("    public Result<%s> story(%s %s) {\n        %sDO %sDO = %sConverter" + this.getMapStructInstance() + ".from%s(%s);\n        lazyLambdaStream.upsert(%sDO);\n        return ResultFactory.successOf();\n    }\n", className, className, methodParamName, className, methodParamName, className, className, methodParamName, methodParamName));
            this.addClassMethodPart(this.generateMethodDescribe("\u6279\u91cf\u65b0\u589e" + comment, ParamDescribeList.of().param(String.format("%sList", methodParamName), "\u6279\u91cf\u65b0\u589e" + comment).returnParam(String.format("Result<List<%s>>", className), comment + "\u65b0\u589e\u540e\u9886\u57df\u5bf9\u8c61\u96c6\u5408")));
            this.addClassMethodPart("    @Override");
            this.addClassMethodPart(String.format("    public Result<List<%s>> batchStory(List<%s> %sList) {\n        List<%sDO> %sDOList = %sList.stream().map(%sConverter" + this.getMapStructInstance() + "::from%s).collect(Collectors.toList());\n        lazyLambdaStream.upsert(%sDOList);\n        return ResultFactory.successOf();\n    }\n", className, className, methodParamName, className, methodParamName, methodParamName, className, className, methodParamName));
            String queryLambdaWrapperCondition = this.getReverseClassLazyTableEndpoint().getModelLazyTableFieldEndpoints().stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<LazyTableFieldEndpoint>(Comparator.comparing(LazyTableFieldEndpoint::getName))), ArrayList::new)).stream().map(lazyTableFieldEndpoint -> {
                String name = lazyTableFieldEndpoint.getName();
                String _name = CamelAndUnderLineConverter.capitalizeFirstLetter((String)name);
                return String.format("                .eqIgnoreEmpty(%sDO::get%s,%sDO.get%s())\n", className, _name, lowerFirstClassName, _name);
            }).collect(Collectors.joining());
            String queryLambdaWrapper = String.format("\n                LazyWrappers.<%sDO>lambdaWrapper()\n        " + queryLambdaWrapperCondition, className);
            String findOneMethodDescribe = this.generateMethodDescribe("\u67e5\u8be2\u5355\u4e2a" + comment, ParamDescribeList.of().param(String.format("%s", methodParamName), "\u67e5\u8be2\u5355\u4e2a" + comment).returnParam(String.format("Result<%s>", className), comment + "\u9886\u57df\u5bf9\u8c61"));
            this.addClassMethodPart(findOneMethodDescribe);
            this.addClassMethodPart("    @Override");
            this.addClassMethodPart(String.format("    public Result<%s> findOne(%s %s) {\n        %sDO %sDO = %sConverter" + this.getMapStructInstance() + ".from%s(%s);\n        %s %sOne = lazyLambdaStream.selectOne(%s, %s.class);\n        return ResultFactory.successOf(%sOne);\n    }\n", className, className, methodParamName, className, methodParamName, className, className, methodParamName, className, methodParamName, queryLambdaWrapper, className, methodParamName));
            String findListMethodDescribe = this.generateMethodDescribe("\u67e5\u8be2\u591a\u4e2a" + comment, ParamDescribeList.of().param(String.format("%s", methodParamName), "\u67e5\u8be2\u591a\u4e2a" + comment).returnParam(String.format("Result<List<%s>>", className), comment + "\u9886\u57df\u5bf9\u8c61"));
            this.addClassMethodPart(findListMethodDescribe);
            this.addClassMethodPart("    @Override");
            this.addClassMethodPart(String.format("    public Result<List<%s>> findList(%s %s) {\n        %sDO %sDO = %sConverter" + this.getMapStructInstance() + ".from%s(%s);\n        List<%s> %sList = lazyLambdaStream.selectList(%s, %s.class);\n        return ResultFactory.successOf(%sList);\n    }\n", className, className, methodParamName, className, methodParamName, className, className, methodParamName, className, methodParamName, queryLambdaWrapper, className, methodParamName));
            String findPageMethodDescribe = this.generateMethodDescribe("\u5206\u9875\u67e5\u8be2\u591a\u4e2a" + comment, ParamDescribeList.of().param("size", "\u5f53\u524d\u9875\u6570").param("current", "\u5f53\u524d\u9875").param(String.format("%s", methodParamName), "\u5206\u9875\u67e5\u8be2\u591a\u4e2a" + comment).returnParam(String.format("Result<LazyPage<%s>>", className), "\u5206\u9875" + comment + "\u9886\u57df\u5bf9\u8c61"));
            this.addClassMethodPart(findPageMethodDescribe);
            this.addClassMethodPart("    @Override");
            this.addClassMethodPart(String.format("    public Result<LazyPage<%s>> findPage(int size,int current,%s %s) {\n        %sDO %sDO = %sConverter" + this.getMapStructInstance() + ".from%s(%s);\n        LazyPage<%s> lazyPage = new LazyPage<>(current,size);\n        LazyPage<%s> %sLazyPage = lazyLambdaStream.selectPage(%s,lazyPage, %s.class);\n        return ResultFactory.successOf(%sLazyPage);\n    }\n", className, className, methodParamName, className, methodParamName, className, className, methodParamName, className, className, methodParamName, queryLambdaWrapper, className, methodParamName));
            String deleteMethodDescribe = this.generateMethodDescribe("\u5220\u9664" + comment, ParamDescribeList.of().param(String.format("%s", methodParamName), "\u5220\u9664" + comment).returnParam(String.format("Result<%s>", className), comment));
            this.addClassMethodPart(deleteMethodDescribe);
            this.addClassMethodPart("    @Override");
            this.addClassMethodPart(String.format("    public Result<%s> remove(%s %s) {\n        %sDO %sDO = %sConverter" + this.getMapStructInstance() + ".from%s(%s);\n        lazyLambdaStream.delete(%s);\n        return ResultFactory.successOf();\n    }\n", className, className, methodParamName, className, methodParamName, className, className, methodParamName, queryLambdaWrapper));
            String existsMethodDescribe = this.generateMethodDescribe("\u662f\u5426\u5b58\u5728" + comment, ParamDescribeList.of().param(String.format("%s", methodParamName), comment + "\u9886\u57df\u5bf9\u8c61").returnParam("Result<Boolean>", "\u662f\u5426\u5b58\u5728 true \u5b58\u5728\uff0cfalse \u4e0d\u5b58\u5728"));
            this.addClassMethodPart(existsMethodDescribe);
            this.addClassMethodPart("    @Override");
            this.addClassMethodPart(String.format("    public Result<Boolean> exists(%s %s) {\n        %sDO %sDO = %sConverter" + this.getMapStructInstance() + ".from%s(%s);\n        Boolean exists=lazyLambdaStream.exists(%s);\n        return ResultFactory.successOf(exists);\n    }\n", className, methodParamName, className, methodParamName, className, className, methodParamName, queryLambdaWrapper));
        }
    }

    private String getMapStructInstance() {
        if (this.getReverseEngineering().isEnableMapStruct()) {
            return ".INSTANCE";
        }
        return "";
    }

    @Override
    protected String getPackage() {
        ReverseClassLazyTableEndpoint tableEndpoint = this.getReverseClassLazyTableEndpoint();
        return String.format("package %s;", tableEndpoint.getPackageName() + "." + "infrastructure" + "." + "persistence") + "\n" + "\n";
    }

    @Override
    public void initClassFieldPart() {
        this.addClassFieldPart("    @Resource\n    LazyLambdaStream lazyLambdaStream;\n");
        if (OrmArchitecture.MYBATIS.equals((Object)this.getReverseEngineering().getOrmArchitecture())) {
            this.addClassFieldPart(String.format("    @Resource\n    %sMapper %sMapper;", this.getReverseClassLazyTableEndpoint().getClassName(), this.lowercaseFirstLetterTableName()));
        }
    }

    @Override
    protected String getModuleType() {
        return "infrastructure" + File.separator + "persistence";
    }
}

