/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.orm.core.persistence.reverse.lazy.ddd;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.wu.framework.core.CamelAndUnderLineConverter;
import org.wu.framework.lazy.orm.core.config.ReverseEngineering;
import org.wu.framework.lazy.orm.core.config.enums.MapStructConversionStrategy;
import org.wu.framework.lazy.orm.core.persistence.reverse.ParamDescribeList;
import org.wu.framework.lazy.orm.core.persistence.reverse.ReverseClassLazyTableEndpoint;
import org.wu.framework.lazy.orm.core.persistence.reverse.lazy.DefaultAbstractJavaReverseEngineeringMethod;
import org.wu.framework.translation.data.JavaKeyword;

public class DefaultDDDLazyInfrastructureConverter
extends DefaultAbstractJavaReverseEngineeringMethod {
    public DefaultDDDLazyInfrastructureConverter(ReverseClassLazyTableEndpoint reverseClassLazyTableEndpoint, ReverseEngineering reverseEngineering) {
        super(reverseClassLazyTableEndpoint, reverseEngineering);
    }

    @Override
    public void initImportClassName() {
        ReverseClassLazyTableEndpoint tableEndpoint = this.getReverseClassLazyTableEndpoint();
        String className = tableEndpoint.getClassName();
        List domainNames = CamelAndUnderLineConverter.humpToArray((String)className);
        String domainClass = tableEndpoint.getPackageName() + "." + "domain.model." + domainNames.stream().map(domainName -> {
            if (Arrays.stream(JavaKeyword.values()).anyMatch(javaKeyword -> javaKeyword.name().toLowerCase().equals(domainName))) {
                return domainName + "_";
            }
            return domainName;
        }).collect(Collectors.joining(".")) + "." + className;
        this.addImportClassName(domainClass);
        this.addImportClassName(tableEndpoint.getPackageName() + "." + "infrastructure.entity" + "." + className + "DO");
    }

    @Override
    public void initClassAnnotationPart() {
    }

    @Override
    public void initClassNamePart() {
        ReverseClassLazyTableEndpoint tableEndpoint = this.getReverseClassLazyTableEndpoint();
        String converterName = String.format("%sConverter", tableEndpoint.getClassName());
        this.setFileName(converterName);
        if (this.getReverseEngineering().isEnableMapStruct()) {
            if (this.getReverseEngineering().getMapStructConversionStrategy() == MapStructConversionStrategy.MAPPER) {
                this.addImportClassName("org.mapstruct.factory.Mappers");
                this.addImportClassName("org.mapstruct.Mapper");
                this.addClassAnnotationPart("@Mapper");
            } else if (this.getReverseEngineering().getMapStructConversionStrategy() == MapStructConversionStrategy.LAZY_STRUCT_MAPPERS) {
                this.addImportClassName("org.wu.framework.core.mapper.LazyStructMappers");
                this.addImportClassName("org.wu.framework.core.mapper.LazyStructMapper");
                this.addClassAnnotationPart("@LazyStructMapper");
            }
            this.addClassNamePart(String.format("public interface %s {\n", converterName) + "\n");
        } else {
            this.addClassNamePart(String.format("public class %s {\n", converterName) + "\n");
        }
    }

    @Override
    protected String getPackage() {
        ReverseClassLazyTableEndpoint tableEndpoint = this.getReverseClassLazyTableEndpoint();
        return String.format("package %s;", tableEndpoint.getPackageName() + "." + "infrastructure" + "." + "converter") + "\n" + "\n";
    }

    @Override
    public void initClassFieldPart() {
    }

    @Override
    public void initClassMethodPart() {
        String lowercaseFirstLetter;
        ReverseClassLazyTableEndpoint tableEndpoint = this.getReverseClassLazyTableEndpoint();
        String className = tableEndpoint.getClassName();
        String comment = tableEndpoint.getComment();
        String methodParamName = lowercaseFirstLetter = CamelAndUnderLineConverter.lowercaseFirstLetter((String)className);
        if (Arrays.stream(JavaKeyword.values()).anyMatch(javaKeyword -> javaKeyword.name().toLowerCase().equals(lowercaseFirstLetter))) {
            methodParamName = methodParamName + "_";
        }
        if (this.getReverseEngineering().isEnableMapStruct()) {
            if (this.getReverseEngineering().getMapStructConversionStrategy() == MapStructConversionStrategy.MAPPER) {
                this.addClassMethodPart(this.generateMethodDescribe("MapStruct \u521b\u5efa\u7684\u4ee3\u7406\u5bf9\u8c61", ParamDescribeList.of()) + String.format("    %sDTOAssembler INSTANCE = Mappers.getMapper(%sDTOAssembler.class);", className, className));
            } else if (this.getReverseEngineering().getMapStructConversionStrategy() == MapStructConversionStrategy.LAZY_STRUCT_MAPPERS) {
                this.addClassMethodPart(this.generateMethodDescribe("LazyStructMapper \u521b\u5efa\u7684\u4ee3\u7406\u5bf9\u8c61", ParamDescribeList.of()) + String.format("    %sDTOAssembler INSTANCE = LazyStructMappers.getMapper(%sDTOAssembler.class);", className, className));
            }
            this.addClassMethodPart(this.generateMethodDescribe("\u5b9e\u4f53\u5bf9\u8c61 \u8f6c\u6362\u6210\u9886\u57df\u5bf9\u8c61", ParamDescribeList.of().param(String.format("%sDO", methodParamName), comment + "\u5b9e\u4f53\u5bf9\u8c61").returnParam(String.format("%s", className), comment + "\u9886\u57df\u5bf9\u8c61")) + String.format("    %s to%s(%sDO %sDO);", className, className, className, methodParamName));
            this.addClassMethodPart(this.generateMethodDescribe("\u9886\u57df\u5bf9\u8c61 \u8f6c\u6362\u6210\u5b9e\u4f53\u5bf9\u8c61", ParamDescribeList.of().param(String.format("%s", methodParamName), comment + "\u9886\u57df\u5bf9\u8c61").returnParam(String.format("%sDO", className), comment + "\u5b9e\u4f53\u5bf9\u8c61")) + String.format("     %sDO from%s(%s %s); ", className, className, className, methodParamName));
        } else {
            String finalMethodParamName = methodParamName;
            this.addClassMethodPart(this.generateMethodDescribe("\u5b9e\u4f53\u5bf9\u8c61 \u8f6c\u6362\u6210\u9886\u57df\u5bf9\u8c61", ParamDescribeList.of().param(String.format("%sDO", methodParamName), comment + "\u5b9e\u4f53\u5bf9\u8c61").returnParam(String.format("%s", className), comment + "\u9886\u57df\u5bf9\u8c61")) + String.format("    public static %s to%s(%sDO %sDO) {\n        if (null != %sDO) {\n        %s %s = new %s(); \n" + tableEndpoint.getOutLazyTableFieldEndpoints().stream().map(lazyTableFieldEndpoint -> {
                String capitalizeFirstLetterFieldName;
                String name = lazyTableFieldEndpoint.getName();
                String finalCapitalizeFirstLetterFieldName = capitalizeFirstLetterFieldName = CamelAndUnderLineConverter.capitalizeFirstLetter((String)name);
                if (Arrays.stream(JavaKeyword.values()).anyMatch(javaKeyword -> javaKeyword.name().toLowerCase().equals(finalCapitalizeFirstLetterFieldName))) {
                    capitalizeFirstLetterFieldName = capitalizeFirstLetterFieldName + "_";
                }
                return String.format("           %s.set%s(%sDO.get%s());\n", finalMethodParamName, capitalizeFirstLetterFieldName, finalMethodParamName, capitalizeFirstLetterFieldName);
            }).collect(Collectors.joining()) + "            return %s;\n        }\n        return null;\n    }\n", className, className, className, methodParamName, methodParamName, className, methodParamName, className, methodParamName));
            this.addClassMethodPart(this.generateMethodDescribe("\u9886\u57df\u5bf9\u8c61 \u8f6c\u6362\u6210\u5b9e\u4f53\u5bf9\u8c61", ParamDescribeList.of().param(String.format("%s", methodParamName), comment + "\u9886\u57df\u5bf9\u8c61").returnParam(String.format("%sDO", className), comment + "\u5b9e\u4f53\u5bf9\u8c61")) + String.format("    public static %sDO from%s(%s %s) {\n        if (null != %s) {\n        %sDO %sDO = new %sDO(); \n" + tableEndpoint.getOutLazyTableFieldEndpoints().stream().map(lazyTableFieldEndpoint -> {
                String capitalizeFirstLetterFieldName;
                String name = lazyTableFieldEndpoint.getName();
                String finalCapitalizeFirstLetterFieldName = capitalizeFirstLetterFieldName = CamelAndUnderLineConverter.capitalizeFirstLetter((String)name);
                if (Arrays.stream(JavaKeyword.values()).anyMatch(javaKeyword -> javaKeyword.name().toLowerCase().equals(finalCapitalizeFirstLetterFieldName))) {
                    capitalizeFirstLetterFieldName = capitalizeFirstLetterFieldName + "_";
                }
                return String.format("           %sDO.set%s(%s.get%s());\n", finalMethodParamName, capitalizeFirstLetterFieldName, finalMethodParamName, capitalizeFirstLetterFieldName);
            }).collect(Collectors.joining()) + "            return %sDO;\n        }\n        return null;\n    }\n", className, className, className, methodParamName, methodParamName, className, methodParamName, className, methodParamName));
        }
    }

    @Override
    protected String getModuleType() {
        return "infrastructure" + File.separator + "converter";
    }
}

