/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.orm.core.persistence.reverse.lazy.ddd;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.wu.framework.core.CamelAndUnderLineConverter;
import org.wu.framework.lazy.orm.core.config.ReverseEngineering;
import org.wu.framework.lazy.orm.core.persistence.reverse.ParamDescribeList;
import org.wu.framework.lazy.orm.core.persistence.reverse.ReverseClassLazyTableEndpoint;
import org.wu.framework.lazy.orm.core.persistence.reverse.lazy.DefaultAbstractJavaReverseEngineeringMethod;
import org.wu.framework.translation.data.JavaKeyword;

public class DefaultDDDLazyDomainRepository
extends DefaultAbstractJavaReverseEngineeringMethod {
    public DefaultDDDLazyDomainRepository(ReverseClassLazyTableEndpoint reverseClassLazyTableEndpoint, ReverseEngineering reverseEngineering) {
        super(reverseClassLazyTableEndpoint, reverseEngineering);
    }

    @Override
    public void initImportClassName() {
        ReverseEngineering reverseEngineering = this.getReverseEngineering();
        ReverseClassLazyTableEndpoint tableEndpoint = this.getReverseClassLazyTableEndpoint();
        String className = tableEndpoint.getClassName();
        if (this.getReverseEngineering().isEnableNormalCrud()) {
            this.addImportClassName("org.wu.framework.web.response.Result");
            this.addImportClassName("org.wu.framework.web.response.ResultFactory");
            this.addImportClassName("org.springframework.beans.factory.annotation.Autowired");
            List domainNames = CamelAndUnderLineConverter.humpToArray((String)className);
            String domainClass = tableEndpoint.getPackageName() + "." + "domain.model." + domainNames.stream().map(domainName -> {
                if (Arrays.stream(JavaKeyword.values()).anyMatch(javaKeyword -> javaKeyword.name().toLowerCase().equals(domainName))) {
                    return domainName + "_";
                }
                return domainName;
            }).collect(Collectors.joining(".")) + "." + className;
            this.addImportClassName(domainClass);
            this.addImportClassName("java.util.List");
            this.addImportClassName("org.wu.framework.lazy.orm.database.lambda.domain.LazyPage");
        }
    }

    @Override
    public void initClassAnnotationPart() {
    }

    @Override
    public void initClassNamePart() {
        ReverseClassLazyTableEndpoint tableEndpoint = this.getReverseClassLazyTableEndpoint();
        String className = tableEndpoint.getClassName();
        String repositoryName = String.format("%sRepository", className);
        this.setFileName(repositoryName);
        this.addClassNamePart(String.format("public interface %s {\n", repositoryName) + "\n");
    }

    @Override
    public void initClassMethodPart() {
        if (this.getReverseEngineering().isEnableNormalCrud()) {
            String lowercaseFirstLetter;
            String comment = this.getReverseClassLazyTableEndpoint().getComment();
            String className = this.getReverseClassLazyTableEndpoint().getClassName();
            String methodParamName = lowercaseFirstLetter = CamelAndUnderLineConverter.lowercaseFirstLetter((String)className);
            if (Arrays.stream(JavaKeyword.values()).anyMatch(javaKeyword -> javaKeyword.name().toLowerCase().equals(lowercaseFirstLetter))) {
                methodParamName = methodParamName + "_";
            }
            String saveMethodDescribe = this.generateMethodDescribe("\u65b0\u589e" + comment, ParamDescribeList.of().param(String.format("%s", methodParamName), "\u65b0\u589e" + comment).returnParam(String.format(" Result<%s>", className), comment + "\u65b0\u589e\u540e\u9886\u57df\u5bf9\u8c61"));
            this.addClassMethodPart(saveMethodDescribe);
            this.addClassMethodPart(String.format("    Result<%s> story(%s %s);\n", className, className, methodParamName));
            this.addClassMethodPart(this.generateMethodDescribe("\u6279\u91cf\u65b0\u589e" + comment, ParamDescribeList.of().param(String.format("%sList", methodParamName), "\u6279\u91cf\u65b0\u589e" + comment).returnParam(String.format("Result<List<%s>>", className), comment + "\u65b0\u589e\u540e\u9886\u57df\u5bf9\u8c61\u96c6\u5408")));
            this.addClassMethodPart(String.format("    Result<List<%s>> batchStory(List<%s> %sList);\n", className, className, methodParamName));
            String findOneMethodDescribe = this.generateMethodDescribe("\u67e5\u8be2\u5355\u4e2a" + comment, ParamDescribeList.of().param(String.format("%s", methodParamName), "\u67e5\u8be2\u5355\u4e2a" + comment).returnParam(String.format("Result<%s>", className), comment + "DTO\u5bf9\u8c61"));
            this.addClassMethodPart(findOneMethodDescribe);
            this.addClassMethodPart(String.format("    Result<%s> findOne(%s %s);\n", className, className, methodParamName));
            String findListMethodDescribe = this.generateMethodDescribe("\u67e5\u8be2\u591a\u4e2a" + comment, ParamDescribeList.of().param(String.format("%s", methodParamName), "\u67e5\u8be2\u591a\u4e2a" + comment).returnParam(String.format("Result<List<%s>>", className), comment + "DTO\u5bf9\u8c61"));
            this.addClassMethodPart(findListMethodDescribe);
            this.addClassMethodPart(String.format("    Result<List<%s>> findList(%s %s);\n", className, className, methodParamName));
            String findPageMethodDescribe = this.generateMethodDescribe("\u5206\u9875\u67e5\u8be2\u591a\u4e2a" + comment, ParamDescribeList.of().param("size", "\u5f53\u524d\u9875\u6570").param("current", "\u5f53\u524d\u9875").param(String.format("%s", methodParamName), "\u5206\u9875\u67e5\u8be2\u591a\u4e2a" + comment).returnParam(String.format("Result<LazyPage<%s>>", className), "\u5206\u9875" + comment + "\u9886\u57df\u5bf9\u8c61"));
            this.addClassMethodPart(findPageMethodDescribe);
            this.addClassMethodPart(String.format("    Result<LazyPage<%s>> findPage(int size,int current,%s %s);\n", className, className, methodParamName));
            String deleteMethodDescribe = this.generateMethodDescribe("\u5220\u9664" + comment, ParamDescribeList.of().param(String.format("%s", methodParamName), "\u5220\u9664" + comment).returnParam(String.format("Result<%s>", className), comment));
            this.addClassMethodPart(deleteMethodDescribe);
            this.addClassMethodPart(String.format("    Result<%s> remove(%s %s);\n", className, className, methodParamName));
            String existsMethodDescribe = this.generateMethodDescribe("\u662f\u5426\u5b58\u5728" + comment, ParamDescribeList.of().param(String.format("%s", methodParamName), "\u662f\u5426\u5b58\u5728" + comment).returnParam("Result<Boolean>", comment + "\u662f\u5426\u5b58\u5728"));
            this.addClassMethodPart(existsMethodDescribe);
            this.addClassMethodPart(String.format("    Result<Boolean> exists(%s %s);\n", className, methodParamName));
        }
    }

    @Override
    protected String getPackage() {
        ReverseClassLazyTableEndpoint tableEndpoint = this.getReverseClassLazyTableEndpoint();
        String domain = tableEndpoint.getClassName();
        List domainNames = CamelAndUnderLineConverter.humpToArray((String)domain);
        String classPackage = String.format("package %s;", tableEndpoint.getPackageName() + "." + "domain.model." + domainNames.stream().map(domainName -> {
            if (Arrays.stream(JavaKeyword.values()).anyMatch(javaKeyword -> javaKeyword.name().toLowerCase().equals(domainName))) {
                return domainName + "_";
            }
            return domainName;
        }).collect(Collectors.joining("."))) + "\n" + "\n";
        return classPackage;
    }

    @Override
    public void initClassFieldPart() {
    }

    @Override
    protected String getModuleType() {
        ReverseClassLazyTableEndpoint tableEndpoint = this.getReverseClassLazyTableEndpoint();
        String domain = tableEndpoint.getClassName();
        List domainNames = CamelAndUnderLineConverter.humpToArray((String)domain);
        return "domain" + File.separator + "model" + File.separator + domainNames.stream().map(domainName -> {
            if (Arrays.stream(JavaKeyword.values()).anyMatch(javaKeyword -> javaKeyword.name().toLowerCase().equals(domainName))) {
                return domainName + "_";
            }
            return domainName;
        }).collect(Collectors.joining(File.separator));
    }
}

