/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.orm.core.persistence.reverse.lazy.ddd;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.wu.framework.core.CamelAndUnderLineConverter;
import org.wu.framework.lazy.orm.core.config.ReverseEngineering;
import org.wu.framework.lazy.orm.core.persistence.reverse.ParamDescribeList;
import org.wu.framework.lazy.orm.core.persistence.reverse.ReverseClassLazyTableEndpoint;
import org.wu.framework.lazy.orm.core.persistence.reverse.lazy.DefaultAbstractJavaReverseEngineeringMethod;
import org.wu.framework.translation.data.JavaKeyword;

public class DefaultDDDLazyController
extends DefaultAbstractJavaReverseEngineeringMethod {
    public DefaultDDDLazyController(ReverseClassLazyTableEndpoint reverseClassLazyTableEndpoint, ReverseEngineering reverseEngineering) {
        super(reverseClassLazyTableEndpoint, reverseEngineering);
    }

    @Override
    public void initImportClassName() {
        if (this.getReverseEngineering().isEnableSwagger()) {
            this.addImportClassName("io.swagger.v3.oas.annotations.tags.Tag");
            this.addImportClassName("io.swagger.v3.oas.annotations.Operation");
            this.addImportClassName("io.swagger.v3.oas.annotations.Parameter");
        }
        this.addImportClassName("org.wu.framework.web.spring.EasyController");
        if (this.getReverseEngineering().isEnableNormalCrud()) {
            this.addImportClassName("org.springframework.web.bind.annotation.*");
            this.addImportClassName("org.wu.framework.web.response.Result");
            this.addImportClassName("org.wu.framework.web.response.ResultFactory");
            this.addImportClassName("org.springframework.beans.factory.annotation.Autowired");
            this.addImportClassName("jakarta.annotation.Resource");
            this.addImportClassName("java.util.List");
            ReverseClassLazyTableEndpoint tableEndpoint = this.getReverseClassLazyTableEndpoint();
            String className = tableEndpoint.getClassName();
            List domainNames = CamelAndUnderLineConverter.humpToArray((String)className);
            String domainClass = tableEndpoint.getPackageName() + "." + "domain.model." + domainNames.stream().map(domainName -> {
                if (Arrays.stream(JavaKeyword.values()).anyMatch(javaKeyword -> javaKeyword.name().toLowerCase().equals(domainName))) {
                    return domainName + "_";
                }
                return domainName;
            }).collect(Collectors.joining(".")) + "." + className;
            this.addImportClassName(domainClass);
            this.addImportClassName(this.getReverseClassLazyTableEndpoint().getPackageName() + "." + "application.command" + "." + this.humpToDOT() + "." + this.getReverseClassLazyTableEndpoint().getClassName() + "RemoveCommand");
            this.addImportClassName(this.getReverseClassLazyTableEndpoint().getPackageName() + "." + "application.command" + "." + this.humpToDOT() + "." + this.getReverseClassLazyTableEndpoint().getClassName() + "StoryCommand");
            this.addImportClassName(this.getReverseClassLazyTableEndpoint().getPackageName() + "." + "application.command" + "." + this.humpToDOT() + "." + this.getReverseClassLazyTableEndpoint().getClassName() + "UpdateCommand");
            this.addImportClassName(this.getReverseClassLazyTableEndpoint().getPackageName() + "." + "application.command" + "." + this.humpToDOT() + "." + this.getReverseClassLazyTableEndpoint().getClassName() + "QueryListCommand");
            this.addImportClassName(this.getReverseClassLazyTableEndpoint().getPackageName() + "." + "application.command" + "." + this.humpToDOT() + "." + this.getReverseClassLazyTableEndpoint().getClassName() + "QueryOneCommand");
            this.addImportClassName(this.getReverseClassLazyTableEndpoint().getPackageName() + "." + "application" + "." + this.getReverseClassLazyTableEndpoint().getClassName() + "Application");
            this.addImportClassName(this.getReverseClassLazyTableEndpoint().getPackageName() + "." + "application" + "." + "dto" + "." + this.getReverseClassLazyTableEndpoint().getClassName() + "DTO");
            this.addImportClassName("java.util.List");
            this.addImportClassName("org.wu.framework.lazy.orm.database.lambda.domain.LazyPage");
            if (this.getReverseEngineering().isEnableExport()) {
                this.addImportClassName(this.getReverseClassLazyTableEndpoint().getPackageName() + "." + "application.command" + "." + this.humpToDOT() + "." + this.getReverseClassLazyTableEndpoint().getClassName() + "ExcelExport");
                this.addImportClassName(this.getReverseClassLazyTableEndpoint().getPackageName() + "." + "application.command" + "." + this.humpToDOT() + "." + this.getReverseClassLazyTableEndpoint().getClassName() + "ExcelImport");
                this.addImportClassName("org.wu.framework.easy.excel.stereotype.RequestExcelBody");
                this.addImportClassName("org.wu.framework.easy.excel.stereotype.EasyExcel");
            }
        }
    }

    @Override
    public void initClassAnnotationPart() {
        ReverseClassLazyTableEndpoint tableEndpoint = this.getReverseClassLazyTableEndpoint();
        String domain = tableEndpoint.getClassName();
        List domainNames = CamelAndUnderLineConverter.humpToArray((String)domain);
        String path = domainNames.stream().map(domainName -> {
            if (Arrays.stream(JavaKeyword.values()).anyMatch(javaKeyword -> javaKeyword.name().toLowerCase().equals(domainName))) {
                return domainName + "_";
            }
            return domainName;
        }).collect(Collectors.joining("/"));
        this.addClassAnnotationPart(String.format("@Tag(name = \"%s\u63d0\u4f9b\u8005\")", this.getReverseClassLazyTableEndpoint().getComment()));
        this.addClassAnnotationPart(String.format("@EasyController(\"%s/%s\")", this.getReverseEngineering().getApiUrlPrefix(), path));
        super.initClassAnnotationPart();
    }

    @Override
    public void initClassFieldPart() {
        String lowercaseFirstLetterTableName = this.lowercaseFirstLetterTableName();
        this.addClassFieldPart(String.format("    @Resource\n    private %sApplication %sApplication;\n", this.getReverseClassLazyTableEndpoint().getClassName(), lowercaseFirstLetterTableName));
    }

    @Override
    public void initClassMethodPart() {
        if (this.getReverseEngineering().isEnableNormalCrud()) {
            String lowercaseFirstLetter;
            String comment = this.getReverseClassLazyTableEndpoint().getComment();
            String className = this.getReverseClassLazyTableEndpoint().getClassName();
            String methodParamName = lowercaseFirstLetter = CamelAndUnderLineConverter.lowercaseFirstLetter((String)className);
            if (Arrays.stream(JavaKeyword.values()).anyMatch(javaKeyword -> javaKeyword.name().toLowerCase().equals(lowercaseFirstLetter))) {
                methodParamName = methodParamName + "_";
            }
            String saveMethodDescribe = this.generateMethodDescribe("\u65b0\u589e" + comment, ParamDescribeList.of().param(String.format("%sStoryCommand", methodParamName), "\u65b0\u589e" + comment).returnParam(String.format("Result<%s>", className), comment + "\u65b0\u589e\u540e\u9886\u57df\u5bf9\u8c61"));
            this.addClassMethodPart(saveMethodDescribe);
            if (this.getReverseEngineering().isEnableSwagger()) {
                this.addClassMethodPart(String.format("    @Operation(summary = \"\u65b0\u589e%s\")", comment));
            }
            this.addClassMethodPart("    @PostMapping(\"/story\")");
            this.addClassMethodPart(String.format("    public Result<%s> story(@RequestBody %sStoryCommand %sStoryCommand){%n        return %sApplication.story(%sStoryCommand);%n    }", className, className, methodParamName, methodParamName, methodParamName));
            this.addClassMethodPart(this.generateMethodDescribe("\u6279\u91cf\u65b0\u589e" + comment, ParamDescribeList.of().param(String.format("%sStoryCommandList", methodParamName), "\u6279\u91cf\u65b0\u589e" + comment).returnParam(String.format("Result<List<%s>>", className), comment + "\u65b0\u589e\u540e\u9886\u57df\u5bf9\u8c61\u96c6\u5408")));
            if (this.getReverseEngineering().isEnableSwagger()) {
                this.addClassMethodPart(String.format("    @Operation(summary = \"\u6279\u91cf\u65b0\u589e%s\")", comment));
            }
            this.addClassMethodPart("    @PostMapping(\"/batchStory\")");
            this.addClassMethodPart(String.format("    public Result<List<%s>> batchStory(@RequestBody List<%sStoryCommand> %sStoryCommandList){%n        return %sApplication.batchStory(%sStoryCommandList);%n    }", className, className, methodParamName, methodParamName, methodParamName));
            String updateMethodDescribe = this.generateMethodDescribe("\u66f4\u65b0" + comment, ParamDescribeList.of().param(String.format("%sUpdateCommand", methodParamName), "\u66f4\u65b0" + comment).returnParam(String.format("Result<%s>", className), comment + "\u9886\u57df\u5bf9\u8c61"));
            this.addClassMethodPart(updateMethodDescribe);
            if (this.getReverseEngineering().isEnableSwagger()) {
                this.addClassMethodPart(String.format("    @Operation(summary = \"\u66f4\u65b0%s\")", comment));
            }
            this.addClassMethodPart("    @PutMapping(\"/updateOne\")");
            this.addClassMethodPart(String.format("    public Result<%s> updateOne(@RequestBody %sUpdateCommand %sUpdateCommand){%n        return %sApplication.updateOne(%sUpdateCommand);%n    }", className, className, methodParamName, methodParamName, methodParamName));
            String findOneMethodDescribe = this.generateMethodDescribe("\u67e5\u8be2\u5355\u4e2a" + comment, ParamDescribeList.of().param(String.format("%sQueryOneCommand", methodParamName), "\u67e5\u8be2\u5355\u4e2a" + comment).returnParam(String.format("Result<%sDTO>", className), comment + "DTO\u5bf9\u8c61"));
            this.addClassMethodPart(findOneMethodDescribe);
            if (this.getReverseEngineering().isEnableSwagger()) {
                this.addClassMethodPart(String.format("    @Operation(summary = \"\u67e5\u8be2\u5355\u4e2a%s\")", comment));
            }
            this.addClassMethodPart("    @GetMapping(\"/findOne\")");
            this.addClassMethodPart(String.format("    public Result<%sDTO> findOne(@ModelAttribute %sQueryOneCommand %sQueryOneCommand){%n        return %sApplication.findOne(%sQueryOneCommand);%n    }", className, className, methodParamName, methodParamName, methodParamName));
            String findListMethodDescribe = this.generateMethodDescribe("\u67e5\u8be2\u591a\u4e2a" + comment, ParamDescribeList.of().param(String.format("%sQueryListCommand", methodParamName), "\u67e5\u8be2\u591a\u4e2a" + comment).returnParam(String.format("Result<List<%sDTO>>", className), comment + "DTO\u5bf9\u8c61"));
            this.addClassMethodPart(findListMethodDescribe);
            if (this.getReverseEngineering().isEnableSwagger()) {
                this.addClassMethodPart(String.format("    @Operation(summary = \"\u67e5\u8be2\u591a\u4e2a%s\")", comment));
            }
            this.addClassMethodPart("    @GetMapping(\"/findList\")");
            this.addClassMethodPart(String.format("    public Result<List<%sDTO>> findList(@ModelAttribute %sQueryListCommand %sQueryListCommand){%n        return %sApplication.findList(%sQueryListCommand);%n    }", className, className, methodParamName, methodParamName, methodParamName));
            String findPageMethodDescribe = this.generateMethodDescribe("\u5206\u9875\u67e5\u8be2\u591a\u4e2a" + comment, ParamDescribeList.of().param(String.format("%sQueryListCommand", methodParamName), "\u5206\u9875\u67e5\u8be2\u591a\u4e2a" + comment).returnParam(String.format("Result<LazyPage<%sDTO>>", className), "\u5206\u9875" + comment + "DTO\u5bf9\u8c61"));
            this.addClassMethodPart(findPageMethodDescribe);
            if (this.getReverseEngineering().isEnableSwagger()) {
                this.addClassMethodPart(String.format("    @Operation(summary = \"\u5206\u9875\u67e5\u8be2\u591a\u4e2a%s\")", comment));
            }
            this.addClassMethodPart("    @GetMapping(\"/findPage\")");
            this.addClassMethodPart(String.format("    public Result<LazyPage<%sDTO>> findPage(@Parameter(description =\"\u5206\u9875\u5927\u5c0f\") @RequestParam(defaultValue = \"10\", value = \"size\") int size,\n                           @Parameter(description =\"\u5f53\u524d\u9875\u6570\") @RequestParam(defaultValue = \"1\", value = \"current\") int current,@ModelAttribute %sQueryListCommand %sQueryListCommand){%n        return %sApplication.findPage(size,current,%sQueryListCommand);%n    }", className, className, methodParamName, methodParamName, methodParamName));
            String deleteMethodDescribe = this.generateMethodDescribe("\u5220\u9664" + comment, ParamDescribeList.of().param(String.format("%sRemoveCommand", methodParamName), "\u5220\u9664" + comment).returnParam(String.format("Result<%s>", className), comment));
            this.addClassMethodPart(deleteMethodDescribe);
            this.addClassMethodPart(String.format("    @Operation(summary = \"\u5220\u9664%s\")", comment));
            this.addClassMethodPart("    @DeleteMapping(\"/remove\")");
            this.addClassMethodPart(String.format("    public Result<%s> remove(@ModelAttribute %sRemoveCommand %sRemoveCommand){%n        return %sApplication.remove(%sRemoveCommand);%n    }", className, className, methodParamName, methodParamName, methodParamName));
            if (this.getReverseEngineering().isEnableExport()) {
                String exportMethodDescribe = this.generateMethodDescribe("\u5bfc\u51fa" + comment, ParamDescribeList.of().param(String.format("%sQueryListCommand", methodParamName), "\u5bfc\u51fa" + comment).returnParam(String.format("List<%sExcelExport>", className), comment));
                this.addClassMethodPart(exportMethodDescribe);
                this.addClassMethodPart(String.format("    @EasyExcel(fileName = \"\u5bfc\u51fa%s\u6570\u636e\")", comment));
                this.addClassMethodPart(String.format("    @Operation(summary = \"\u5bfc\u51fa%s\")", comment));
                this.addClassMethodPart("    @GetMapping(\"/exportExcel\")");
                this.addClassMethodPart(String.format("    public List<%sExcelExport> exportExcel(@ModelAttribute %sQueryListCommand %sQueryListCommand){%n        return %sApplication.exportExcel(%sQueryListCommand);%n    }", className, className, methodParamName, methodParamName, methodParamName));
                String exportTemplateMethodDescribe = this.generateMethodDescribe("\u5bfc\u51fa\u6a21\u7248" + comment, ParamDescribeList.of().returnParam(String.format("Result<List<%sExcelExport>>", className), comment));
                this.addClassMethodPart(exportTemplateMethodDescribe);
                this.addClassMethodPart(String.format("    @EasyExcel(fileName = \"\u5bfc\u51fa%s\u6a21\u7248\u6570\u636e\")", comment));
                this.addClassMethodPart(String.format("    @Operation(summary = \"\u5bfc\u51fa%s\u6a21\u7248\")", comment));
                this.addClassMethodPart("    @GetMapping(\"/exportTemplateExcel\")");
                this.addClassMethodPart(String.format("    public List<%sExcelExport> exportTemplateExcel(){%n        return Arrays.asList(new %sExcelExport());%n    }", className, className));
                String importMethodDescribe = this.generateMethodDescribe("\u5bfc\u5165" + comment, ParamDescribeList.of().param(String.format("%sExcelImportList", methodParamName), "\u5bfc\u5165" + comment).returnParam(String.format("Result<%sExcelImport>", className), comment));
                this.addClassMethodPart(importMethodDescribe);
                this.addClassMethodPart(String.format("    @Operation(summary = \"\u5bfc\u5165%s\")", comment));
                this.addClassMethodPart("    @PostMapping(\"/importExcel\")");
                this.addClassMethodPart(String.format("    public Result<List<%sExcelImport>> importExcel(@RequestExcelBody(\"multipartFile\") List<%sExcelImport> %sExcelImportList){%n        return %sApplication.importExcel(%sExcelImportList);%n    }", className, className, methodParamName, methodParamName, methodParamName));
            }
        }
    }

    @Override
    public void initClassNamePart() {
        String className = this.getReverseClassLazyTableEndpoint().getClassName();
        String controller = className + "Provider";
        this.setFileName(controller);
        this.addClassNamePart(String.format("public class %s  {\n", controller) + "\n");
        super.initClassNamePart();
    }

    @Override
    protected String getModuleType() {
        return "controller";
    }
}

