/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.orm.core.persistence.reverse.lazy.ddd;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.wu.framework.core.CamelAndUnderLineConverter;
import org.wu.framework.lazy.orm.core.config.ReverseEngineering;
import org.wu.framework.lazy.orm.core.config.enums.MapStructConversionStrategy;
import org.wu.framework.lazy.orm.core.persistence.reverse.ParamDescribeList;
import org.wu.framework.lazy.orm.core.persistence.reverse.ReverseClassLazyTableEndpoint;
import org.wu.framework.lazy.orm.core.persistence.reverse.lazy.DefaultAbstractJavaReverseEngineeringMethod;
import org.wu.framework.translation.data.JavaKeyword;

public class DefaultDDDLazyAssembler
extends DefaultAbstractJavaReverseEngineeringMethod {
    public DefaultDDDLazyAssembler(ReverseClassLazyTableEndpoint reverseClassLazyTableEndpoint, ReverseEngineering reverseEngineering) {
        super(reverseClassLazyTableEndpoint, reverseEngineering);
    }

    @Override
    public void initImportClassName() {
        ReverseClassLazyTableEndpoint tableEndpoint = this.getReverseClassLazyTableEndpoint();
        String className = tableEndpoint.getClassName();
        List domainNames = CamelAndUnderLineConverter.humpToArray((String)className);
        String domainClass = tableEndpoint.getPackageName() + "." + "domain.model." + domainNames.stream().map(domainName -> {
            if (Arrays.stream(JavaKeyword.values()).anyMatch(javaKeyword -> javaKeyword.name().toLowerCase().equals(domainName))) {
                return domainName + "_";
            }
            return domainName;
        }).collect(Collectors.joining(".")) + "." + className;
        this.addImportClassName(domainClass);
        this.addImportClassName(this.getReverseClassLazyTableEndpoint().getPackageName() + "." + "application.command" + "." + this.humpToDOT() + "." + this.getReverseClassLazyTableEndpoint().getClassName() + "RemoveCommand");
        this.addImportClassName(this.getReverseClassLazyTableEndpoint().getPackageName() + "." + "application.command" + "." + this.humpToDOT() + "." + this.getReverseClassLazyTableEndpoint().getClassName() + "StoryCommand");
        this.addImportClassName(this.getReverseClassLazyTableEndpoint().getPackageName() + "." + "application.command" + "." + this.humpToDOT() + "." + this.getReverseClassLazyTableEndpoint().getClassName() + "UpdateCommand");
        this.addImportClassName(this.getReverseClassLazyTableEndpoint().getPackageName() + "." + "application.command" + "." + this.humpToDOT() + "." + this.getReverseClassLazyTableEndpoint().getClassName() + "QueryListCommand");
        this.addImportClassName(this.getReverseClassLazyTableEndpoint().getPackageName() + "." + "application.command" + "." + this.humpToDOT() + "." + this.getReverseClassLazyTableEndpoint().getClassName() + "QueryOneCommand");
        this.addImportClassName(tableEndpoint.getPackageName() + "." + "application.dto" + "." + className + "DTO");
        if (this.getReverseEngineering().isEnableExport()) {
            this.addImportClassName(this.getReverseClassLazyTableEndpoint().getPackageName() + "." + "application.command" + "." + this.humpToDOT() + "." + this.getReverseClassLazyTableEndpoint().getClassName() + "ExcelExport");
            this.addImportClassName(this.getReverseClassLazyTableEndpoint().getPackageName() + "." + "application.command" + "." + this.humpToDOT() + "." + this.getReverseClassLazyTableEndpoint().getClassName() + "ExcelImport");
        }
    }

    @Override
    public void initClassAnnotationPart() {
    }

    @Override
    public void initClassNamePart() {
        ReverseClassLazyTableEndpoint tableEndpoint = this.getReverseClassLazyTableEndpoint();
        String assemblerName = String.format("%sDTOAssembler", tableEndpoint.getClassName());
        this.setFileName(assemblerName);
        if (this.getReverseEngineering().isEnableMapStruct()) {
            if (this.getReverseEngineering().getMapStructConversionStrategy() == MapStructConversionStrategy.MAPPER) {
                this.addImportClassName("org.mapstruct.factory.Mappers");
                this.addImportClassName("org.mapstruct.Mapper");
                this.addClassAnnotationPart("@Mapper");
            } else if (this.getReverseEngineering().getMapStructConversionStrategy().equals((Object)MapStructConversionStrategy.LAZY_STRUCT_MAPPERS)) {
                this.addImportClassName("org.wu.framework.core.mapper.LazyStructMappers");
                this.addImportClassName("org.wu.framework.core.mapper.LazyStructMapper");
                this.addClassAnnotationPart("@LazyStructMapper");
            }
            this.addClassNamePart(String.format("public interface %s {\n", assemblerName) + "\n");
        } else {
            this.addClassNamePart(String.format("public class %s {\n", assemblerName) + "\n");
        }
    }

    @Override
    protected String getPackage() {
        ReverseClassLazyTableEndpoint tableEndpoint = this.getReverseClassLazyTableEndpoint();
        return String.format("package %s;", tableEndpoint.getPackageName() + "." + "application" + "." + "assembler") + "\n" + "\n";
    }

    @Override
    public void initClassFieldPart() {
    }

    @Override
    public void initClassMethodPart() {
        String lowercaseFirstLetter;
        ReverseClassLazyTableEndpoint tableEndpoint = this.getReverseClassLazyTableEndpoint();
        String className = tableEndpoint.getClassName();
        String comment = tableEndpoint.getComment();
        String methodParamName = lowercaseFirstLetter = CamelAndUnderLineConverter.lowercaseFirstLetter((String)className);
        if (Arrays.stream(JavaKeyword.values()).anyMatch(javaKeyword -> javaKeyword.name().toLowerCase().equals(lowercaseFirstLetter))) {
            methodParamName = methodParamName + "_";
        }
        String finalMethodParamName = methodParamName;
        if (this.getReverseEngineering().isEnableMapStruct()) {
            if (this.getReverseEngineering().getMapStructConversionStrategy() == MapStructConversionStrategy.MAPPER) {
                this.addClassMethodPart(this.generateMethodDescribe("MapStruct \u521b\u5efa\u7684\u4ee3\u7406\u5bf9\u8c61", ParamDescribeList.of()) + String.format("    %sDTOAssembler INSTANCE = Mappers.getMapper(%sDTOAssembler.class);", className, className));
            } else if (this.getReverseEngineering().getMapStructConversionStrategy() == MapStructConversionStrategy.LAZY_STRUCT_MAPPERS) {
                this.addClassMethodPart(this.generateMethodDescribe("LazyStructMapper \u521b\u5efa\u7684\u4ee3\u7406\u5bf9\u8c61", ParamDescribeList.of()) + String.format("    %sDTOAssembler INSTANCE = LazyStructMappers.getMapper(%sDTOAssembler.class);", className, className));
            }
            this.addClassMethodPart(this.generateMethodDescribe("\u5e94\u7528\u5c42\u5b58\u50a8\u5165\u53c2\u8f6c\u6362\u6210 \u9886\u57df\u5bf9\u8c61", ParamDescribeList.of().param(String.format("%sStoryCommand", methodParamName), "\u4fdd\u5b58" + comment + "\u5bf9\u8c61").returnParam(className, comment + "\u9886\u57df\u5bf9\u8c61")) + String.format("     %s to%s(%sStoryCommand %sStoryCommand);", className, className, className, methodParamName));
            this.addClassMethodPart(this.generateMethodDescribe("\u5e94\u7528\u5c42\u66f4\u65b0\u5165\u53c2\u8f6c\u6362\u6210 \u9886\u57df\u5bf9\u8c61", ParamDescribeList.of().param(String.format("%sUpdateCommand", methodParamName), "\u66f4\u65b0" + comment + "\u5bf9\u8c61").returnParam(className, comment + "\u9886\u57df\u5bf9\u8c61")) + String.format("     %s to%s(%sUpdateCommand %sUpdateCommand);", className, className, className, methodParamName));
            this.addClassMethodPart(this.generateMethodDescribe("\u5e94\u7528\u5c42\u67e5\u8be2\u5165\u53c2\u8f6c\u6362\u6210 \u9886\u57df\u5bf9\u8c61", ParamDescribeList.of().param(String.format("%sQueryOneCommand", methodParamName), "\u67e5\u8be2\u5355\u4e2a" + comment + "\u5bf9\u8c61\u53c2\u6570").returnParam(className, comment + "\u9886\u57df\u5bf9\u8c61")) + String.format("     %s to%s(%sQueryOneCommand %sQueryOneCommand);", className, className, className, methodParamName));
            this.addClassMethodPart(this.generateMethodDescribe("\u5e94\u7528\u5c42\u67e5\u8be2\u5165\u53c2\u8f6c\u6362\u6210 \u9886\u57df\u5bf9\u8c61", ParamDescribeList.of().param(String.format("%sQueryListCommand", methodParamName), "\u67e5\u8be2\u96c6\u5408" + comment + "\u5bf9\u8c61\u53c2\u6570").returnParam(className, comment + "\u9886\u57df\u5bf9\u8c61")) + String.format("     %s to%s(%sQueryListCommand %sQueryListCommand);", className, className, className, methodParamName));
            this.addClassMethodPart(this.generateMethodDescribe("\u5e94\u7528\u5c42\u5220\u9664\u5165\u53c2\u8f6c\u6362\u6210 \u9886\u57df\u5bf9\u8c61", ParamDescribeList.of().param(String.format("%sRemoveCommand", methodParamName), "\u5220\u9664" + comment + "\u5bf9\u8c61\u53c2\u6570").returnParam(className, comment + "\u9886\u57df\u5bf9\u8c61")) + String.format("     %s to%s(%sRemoveCommand %sRemoveCommand);", className, className, className, methodParamName));
            this.addClassMethodPart(this.generateMethodDescribe("\u6301\u4e45\u5c42\u9886\u57df\u5bf9\u8c61\u8f6c\u6362\u6210DTO\u5bf9\u8c61", ParamDescribeList.of().param(String.format("%s", methodParamName), comment + "\u9886\u57df\u5bf9\u8c61").returnParam(String.format("%sDTO", className), comment + "DTO\u5bf9\u8c61")) + String.format("     %sDTO from%s(%s %s);", className, className, className, methodParamName));
            this.addClassMethodPart(this.generateMethodDescribe("\u6301\u4e45\u5c42\u9886\u57df\u5bf9\u8c61\u8f6c\u6362\u6210\u5bfc\u51fa\u6570\u636e\u5bf9\u8c61", ParamDescribeList.of().param(String.format("%s", methodParamName), comment + "\u9886\u57df\u5bf9\u8c61").returnParam(String.format("%sExcelExport", className), comment + "\u5bfc\u51fa\u6570\u636e\u5bf9\u8c61")) + String.format("     %sExcelExport from%sToExcelExport(%s %s);", className, className, className, methodParamName));
            this.addClassMethodPart(this.generateMethodDescribe("\u5e94\u7528\u5c42\u5bfc\u5165\u5165\u53c2\u8f6c\u6362\u6210 \u9886\u57df\u5bf9\u8c61", ParamDescribeList.of().param(String.format("%sExcelImport", methodParamName), "\u5bfc\u5165" + comment + "\u5bf9\u8c61\u53c2\u6570").returnParam(className, comment + "\u9886\u57df\u5bf9\u8c61")) + String.format("     %s to%s(%sExcelImport %sExcelImport);", className, className, className, methodParamName));
        } else {
            this.addClassMethodPart(this.generateMethodDescribe("\u5e94\u7528\u5c42\u5b58\u50a8\u5165\u53c2\u8f6c\u6362\u6210 \u9886\u57df\u5bf9\u8c61", ParamDescribeList.of().param(String.format("%sStoryCommand", methodParamName), "\u4fdd\u5b58" + comment + "\u5bf9\u8c61").returnParam(className, comment + "\u9886\u57df\u5bf9\u8c61")) + String.format("    public static %s to%s(%sStoryCommand %sStoryCommand) {\n        if (null != %sStoryCommand) {\n        %s %s = new %s(); \n" + tableEndpoint.getOutLazyTableFieldEndpoints().stream().map(lazyTableFieldEndpoint -> {
                String capitalizeFirstLetterFieldName;
                String name = lazyTableFieldEndpoint.getName();
                String finalCapitalizeFirstLetterFieldName = capitalizeFirstLetterFieldName = CamelAndUnderLineConverter.capitalizeFirstLetter((String)name);
                if (Arrays.stream(JavaKeyword.values()).anyMatch(javaKeyword -> javaKeyword.name().toLowerCase().equals(finalCapitalizeFirstLetterFieldName))) {
                    capitalizeFirstLetterFieldName = capitalizeFirstLetterFieldName + "_";
                }
                return String.format("           %s.set%s(%sStoryCommand.get%s());\n", finalMethodParamName, capitalizeFirstLetterFieldName, finalMethodParamName, capitalizeFirstLetterFieldName);
            }).collect(Collectors.joining()) + "            return %s;\n        }\n        return null;\n    }\n", className, className, className, methodParamName, methodParamName, className, methodParamName, className, methodParamName));
            this.addClassMethodPart(this.generateMethodDescribe("\u5e94\u7528\u5c42\u66f4\u65b0\u5165\u53c2\u8f6c\u6362\u6210 \u9886\u57df\u5bf9\u8c61", ParamDescribeList.of().param(String.format("%sUpdateCommand", methodParamName), "\u66f4\u65b0" + comment + "\u5bf9\u8c61").returnParam(className, comment + "\u9886\u57df\u5bf9\u8c61")) + String.format("    public static %s to%s(%sUpdateCommand %sUpdateCommand) {\n        if (null != %sUpdateCommand) {\n        %s %s = new %s(); \n" + tableEndpoint.getOutLazyTableFieldEndpoints().stream().map(lazyTableFieldEndpoint -> {
                String capitalizeFirstLetterFieldName;
                String name = lazyTableFieldEndpoint.getName();
                String finalCapitalizeFirstLetterFieldName = capitalizeFirstLetterFieldName = CamelAndUnderLineConverter.capitalizeFirstLetter((String)name);
                if (Arrays.stream(JavaKeyword.values()).anyMatch(javaKeyword -> javaKeyword.name().toLowerCase().equals(finalCapitalizeFirstLetterFieldName))) {
                    capitalizeFirstLetterFieldName = capitalizeFirstLetterFieldName + "_";
                }
                return String.format("           %s.set%s(%sUpdateCommand.get%s());\n", finalMethodParamName, capitalizeFirstLetterFieldName, finalMethodParamName, capitalizeFirstLetterFieldName);
            }).collect(Collectors.joining()) + "            return %s;\n        }\n        return null;\n    }\n", className, className, className, methodParamName, methodParamName, className, methodParamName, className, methodParamName));
            this.addClassMethodPart(this.generateMethodDescribe("\u5e94\u7528\u5c42\u67e5\u8be2\u5165\u53c2\u8f6c\u6362\u6210 \u9886\u57df\u5bf9\u8c61", ParamDescribeList.of().param(String.format("%sQueryOneCommand", methodParamName), "\u67e5\u8be2\u5355\u4e2a" + comment + "\u5bf9\u8c61\u53c2\u6570").returnParam(className, comment + "\u9886\u57df\u5bf9\u8c61")) + String.format("    public static %s to%s(%sQueryOneCommand %sQueryOneCommand) {\n        if (null != %sQueryOneCommand) {\n        %s %s = new %s(); \n" + tableEndpoint.getOutLazyTableFieldEndpoints().stream().map(lazyTableFieldEndpoint -> {
                String capitalizeFirstLetterFieldName;
                String name = lazyTableFieldEndpoint.getName();
                String finalCapitalizeFirstLetterFieldName = capitalizeFirstLetterFieldName = CamelAndUnderLineConverter.capitalizeFirstLetter((String)name);
                if (Arrays.stream(JavaKeyword.values()).anyMatch(javaKeyword -> javaKeyword.name().toLowerCase().equals(finalCapitalizeFirstLetterFieldName))) {
                    capitalizeFirstLetterFieldName = capitalizeFirstLetterFieldName + "_";
                }
                return String.format("           %s.set%s(%sQueryOneCommand.get%s());\n", finalMethodParamName, capitalizeFirstLetterFieldName, finalMethodParamName, capitalizeFirstLetterFieldName);
            }).collect(Collectors.joining()) + "            return %s;\n        }\n        return null;\n    }\n", className, className, className, methodParamName, methodParamName, className, methodParamName, className, methodParamName));
            this.addClassMethodPart(this.generateMethodDescribe("\u5e94\u7528\u5c42\u67e5\u8be2\u5165\u53c2\u8f6c\u6362\u6210 \u9886\u57df\u5bf9\u8c61", ParamDescribeList.of().param(String.format("%sQueryListCommand", methodParamName), "\u67e5\u8be2\u96c6\u5408" + comment + "\u5bf9\u8c61\u53c2\u6570").returnParam(className, comment + "\u9886\u57df\u5bf9\u8c61")) + String.format("    public static %s to%s(%sQueryListCommand %sQueryListCommand) {\n        if (null != %sQueryListCommand) {\n        %s %s = new %s(); \n" + tableEndpoint.getOutLazyTableFieldEndpoints().stream().map(lazyTableFieldEndpoint -> {
                String capitalizeFirstLetterFieldName;
                String name = lazyTableFieldEndpoint.getName();
                String finalCapitalizeFirstLetterFieldName = capitalizeFirstLetterFieldName = CamelAndUnderLineConverter.capitalizeFirstLetter((String)name);
                if (Arrays.stream(JavaKeyword.values()).anyMatch(javaKeyword -> javaKeyword.name().toLowerCase().equals(finalCapitalizeFirstLetterFieldName))) {
                    capitalizeFirstLetterFieldName = capitalizeFirstLetterFieldName + "_";
                }
                return String.format("           %s.set%s(%sQueryListCommand.get%s());\n", finalMethodParamName, capitalizeFirstLetterFieldName, finalMethodParamName, capitalizeFirstLetterFieldName);
            }).collect(Collectors.joining()) + "            return %s;\n        }\n        return null;\n    }\n", className, className, className, methodParamName, methodParamName, className, methodParamName, className, methodParamName));
            this.addClassMethodPart(this.generateMethodDescribe("\u5e94\u7528\u5c42\u5220\u9664\u5165\u53c2\u8f6c\u6362\u6210 \u9886\u57df\u5bf9\u8c61", ParamDescribeList.of().param(String.format("%sRemoveCommand", methodParamName), "\u5220\u9664" + comment + "\u5bf9\u8c61\u53c2\u6570").returnParam(className, comment + "\u9886\u57df\u5bf9\u8c61")) + String.format("    public static %s to%s(%sRemoveCommand %sRemoveCommand) {\n        if (null != %sRemoveCommand) {\n        %s %s = new %s(); \n" + tableEndpoint.getOutLazyTableFieldEndpoints().stream().map(lazyTableFieldEndpoint -> {
                String capitalizeFirstLetterFieldName;
                String name = lazyTableFieldEndpoint.getName();
                String finalCapitalizeFirstLetterFieldName = capitalizeFirstLetterFieldName = CamelAndUnderLineConverter.capitalizeFirstLetter((String)name);
                if (Arrays.stream(JavaKeyword.values()).anyMatch(javaKeyword -> javaKeyword.name().toLowerCase().equals(finalCapitalizeFirstLetterFieldName))) {
                    capitalizeFirstLetterFieldName = capitalizeFirstLetterFieldName + "_";
                }
                return String.format("           %s.set%s(%sRemoveCommand.get%s());\n", finalMethodParamName, capitalizeFirstLetterFieldName, finalMethodParamName, capitalizeFirstLetterFieldName);
            }).collect(Collectors.joining()) + "            return %s;\n        }\n        return null;\n    }\n", className, className, className, methodParamName, methodParamName, className, methodParamName, className, methodParamName));
            this.addClassMethodPart(this.generateMethodDescribe("\u6301\u4e45\u5c42\u9886\u57df\u5bf9\u8c61\u8f6c\u6362\u6210DTO\u5bf9\u8c61", ParamDescribeList.of().param(String.format("%s", methodParamName), comment + "\u9886\u57df\u5bf9\u8c61").returnParam(String.format("%sDTO", className), comment + "DTO\u5bf9\u8c61")) + String.format("    public static %sDTO from%s(%s %s) {\n        if (null != %s) {\n        %sDTO %sDTO = new %sDTO(); \n" + tableEndpoint.getOutLazyTableFieldEndpoints().stream().map(lazyTableFieldEndpoint -> {
                String capitalizeFirstLetterFieldName;
                String name = lazyTableFieldEndpoint.getName();
                String finalCapitalizeFirstLetterFieldName = capitalizeFirstLetterFieldName = CamelAndUnderLineConverter.capitalizeFirstLetter((String)name);
                if (Arrays.stream(JavaKeyword.values()).anyMatch(javaKeyword -> javaKeyword.name().toLowerCase().equals(finalCapitalizeFirstLetterFieldName))) {
                    capitalizeFirstLetterFieldName = capitalizeFirstLetterFieldName + "_";
                }
                return String.format("           %sDTO.set%s(%s.get%s());\n", finalMethodParamName, capitalizeFirstLetterFieldName, finalMethodParamName, capitalizeFirstLetterFieldName);
            }).collect(Collectors.joining()) + "            return %sDTO;\n        }\n        return null;\n    }\n", className, className, className, methodParamName, methodParamName, className, methodParamName, className, methodParamName));
            this.addClassMethodPart(this.generateMethodDescribe("\u6301\u4e45\u5c42\u9886\u57df\u5bf9\u8c61\u8f6c\u6362\u6210\u5bfc\u51fa\u6570\u636e\u5bf9\u8c61", ParamDescribeList.of().param(String.format("%s", methodParamName), comment + "\u9886\u57df\u5bf9\u8c61").returnParam(String.format("%sExcelExport", className), comment + "\u5bfc\u51fa\u6570\u636e\u5bf9\u8c61")) + String.format("    public static %sExcelExport from%sToExcelExport(%s %s) {\n        if (null != %s) {\n        %sExcelExport %sExcelExport = new %sExcelExport(); \n" + tableEndpoint.getOutLazyTableFieldEndpoints().stream().map(lazyTableFieldEndpoint -> {
                String capitalizeFirstLetterFieldName;
                String name = lazyTableFieldEndpoint.getName();
                String finalCapitalizeFirstLetterFieldName = capitalizeFirstLetterFieldName = CamelAndUnderLineConverter.capitalizeFirstLetter((String)name);
                if (Arrays.stream(JavaKeyword.values()).anyMatch(javaKeyword -> javaKeyword.name().toLowerCase().equals(finalCapitalizeFirstLetterFieldName))) {
                    capitalizeFirstLetterFieldName = capitalizeFirstLetterFieldName + "_";
                }
                return String.format("           %sExcelExport.set%s(%s.get%s());\n", finalMethodParamName, capitalizeFirstLetterFieldName, finalMethodParamName, capitalizeFirstLetterFieldName);
            }).collect(Collectors.joining()) + "            return %sExcelExport;\n        }\n        return null;\n    }\n", className, className, className, methodParamName, methodParamName, className, methodParamName, className, methodParamName));
            this.addClassMethodPart(this.generateMethodDescribe("\u5e94\u7528\u5c42\u5bfc\u5165\u5165\u53c2\u8f6c\u6362\u6210 \u9886\u57df\u5bf9\u8c61", ParamDescribeList.of().param(String.format("%sExcelImport", methodParamName), comment + "\u9886\u57df\u5bf9\u8c61").returnParam(String.format("%sExcelImport", className), comment + "\u5bfc\u5165\u5bf9\u8c61")) + String.format("    public static %s to%s(%sExcelImport %sExcelImport) {\n        if (null != %sExcelImport) {\n        %s %s = new %s(); \n" + tableEndpoint.getOutLazyTableFieldEndpoints().stream().map(lazyTableFieldEndpoint -> {
                String capitalizeFirstLetterFieldName;
                String name = lazyTableFieldEndpoint.getName();
                String finalCapitalizeFirstLetterFieldName = capitalizeFirstLetterFieldName = CamelAndUnderLineConverter.capitalizeFirstLetter((String)name);
                if (Arrays.stream(JavaKeyword.values()).anyMatch(javaKeyword -> javaKeyword.name().toLowerCase().equals(finalCapitalizeFirstLetterFieldName))) {
                    capitalizeFirstLetterFieldName = capitalizeFirstLetterFieldName + "_";
                }
                return String.format("           %sExcelImport.set%s(%s.get%s());\n", finalMethodParamName, capitalizeFirstLetterFieldName, finalMethodParamName, capitalizeFirstLetterFieldName);
            }).collect(Collectors.joining()) + "            return %s;\n        }\n        return null;\n    }\n", className, className, className, methodParamName, methodParamName, className, methodParamName, className, methodParamName));
        }
    }

    @Override
    protected String getModuleType() {
        return "application" + File.separator + "assembler";
    }
}

