/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.orm.core.persistence.reverse.lazy.ddd;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.wu.framework.core.CamelAndUnderLineConverter;
import org.wu.framework.lazy.orm.core.config.ReverseEngineering;
import org.wu.framework.lazy.orm.core.persistence.reverse.ParamDescribeList;
import org.wu.framework.lazy.orm.core.persistence.reverse.ReverseClassLazyTableEndpoint;
import org.wu.framework.lazy.orm.core.persistence.reverse.lazy.DefaultAbstractJavaReverseEngineeringMethod;
import org.wu.framework.translation.data.JavaKeyword;

public class DefaultDDDLazyApplicationImpl
extends DefaultAbstractJavaReverseEngineeringMethod {
    public DefaultDDDLazyApplicationImpl(ReverseClassLazyTableEndpoint reverseClassLazyTableEndpoint, ReverseEngineering reverseEngineering) {
        super(reverseClassLazyTableEndpoint, reverseEngineering);
    }

    @Override
    public void initImportClassName() {
        this.addImportClassName("org.wu.framework.lazy.orm.web.plus.stereotype.LazyApplication");
        ReverseClassLazyTableEndpoint tableEndpoint = this.getReverseClassLazyTableEndpoint();
        String application = tableEndpoint.getClassName() + "Application";
        this.addImportClassName(tableEndpoint.getPackageName() + "." + "application." + application);
        if (this.getReverseEngineering().isEnableNormalCrud()) {
            this.addImportClassName("org.springframework.web.bind.annotation.*");
            this.addImportClassName("org.wu.framework.web.response.Result");
            this.addImportClassName("org.wu.framework.web.response.ResultFactory");
            this.addImportClassName("org.springframework.beans.factory.annotation.Autowired");
            String className = tableEndpoint.getClassName();
            List domainNames = CamelAndUnderLineConverter.humpToArray((String)className);
            String domainClass = tableEndpoint.getPackageName() + "." + "domain.model." + domainNames.stream().map(domainName -> {
                if (Arrays.stream(JavaKeyword.values()).anyMatch(javaKeyword -> javaKeyword.name().toLowerCase().equals(domainName))) {
                    return domainName + "_";
                }
                return domainName;
            }).collect(Collectors.joining(".")) + "." + className;
            this.addImportClassName(domainClass);
            this.addImportClassName(this.getReverseClassLazyTableEndpoint().getPackageName() + "." + "application.command" + "." + this.humpToDOT() + "." + this.getReverseClassLazyTableEndpoint().getClassName() + "RemoveCommand");
            this.addImportClassName(this.getReverseClassLazyTableEndpoint().getPackageName() + "." + "application.command" + "." + this.humpToDOT() + "." + this.getReverseClassLazyTableEndpoint().getClassName() + "StoryCommand");
            this.addImportClassName(this.getReverseClassLazyTableEndpoint().getPackageName() + "." + "application.command" + "." + this.humpToDOT() + "." + this.getReverseClassLazyTableEndpoint().getClassName() + "UpdateCommand");
            this.addImportClassName(this.getReverseClassLazyTableEndpoint().getPackageName() + "." + "application.command" + "." + this.humpToDOT() + "." + this.getReverseClassLazyTableEndpoint().getClassName() + "QueryListCommand");
            this.addImportClassName(this.getReverseClassLazyTableEndpoint().getPackageName() + "." + "application.command" + "." + this.humpToDOT() + "." + this.getReverseClassLazyTableEndpoint().getClassName() + "QueryOneCommand");
            this.addImportClassName(this.getReverseClassLazyTableEndpoint().getPackageName() + "." + "application" + "." + this.getReverseClassLazyTableEndpoint().getClassName() + "Application");
            this.addImportClassName(this.getReverseClassLazyTableEndpoint().getPackageName() + "." + "application.assembler" + "." + this.getReverseClassLazyTableEndpoint().getClassName() + "DTOAssembler");
            this.addImportClassName(this.getReverseClassLazyTableEndpoint().getPackageName() + "." + "application" + "." + "dto" + "." + this.getReverseClassLazyTableEndpoint().getClassName() + "DTO");
            this.addImportClassName("java.util.stream.Collectors");
            this.addImportClassName("jakarta.annotation.Resource");
            this.addImportClassName(tableEndpoint.getPackageName() + "." + "domain.model." + domainNames.stream().map(domainName -> {
                if (Arrays.stream(JavaKeyword.values()).anyMatch(javaKeyword -> javaKeyword.name().toLowerCase().equals(domainName))) {
                    return domainName + "_";
                }
                return domainName;
            }).collect(Collectors.joining(".")) + "." + className + "Repository");
            this.addImportClassName("java.util.List");
            this.addImportClassName("org.wu.framework.lazy.orm.database.lambda.domain.LazyPage");
            if (this.getReverseEngineering().isEnableExport()) {
                this.addImportClassName(this.getReverseClassLazyTableEndpoint().getPackageName() + "." + "application.command" + "." + this.humpToDOT() + "." + this.getReverseClassLazyTableEndpoint().getClassName() + "ExcelExport");
                this.addImportClassName(this.getReverseClassLazyTableEndpoint().getPackageName() + "." + "application.command" + "." + this.humpToDOT() + "." + this.getReverseClassLazyTableEndpoint().getClassName() + "ExcelImport");
            }
        }
    }

    @Override
    public void initClassAnnotationPart() {
        this.addClassAnnotationPart("@LazyApplication");
    }

    @Override
    public void initClassNamePart() {
        ReverseClassLazyTableEndpoint tableEndpoint = this.getReverseClassLazyTableEndpoint();
        String className = tableEndpoint.getClassName();
        String applicationImpl = className + "ApplicationImpl";
        this.setFileName(applicationImpl);
        String application = className + "Application";
        String classname = String.format("public class %s implements %s {\n", applicationImpl, application) + "\n";
        this.addClassNamePart(classname);
    }

    @Override
    public void initClassMethodPart() {
        if (this.getReverseEngineering().isEnableNormalCrud()) {
            String lowercaseFirstLetter;
            String comment = this.getReverseClassLazyTableEndpoint().getComment();
            String className = this.getReverseClassLazyTableEndpoint().getClassName();
            String methodParamName = lowercaseFirstLetter = CamelAndUnderLineConverter.lowercaseFirstLetter((String)className);
            if (Arrays.stream(JavaKeyword.values()).anyMatch(javaKeyword -> javaKeyword.name().toLowerCase().equals(lowercaseFirstLetter))) {
                methodParamName = methodParamName + "_";
            }
            String saveMethodDescribe = this.generateMethodDescribe("\u65b0\u589e" + comment, ParamDescribeList.of().param(String.format("%sStoryCommand", methodParamName), "\u65b0\u589e" + comment).returnParam(String.format("Result<%s>", className), comment + "\u65b0\u589e\u540e\u9886\u57df\u5bf9\u8c61"));
            this.addClassMethodPart(saveMethodDescribe);
            this.addClassMethodPart("    @Override");
            this.addClassMethodPart(String.format("    public Result<%s> story(%sStoryCommand %sStoryCommand) {\n        %s %s = %sDTOAssembler" + this.getMapStructInstance() + "to%s(%sStoryCommand);\n        return %sRepository.story(%s);\n    }", className, className, methodParamName, className, methodParamName, className, className, methodParamName, methodParamName, methodParamName));
            this.addClassMethodPart(this.generateMethodDescribe("\u6279\u91cf\u65b0\u589e" + comment, ParamDescribeList.of().param(String.format("%sStoryCommandList", methodParamName), "\u6279\u91cf\u65b0\u589e" + comment).returnParam(String.format("Result<List<%s>>", className), comment + "\u65b0\u589e\u540e\u9886\u57df\u5bf9\u8c61\u96c6\u5408")));
            this.addClassMethodPart("    @Override");
            this.addClassMethodPart(String.format("    public Result<List<%s>> batchStory(List<%sStoryCommand> %sStoryCommandList) {\n        List<%s> %sList = %sStoryCommandList.stream().map( %sDTOAssembler" + this.getMapLambdaStructInstance() + "to%s).collect(Collectors.toList());\n        return %sRepository.batchStory(%sList);\n    }", className, className, methodParamName, className, methodParamName, methodParamName, className, className, methodParamName, methodParamName));
            String updateMethodDescribe = this.generateMethodDescribe("\u66f4\u65b0" + comment, ParamDescribeList.of().param(String.format("%sUpdateCommand", methodParamName), "\u66f4\u65b0" + comment).returnParam(String.format("Result<%s>", className), comment + "\u9886\u57df\u5bf9\u8c61"));
            this.addClassMethodPart(updateMethodDescribe);
            this.addClassMethodPart("    @Override");
            this.addClassMethodPart(String.format("    public Result<%s> updateOne(%sUpdateCommand %sUpdateCommand) {\n        %s %s = %sDTOAssembler" + this.getMapStructInstance() + "to%s(%sUpdateCommand);\n        return %sRepository.story(%s);\n    }\n", className, className, methodParamName, className, methodParamName, className, className, methodParamName, methodParamName, methodParamName));
            String findOneMethodDescribe = this.generateMethodDescribe("\u67e5\u8be2\u5355\u4e2a" + comment, ParamDescribeList.of().param(String.format("%sQueryOneCommand", methodParamName), "\u67e5\u8be2\u5355\u4e2a" + comment).returnParam(String.format("Result<%sDTO>", className), comment + "DTO\u5bf9\u8c61"));
            this.addClassMethodPart(findOneMethodDescribe);
            this.addClassMethodPart("    @Override");
            this.addClassMethodPart(String.format("    public Result<%sDTO> findOne(%sQueryOneCommand %sQueryOneCommand) {\n        %s %s = %sDTOAssembler" + this.getMapStructInstance() + "to%s(%sQueryOneCommand);\n        return %sRepository.findOne(%s).convert(%sDTOAssembler" + this.getMapLambdaStructInstance() + "from%s);\n    }\n", className, className, methodParamName, className, methodParamName, className, className, methodParamName, methodParamName, methodParamName, className, className));
            String findListMethodDescribe = this.generateMethodDescribe("\u67e5\u8be2\u591a\u4e2a" + comment, ParamDescribeList.of().param(String.format("%sQueryListCommand", methodParamName), "\u67e5\u8be2\u591a\u4e2a" + comment).returnParam(String.format("Result<List<%sDTO>>", className), comment + "DTO\u5bf9\u8c61"));
            this.addClassMethodPart(findListMethodDescribe);
            this.addClassMethodPart("    @Override");
            this.addClassMethodPart(String.format("    public Result<List<%sDTO>> findList(%sQueryListCommand %sQueryListCommand) {\n        %s %s = %sDTOAssembler" + this.getMapStructInstance() + "to%s(%sQueryListCommand);\n        return %sRepository.findList(%s)        .convert(%ss -> %ss.stream().map(%sDTOAssembler" + this.getMapLambdaStructInstance() + "from%s).collect(Collectors.toList())) ;\n    }\n", className, className, methodParamName, className, methodParamName, className, className, methodParamName, methodParamName, methodParamName, methodParamName, methodParamName, className, className));
            String findPageMethodDescribe = this.generateMethodDescribe("\u5206\u9875\u67e5\u8be2\u591a\u4e2a" + comment, ParamDescribeList.of().param(String.format("%sQueryListCommand", methodParamName), "\u5206\u9875\u67e5\u8be2\u591a\u4e2a" + comment).returnParam(String.format("Result<LazyPage<%sDTO>>", className), "\u5206\u9875" + comment + "DTO\u5bf9\u8c61"));
            this.addClassMethodPart(findPageMethodDescribe);
            this.addClassMethodPart("    @Override");
            this.addClassMethodPart(String.format("    public Result<LazyPage<%sDTO>> findPage(int size,int current,%sQueryListCommand %sQueryListCommand) {\n        %s %s = %sDTOAssembler" + this.getMapStructInstance() + "to%s(%sQueryListCommand);\n        return %sRepository.findPage(size,current,%s)        .convert(page -> page.convert(%sDTOAssembler" + this.getMapLambdaStructInstance() + "from%s))            ;\n    }\n", className, className, methodParamName, className, methodParamName, className, className, methodParamName, methodParamName, methodParamName, className, className));
            String deleteMethodDescribe = this.generateMethodDescribe("\u5220\u9664" + comment, ParamDescribeList.of().param(String.format("%sRemoveCommand", methodParamName), "\u5220\u9664" + comment).returnParam(String.format("Result<%s>", className), comment));
            this.addClassMethodPart(deleteMethodDescribe);
            this.addClassMethodPart("    @Override");
            this.addClassMethodPart(String.format("    public Result<%s> remove(%sRemoveCommand %sRemoveCommand) {\n     %s %s = %sDTOAssembler" + this.getMapStructInstance() + "to%s(%sRemoveCommand);\n     return %sRepository.remove(%s);\n    }\n", className, className, methodParamName, className, methodParamName, className, className, methodParamName, methodParamName, methodParamName));
            if (this.getReverseEngineering().isEnableExport()) {
                String exportMethodDescribe = this.generateMethodDescribe("\u5bfc\u51fa" + comment, ParamDescribeList.of().param(String.format("%sQueryListCommand", methodParamName), "\u5bfc\u51fa" + comment).returnParam(String.format("List<%sExcelExport>", className), comment));
                this.addClassMethodPart(exportMethodDescribe);
                this.addClassMethodPart("    @Override");
                this.addClassMethodPart(String.format("    public List<%sExcelExport> exportExcel(%sQueryListCommand %sQueryListCommand) {\n     %s %s = %sDTOAssembler" + this.getMapStructInstance() + "to%s(%sQueryListCommand);\n        return %sRepository.findList(%s)        .applyOther(%ss -> %ss.stream().map(%sDTOAssembler" + this.getMapLambdaStructInstance() + "from%sToExcelExport).collect(Collectors.toList())) ;\n    }\n", className, className, methodParamName, className, methodParamName, className, className, methodParamName, methodParamName, methodParamName, methodParamName, methodParamName, className, className));
                String importMethodDescribe = this.generateMethodDescribe("\u5bfc\u5165" + comment, ParamDescribeList.of().param(String.format("%sExcelImportList", methodParamName), "\u5bfc\u5165" + comment).returnParam(String.format("Result<%sExcelImport>", className), comment));
                this.addClassMethodPart(importMethodDescribe);
                this.addClassMethodPart("    @Override");
                this.addClassMethodPart(String.format("    public Result<List<%sExcelImport>> importExcel(List<%sExcelImport> %sExcelImportList) {\n        List<%s> %sList = %sExcelImportList.stream().map( %sDTOAssembler" + this.getMapLambdaStructInstance() + "to%s).collect(Collectors.toList());\n        %sRepository.batchStory(%sList);\n        return ResultFactory.successOf(%sExcelImportList);\n    }", className, className, methodParamName, className, methodParamName, methodParamName, className, className, methodParamName, methodParamName, methodParamName));
            }
        }
    }

    private String getMapStructInstance() {
        if (this.getReverseEngineering().isEnableMapStruct()) {
            return ".INSTANCE.";
        }
        return ".";
    }

    private String getMapLambdaStructInstance() {
        if (this.getReverseEngineering().isEnableMapStruct()) {
            return ".INSTANCE::";
        }
        return "::";
    }

    @Override
    protected String getPackage() {
        ReverseClassLazyTableEndpoint tableEndpoint = this.getReverseClassLazyTableEndpoint();
        return String.format("package %s;", tableEndpoint.getPackageName() + "." + "application.impl") + "\n" + "\n";
    }

    @Override
    public void initClassFieldPart() {
        this.addClassFieldPart(String.format("    @Resource\n    %sRepository %sRepository;", this.getReverseClassLazyTableEndpoint().getClassName(), this.lowercaseFirstLetterTableName()));
    }

    @Override
    protected String getModuleType() {
        return "application" + File.separator + "impl";
    }
}

