/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.orm.core.persistence.reverse.lazy.ddd;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.wu.framework.core.CamelAndUnderLineConverter;
import org.wu.framework.lazy.orm.core.config.ReverseEngineering;
import org.wu.framework.lazy.orm.core.persistence.reverse.ParamDescribeList;
import org.wu.framework.lazy.orm.core.persistence.reverse.ReverseClassLazyTableEndpoint;
import org.wu.framework.lazy.orm.core.persistence.reverse.lazy.DefaultAbstractJavaReverseEngineeringMethod;
import org.wu.framework.translation.data.JavaKeyword;

public class DefaultDDDLazyApplication
extends DefaultAbstractJavaReverseEngineeringMethod {
    public DefaultDDDLazyApplication(ReverseClassLazyTableEndpoint reverseClassLazyTableEndpoint, ReverseEngineering reverseEngineering) {
        super(reverseClassLazyTableEndpoint, reverseEngineering);
    }

    @Override
    public void initImportClassName() {
        if (this.getReverseEngineering().isEnableNormalCrud()) {
            this.addImportClassName("org.wu.framework.web.response.Result");
            this.addImportClassName("org.wu.framework.web.response.ResultFactory");
            ReverseClassLazyTableEndpoint tableEndpoint = this.getReverseClassLazyTableEndpoint();
            String className = tableEndpoint.getClassName();
            List domainNames = CamelAndUnderLineConverter.humpToArray((String)className);
            String domainClass = tableEndpoint.getPackageName() + "." + "domain.model." + domainNames.stream().map(domainName -> {
                if (Arrays.stream(JavaKeyword.values()).anyMatch(javaKeyword -> javaKeyword.name().toLowerCase().equals(domainName))) {
                    return domainName + "_";
                }
                return domainName;
            }).collect(Collectors.joining(".")) + "." + className;
            this.addImportClassName(domainClass);
            this.addImportClassName(this.getReverseClassLazyTableEndpoint().getPackageName() + "." + "application.command" + "." + this.humpToDOT() + "." + this.getReverseClassLazyTableEndpoint().getClassName() + "RemoveCommand");
            this.addImportClassName(this.getReverseClassLazyTableEndpoint().getPackageName() + "." + "application.command" + "." + this.humpToDOT() + "." + this.getReverseClassLazyTableEndpoint().getClassName() + "StoryCommand");
            this.addImportClassName(this.getReverseClassLazyTableEndpoint().getPackageName() + "." + "application.command" + "." + this.humpToDOT() + "." + this.getReverseClassLazyTableEndpoint().getClassName() + "UpdateCommand");
            this.addImportClassName(this.getReverseClassLazyTableEndpoint().getPackageName() + "." + "application.command" + "." + this.humpToDOT() + "." + this.getReverseClassLazyTableEndpoint().getClassName() + "QueryListCommand");
            this.addImportClassName(this.getReverseClassLazyTableEndpoint().getPackageName() + "." + "application.command" + "." + this.humpToDOT() + "." + this.getReverseClassLazyTableEndpoint().getClassName() + "QueryOneCommand");
            this.addImportClassName(this.getReverseClassLazyTableEndpoint().getPackageName() + "." + "application" + "." + "dto" + "." + this.getReverseClassLazyTableEndpoint().getClassName() + "DTO");
            this.addImportClassName("java.util.List");
            this.addImportClassName("org.wu.framework.lazy.orm.database.lambda.domain.LazyPage");
            if (this.getReverseEngineering().isEnableExport()) {
                this.addImportClassName(this.getReverseClassLazyTableEndpoint().getPackageName() + "." + "application.command" + "." + this.humpToDOT() + "." + this.getReverseClassLazyTableEndpoint().getClassName() + "ExcelExport");
                this.addImportClassName(this.getReverseClassLazyTableEndpoint().getPackageName() + "." + "application.command" + "." + this.humpToDOT() + "." + this.getReverseClassLazyTableEndpoint().getClassName() + "ExcelImport");
            }
        }
    }

    @Override
    public void initClassMethodPart() {
        if (this.getReverseEngineering().isEnableNormalCrud()) {
            String lowercaseFirstLetter;
            String comment = this.getReverseClassLazyTableEndpoint().getComment();
            String className = this.getReverseClassLazyTableEndpoint().getClassName();
            String methodParamName = lowercaseFirstLetter = CamelAndUnderLineConverter.lowercaseFirstLetter((String)className);
            if (Arrays.stream(JavaKeyword.values()).anyMatch(javaKeyword -> javaKeyword.name().toLowerCase().equals(lowercaseFirstLetter))) {
                methodParamName = methodParamName + "_";
            }
            String saveMethodDescribe = this.generateMethodDescribe("\u65b0\u589e" + comment, ParamDescribeList.of().param(String.format("%sStoryCommand", methodParamName), "\u65b0\u589e" + comment).returnParam(String.format("Result<%s>", className), comment + "\u65b0\u589e\u540e\u9886\u57df\u5bf9\u8c61"));
            this.addClassMethodPart(saveMethodDescribe);
            this.addClassMethodPart(String.format("    Result<%s> story(%sStoryCommand %sStoryCommand);\n", className, className, methodParamName));
            this.addClassMethodPart(this.generateMethodDescribe("\u6279\u91cf\u65b0\u589e" + comment, ParamDescribeList.of().param(String.format("%sStoryCommandList", methodParamName), "\u6279\u91cf\u65b0\u589e" + comment).returnParam(String.format("Result<List<%s>>", className), comment + "\u65b0\u589e\u540e\u9886\u57df\u5bf9\u8c61\u96c6\u5408")));
            this.addClassMethodPart(String.format("    Result<List<%s>> batchStory(List<%sStoryCommand> %sStoryCommandList);\n", className, className, methodParamName));
            String updateMethodDescribe = this.generateMethodDescribe("\u66f4\u65b0" + comment, ParamDescribeList.of().param(String.format("%sUpdateCommand", methodParamName), "\u66f4\u65b0" + comment).returnParam(String.format("Result<%s>", className), comment + "\u9886\u57df\u5bf9\u8c61"));
            this.addClassMethodPart(updateMethodDescribe);
            this.addClassMethodPart(String.format("    Result<%s> updateOne(%sUpdateCommand %sUpdateCommand);\n", className, className, methodParamName));
            String findOneMethodDescribe = this.generateMethodDescribe("\u67e5\u8be2\u5355\u4e2a" + comment, ParamDescribeList.of().param(String.format("%sQueryOneCommand", methodParamName), "\u67e5\u8be2\u5355\u4e2a" + comment).returnParam(String.format("Result<%sDTO>", className), comment + "DTO\u5bf9\u8c61"));
            this.addClassMethodPart(findOneMethodDescribe);
            this.addClassMethodPart(String.format("    Result<%sDTO> findOne(%sQueryOneCommand %sQueryOneCommand);\n", className, className, methodParamName));
            String findListMethodDescribe = this.generateMethodDescribe("\u67e5\u8be2\u591a\u4e2a" + comment, ParamDescribeList.of().param(String.format("%sQueryListCommand", methodParamName), "\u67e5\u8be2\u591a\u4e2a" + comment).returnParam(String.format("Result <List<%sDTO>>", className), comment + "DTO\u5bf9\u8c61"));
            this.addClassMethodPart(findListMethodDescribe);
            this.addClassMethodPart(String.format("    Result <List<%sDTO>> findList(%sQueryListCommand %sQueryListCommand);\n", className, className, methodParamName));
            String findPageMethodDescribe = this.generateMethodDescribe("\u5206\u9875\u67e5\u8be2\u591a\u4e2a" + comment, ParamDescribeList.of().param(String.format("%sQueryListCommand", methodParamName), "\u5206\u9875\u67e5\u8be2\u591a\u4e2a" + comment).returnParam(String.format("Result <LazyPage<%sDTO>>", className), "\u5206\u9875" + comment + "DTO\u5bf9\u8c61"));
            this.addClassMethodPart(findPageMethodDescribe);
            this.addClassMethodPart(String.format("    Result <LazyPage<%sDTO>> findPage(int size,int current,%sQueryListCommand %sQueryListCommand);\n", className, className, methodParamName));
            String deleteMethodDescribe = this.generateMethodDescribe("\u5220\u9664" + comment, ParamDescribeList.of().param(String.format("%sRemoveCommand", methodParamName), "\u5220\u9664" + comment).returnParam(String.format("Result<%s>", className), comment));
            this.addClassMethodPart(deleteMethodDescribe);
            this.addClassMethodPart(String.format("    Result<%s> remove(%sRemoveCommand %sRemoveCommand);\n", className, className, methodParamName));
            if (this.getReverseEngineering().isEnableExport()) {
                String exportMethodDescribe = this.generateMethodDescribe("\u5bfc\u51fa" + comment, ParamDescribeList.of().param(String.format("%sQueryListCommand", methodParamName), "\u5bfc\u51fa" + comment).returnParam(String.format("List<%sExcelExport>", className), comment));
                this.addClassMethodPart(exportMethodDescribe);
                this.addClassMethodPart(String.format("    public List<%sExcelExport> exportExcel(%sQueryListCommand %sQueryListCommand);\n", className, className, methodParamName));
                String importMethodDescribe = this.generateMethodDescribe("\u5bfc\u5165" + comment, ParamDescribeList.of().param(String.format("%sExcelImportList", methodParamName), "\u5bfc\u5165" + comment).returnParam(String.format("Result<List<%sExcelImport>>", className), comment));
                this.addClassMethodPart(importMethodDescribe);
                this.addClassMethodPart(String.format("    public Result<List<%sExcelImport>> importExcel(List<%sExcelImport> %sExcelImportList);\n", className, className, methodParamName));
            }
        }
    }

    @Override
    public void initClassAnnotationPart() {
    }

    @Override
    public void initClassNamePart() {
        ReverseClassLazyTableEndpoint tableEndpoint = this.getReverseClassLazyTableEndpoint();
        String applicationName = String.format("%sApplication", tableEndpoint.getClassName());
        this.setFileName(applicationName);
        this.addClassNamePart(String.format("public interface %s {\n", applicationName) + "\n");
    }

    @Override
    protected String getPackage() {
        ReverseClassLazyTableEndpoint tableEndpoint = this.getReverseClassLazyTableEndpoint();
        return String.format("package %s;", tableEndpoint.getPackageName() + "." + "application") + "\n" + "\n";
    }

    @Override
    public void initClassFieldPart() {
    }

    @Override
    protected String getModuleType() {
        return "application";
    }
}

