/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.orm.core.persistence.reverse.lazy;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.wu.framework.core.CamelAndUnderLineConverter;
import org.wu.framework.core.utils.FileUtil;
import org.wu.framework.core.utils.ObjectUtils;
import org.wu.framework.lazy.orm.core.config.ReverseEngineering;
import org.wu.framework.lazy.orm.core.persistence.reverse.AbstractJavaReverseEngineeringMethod;
import org.wu.framework.lazy.orm.core.persistence.reverse.ReverseClassLazyTableEndpoint;
import org.wu.framework.translation.data.JavaKeyword;

public abstract class DefaultAbstractJavaReverseEngineeringMethod
extends AbstractJavaReverseEngineeringMethod {
    private final ReverseClassLazyTableEndpoint reverseClassLazyTableEndpoint;
    private final ReverseEngineering reverseEngineering;

    protected DefaultAbstractJavaReverseEngineeringMethod(ReverseClassLazyTableEndpoint reverseClassLazyTableEndpoint, ReverseEngineering reverseEngineering) {
        this.reverseClassLazyTableEndpoint = reverseClassLazyTableEndpoint;
        this.reverseEngineering = reverseEngineering;
    }

    protected String getPackage() {
        return String.format("package %s;", this.getReverseClassLazyTableEndpoint().getPackageName() + "." + this.getModuleType()) + "\n" + "\n";
    }

    protected String humpToDOT() {
        ReverseClassLazyTableEndpoint tableEndpoint = this.getReverseClassLazyTableEndpoint();
        String domain = tableEndpoint.getClassName();
        List domainNames = CamelAndUnderLineConverter.humpToArray((String)domain);
        return domainNames.stream().map(domainName -> {
            if (Arrays.stream(JavaKeyword.values()).anyMatch(javaKeyword -> javaKeyword.name().toLowerCase().equals(domainName))) {
                return domainName + "_";
            }
            return domainName;
        }).collect(Collectors.joining("."));
    }

    protected String humpToSeparator() {
        ReverseClassLazyTableEndpoint tableEndpoint = this.getReverseClassLazyTableEndpoint();
        String domain = tableEndpoint.getClassName();
        List domainNames = CamelAndUnderLineConverter.humpToArray((String)domain);
        return domainNames.stream().map(domainName -> {
            if (Arrays.stream(JavaKeyword.values()).anyMatch(javaKeyword -> javaKeyword.name().toLowerCase().equals(domainName))) {
                return domainName + "_";
            }
            return domainName;
        }).collect(Collectors.joining(File.separator));
    }

    @Override
    public String createJavaContextCode() {
        this.initImportClassName();
        this.initClassAnnotationPart();
        this.initClassNamePart();
        this.initClassFieldPart();
        this.initClassMethodPart();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getPackage());
        List<String> importClassName = this.getImportClassNames();
        importClassName.forEach(s -> stringBuilder.append("import ").append((String)s).append(";").append("\n"));
        String classDescribe = this.generateClassDescribe(ObjectUtils.isEmpty((Object)this.reverseClassLazyTableEndpoint.getComment()) ? this.reverseClassLazyTableEndpoint.getTableName() : this.reverseClassLazyTableEndpoint.getComment());
        stringBuilder.append(classDescribe);
        List<String> classAnnotationPart = this.getClassAnnotationParts();
        stringBuilder.append(String.join((CharSequence)"\n", classAnnotationPart));
        stringBuilder.append("\n");
        List<String> classNamePart = this.getClassNamePart();
        stringBuilder.append(String.join((CharSequence)";\n", classNamePart));
        List<String> classFieldPart = this.getClassFieldPart();
        stringBuilder.append(String.join((CharSequence)"\n", classFieldPart));
        List<String> classMethodPart = this.getClassMethodPart();
        stringBuilder.append("\n");
        stringBuilder.append(String.join((CharSequence)"\n", classMethodPart));
        stringBuilder.append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    @Override
    public String createJavaFile(String resourceFilePrefix) {
        ReverseClassLazyTableEndpoint tableEndpoint = this.getReverseClassLazyTableEndpoint();
        String contextCode = this.createJavaContextCode();
        try {
            BufferedWriter bufferedWriter = FileUtil.createFileBufferedWriter(null, (String)this.getFilePrefix(), (String)this.getFileSuffix(), (String)(resourceFilePrefix + this.getModuleType() + File.separator + this.getFileName()));
            bufferedWriter.write(contextCode);
            bufferedWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return contextCode;
    }

    protected abstract String getModuleType();

    protected String getFilePrefix() {
        return "";
    }

    protected String getFileSuffix() {
        return ".java";
    }

    @Override
    public ReverseClassLazyTableEndpoint getReverseClassLazyTableEndpoint() {
        return this.reverseClassLazyTableEndpoint;
    }

    public String lowercaseFirstLetterTableName() {
        String lowercaseFirstLetter;
        String className = this.getReverseClassLazyTableEndpoint().getClassName();
        String methodParamName = lowercaseFirstLetter = CamelAndUnderLineConverter.lowercaseFirstLetter((String)className);
        if (Arrays.stream(JavaKeyword.values()).anyMatch(javaKeyword -> javaKeyword.name().toLowerCase().equals(lowercaseFirstLetter))) {
            methodParamName = methodParamName + "_";
        }
        return methodParamName;
    }

    @Override
    public ReverseEngineering getReverseEngineering() {
        return this.reverseEngineering;
    }
}

