/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.orm.core.persistence.reverse;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.wu.framework.core.utils.ObjectUtils;
import org.wu.framework.lazy.orm.core.config.ReverseEngineering;
import org.wu.framework.lazy.orm.core.config.enums.MysqlColumnTypeEnum;
import org.wu.framework.lazy.orm.core.config.enums.OrmArchitecture;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyDatabaseJsonMessage;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyTableFieldEndpoint;
import org.wu.framework.lazy.orm.core.persistence.reverse.AbstractJavaReverseEngineeringClassName;
import org.wu.framework.lazy.orm.core.persistence.reverse.JavaReverseEngineeringField;
import org.wu.framework.lazy.orm.core.persistence.reverse.ReverseClassLazyTableEndpoint;
import org.wu.framework.lazy.orm.core.stereotype.LazyTableFieldId;

public abstract class AbstractJavaReverseEngineeringField
extends AbstractJavaReverseEngineeringClassName
implements JavaReverseEngineeringField {
    private List<String> classFieldParts = new ArrayList<String>();

    @Override
    public void initClassFieldPart() {
        ReverseEngineering reverseEngineering = this.getReverseEngineering();
        ReverseClassLazyTableEndpoint tableEndpoint = this.getReverseClassLazyTableEndpoint();
        List<LazyTableFieldEndpoint> fieldEndpoints = tableEndpoint.getOutLazyTableFieldEndpoints();
        fieldEndpoints.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<LazyTableFieldEndpoint>(Comparator.comparing(LazyTableFieldEndpoint::getName))), ArrayList::new)).forEach(fieldLazyTableFieldEndpoint -> {
            String comment = fieldLazyTableFieldEndpoint.getComment();
            String commentFormat = "\n" + String.format("    /**\n     * \n     * %s\n     */\n", comment);
            MysqlColumnTypeEnum mysqlColumnTypeEnum = MysqlColumnTypeEnum.MYSQL_COLUMN_TYPE_ENUM_MAP.getOrDefault(fieldLazyTableFieldEndpoint.getDataType(), MysqlColumnTypeEnum.VARCHAR);
            String format = String.format("    private %s %s;", mysqlColumnTypeEnum.getJavaType().getSimpleName(), fieldLazyTableFieldEndpoint.getName());
            String apiModelPropertyAnnotation = "";
            if (reverseEngineering.isEnableSwagger()) {
                apiModelPropertyAnnotation = String.format("    @Schema(description =\"%s\",name =\"%s\",example = \"%s\")", fieldLazyTableFieldEndpoint.getComment(), fieldLazyTableFieldEndpoint.getName(), "") + "\n";
            }
            String lazyTableFieldAnnotation = "";
            if (OrmArchitecture.LAZY.equals((Object)reverseEngineering.getOrmArchitecture())) {
                String extra = fieldLazyTableFieldEndpoint.getExtra();
                String name = fieldLazyTableFieldEndpoint.getColumnName().replace("`", "");
                boolean key = fieldLazyTableFieldEndpoint.isKey();
                if ("AUTO_INCREMENT".equalsIgnoreCase(extra)) {
                    lazyTableFieldAnnotation = String.format("    @LazyTableFieldId(name = \"%s\", comment = \"%s\")", name, comment) + "\n";
                    this.addImportClassName(LazyTableFieldId.class.getName());
                } else {
                    ArrayList<String> valueList = new ArrayList<String>();
                    valueList.add(String.format("name=\"%s\"", name));
                    valueList.add(String.format("comment=\"%s\"", fieldLazyTableFieldEndpoint.getComment()));
                    if (fieldLazyTableFieldEndpoint.isNotNull()) {
                        valueList.add("notNull=true");
                    }
                    if (key) {
                        valueList.add("key=true");
                    }
                    if (!ObjectUtils.isEmpty((Object)fieldLazyTableFieldEndpoint.getLazyTableIndexEndpoints())) {
                        valueList.add("lazyTableIndexs = {" + Arrays.stream(fieldLazyTableFieldEndpoint.getLazyTableIndexEndpoints()).map(lazyTableIndexEndpoint -> {
                            String indexTypeString = "LayerField.LayerFieldType.NORMAL";
                            switch (lazyTableIndexEndpoint.getFieldIndexType()) {
                                case ID: {
                                    indexTypeString = "LayerField.LayerFieldType.ID";
                                    break;
                                }
                                case NORMAL: {
                                    indexTypeString = "LayerField.LayerFieldType.NORMAL";
                                    break;
                                }
                                case UNIQUE: {
                                    indexTypeString = "LayerField.LayerFieldType.UNIQUE";
                                    break;
                                }
                                case SPATIAL: {
                                    indexTypeString = "LayerField.LayerFieldType.SPATIAL";
                                    break;
                                }
                                case FULLTEXT: {
                                    indexTypeString = "LayerField.LayerFieldType.FULLTEXT";
                                    break;
                                }
                                case AUTOMATIC: {
                                    indexTypeString = "LayerField.LayerFieldType.AUTOMATIC";
                                    break;
                                }
                                default: {
                                    indexTypeString = "LayerField.LayerFieldType.NORMAL";
                                }
                            }
                            return "@LazyTableIndex(indexName = \"" + lazyTableIndexEndpoint.getIndexName() + "\", indexType = " + indexTypeString + ")";
                        }).collect(Collectors.joining(",")) + "}");
                    }
                    if (!ObjectUtils.isEmpty((Object)fieldLazyTableFieldEndpoint.getDefaultValue())) {
                        if (LazyDatabaseJsonMessage.specialFields.contains(fieldLazyTableFieldEndpoint.getDefaultValue())) {
                            valueList.add(String.format("defaultValue=\"%s\"", fieldLazyTableFieldEndpoint.getDefaultValue()));
                        } else {
                            valueList.add(String.format("defaultValue=\"'%s'\"", fieldLazyTableFieldEndpoint.getDefaultValue()));
                        }
                        valueList.add("upsertStrategy = LazyFieldStrategy.NEVER");
                    }
                    valueList.add(String.format("columnType=\"%s\"", fieldLazyTableFieldEndpoint.getColumnType()));
                    if (!ObjectUtils.isEmpty((Object)extra)) {
                        valueList.add(String.format("extra=\"%s\"", extra.replace("DEFAULT_GENERATED", "")));
                    }
                    lazyTableFieldAnnotation = String.format("    @LazyTableField(%s)", String.join((CharSequence)",", valueList)) + "\n";
                }
            }
            this.addImportClassName(mysqlColumnTypeEnum.getJavaType().getName());
            this.addClassFieldPart(commentFormat + apiModelPropertyAnnotation + lazyTableFieldAnnotation + format);
        });
    }

    @Override
    public void addClassFieldPart(String classFieldPart) {
        this.classFieldParts.add(classFieldPart);
    }

    @Override
    public List<String> getClassFieldPart() {
        return this.classFieldParts;
    }
}

