/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.orm.core.persistence.map;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import lombok.Generated;
import org.wu.framework.core.utils.ObjectUtils;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyTableEndpoint;
import org.wu.framework.lazy.orm.core.persistence.map.EasyHashMap;
import org.wu.framework.lazy.orm.core.persistence.map.EasySmartConverterAbstract;
import org.wu.framework.lazy.orm.core.persistence.map.IEasySmartConverter;
import org.wu.framework.lazy.orm.core.source.SqlSourceClass;

public abstract class EasySmartFillFieldConverterAbstract
extends EasySmartConverterAbstract
implements IEasySmartConverter {
    public void smartFillField(Object source, Object target) {
        Field[] declaredFields;
        AtomicBoolean smartFillField;
        Class<?> targetClass;
        if (target.getClass().equals(Class.class)) {
            targetClass = (Class<?>)target;
            smartFillField = new AtomicBoolean(true);
            declaredFields = new Field[]{};
        } else {
            targetClass = target.getClass();
            SqlSourceClass sqlSourceClass = SqlSourceClass.getInstance(targetClass);
            LazyTableEndpoint<?> targetLazyTableAnnotation = sqlSourceClass.getLazyTableEndpoint();
            smartFillField = new AtomicBoolean(targetLazyTableAnnotation.isSmartFillField());
            declaredFields = target.getClass().getDeclaredFields();
        }
        if (smartFillField.get()) {
            Set<CreateField> sourceFieldSet;
            smartFillField.set(false);
            Class<?> sourceClass = source.getClass();
            Set fieldSet = Arrays.stream(declaredFields).map(field -> new CreateField().setFieldName(field.getName()).setFieldTypeName(field.getType().getSimpleName())).collect(Collectors.toSet());
            if (EasyHashMap.class.isAssignableFrom(sourceClass)) {
                sourceFieldSet = ((EasyHashMap)source).entrySet().stream().map(stringObjectEntry -> {
                    Class<Object> fileType = ObjectUtils.isEmpty(stringObjectEntry.getValue()) ? Object.class : stringObjectEntry.getValue().getClass();
                    return new CreateField().setFieldName((String)stringObjectEntry.getKey()).setFieldTypeName(fileType.getSimpleName());
                }).collect(Collectors.toSet());
                if (ObjectUtils.isEmpty(sourceFieldSet)) {
                    return;
                }
            } else {
                Field[] sourceClassDeclaredFields = sourceClass.getDeclaredFields();
                if (ObjectUtils.isEmpty((Object)sourceClassDeclaredFields)) {
                    return;
                }
                sourceFieldSet = Arrays.stream(sourceClassDeclaredFields).map(field -> new CreateField().setFieldName(field.getName()).setFieldTypeName(field.getType().getSimpleName())).collect(Collectors.toSet());
            }
            ArrayList<CreateField> createFieldList = new ArrayList<CreateField>(fieldSet);
            sourceFieldSet.forEach(createField -> {
                if (!fieldSet.contains(createField)) {
                    createFieldList.add((CreateField)createField);
                    smartFillField.set(true);
                }
            });
            if (smartFillField.get()) {
                CreateInfo createInfo = new CreateInfo().setCreateFieldList(createFieldList);
                createInfo.setClassName(targetClass.getSimpleName());
                this.targetClassWriteAttributeFieldList(createInfo);
            }
        }
    }

    protected abstract String targetClassWriteAttributeFieldList(CreateInfo var1);

    @Override
    public Object converter(Object source, Object target) {
        this.smartFillField(source, target);
        return target;
    }

    public static class CreateInfo {
        private List<CreateField> createFieldList = new ArrayList<CreateField>();
        private Package aPackage = EasySmartFillFieldConverterAbstract.class.getPackage();
        private Boolean override = false;
        private String className;
        private List<Annotation> classAnnotationList = new ArrayList<Annotation>();
        private String fileSuffix = ".class";
        private List<CreateInfo> innerClassList = new ArrayList<CreateInfo>();

        @Generated
        public CreateInfo() {
        }

        @Generated
        public List<CreateField> getCreateFieldList() {
            return this.createFieldList;
        }

        @Generated
        public Package getAPackage() {
            return this.aPackage;
        }

        @Generated
        public Boolean getOverride() {
            return this.override;
        }

        @Generated
        public String getClassName() {
            return this.className;
        }

        @Generated
        public List<Annotation> getClassAnnotationList() {
            return this.classAnnotationList;
        }

        @Generated
        public String getFileSuffix() {
            return this.fileSuffix;
        }

        @Generated
        public List<CreateInfo> getInnerClassList() {
            return this.innerClassList;
        }

        @Generated
        public CreateInfo setCreateFieldList(List<CreateField> createFieldList) {
            this.createFieldList = createFieldList;
            return this;
        }

        @Generated
        public CreateInfo setAPackage(Package aPackage) {
            this.aPackage = aPackage;
            return this;
        }

        @Generated
        public CreateInfo setOverride(Boolean override) {
            this.override = override;
            return this;
        }

        @Generated
        public CreateInfo setClassName(String className) {
            this.className = className;
            return this;
        }

        @Generated
        public CreateInfo setClassAnnotationList(List<Annotation> classAnnotationList) {
            this.classAnnotationList = classAnnotationList;
            return this;
        }

        @Generated
        public CreateInfo setFileSuffix(String fileSuffix) {
            this.fileSuffix = fileSuffix;
            return this;
        }

        @Generated
        public CreateInfo setInnerClassList(List<CreateInfo> innerClassList) {
            this.innerClassList = innerClassList;
            return this;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CreateInfo)) {
                return false;
            }
            CreateInfo other = (CreateInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$override = this.getOverride();
            Boolean other$override = other.getOverride();
            if (this$override == null ? other$override != null : !((Object)this$override).equals(other$override)) {
                return false;
            }
            List<CreateField> this$createFieldList = this.getCreateFieldList();
            List<CreateField> other$createFieldList = other.getCreateFieldList();
            if (this$createFieldList == null ? other$createFieldList != null : !((Object)this$createFieldList).equals(other$createFieldList)) {
                return false;
            }
            Package this$aPackage = this.getAPackage();
            Package other$aPackage = other.getAPackage();
            if (this$aPackage == null ? other$aPackage != null : !this$aPackage.equals(other$aPackage)) {
                return false;
            }
            String this$className = this.getClassName();
            String other$className = other.getClassName();
            if (this$className == null ? other$className != null : !this$className.equals(other$className)) {
                return false;
            }
            List<Annotation> this$classAnnotationList = this.getClassAnnotationList();
            List<Annotation> other$classAnnotationList = other.getClassAnnotationList();
            if (this$classAnnotationList == null ? other$classAnnotationList != null : !((Object)this$classAnnotationList).equals(other$classAnnotationList)) {
                return false;
            }
            String this$fileSuffix = this.getFileSuffix();
            String other$fileSuffix = other.getFileSuffix();
            if (this$fileSuffix == null ? other$fileSuffix != null : !this$fileSuffix.equals(other$fileSuffix)) {
                return false;
            }
            List<CreateInfo> this$innerClassList = this.getInnerClassList();
            List<CreateInfo> other$innerClassList = other.getInnerClassList();
            return !(this$innerClassList == null ? other$innerClassList != null : !((Object)this$innerClassList).equals(other$innerClassList));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CreateInfo;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $override = this.getOverride();
            result = result * 59 + ($override == null ? 43 : ((Object)$override).hashCode());
            List<CreateField> $createFieldList = this.getCreateFieldList();
            result = result * 59 + ($createFieldList == null ? 43 : ((Object)$createFieldList).hashCode());
            Package $aPackage = this.getAPackage();
            result = result * 59 + ($aPackage == null ? 43 : ((Object)$aPackage).hashCode());
            String $className = this.getClassName();
            result = result * 59 + ($className == null ? 43 : $className.hashCode());
            List<Annotation> $classAnnotationList = this.getClassAnnotationList();
            result = result * 59 + ($classAnnotationList == null ? 43 : ((Object)$classAnnotationList).hashCode());
            String $fileSuffix = this.getFileSuffix();
            result = result * 59 + ($fileSuffix == null ? 43 : $fileSuffix.hashCode());
            List<CreateInfo> $innerClassList = this.getInnerClassList();
            result = result * 59 + ($innerClassList == null ? 43 : ((Object)$innerClassList).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "EasySmartFillFieldConverterAbstract.CreateInfo(createFieldList=" + this.getCreateFieldList() + ", aPackage=" + this.getAPackage() + ", override=" + this.getOverride() + ", className=" + this.getClassName() + ", classAnnotationList=" + this.getClassAnnotationList() + ", fileSuffix=" + this.getFileSuffix() + ", innerClassList=" + this.getInnerClassList() + ")";
        }
    }

    public static class CreateField {
        private String fieldTypeName;
        private String fieldName;

        @Generated
        public CreateField() {
        }

        @Generated
        public String getFieldTypeName() {
            return this.fieldTypeName;
        }

        @Generated
        public String getFieldName() {
            return this.fieldName;
        }

        @Generated
        public CreateField setFieldTypeName(String fieldTypeName) {
            this.fieldTypeName = fieldTypeName;
            return this;
        }

        @Generated
        public CreateField setFieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CreateField)) {
                return false;
            }
            CreateField other = (CreateField)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$fieldTypeName = this.getFieldTypeName();
            String other$fieldTypeName = other.getFieldTypeName();
            if (this$fieldTypeName == null ? other$fieldTypeName != null : !this$fieldTypeName.equals(other$fieldTypeName)) {
                return false;
            }
            String this$fieldName = this.getFieldName();
            String other$fieldName = other.getFieldName();
            return !(this$fieldName == null ? other$fieldName != null : !this$fieldName.equals(other$fieldName));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CreateField;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $fieldTypeName = this.getFieldTypeName();
            result = result * 59 + ($fieldTypeName == null ? 43 : $fieldTypeName.hashCode());
            String $fieldName = this.getFieldName();
            result = result * 59 + ($fieldName == null ? 43 : $fieldName.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "EasySmartFillFieldConverterAbstract.CreateField(fieldTypeName=" + this.getFieldTypeName() + ", fieldName=" + this.getFieldName() + ")";
        }
    }
}

