/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.orm.core.persistence.map;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.wu.framework.core.utils.FileUtil;
import org.wu.framework.lazy.orm.core.persistence.map.EasySmartFillFieldConverterAbstract;
import org.wu.framework.lazy.orm.core.persistence.map.IEasySmartConverter;

public class EasySmartFillFieldConverter
extends EasySmartFillFieldConverterAbstract
implements IEasySmartConverter {
    public static final List<String> BASE_DATA_TYPE = Arrays.asList(String.class.getSimpleName(), String[].class.getSimpleName(), Integer.class.getSimpleName(), Integer.TYPE.getSimpleName(), Integer[].class.getSimpleName(), int[].class.getSimpleName(), Double.class.getSimpleName(), Double.TYPE.getSimpleName(), Double[].class.getSimpleName(), double[].class.getSimpleName(), Float.class.getSimpleName(), Float.TYPE.getSimpleName(), Float[].class.getSimpleName(), float[].class.getSimpleName(), Long.class.getSimpleName(), Long.TYPE.getSimpleName(), Long[].class.getSimpleName(), long[].class.getSimpleName(), Boolean.class.getSimpleName(), Boolean.TYPE.getSimpleName(), Boolean[].class.getSimpleName(), boolean[].class.getSimpleName(), Byte.class.getSimpleName(), Byte.TYPE.getSimpleName(), byte[].class.getSimpleName(), Byte[].class.getSimpleName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String targetClassWriteAttributeFieldList(EasySmartFillFieldConverterAbstract.CreateInfo createInfo) {
        URL resource = EasySmartFillFieldConverter.class.getResource("/");
        String resourceFile = resource.getFile();
        Package aPackage = createInfo.getAPackage();
        String name = aPackage.getName();
        if (".class".equals(createInfo.getFileSuffix())) {
            resourceFile = resourceFile + name.replace(".", File.separator) + File.separator + createInfo.getClassName();
        } else {
            String target = resourceFile.split("target")[0] + "src/main/java/";
            resourceFile = target + name.replace(".", File.separator) + File.separator + createInfo.getClassName();
        }
        String classContext = this.createInfo2String(createInfo);
        try {
            BufferedWriter bufferedWriter = FileUtil.createFileBufferedWriter(null, (String)"", (String)createInfo.getFileSuffix(), (String)resourceFile);
            bufferedWriter.write(classContext);
            bufferedWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return classContext;
    }

    public String createInfo2String(EasySmartFillFieldConverterAbstract.CreateInfo createInfo) {
        List<EasySmartFillFieldConverterAbstract.CreateField> createFieldList = createInfo.getCreateFieldList();
        String classPackage = String.format("package %s;", createInfo.getAPackage().getName()) + "\n";
        List importClassList = createFieldList.stream().filter(createField -> !BASE_DATA_TYPE.contains(createField.getFieldTypeName())).map(createField -> String.format("import %s; \n", createField.getFieldTypeName())).distinct().collect(Collectors.toList());
        String classname = String.format("public  class %s {", createInfo.getClassName()) + "\n";
        List attributeFileList = createFieldList.stream().map(createField -> String.format("private %s %s;", createField.getFieldTypeName(), createField.getFieldName())).collect(Collectors.toList());
        StringBuilder classContext = new StringBuilder(classPackage + String.join((CharSequence)"\n", importClassList) + "\n" + classname + String.join((CharSequence)"\n", attributeFileList));
        for (EasySmartFillFieldConverterAbstract.CreateInfo innerClass : createInfo.getInnerClassList()) {
            classContext.append(this.innerClass2String(innerClass));
        }
        classContext.append("\n}");
        return classContext.toString();
    }

    public String innerClass2String(EasySmartFillFieldConverterAbstract.CreateInfo innerClass) {
        List<EasySmartFillFieldConverterAbstract.CreateField> createFieldList = innerClass.getCreateFieldList();
        String classname = String.format("\npublic static class %s {", innerClass.getClassName());
        List attributeFileList = createFieldList.stream().map(createField -> String.format("private %s %s;", createField.getFieldTypeName(), createField.getFieldName())).collect(Collectors.toList());
        StringBuilder first = new StringBuilder(classname + "\n" + String.join((CharSequence)"\n", attributeFileList) + "\n" + "}");
        for (EasySmartFillFieldConverterAbstract.CreateInfo createInfo : innerClass.getInnerClassList()) {
            first.append(this.innerClass2String(createInfo));
        }
        return first.toString();
    }
}

