/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.orm.core.persistence.map;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import lombok.Generated;
import org.wu.framework.core.CamelAndUnderLineConverter;
import org.wu.framework.core.stereotype.LayerField;
import org.wu.framework.core.utils.ObjectUtils;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyDatabaseJsonMessage;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyTableFieldEndpoint;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyTableIndexEndpoint;
import org.wu.framework.lazy.orm.core.persistence.conf.mysql.ClassLazyTableEndpoint;
import org.wu.framework.lazy.orm.core.persistence.conf.mysql.FieldLazyTableIndexEndpoint;
import org.wu.framework.lazy.orm.core.persistence.domain.JavaVerification;
import org.wu.framework.lazy.orm.core.persistence.map.EasySmartFillFieldConverter;
import org.wu.framework.lazy.orm.core.persistence.map.EasySmartFillFieldConverterAbstract;
import org.wu.framework.lazy.orm.core.source.adapter.SourceFactory;
import org.wu.framework.lazy.orm.core.stereotype.LazyTableField;
import org.wu.framework.translation.data.IBeanUpsert;
import org.wu.framework.translation.data.ProcessException;

public class EasyHashMap<K, V>
extends LinkedHashMap<K, V>
implements Map<K, V>,
IBeanUpsert {
    public static final Pattern pattern = Pattern.compile("[0-9]*");
    private final List<Object> uniqueFieldList = new ArrayList<Object>();
    private final HashMap<K, Class<?>> ValueType = new HashMap();
    private String uniqueLabel = UUID.randomUUID().toString();
    private boolean modifyUniqueLabel = false;
    private boolean keyAdjust = true;
    private boolean isCapitalized;
    private boolean humpToUnderline;

    public EasyHashMap() {
    }

    public EasyHashMap(String uniqueLabel) {
        this.uniqueLabel = uniqueLabel;
    }

    public static byte[] castToBytes(Object value) {
        if (value instanceof byte[]) {
            return (byte[])value;
        }
        if (value instanceof String) {
            return ((String)value).getBytes(StandardCharsets.UTF_8);
        }
        throw new RuntimeException("can not cast to byte[], value : " + value);
    }

    public static EasySmartFillFieldConverterAbstract.CreateInfo mapConverterJava(Map<Object, Object> map) {
        EasySmartFillFieldConverterAbstract.CreateInfo createInfo = new EasySmartFillFieldConverterAbstract.CreateInfo();
        map.forEach((k, v) -> {
            EasySmartFillFieldConverterAbstract.CreateField createField = new EasySmartFillFieldConverterAbstract.CreateField();
            if (k instanceof String) {
                String fieldName = (String)k;
                JavaVerification javaVerification = EasyHashMap.verificationKey(fieldName);
                if (!javaVerification.isJava()) {
                    fieldName = javaVerification.getNewName();
                }
                createField.setFieldName(fieldName);
                if (fieldName.contains("\u00ab") || fieldName.contains("\u00bb")) {
                    fieldName = fieldName.replace("\u00ab", "_");
                    fieldName = fieldName.replace("\u00bb", "_");
                }
                if (fieldName.contains("\u00ab")) {
                    System.out.println(fieldName);
                }
                String className = CamelAndUnderLineConverter.lineToHumpField((String)("_" + fieldName));
                if (v instanceof Map) {
                    EasySmartFillFieldConverterAbstract.CreateInfo innerClass = EasyHashMap.mapConverterJava((Map)v);
                    innerClass.setClassName(className);
                    createInfo.getInnerClassList().add(innerClass);
                    createField.setFieldTypeName(innerClass.getClassName());
                } else if (v instanceof List) {
                    if (ObjectUtils.isEmpty((Object)v)) {
                        createField.setFieldTypeName(List.class.getSimpleName());
                    } else {
                        Object o = ((List)v).get(0);
                        if (o instanceof Map) {
                            EasySmartFillFieldConverterAbstract.CreateInfo innerClass = EasyHashMap.mapConverterJava((Map)o);
                            innerClass.setClassName(className);
                            createInfo.getInnerClassList().add(innerClass);
                            createField.setFieldTypeName(innerClass.getClassName());
                        } else {
                            createField.setFieldTypeName(v.getClass().getSimpleName());
                        }
                    }
                } else if (ObjectUtils.isEmpty((Object)v)) {
                    createField.setFieldTypeName(String.class.getSimpleName());
                } else {
                    createField.setFieldTypeName(v.getClass().getSimpleName());
                }
            }
            createInfo.getCreateFieldList().add(createField);
        });
        createInfo.setClassName("Temp" + LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy_MM_dd")));
        return createInfo;
    }

    public static JavaVerification verificationKey(String key) {
        JavaVerification javaVerification = new JavaVerification();
        javaVerification.setOldName(key);
        boolean isJava = true;
        List<String> illegalList = Arrays.asList(".", ",", "*", ":", "/", "-");
        for (String illegal : illegalList) {
            if (!key.contains(illegal)) continue;
            isJava = false;
            key = key.replace(illegal, "");
            javaVerification.setNewName(key);
        }
        if (EasyHashMap.isNumeric(key)) {
            javaVerification.setNewName("temp" + key);
            isJava = false;
        }
        javaVerification.setJava(isJava);
        return javaVerification;
    }

    public static boolean isNumeric(String str) {
        return pattern.matcher(str).matches();
    }

    public ClassLazyTableEndpoint toEasyTableAnnotation() {
        return this.toEasyTableAnnotation(this.isCapitalized, this.humpToUnderline);
    }

    public ClassLazyTableEndpoint toEasyTableAnnotation(boolean isCapitalized) {
        return this.toEasyTableAnnotation(isCapitalized, false);
    }

    public ClassLazyTableEndpoint toEasyTableAnnotation(boolean isCapitalized, boolean humpToUnderline) {
        ClassLazyTableEndpoint lazyTableAnnotation = new ClassLazyTableEndpoint();
        lazyTableAnnotation.setClassName(this.getClass().getName());
        lazyTableAnnotation.setClazz(this.getClass());
        lazyTableAnnotation.setTableName(CamelAndUnderLineConverter.humpToLine2((String)this.uniqueLabel));
        lazyTableAnnotation.setComment(String.format("\u521b\u5efa\u65f6\u95f4%s", LocalDateTime.now()));
        List<LazyTableFieldEndpoint> convertedFieldList = this.getFieldLazyTableFieldEndpointList(isCapitalized, humpToUnderline);
        lazyTableAnnotation.setOtherFieldToThis(convertedFieldList);
        return lazyTableAnnotation;
    }

    public List<LazyTableFieldEndpoint> getFieldLazyTableFieldEndpointList() {
        return this.getFieldLazyTableFieldEndpointList(false, true);
    }

    public List<LazyTableFieldEndpoint> getFieldLazyTableFieldEndpointList(boolean isCapitalized, boolean humpToUnderline) {
        ArrayList<LazyTableFieldEndpoint> convertedFieldList = new ArrayList<LazyTableFieldEndpoint>();
        this.forEach((key, value) -> {
            String fieldName = key.toString();
            LazyTableFieldEndpoint convertedField = SourceFactory.getDefaultLazyTableFieldEndpointInstance();
            convertedField.setName(fieldName);
            if (this.keyAdjust) {
                if (humpToUnderline) {
                    fieldName = CamelAndUnderLineConverter.humpToLine2((String)fieldName);
                }
                fieldName = isCapitalized ? fieldName.toUpperCase() : fieldName.toLowerCase();
            } else {
                fieldName = key.toString();
            }
            String tempFieldName = fieldName;
            if (LazyDatabaseJsonMessage.specialFields.contains(tempFieldName.toUpperCase())) {
                fieldName = "`" + fieldName + "`";
            }
            Class<?> fieldClazz = null == value ? this.ValueType.getOrDefault(key, String.class) : value.getClass();
            convertedField.setColumnType(LazyTableField.FieldType.getMysqlTypeByClass(fieldClazz));
            convertedField.setComment(String.format("\u5b57\u6bb5\u521b\u5efa\u65f6\u95f4%s", LocalDateTime.now()));
            convertedField.setClazz(fieldClazz);
            convertedField.setExist(true);
            convertedField.setColumnName(CamelAndUnderLineConverter.humpToLine2((String)fieldName));
            convertedField.setFieldValue(value);
            if (!this.keyAdjust) {
                convertedField.setColumnName(fieldName);
            }
            FieldLazyTableIndexEndpoint fieldLazyTableIndexEndpoint = new FieldLazyTableIndexEndpoint();
            if (this.uniqueFieldList.contains(key)) {
                fieldLazyTableIndexEndpoint.setFieldIndexType(LayerField.LayerFieldType.UNIQUE);
                convertedField.setLazyTableIndexEndpoints(new LazyTableIndexEndpoint[]{fieldLazyTableIndexEndpoint});
            } else {
                fieldLazyTableIndexEndpoint.setFieldIndexType(LayerField.LayerFieldType.NONE);
                convertedField.setLazyTableIndexEndpoints(new LazyTableIndexEndpoint[]{fieldLazyTableIndexEndpoint});
            }
            convertedFieldList.add(convertedField);
        });
        return convertedFieldList;
    }

    public V put(K key, V value, String valueClass) {
        try {
            this.ValueType.put(key, Class.forName(valueClass));
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return this.put(key, value);
    }

    public V put(K key, V value, Class valueClass) {
        this.ValueType.put(key, valueClass);
        return this.put(key, value);
    }

    public Type[] getClassParadigm() {
        ParameterizedType parameterizedType = (ParameterizedType)this.getClass().getGenericSuperclass();
        return parameterizedType.getActualTypeArguments();
    }

    public V putUnique(K key, V value) {
        this.uniqueFieldList.add(key);
        return super.put(key, value);
    }

    public void setUniqueLabel(String uniqueLabel) {
        this.modifyUniqueLabel = true;
        this.uniqueLabel = uniqueLabel;
    }

    public String generateClass(boolean createClass) {
        EasySmartFillFieldConverter easySmartFillFieldConverter = new EasySmartFillFieldConverter();
        EasySmartFillFieldConverterAbstract.CreateInfo createInfo = EasyHashMap.mapConverterJava(this);
        createInfo.setFileSuffix(".class");
        createInfo.setClassName(this.uniqueLabel);
        return createClass ? easySmartFillFieldConverter.targetClassWriteAttributeFieldList(createInfo) : easySmartFillFieldConverter.createInfo2String(createInfo);
    }

    public String generateJava(boolean createJava) {
        EasySmartFillFieldConverter easySmartFillFieldConverter = new EasySmartFillFieldConverter();
        EasySmartFillFieldConverterAbstract.CreateInfo createInfo = EasyHashMap.mapConverterJava(this);
        createInfo.setFileSuffix(".java");
        createInfo.setClassName(this.uniqueLabel);
        return createJava ? easySmartFillFieldConverter.targetClassWriteAttributeFieldList(createInfo) : easySmartFillFieldConverter.createInfo2String(createInfo);
    }

    public Object beforeObjectProcess() throws ProcessException {
        return null;
    }

    public byte[] getBytes(String key) {
        Object value = this.get(key);
        if (value == null) {
            return null;
        }
        return EasyHashMap.castToBytes(value);
    }

    public boolean isCapitalized() {
        return this.isCapitalized;
    }

    public void setCapitalized(boolean capitalized) {
        this.isCapitalized = capitalized;
    }

    public String getString(String key) {
        Object value = this.get(key);
        if (value == null) {
            return null;
        }
        return String.valueOf(value);
    }

    @Override
    public String toString() {
        return "EasyHashMap{uniqueFieldList=" + this.uniqueFieldList + ", ValueType=" + this.ValueType + ", uniqueLabel='" + this.uniqueLabel + '\'' + ", modifyUniqueLabel=" + this.modifyUniqueLabel + ", keyAdjust=" + this.keyAdjust + "," + super.toString() + '}';
    }

    @Generated
    public List<Object> getUniqueFieldList() {
        return this.uniqueFieldList;
    }

    @Generated
    public HashMap<K, Class<?>> getValueType() {
        return this.ValueType;
    }

    @Generated
    public String getUniqueLabel() {
        return this.uniqueLabel;
    }

    @Generated
    public boolean isModifyUniqueLabel() {
        return this.modifyUniqueLabel;
    }

    @Generated
    public void setModifyUniqueLabel(boolean modifyUniqueLabel) {
        this.modifyUniqueLabel = modifyUniqueLabel;
    }

    @Generated
    public void setKeyAdjust(boolean keyAdjust) {
        this.keyAdjust = keyAdjust;
    }

    @Generated
    public boolean isKeyAdjust() {
        return this.keyAdjust;
    }

    @Generated
    public void setHumpToUnderline(boolean humpToUnderline) {
        this.humpToUnderline = humpToUnderline;
    }

    @Generated
    public boolean isHumpToUnderline() {
        return this.humpToUnderline;
    }
}

