/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.orm.core.persistence.conf.mysql;

import java.text.Collator;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wu.framework.core.stereotype.LayerField;
import org.wu.framework.core.utils.ObjectUtils;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyDatabaseJsonMessage;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyTableFieldEndpoint;
import org.wu.framework.lazy.orm.core.persistence.conf.clazz.AbstractLazyTableEndpoint;
import org.wu.framework.lazy.orm.core.persistence.conf.mysql.FieldLazyTableFieldEndpoint;

public class ClassLazyTableEndpoint
extends AbstractLazyTableEndpoint<FieldLazyTableFieldEndpoint> {
    Logger log = LoggerFactory.getLogger(ClassLazyTableEndpoint.class);
    private List<FieldLazyTableFieldEndpoint> lazyTableFieldEndpointList;

    @Override
    public String creatTableSQL() {
        Map<String, List<LazyTableFieldEndpoint>> spatialIndexMap;
        StringBuilder createTableSQLBuffer = new StringBuilder(String.format("-- \u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\n-- create table %s  %s  \n-- add by  %s  %s  \n-- \u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\n", this.getFullTableName(), this.getComment(), "wujiawei", LocalDate.now()));
        if (!ObjectUtils.isEmpty((Object)this.getSchema())) {
            createTableSQLBuffer.append(String.format(" CREATE DATABASE IF NOT EXISTS %s; \n use %s ; \n ", this.getSchema(), this.getSchema()));
        }
        createTableSQLBuffer.append("CREATE TABLE IF NOT EXISTS `").append(this.getTableName()).append("` ( \n");
        List<FieldLazyTableFieldEndpoint> fieldEndpoints = this.getLazyTableFieldEndpointList();
        List<FieldLazyTableFieldEndpoint> fieldLazyTableFieldEndpointList = new ArrayList<FieldLazyTableFieldEndpoint>(fieldEndpoints);
        fieldLazyTableFieldEndpointList.addAll(LazyDatabaseJsonMessage.extraFields);
        fieldLazyTableFieldEndpointList = fieldLazyTableFieldEndpointList.stream().sorted((firstLazyTableFieldEndpoint, secondLazyFieldLazyTableFieldEndpoint) -> Collator.getInstance(Locale.CHINA).compare(firstLazyTableFieldEndpoint.getColumnName(), secondLazyFieldLazyTableFieldEndpoint.getColumnName())).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<FieldLazyTableFieldEndpoint>(Comparator.comparing(LazyTableFieldEndpoint::getColumnName))), ArrayList::new));
        List uniqueList = fieldLazyTableFieldEndpointList.stream().filter(LazyTableFieldEndpoint::isExist).filter(field -> Arrays.stream(field.getLazyTableIndexEndpoints()).anyMatch(index -> LayerField.LayerFieldType.UNIQUE.equals((Object)index.getFieldIndexType()))).map(LazyTableFieldEndpoint::getColumnName).collect(Collectors.toList());
        Map<LayerField.LayerFieldType, Map<String, List<LazyTableFieldEndpoint>>> layerFieldTypeMap = this.getLayerFieldTypeMap(fieldLazyTableFieldEndpointList);
        ArrayList<String> columnList = new ArrayList<String>();
        fieldLazyTableFieldEndpointList.stream().filter(LazyTableFieldEndpoint::isExist).forEach(field -> columnList.add(field.columnSQL() + "\n"));
        List idList = fieldLazyTableFieldEndpointList.stream().filter(LazyTableFieldEndpoint::isExist).filter(LazyTableFieldEndpoint::isKey).map(LazyTableFieldEndpoint::getColumnName).collect(Collectors.toList());
        if (!ObjectUtils.isEmpty(idList)) {
            columnList.add(String.format("PRIMARY KEY (%s) USING BTREE", String.join((CharSequence)",", idList)) + "\n");
        }
        if (!ObjectUtils.isEmpty(layerFieldTypeMap)) {
            Map<String, List<LazyTableFieldEndpoint>> fulltextIndexMap;
            Map<String, List<LazyTableFieldEndpoint>> normalIndexMap;
            Map<String, List<LazyTableFieldEndpoint>> uniqueIndexMap = layerFieldTypeMap.get(LayerField.LayerFieldType.UNIQUE);
            if (!ObjectUtils.isEmpty(uniqueIndexMap)) {
                uniqueIndexMap.forEach((uniqueIndexName, lazyTableFieldEndpoints) -> {
                    String uniqueIndexSql = "UNIQUE KEY `" + uniqueIndexName + "` (" + lazyTableFieldEndpoints.stream().map(LazyTableFieldEndpoint::getColumnName).collect(Collectors.joining(",")) + ")";
                    columnList.add(uniqueIndexSql);
                });
            }
            if (!ObjectUtils.isEmpty(normalIndexMap = layerFieldTypeMap.get(LayerField.LayerFieldType.NORMAL))) {
                normalIndexMap.forEach((normalIndexName, lazyTableFieldEndpoints) -> {
                    String normalIndexSql = " KEY `" + normalIndexName + "` (" + lazyTableFieldEndpoints.stream().map(LazyTableFieldEndpoint::getColumnName).collect(Collectors.joining(",")) + ")";
                    columnList.add(normalIndexSql);
                });
            }
            if (!ObjectUtils.isEmpty(fulltextIndexMap = layerFieldTypeMap.get(LayerField.LayerFieldType.FULLTEXT))) {
                fulltextIndexMap.forEach((fulltextIndexName, lazyTableFieldEndpoints) -> {
                    String fulltextIndexSql = " FULLTEXT KEY `" + fulltextIndexName + "` (" + lazyTableFieldEndpoints.stream().map(LazyTableFieldEndpoint::getColumnName).collect(Collectors.joining(",")) + ")";
                    columnList.add(fulltextIndexSql);
                });
            }
        }
        if (!ObjectUtils.isEmpty(spatialIndexMap = layerFieldTypeMap.get(LayerField.LayerFieldType.SPATIAL))) {
            spatialIndexMap.forEach((spatialIndexName, lazyTableFieldEndpoints) -> {
                String spatialIndexSql = " SPATIAL KEY `" + spatialIndexName + "` (" + lazyTableFieldEndpoints.stream().map(LazyTableFieldEndpoint::getColumnName).collect(Collectors.joining(",")) + ")";
                columnList.add(spatialIndexSql);
            });
        }
        createTableSQLBuffer.append(String.join((CharSequence)",", columnList));
        createTableSQLBuffer.append(") ENGINE=");
        createTableSQLBuffer.append(this.getEngine().getName());
        createTableSQLBuffer.append(" DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='");
        createTableSQLBuffer.append(this.getComment()).append("';\n");
        createTableSQLBuffer.append("-- ------end \n-- \u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\n");
        System.out.println(createTableSQLBuffer);
        return createTableSQLBuffer.toString();
    }

    @Override
    public String alterTableSQL(List<FieldLazyTableFieldEndpoint> currentColumnNameList, boolean dropColumn) {
        currentColumnNameList = currentColumnNameList.stream().sorted((fieldLazyTableFieldEndpoint1, fieldLazyTableFieldEndpoint2) -> Collator.getInstance(Locale.CHINA).compare(fieldLazyTableFieldEndpoint1.getColumnName(), fieldLazyTableFieldEndpoint2.getColumnName())).collect(Collectors.toList());
        String ALTER_TABLE = "ALTER TABLE %s ";
        List<String> sql = this.alterTableColumnSQLPartList(currentColumnNameList, dropColumn);
        if (ObjectUtils.isEmpty(sql)) {
            return null;
        }
        String alterSQL = String.format(ALTER_TABLE, this.getFullTableName()) + sql.stream().filter(s -> !ObjectUtils.isEmpty((Object)s)).collect(Collectors.joining(","));
        this.log.debug("\u66f4\u65b0\u8868\u7ed3\u6784\u8bed\u53e5:{}", (Object)alterSQL);
        return alterSQL;
    }

    @Override
    public List<String> alterTableColumnSQL(List<FieldLazyTableFieldEndpoint> currentColumnNameList, boolean dropColumn) {
        String ALTER_TABLE = "ALTER TABLE %s ";
        List<String> sql = this.alterTableColumnSQLPartList(currentColumnNameList, dropColumn);
        List<String> alterSQLList = sql.stream().filter(columnSql -> !ObjectUtils.isEmpty((Object)columnSql)).map(columnSql -> String.format(ALTER_TABLE, this.getFullTableName()) + columnSql).collect(Collectors.toList());
        return alterSQLList;
    }

    @Override
    public List<FieldLazyTableFieldEndpoint> specifiedFieldAnnotation(LayerField.LayerFieldType layerFieldType) {
        List<FieldLazyTableFieldEndpoint> lazyTableFieldEndpoints = new ArrayList<FieldLazyTableFieldEndpoint>();
        List<FieldLazyTableFieldEndpoint> fieldEndpoints = this.getLazyTableFieldEndpointList();
        if (ObjectUtils.isEmpty(fieldEndpoints)) {
            return lazyTableFieldEndpoints;
        }
        lazyTableFieldEndpoints = fieldEndpoints.stream().filter(lazyTableFieldEndpoint -> Arrays.stream(lazyTableFieldEndpoint.getLazyTableIndexEndpoints()).anyMatch(lazyTableIndexEndpoint -> lazyTableIndexEndpoint.getFieldIndexType().equals((Object)layerFieldType))).collect(Collectors.toList());
        return lazyTableFieldEndpoints;
    }

    @Override
    public FieldLazyTableFieldEndpoint createLazyTableFieldEndpointInstance() {
        return new FieldLazyTableFieldEndpoint();
    }

    @Generated
    public ClassLazyTableEndpoint() {
    }

    @Generated
    public Logger getLog() {
        return this.log;
    }

    @Override
    @Generated
    public List<FieldLazyTableFieldEndpoint> getLazyTableFieldEndpointList() {
        return this.lazyTableFieldEndpointList;
    }

    @Generated
    public void setLog(Logger log) {
        this.log = log;
    }

    @Override
    @Generated
    public void setLazyTableFieldEndpointList(List<FieldLazyTableFieldEndpoint> lazyTableFieldEndpointList) {
        this.lazyTableFieldEndpointList = lazyTableFieldEndpointList;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClassLazyTableEndpoint)) {
            return false;
        }
        ClassLazyTableEndpoint other = (ClassLazyTableEndpoint)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Logger this$log = this.getLog();
        Logger other$log = other.getLog();
        if (this$log == null ? other$log != null : !this$log.equals(other$log)) {
            return false;
        }
        List<FieldLazyTableFieldEndpoint> this$lazyTableFieldEndpointList = this.getLazyTableFieldEndpointList();
        List<FieldLazyTableFieldEndpoint> other$lazyTableFieldEndpointList = other.getLazyTableFieldEndpointList();
        return !(this$lazyTableFieldEndpointList == null ? other$lazyTableFieldEndpointList != null : !((Object)this$lazyTableFieldEndpointList).equals(other$lazyTableFieldEndpointList));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ClassLazyTableEndpoint;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Logger $log = this.getLog();
        result = result * 59 + ($log == null ? 43 : $log.hashCode());
        List<FieldLazyTableFieldEndpoint> $lazyTableFieldEndpointList = this.getLazyTableFieldEndpointList();
        result = result * 59 + ($lazyTableFieldEndpointList == null ? 43 : ((Object)$lazyTableFieldEndpointList).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "ClassLazyTableEndpoint(log=" + this.getLog() + ", lazyTableFieldEndpointList=" + this.getLazyTableFieldEndpointList() + ")";
    }
}

